# Installation de nine

## Cloner le dépot

git clone --branch master https://forge.cadoles.com/afornerot/ninedocker.git

## Nine sur localhost

Vous devez ajouter un domaine dans votre host qui pointe sur 127.0.0.0

Sans personnalisation nine est configuré pour travailler avec nine.local et il écoute les ports 443 et 80

```
127.0.0.0 nine.local
```

# Structure du projet

## env

Ce répertoire contient l'ensemble des variables d'environnements de Ninedocker. Ne modifiez jamais le fichier .env, si vous souhaitez personnaliser votre environnement, initialisez un fichier .env.local au même emplacement. Dans ce fichier vous pourrez altérer les valeurs des variables présentes dans le .env.

### Variables "SERVICE"

Chaque service ont au minimum trois variables

```
- LESERVICE_SERVICE_NAME=leservice # Le nom du service
- LESERVICE_ACTIVATE=1             # Pour activer le service
- LESERVICE_LOCAL=1                # Pour indiquer si le service est hébergé sur ninedocker
```

Si vous souhaitez ajouter vos propres services à Ninedocker, ajoutez obligatoirement au moins trois variables dans votre .env.local:

```
- MONSERVICE_SERVICE_NAME=leservice
- MONSERVICE_ACTIVATE=1
- MONSERVICE_LOCAL=1
```

### Variables WEB_URL & PROTOCOLE

De base ninedocker est configuré pour fonctionner sur nine.local en https

Vous devez donc modifier dans le .env.local pour être en phase avec votre environnement

```
WEB_URL=mondomaine
PROTOCOLE=https
```

### Variable MASTERIDENTITY

La variable MASTERIDENTITY peut prendre les valeurs SQL ou SSO ou LDAP. Elle permet d'indiquer à Ninegate ou Nineskeletor qui est le maître de l'indentité.

- Si **SQL** = c'est que c'est Ninegate ou Nineskeletor qui sont detenteur et maître de l'indentité. Dans ce cas Ninegate ou Nineskeletor seront capable de synchroniser leurs utilisateurs dans un annuaire. Si un service OPENLDAP est activé.
- Si **SSO** = c'est que c'est à la connexion en SSO aux différents services qui va autosubmit ou autoupdate l'utilisateur dans le service qui utilise le service SSO. Dans ce cas, il est impératif que votre mode d'authentification soit paramétré en CAS.
- Si **LDAP** = c'est que c'est le service OPENLDAP qui est maître de l'identité. Dans ce cas c'est à vous d'alimenter les utilisateurs dans l'annuaire. Le service PHPLDAPADMIN pourrait vous aider à cela. Certains service pourront se synchroniser avec votre annuaire pour récupérer d'avance votre structure organisationnelle

### Variable MODE_AUTH

Cette variable permet de déterminer quel protocole d'authentification sera utilisé par les différents service

- **SQL** = sa propre mire d'authentification
- **CAS** = CAS le serveur CAS local ou externe
- **LDAP** = l'annuaire local ou externe dans ce cas la variable LDAP_LOGIN_FILTER est nécessaire

### Variables LDAP

```
LDAP_HOST                       # Host de votre annuaire
LDAP_PORT                       # Port de votre annuaire
LDAP_TLS                        # Use TLS 1/0
LDAP_BASEDN                     # Basedn de votre annuaire
LDAP_ADMIN_USERNAME             # UID du compte writer ou reader de votre annuaire. Writer obligatoire si vous synchroniser ninegate dans votre openldap
LDAP_USER                       # DN du compte writer ou reader de votre annuaire. Writer obligatoire si vous synchroniser ninegate dans votre openldap
LDAP_PASSWORD                   # Password du compte writer ou reader de votre annuaire. Writer obligatoire si vous synchroniser ninegate dans votre openldap
LDAP_USERNAME=uid               # Attribut de l'uid d'un utilisateur
LDAP_FIRSTNAME=givenname        # Attribut prénom d'un utilisateur
LDAP_LASTNAME=sn                # Attribut nom d'un utilisateur
LDAP_DISPLAYNAME=displayName    # Attribut displayname d'un utilisateur
LDAP_EMAIL=mail                 # Attribut mail d'un utilisateur
LDAP_MEMBER=memberUid           # Liste des uid utilisateur dans un groupe
```

#### Variable LDAP_SYNC

Pour activer la synchronisation des comptes il est nessaire d'activer cette variable

```
LDAP_SYNC
```

En fonction de votre MASTERIDENTITY vous pouvez synchroniser les utilisateurs

**Si MASTERIDENTITY est à SQL = synchronisation des datas la BDD vers l'annuaire**

Attention dans ce cas ninegate attend une structure d'annuaire bien précise. Vous pouvez retrouver cette structure si vous souhaitez déporter votre annuaire à ces emplacements :

- schema = ./volume/openldap/nine/schema/cadoles.ldif
- ldif = ./volume/openldap/nine/ldif/cadoles.ldif

Voici les variables qui indiquera à Ninegate où aller synchroniser son organisation

```
LDAP_BASEUSER="ou=users,ou=ninegate,o=gouv,c=fr"
LDAP_BASENIVEAU01="ou=niveau01,ou=ninegate,o=gouv,c=fr"
LDAP_BASENIVEAU02="ou=niveau02,ou=ninegate,o=gouv,c=fr"
LDAP_BASEGROUP="ou=groups,ou=ninegate,o=gouv,c=fr"
```

**Si MASTERIDENTITY est à LDAP**

Dans l'interface de ninegate sur les niveaux vous devrait lui indiquer comment créer les utilisateurs de ce niveau via un filtre LDAP

Exemple

```
(&(uid=*)(objectclass=inetOrgPerson)(!(description=Computer)))
```

Dans ce cas à l'initialisation de ninegate un premier niveau sera généré est lié à la requete annuaire déclarée via

```
OPENLDAPREQNIVEAU01
```

Vous pouvez aussi synchroniser vos groupes annuaires dans ninegate en activant et en précisant la requête LDAP permettrant de les récupérer

```
OPENLDAPSYNCHROGROUP
OPENLDAPREQGROUP
```

**Si MASTERIDENTITY est à SSO**

Il n'y a pas de synchronisation, la création / modification des utilisateurs se fait à la connexion de ce dernier.
