#!/bin/bash

#1 : action = default up
#2 : service = optionnel

# Include bibliotheque de fonction
. ./misc/tools/e-ihm.sh

# Start script
BigTitle "NINE"

#===========================================================================================================================================
#== STOP ===================================================================================================================================
#===========================================================================================================================================
#1 = service to stop if null all service
#2 = stopper par destroyall

stop() {
    if [[ "$2" != 1 ]]; then Title "STOP"; fi

    echo "docker-compose stop $1"
    docker-compose stop $1

    if [[ "$2" != 1 ]]; then echo; fi

    if [[ "$2" != 1 ]]; then Title "REMOVE"; fi
    
    if [[ "$1" != "" ]]; then 
        docker-compose rm -s -v -f "${1}"
    else
        docker-compose down
    fi
    
    if [[ "$2" != 1 ]]; then echo; fi
}

#===========================================================================================================================================
#== WAIT_FOR_CONTAINER =====================================================================================================================
#===========================================================================================================================================
#1 = service to wait

wait_for_container() {
    container_id="nine-$1"
    container_name="$(docker inspect "${container_id}" --format '{{ .Name }}')"
    waiting_done="false"

    while [[ "${waiting_done}" != "true" ]]; do
         container_state="$(docker inspect "${container_id}" --format '{{ .State.Status }}')"
         if [[ "${container_state}" == "running" ]]; then
             health_status="$(docker inspect "${container_id}" --format '{{ .State.Health.Status }}')"
             if [[ ${health_status} == "healthy" ]]; then
                 waiting_done="true"
             fi
         else
             waiting_done="true"
         fi
        sleep 1;
    done;
}


#===========================================================================================================================================
#== UP =====================================================================================================================================
#===========================================================================================================================================
#1 = service to up if null all service

up(){
    # Stop du ou des services
    stop $1

    # SERVICES
    if [[ -z "$1" ]]
    then
        # Pour chaque répertoire service on execute sa fonction up
        for key in $(for k in "${!services[@]}"; do echo "$k:${services[$k]}"; done | sort -t: -k2,2 | cut -d: -f1); do
            up${key}
        done
    else
        up${1}
    fi
}

upservice(){
    docker-compose up -d --remove-orphans $1
    if [[ $2 == "wait" ]]
    then
        wait_for_container $1
    fi
}

#===========================================================================================================================================
#== DESTROYALL =============================================================================================================================
#===========================================================================================================================================

destroyall(){
    Question_ouinon "Souhaitez-vous supprimer l'ensemble des containers : Attention cela supprimera vraiment tout  ?"
    if [[ "$?" = 0 ]]
    then
        # Pour chaque répertoire service on execute sa fonction destroy
        # On part du dernier service vers le premiser
        for key in $(for k in "${!services[@]}"; do echo "$k:${services[$k]}"; done | sort -t: -k2,2r | cut -d: -f1); do
            destroy${key} 1
        done
    fi
}


#===========================================================================================================================================
#== PULL ===================================================================================================================================
#===========================================================================================================================================

pull(){
    if [[ "$1" == "" ]]
    then
        Question_ouinon "Souhaitez-vous mettre à jour les images  ?"
    else
        Question_ouinon "Souhaitez-vous mettre à jour l'images du service $1  ?"
    fi

    if [[ "$?" = 0 ]]
    then
        stop $1
        docker-compose pull $1
    fi
}

#===========================================================================================================================================
#== ENV ====================================================================================================================================
#===========================================================================================================================================
# Construction des environnements mergés par service
        
env(){
    for dir in $(ls -d "services"/[0-9][0-9]-* | sort); do
        mergeenv $dir/env/.env.merge env/.env.merge $dir/env/.env $dir/env/.env.local
        #misc/tools/mergeenv.sh $dir
    done    
}

#===========================================================================================================================================
#== DOCKERCOMPOSE ====================================================================================================================================
#===========================================================================================================================================
# Construction du dockercompose

dockercompose() {

    echo "services:" > services.yml
    echo "secrets:" > secrets.yml
    echo "networks:" > networks.yml
    echo "  nine-network:" >> networks.yml
    echo "    name: nine-network" >> networks.yml
    for dir in $(ls -d "services"/[0-9][0-9]-* | sort); do
        # Construction du docker-compose
        if [ -f "$dir/dockercompose/dockercompose.yml" ]; then
        unset section
        while read; do
            case $REPLY in
                "services:")
                    section=${REPLY%:}
                    ;;
                "secrets:")
                    section=${REPLY%:}
                    ;;
                "networks:")
                    section=${REPLY%:}
                    ;;
                *)
                    if [ -n "$section" ]; then
                        echo "$REPLY" >> ${section}.yml
                    fi
                    ;;

            esac
        done < "$dir/dockercompose/dockercompose.yml"
        fi  
    done
    
    cat services.yml secrets.yml networks.yml > docker-compose.yml
    rm -f services.yml secrets.yml networks.yml

}

#===========================================================================================================================================
#== APACHE =================================================================================================================================
#===========================================================================================================================================
# Construction conf apache
        
apache(){
    for dir in $(ls -d "services"/[0-9][0-9]-* | sort); do
        keyservice="${dir##*-}"
        valueservice="${dir##*/}"

        mkdir -p services/10-nineapache/volume/apache
        if [ -f "$dir/apache/apache.conf" ]; then
            cp "$dir/apache/apache.conf" services/10-nineapache/volume/apache/$valueservice.conf
        fi 
    done    
}


#===========================================================================================================================================
#== TEMPLATE================================================================================================================================
#===========================================================================================================================================
# Templatisation

template() {
    for dir in $(ls -d "services"/[0-9][0-9]-* | sort); do
        misc/tools/dicos.sh $dir   
    done
}

#===========================================================================================================================================
#== SERVICES ===============================================================================================================================
#===========================================================================================================================================
# Liste des services 
        
services() {
    Title "SERVICES"

    for dir in $(ls -d "services"/[0-9][0-9]-* | sort); do
        keyservice="${dir##*-}"
        valueservice="${dir##*/}"
        Echo $keyservice
    done    
}

#===========================================================================================================================================
#== MAIN ===================================================================================================================================
#===========================================================================================================================================

# Include variable d'environnement global
mergeenv env/.env.merge env/.env env/.env.local
#misc/tools/mergeenv.sh
. env/.env.merge
# Include service
declare -A services
for dir in $(ls -d "services"/[0-9][0-9]-* | sort); do
    keyservice="${dir##*-}"
    valueservice="${dir##*/}"

    # Include bibliotheque de fonction
    if [ -f "$dir/misc/nine.sh" ]; then
        . $dir/misc/nine.sh
    fi

    # Include variable d'environnement global
    if [ -f "$dir/env/.env" ]; then
        . $dir/env/.env
    fi

    # Include variable d'environnement local
    if [ -f "$dir/env/.env.local" ]; then
        . $dir/env/.env.local
    fi
    
    # Sauvegarder le service
    services["$keyservice"]="$valueservice"    
done

# Construction des environnements mergés par service
env

# Construction docker_compose
dockercompose

# Construction de la configuration apache
apache

# Templetisation
template

# Execution de la commande
if [[ $1 == "up" || $1 == "" ]]
then
    up $2
elif [[ $1 == "uplogs" || $1 == "" ]]
then
    up $2    
    docker-compose logs -f $2
elif  [[ $1 == "stop" ]]
then
    stop $2
elif  [[ $1 == "bash" ]]
then
    if [[ -z $2 ]]
    then
        EchoRouge "Vous devez precisez un service"
        EchoRouge "nine.sh bash monservice"
    else
        docker-compose exec $2 "/bin/bash"
    fi
elif  [[ $1 == "destroyall" ]]
then
    destroyall
elif  [[ $1 == "destroy" ]]
then
    if [[ -z $2 ]]
    then
        EchoRouge "Vous devez precisez un service"
        EchoRouge "nine.sh destroy monservice"
    else
        destroy$2
    fi
elif [[ $1 == "pull" ]]
then
    pull $2
elif [[ $1 == "pulluplogs" ]]
then
    pull $2
    up $2    
    docker-compose logs -f $2
elif [[ $1 == "services" ]]
then
    services
elif  [[ $1 == "logs" ]]
then
    docker-compose logs -f $2
elif [[ $1 == "iswait" ]]
then
    wait_for_container $2
elif [[ $1 == "regen" ]]
then
    if [[ -z $2 ]]
    then
        destroyall
        apache
        template
        up
    else
        destroy$2
        apache
        template        
        up$2
    fi
elif [[ $1 == "regenlogs" ]]
then
    if [[ -z $2 ]]
    then
        destroyall
        apache
        template
        up
    else
        destroy$2
        apache
        template        
        up$2
    fi
    docker-compose logs -f $2
elif [[ $1 == "letsencrypt" ]]
then
    Title ${NINEAPACHE_SERVICE_NAME^^} LETSENCRYPT
    if [[ $NINEAPACHE_ACTIVATE == 1 && $NINEAPACHE_LOCAL == 1 ]]
    then
        docker-compose exec ${NINEAPACHE_SERVICE_NAME} /nine/addcertif.sh
    else
        EchoRouge "Service ${NINEAPACHE_SERVICE_NAME} non actif"
    fi
else
    EchoRouge "Action possible ="
    EchoRouge "nine.sh > UP de l'ensemble des services actifs"
    EchoRouge "nine.sh up > UP de l'ensemble des services actifs"
    EchoRouge "nine.sh up monservice> UP de monservice"
    EchoRouge "nine.sh uplogs > UP puis logs de l'ensemble des services actifs"
    EchoRouge "nine.sh uplogs monservice> UP puis logs de monservice"    
    EchoRouge "nine.sh stop > STOP de l'ensemble des services"
    EchoRouge "nine.sh stop monservice > STOP de monservice"
    EchoRouge "nine.sh bash monservice > lance un terminel dans le conteneur de monservice"
    EchoRouge "nine.sh destroyall > détruit l'ensemble des services avec l'ensemble des BDD et des volumes persistant"
    EchoRouge "nine.sh destroy monservice > détruit monservices et si souhaitez sa BDD et ses volumes persistant"
    EchoRouge "nine.sh pull > Mettre à jour l'ensemble des images"
    EchoRouge "nine.sh pull monservice > Mettre à jour l'image de monservice"
    EchoRouge "nine.sh pulluplogs > Mettre à jour l'ensemble des images et uplogs de l'ensemble des services"
    EchoRouge "nine.sh pulluplogs monservice > Mettre à jour l'image de monservice et uplogs de mon service"
    EchoRouge "nine.sh services > Liste des Services"
    EchoRouge "nine.sh logs > LOGS de l'ensemble des services"
    EchoRouge "nine.sh logs monservice > LOGS de monservice"
    EchoRouge "nine.sh iswait monservice > monservice est-il en cours de construction"
    EchoRouge "nine.sh regen > lance destroyall puis up sur l'ensemble des service"
    EchoRouge "nine.sh regen monservice > lance destroy monservice puis up monservice"
    EchoRouge "nine.sh letsencrypt > genere ou renouvelle le certificat letsencrypt"
fi
echo
echo
