#!/bin/bash
set -eo pipefail

cd /app/public


if [[ ! -f /app/public/wp-config.php ]]
then
    wp config create \
            --allow-root \
            --dbhost="${WORDPRESS_DB_HOST}" \
            --dbname="${WORDPRESS_DB_NAME}" \
            --dbuser="${WORDPRESS_DB_USER}" \
            --dbpass="${WORDPRESS_DB_PASSWORD}" \
            --dbcharset="utf8mb4" \
            --locale="fr_FR"
fi



wp config set --allow-root DB_HOST ${WORDPRESS_DB_HOST}
wp config set --allow-root DB_NAME ${WORDPRESS_DB_NAME}
wp config set --allow-root DB_USER ${WORDPRESS_DB_USER}
wp config set --allow-root DB_PASSWORD ${WORDPRESS_DB_PASSWORD}

# le ? permet d'enlever le / à la fin de WORDPRESS_ALIAS
wp config set --allow-root WP_HOME ${WORDPRESS_PROTOCOL}://${WORDPRESS_DOMAINE}${WORDPRESS_ALIAS::-1}
wp config set --allow-root WP_SITEURL ${WORDPRESS_PROTOCOL}://${WORDPRESS_DOMAINE}${WORDPRESS_ALIAS::-1}

wp config set --allow-root WP_ALLOW_MULTISITE true --raw
wp config set --allow-root MULTISITE true --raw
wp config set --allow-root SUBDOMAIN_INSTALL false --raw
wp config set --allow-root DOMAIN_CURRENT_SITE ${WORDPRESS_DOMAINE}
wp config set --allow-root PATH_CURRENT_SITE ${WORDPRESS_ALIAS}
wp config set --allow-root FORCE_ADMIN_SSL false --raw
wp config set --allow-root SITE_ID_CURRENT_SITE 1 --raw
wp config set --allow-root BLOG_ID_CURRENT_SITE 1 --raw

# On fait croire à WP qu'il est en https
if grep -qF "_SERVER['HTTPS']='on'" "wp-config.php"; then
    if [[ "${WORDPRESS_PROTOCOL}" == "https" ]]
    then
        echo "FORCE HTTPS already set"
    fi
else
    if [[ "${WORDPRESS_PROTOCOL}" == "https" ]]
    then
        echo "FORCE HTTPS set"
        head -n 1 "wp-config.php" > "wp-config.tmp"
        echo "\$_SERVER['HTTPS']='on';" >> "wp-config.tmp"
        tail -n +2 "wp-config.php" >> "wp-config.tmp"
        mv "wp-config.tmp" "wp-config.php"
    fi
fi

# Install multisite
wp core multisite-install \
	--allow-root \
    --url="${WORDPRESS_PROTOCOL}://${WORDPRESS_DOMAINE}" \
	--title="${WORDPRESS_TITLE}" \
	--admin_user="${WORDPRESS_USER}" \
	--admin_password="${WORDPRESS_PASSWORD}" \
	--admin_email="${WORDPRESS_EMAIL}" \
	--skip-email

# Switch language
echo "== Switch languange"
wp language core install fr_FR 
wp site switch-language fr_FR

# Install plugin
#if [[ "${MODE_AUTH}" == "CAS" && "${CAS_ACTIVATE}" == "1" ]]
#then
#    wp plugin install wp-cassify
#    wp plugin activate wp-cassify --network
#else
#    wp plugin delete wp-cassify
#fi

# Mise à jour theme / plugin / network
wp theme install twentytwentyfour --allow-root
wp theme enable twentytwentyfour --network
wp theme install lowfi --allow-root
wp theme enable lowfi --network
wp theme install astra --allow-root
wp theme enable astra --network
wp plugin install advanced-posts-listing --allow-root
wp plugin activate advanced-posts-listing --network
wp plugin install ultimate-addons-for-gutenberg --allow-root
wp plugin activate ultimate-addons-for-gutenberg --network
wp plugin install wordpress-importer --allow-root
wp plugin install envira-gallery-lite --allow-root

wp theme update --allow-root --all
wp plugin update --allow-root --all
wp language core update 
wp language theme update --all
wp language plugin update --all

# Mise à jour du network
wp core update-db --network

chown -R apache wp-content
chgrp -R apache wp-content

exec $@