/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.cas.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.keycloak.protocol.cas.representations.CASServiceResponse;

public final class ServiceResponseMarshaller {
    private ServiceResponseMarshaller() {
    }

    public static String marshalXml(CASServiceResponse serviceResponse) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CASServiceResponse.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)StandardCharsets.UTF_8.name());
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter writer = new StringWriter();
            marshaller.marshal((Object)serviceResponse, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static String marshalJson(CASServiceResponse serviceResponse) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter().withObjectIndenter((DefaultPrettyPrinter.Indenter)new DefaultIndenter("  ", "\n"));
        HashMap<String, CASServiceResponse> casModel = new HashMap<String, CASServiceResponse>();
        casModel.put("serviceResponse", serviceResponse);
        try {
            return mapper.writer((PrettyPrinter)printer).writeValueAsString(casModel);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

