/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.cas.utils;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.models.KeycloakSession;

public class LogoutHelper {
    private static final String TEMPLATE = "<samlp:LogoutRequest xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" ID=\"$ID\" Version=\"2.0\" IssueInstant=\"$ISSUE_INSTANT\">\n  <saml:NameID xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\">@NOT_USED@</saml:NameID>\n  <samlp:SessionIndex>$SESSION_IDENTIFIER</samlp:SessionIndex>\n</samlp:LogoutRequest>";

    public static HttpEntity buildSingleLogoutRequest(String serviceTicket) throws IOException {
        String id = "ID_" + UUID.randomUUID().toString();
        String issueInstant = new SimpleDateFormat("yyyy-MM-dd'T'H:mm:ss").format(new Date());
        String document = TEMPLATE.replace("$ID", id).replace("$ISSUE_INSTANT", issueInstant).replace("$SESSION_IDENTIFIER", serviceTicket);
        LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("logoutRequest", document));
        return new UrlEncodedFormEntity(parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void postWithRedirect(KeycloakSession session, String url, HttpEntity postBody) throws IOException {
        CloseableHttpClient httpClient = ((HttpClientProvider)session.getProvider(HttpClientProvider.class)).getHttpClient();
        for (int i = 0; i < 2; ++i) {
            HttpPost post = new HttpPost((String)url);
            post.setEntity(postBody);
            HttpResponse response = httpClient.execute((HttpUriRequest)post);
            try {
                int status = response.getStatusLine().getStatusCode();
                if (status != 302 || ((String)url).endsWith("/")) break;
                String redirect = response.getFirstHeader("Location").getValue();
                String withSlash = (String)url + "/";
                if (!withSlash.equals(redirect)) break;
                url = withSlash;
                continue;
            }
            finally {
                InputStream is;
                HttpEntity entity = response.getEntity();
                if (entity != null && (is = entity.getContent()) != null) {
                    is.close();
                }
            }
        }
    }
}

