/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.cas.utils;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import org.keycloak.protocol.cas.representations.CASErrorCode;
import org.keycloak.protocol.cas.utils.CASValidationException;

public class ContentTypeHelper {
    private final UriInfo uriInfo;

    public ContentTypeHelper(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public MediaType selectResponseType() {
        String format = (String)this.uriInfo.getQueryParameters().getFirst((Object)"format");
        if (format != null && !format.isEmpty()) {
            if (format.equalsIgnoreCase("json")) {
                return MediaType.APPLICATION_JSON_TYPE;
            }
            if (format.equalsIgnoreCase("xml")) {
                return MediaType.APPLICATION_XML_TYPE;
            }
            throw new CASValidationException(CASErrorCode.INVALID_REQUEST, "Unsupported value of parameter format", Response.Status.BAD_REQUEST);
        }
        return MediaType.APPLICATION_XML_TYPE;
    }
}

