/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.cas.mappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.cas.mappers.AbstractUserRoleMappingMapper;
import org.keycloak.protocol.cas.mappers.CASAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.AccessToken;
import org.keycloak.utils.RoleResolveUtil;

public class UserClientRoleMappingMapper
extends AbstractUserRoleMappingMapper {
    public static final String PROVIDER_ID = "cas-usermodel-client-role-mapper";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "User Client Role";
    }

    @Override
    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getHelpText() {
        return "Map a user client role to a token claim.";
    }

    @Override
    public void setAttribute(Map<String, Object> attributes, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession session, ClientSessionContext clientSessionCtx) {
        String clientId = (String)mappingModel.getConfig().get("usermodel.clientRoleMapping.clientId");
        String rolePrefix = (String)mappingModel.getConfig().get("usermodel.clientRoleMapping.rolePrefix");
        if (clientId != null && !clientId.isEmpty()) {
            AccessToken.Access access2 = RoleResolveUtil.getResolvedClientRoles((KeycloakSession)session, (ClientSessionContext)clientSessionCtx, (String)clientId, (boolean)false);
            if (access2 == null) {
                return;
            }
            this.setAttribute(attributes, mappingModel, access2.getRoles(), rolePrefix);
        } else {
            Map allAccess = RoleResolveUtil.getAllResolvedClientRoles((KeycloakSession)session, (ClientSessionContext)clientSessionCtx);
            Set<String> allRoles = allAccess.values().stream().filter(Objects::nonNull).flatMap(access -> access.getRoles().stream()).collect(Collectors.toSet());
            this.setAttribute(attributes, mappingModel, allRoles, rolePrefix);
        }
    }

    public static ProtocolMapperModel create(String clientId, String clientRolePrefix, String name, String tokenClaimName) {
        ProtocolMapperModel mapper = CASAttributeMapperHelper.createClaimMapper(name, tokenClaimName, "String", PROVIDER_ID);
        mapper.getConfig().put("usermodel.clientRoleMapping.clientId", clientId);
        mapper.getConfig().put("usermodel.clientRoleMapping.rolePrefix", clientRolePrefix);
        return mapper;
    }

    static {
        ProviderConfigProperty clientId = new ProviderConfigProperty();
        clientId.setName("usermodel.clientRoleMapping.clientId");
        clientId.setLabel("usermodel.clientRoleMapping.clientId.label");
        clientId.setHelpText("usermodel.clientRoleMapping.clientId.tooltip");
        clientId.setType("ClientList");
        CONFIG_PROPERTIES.add(clientId);
        ProviderConfigProperty clientRolePrefix = new ProviderConfigProperty();
        clientRolePrefix.setName("usermodel.clientRoleMapping.rolePrefix");
        clientRolePrefix.setLabel("usermodel.clientRoleMapping.rolePrefix.label");
        clientRolePrefix.setHelpText("usermodel.clientRoleMapping.rolePrefix.tooltip");
        clientRolePrefix.setType("String");
        CONFIG_PROPERTIES.add(clientRolePrefix);
        OIDCAttributeMapperHelper.addTokenClaimNameConfig(CONFIG_PROPERTIES);
    }
}

