/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.cas.mappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.cas.mappers.AbstractCASProtocolMapper;
import org.keycloak.protocol.cas.mappers.CASAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.provider.ProviderConfigProperty;

public class FullNameMapper
extends AbstractCASProtocolMapper {
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String PROVIDER_ID = "cas-full-name-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "User's full name";
    }

    public String getHelpText() {
        return "Maps the user's first and last name to the OpenID Connect 'name' claim. Format is <first> + ' ' + <last>";
    }

    @Override
    public void setAttribute(Map<String, Object> attributes, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession session, ClientSessionContext clientSessionCt) {
        UserModel user = userSession.getUser();
        String first = user.getFirstName() == null ? "" : user.getFirstName() + " ";
        String last = user.getLastName() == null ? "" : user.getLastName();
        this.setMappedAttribute(attributes, mappingModel, first + last);
    }

    public static ProtocolMapperModel create(String name, String tokenClaimName) {
        return CASAttributeMapperHelper.createClaimMapper(name, tokenClaimName, "String", PROVIDER_ID);
    }

    static {
        OIDCAttributeMapperHelper.addTokenClaimNameConfig(configProperties);
    }
}

