/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.cas.installation;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import org.keycloak.Config;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.ClientInstallationProvider;
import org.keycloak.services.resources.RealmsResource;

public class KeycloakCASClientInstallation
implements ClientInstallationProvider {
    public Response generateInstallation(KeycloakSession session, RealmModel realm, ClientModel client, URI baseUri) {
        UriBuilder bindingUrlBuilder = UriBuilder.fromUri((URI)baseUri);
        String bindingUrl = RealmsResource.protocolUrl((UriBuilder)bindingUrlBuilder).build(new Object[]{realm.getName(), "cas"}).toString();
        String description = "CAS Server URL: " + bindingUrl + "\nCAS Protocol: CAS 2.0/3.0, SAML 1.1\nUse CAS REST API: false (unsupported)";
        return Response.ok((Object)description, (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
    }

    public String getProtocol() {
        return "cas";
    }

    public String getDisplayType() {
        return "Plain CAS configuration";
    }

    public String getHelpText() {
        return "CAS configuration properties required by CAS clients. Enter the values shown below into the configuration dialog of your client SP.";
    }

    public void close() {
    }

    public ClientInstallationProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return "keycloak-cas-text";
    }

    public boolean isDownloadOnly() {
        return false;
    }

    public String getFilename() {
        return "keycloak-cas.txt";
    }

    public String getMediaType() {
        return "text/plain";
    }
}

