/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.cas;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.jboss.logging.Logger;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.cas.utils.LogoutHelper;
import org.keycloak.protocol.oidc.utils.OAuth2Code;
import org.keycloak.protocol.oidc.utils.OAuth2CodeParser;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.sessions.AuthenticationSessionModel;

public class CASLoginProtocol
implements LoginProtocol {
    private static final Logger logger = Logger.getLogger(CASLoginProtocol.class);
    public static final String LOGIN_PROTOCOL = "cas";
    public static final String SERVICE_PARAM = "service";
    public static final String TARGET_PARAM = "TARGET";
    public static final String RENEW_PARAM = "renew";
    public static final String GATEWAY_PARAM = "gateway";
    public static final String TICKET_PARAM = "ticket";
    public static final String FORMAT_PARAM = "format";
    public static final String TICKET_RESPONSE_PARAM = "ticket";
    public static final String SAMLART_RESPONSE_PARAM = "SAMLart";
    public static final String SERVICE_TICKET_PREFIX = "ST-";
    public static final String SESSION_SERVICE_TICKET = "service_ticket";
    public static final String LOGOUT_REDIRECT_URI = "CAS_LOGOUT_REDIRECT_URI";
    protected KeycloakSession session;
    protected RealmModel realm;
    protected UriInfo uriInfo;
    protected HttpHeaders headers;
    protected EventBuilder event;

    public CASLoginProtocol(KeycloakSession session, RealmModel realm, UriInfo uriInfo, HttpHeaders headers, EventBuilder event) {
        this.session = session;
        this.realm = realm;
        this.uriInfo = uriInfo;
        this.headers = headers;
        this.event = event;
    }

    public CASLoginProtocol() {
    }

    public CASLoginProtocol setSession(KeycloakSession session) {
        this.session = session;
        return this;
    }

    public CASLoginProtocol setRealm(RealmModel realm) {
        this.realm = realm;
        return this;
    }

    public CASLoginProtocol setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
        return this;
    }

    public CASLoginProtocol setHttpHeaders(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public CASLoginProtocol setEventBuilder(EventBuilder event) {
        this.event = event;
        return this;
    }

    public Response authenticated(AuthenticationSessionModel authSession, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        AuthenticatedClientSessionModel clientSession = clientSessionCtx.getClientSession();
        String service = authSession.getRedirectUri();
        OAuth2Code codeData = new OAuth2Code(UUID.randomUUID().toString(), Time.currentTime() + userSession.getRealm().getAccessCodeLifespan(), null, null, authSession.getRedirectUri(), null, null, userSession.getId());
        String code = OAuth2CodeParser.persistCode((KeycloakSession)this.session, (AuthenticatedClientSessionModel)clientSession, (OAuth2Code)codeData);
        KeycloakUriBuilder uriBuilder = KeycloakUriBuilder.fromUri((String)service);
        String loginTicket = SERVICE_TICKET_PREFIX + code;
        if (authSession.getClientNotes().containsKey(TARGET_PARAM)) {
            uriBuilder.queryParam(SAMLART_RESPONSE_PARAM, new Object[]{loginTicket});
        } else {
            uriBuilder.queryParam("ticket", new Object[]{loginTicket});
        }
        URI redirectUri = uriBuilder.build(new Object[0]);
        Response.ResponseBuilder location = Response.status((int)302).location(redirectUri);
        return location.build();
    }

    public Response sendError(AuthenticationSessionModel authSession, LoginProtocol.Error error) {
        if (authSession.getClientNotes().containsKey(GATEWAY_PARAM) && (error == LoginProtocol.Error.PASSIVE_INTERACTION_REQUIRED || error == LoginProtocol.Error.PASSIVE_LOGIN_REQUIRED)) {
            return Response.status((int)302).location(URI.create(authSession.getRedirectUri())).build();
        }
        return ErrorPage.error((KeycloakSession)this.session, (AuthenticationSessionModel)authSession, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)error.name(), (Object[])new Object[0]);
    }

    public Response backchannelLogout(UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        String logoutUrl = clientSession.getRedirectUri();
        String serviceTicket = clientSession.getNote(SESSION_SERVICE_TICKET);
        if (serviceTicket != null && !serviceTicket.isEmpty()) {
            this.sendSingleLogoutRequest(logoutUrl, serviceTicket);
        }
        ClientModel client = clientSession.getClient();
        new ResourceAdminManager(this.session).logoutClientSession(this.realm, client, clientSession).close();
        return Response.ok().build();
    }

    private void sendSingleLogoutRequest(String logoutUrl, String serviceTicket) {
        try {
            HttpEntity requestEntity = LogoutHelper.buildSingleLogoutRequest(serviceTicket);
            LogoutHelper.postWithRedirect(this.session, logoutUrl, requestEntity);
            logger.debug((Object)("Sent CAS single logout for service " + logoutUrl));
        }
        catch (IOException e) {
            logger.warn((Object)("Failed to call CAS service for logout: " + logoutUrl), (Throwable)e);
        }
    }

    public Response frontchannelLogout(UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public Response finishBrowserLogout(UserSessionModel userSession, AuthenticationSessionModel logoutSession) {
        String redirectUri = userSession.getNote(LOGOUT_REDIRECT_URI);
        this.event.event(EventType.LOGOUT).user(userSession.getUser()).session(userSession).detail("username", userSession.getUser().getUsername());
        if (redirectUri != null) {
            this.event.detail("redirect_uri", redirectUri);
            this.event.success();
            return Response.status((int)302).location(URI.create(redirectUri)).build();
        }
        this.event.success();
        LoginFormsProvider infoPage = ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setSuccess("Logout successful", new Object[0]);
        infoPage.setAttribute("skipLink", (Object)true);
        return infoPage.createInfoPage();
    }

    public boolean requireReauthentication(UserSessionModel userSession, AuthenticationSessionModel authSession) {
        return "true".equals(authSession.getClientNote(RENEW_PARAM));
    }

    public void close() {
    }
}

