<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * Wordcloudword
 *
 * @ORM\Table(name="wordcloudword")
 * @ORM\Entity(repositoryClass="App\Repository\WordcloudwordRepository")
 * 
 */
class Wordcloudword
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $title;
    
    /**
     * @ORM\Column(name="colorfont", type="string", nullable=true)
     */
    private $colorfont;

    /**
     * @ORM\ManyToOne(targetEntity="Wordcloud", inversedBy="wordcloudwords")
     */
    private $wordcloud;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="wordcloudwords")
     * @ORM\JoinColumn(nullable=true)
     */
    private $user;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(int $id): self
    {
        $this->id = $id;

        return $this;
    }
    
    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(string $title): self
    {
        $this->title = $title;

        return $this;
    }


    public function getWordcloud(): ?Wordcloud
    {
        return $this->wordcloud;
    }

    public function setWordcloud(?Wordcloud $wordcloud): self
    {
        $this->wordcloud = $wordcloud;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    public function getColorfont(): ?string
    {
        return $this->colorfont;
    }

    public function setColorfont(?string $colorfont): self
    {
        $this->colorfont = $colorfont;

        return $this;
    }
}
