<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * Wordcloud
 *
 * @ORM\Table(name="wordcloud")
 * @ORM\Entity(repositoryClass="App\Repository\WordcloudRepository")
 * 
 */
class Wordcloud
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $title;

    /**
     * @ORM\Column(name="backgroundcolor", type="string", nullable=true)
     */
    private $backgroundcolor;
    
    /**
     * @ORM\Column(name="backgroundimage", type="string", nullable=true)
     */
    private $backgroundimage;
    
    /**
     * @ORM\Column(name="backgroundmode", type="string", nullable=true)
     */
    private $backgroundmode;    
    
    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="wordclouds")
     */
    private $user;

    /**
     * @ORM\OneToMany(targetEntity="Wordcloudword", mappedBy="wordcloud", cascade={"persist"}, orphanRemoval=true)
     */
    private $wordcloudwords;

    /**
     * @ORM\ManyToMany(targetEntity="Group", inversedBy="wordclouds", cascade={"persist"})
     * @ORM\JoinTable(name="wordcloudgroupe",
     *   joinColumns={@ORM\JoinColumn(name="wordcloud", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groups;

    /**
     * @ORM\ManyToMany(targetEntity="Group", inversedBy="wordcloudwriters", cascade={"persist"})
     * @ORM\JoinTable(name="wordcloudgroupewriter",
     *   joinColumns={@ORM\JoinColumn(name="wordcloud", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groupwriters;

    /**
     * @ORM\ManyToMany(targetEntity="Group", inversedBy="wordcloudreaders", cascade={"persist"})
     * @ORM\JoinTable(name="wordcloudgroupereader",
     *   joinColumns={@ORM\JoinColumn(name="wordcloud", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groupreaders;

    /**
     * @ORM\ManyToMany(targetEntity="User", inversedBy="wordcloudshareds", cascade={"persist"})
     * @ORM\JoinTable(name="wordclouduser",
     *   joinColumns={@ORM\JoinColumn(name="wordcloud", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $users;

    /**
     * @ORM\ManyToMany(targetEntity="User", inversedBy="wordcloudsharedwriters", cascade={"persist"})
     * @ORM\JoinTable(name="wordclouduserwriter",
     *   joinColumns={@ORM\JoinColumn(name="wordcloud", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $userwriters;

    /**
     * @ORM\ManyToMany(targetEntity="User", inversedBy="wordcloudsharedreaders", cascade={"persist"})
     * @ORM\JoinTable(name="wordclouduserreader",
     *   joinColumns={@ORM\JoinColumn(name="wordcloud", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $userreaders;

    protected $info;

    public function __construct()
    {
        $this->wordcloudwords = new ArrayCollection();
        $this->groups = new ArrayCollection();
        $this->groupwriters = new ArrayCollection();
        $this->groupreaders = new ArrayCollection();
        $this->users = new ArrayCollection();
        $this->userwriters = new ArrayCollection();
        $this->userreaders = new ArrayCollection();
    }

    public function getInfo() {
        $info=[];
        $prevColor = '#000000';
        foreach($this->getWordcloudwords() as $word) {
            $cpt=1;
            if(array_key_exists(strtoupper($word->getTitle()),$info))
                $cpt=$info[strtoupper($word->getTitle())]["cpt"]+1;
            $prevColor = ($prevColor != $word->getColorfont()) ? $word->getColorfont() : $prevColor;
            $tmp=[
                "id"=>$word->getId(),
                "name"=>$word->getTitle(),
                "color"=>$prevColor,
                "cpt"=>$cpt,
            ];

            $info[strtoupper($word->getTitle())]=$tmp;
        }

        $cpt = array();
        $total=0;
        foreach ($info as $key => $row)
        {
            $cpt[$key] = $row['cpt'];
            $total+=$row['cpt'];
        }
        array_multisort($cpt, SORT_DESC, $info);

        return ["total"=>$total,"detail"=>$info];
    }
    public function getInfojQWCloud() {
        $info=[];
        $prevColor = '#000000';
        foreach($this->getWordcloudwords() as $word) {
            $cpt=1;
            if(array_key_exists(strtoupper($word->getTitle()),$info))
                $cpt=$info[strtoupper($word->getTitle())]["weight"]+1;
            $prevColor = ($prevColor != $word->getColorfont()) ? $word->getColorfont() : $prevColor;
            $tmp=[
                "id"=>$word->getId(),
                "word"=>$word->getTitle(),
                "color"=>$prevColor,
                "weight"=>$cpt,
            ];

            $info[strtoupper($word->getTitle())]=$tmp;
        }

        $cpt = array();
        $total=0;
        foreach ($info as $key => $row)
        {
            $cpt[$key] = $row['weight'];
            $total+=$row['weight'];
        }
        array_multisort($cpt, SORT_DESC, $info);

        return ["total"=>$total,"words"=>$info];
    }
    // public function getInfojQWCloud() {
    //     $info=[];
    //     $prevColor = '#000000';
    //     foreach($this->getWordcloudwords() as $word) {
    //         $cpt=1;
    //         if(array_key_exists(strtoupper($word->getTitle()),$info))
    //             $cpt=$info[strtoupper($word->getTitle())]["cpt"]+1;
    //         $prevColor = ($prevColor != $word->getColorfont()) ? $word->getColorfont() : $prevColor;
    //         $tmp=[
    //             "id"=>$word->getId(),
    //             "word"=>$word->getTitle(),
    //             "color"=>$prevColor,
    //             "cpt"=>$cpt,
    //         ];

    //         $info[$word->getTitle()]=$tmp;
    //     }

    //     $cpt = array();
    //     $total=0;
    //     foreach ($info as $key => $row)
    //     {
    //         $cpt[$key] = $row['cpt'];
    //         $total+=$row['cpt'];
    //     }
    //     array_multisort($cpt, SORT_DESC, $info);

    //     return ["total"=>$total,"words"=>$info];
    // }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(int $id): self
    {
        $this->id = $id;

        return $this;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(string $title): self
    {
        $this->title = $title;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    /**
     * @return Collection|Wordcloudword[]
     */
    public function getWordcloudwords(): Collection
    {
        return $this->wordcloudwords;
    }

    public function addWordcloudword(Wordcloudword $wordcloudword): self
    {
        if (!$this->wordcloudwords->contains($wordcloudword)) {
            $this->wordcloudwords[] = $wordcloudword;
            $wordcloudword->setWordcloud($this);
        }

        return $this;
    }

    public function removeWordcloudword(Wordcloudword $wordcloudword): self
    {
        if ($this->wordcloudwords->contains($wordcloudword)) {
            $this->wordcloudwords->removeElement($wordcloudword);
            // set the owning side to null (unless already changed)
            if ($wordcloudword->getWordcloud() === $this) {
                $wordcloudword->setWordcloud(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Group[]
     */
    public function getGroups(): Collection
    {
        return $this->groups;
    }

    public function addGroup(Group $group): self
    {
        if (!$this->groups->contains($group)) {
            $this->groups[] = $group;
        }

        return $this;
    }

    public function removeGroup(Group $group): self
    {
        if ($this->groups->contains($group)) {
            $this->groups->removeElement($group);
        }

        return $this;
    }

    /**
     * @return Collection|Group[]
     */
    public function getGroupwriters(): Collection
    {
        return $this->groupwriters;
    }

    public function addGroupwriter(Group $groupwriter): self
    {
        if (!$this->groupwriters->contains($groupwriter)) {
            $this->groupwriters[] = $groupwriter;
        }

        return $this;
    }

    public function removeGroupwriter(Group $groupwriter): self
    {
        if ($this->groupwriters->contains($groupwriter)) {
            $this->groupwriters->removeElement($groupwriter);
        }

        return $this;
    }

    /**
     * @return Collection|Group[]
     */
    public function getGroupreaders(): Collection
    {
        return $this->groupreaders;
    }

    public function addGroupreader(Group $groupreader): self
    {
        if (!$this->groupreaders->contains($groupreader)) {
            $this->groupreaders[] = $groupreader;
        }

        return $this;
    }

    public function removeGroupreader(Group $groupreader): self
    {
        if ($this->groupreaders->contains($groupreader)) {
            $this->groupreaders->removeElement($groupreader);
        }

        return $this;
    }

    /**
     * @return Collection|User[]
     */
    public function getUsers(): Collection
    {
        return $this->users;
    }

    public function addUser(User $user): self
    {
        if (!$this->users->contains($user)) {
            $this->users[] = $user;
        }

        return $this;
    }

    public function removeUser(User $user): self
    {
        if ($this->users->contains($user)) {
            $this->users->removeElement($user);
        }

        return $this;
    }

    /**
     * @return Collection|User[]
     */
    public function getUserwriters(): Collection
    {
        return $this->userwriters;
    }

    public function addUserwriter(User $userwriter): self
    {
        if (!$this->userwriters->contains($userwriter)) {
            $this->userwriters[] = $userwriter;
        }

        return $this;
    }

    public function removeUserwriter(User $userwriter): self
    {
        if ($this->userwriters->contains($userwriter)) {
            $this->userwriters->removeElement($userwriter);
        }

        return $this;
    }

    /**
     * @return Collection|User[]
     */
    public function getUserreaders(): Collection
    {
        return $this->userreaders;
    }

    public function addUserreader(User $userreader): self
    {
        if (!$this->userreaders->contains($userreader)) {
            $this->userreaders[] = $userreader;
        }

        return $this;
    }

    public function removeUserreader(User $userreader): self
    {
        if ($this->userreaders->contains($userreader)) {
            $this->userreaders->removeElement($userreader);
        }

        return $this;
    }

    public function getBackgroundcolor(): ?string
    {
        return $this->backgroundcolor;
    }

    public function setBackgroundcolor(?string $backgroundcolor): self
    {
        $this->backgroundcolor = $backgroundcolor;

        return $this;
    }

    public function getBackgroundimage(): ?string
    {
        return $this->backgroundimage;
    }

    public function setBackgroundimage(?string $backgroundimage): self
    {
        $this->backgroundimage = $backgroundimage;

        return $this;
    }

    public function getBackgroundmode(): ?string
    {
        return $this->backgroundmode;
    }

    public function setBackgroundmode(?string $backgroundmode): self
    {
        $this->backgroundmode = $backgroundmode;

        return $this;
    }


}
