'use strict'

var STR_UNDEFINED = 'undefined'
var STR_OBJECT    = 'object'
var HAS_OWN       = Object.prototype.hasOwnProperty

var copyList = require('./copyList')

/**
 * Copies all properties named in the namedKeys, from source to destination
 *
 *      copyKeys({name: 'jon',age:5, year: 2006, date: '2010/05/12'}, {}, {name:1 ,age: true, year: 'theYear'})
 *      // => {name: 'jon', age: 5, theYear: 2006}
 *
 * @param {Object} source
 * @param {Object} destination
 * @param {Object} namedKeys an object with keys denoting the properties to be copied
 *
 * @return {Object} destination
 */
module.exports = function(source, destination, namedKeys){
    if (arguments.length < 3 ){
        namedKeys = destination
        destination = null
    }

    destination = destination || {}

    if (!namedKeys || Array.isArray(namedKeys)){
        return copyList(source, destination, namedKeys)
    }

    if (
           source != null && typeof source    === STR_OBJECT &&
        namedKeys != null && typeof namedKeys === STR_OBJECT
    ) {
        var typeOfNamedProperty
        var namedPropertyValue

        for  (var propName in namedKeys) if ( HAS_OWN.call(namedKeys, propName) ) {
            namedPropertyValue  = namedKeys[propName]
            typeOfNamedProperty = typeof namedPropertyValue

            if (typeof source[propName] !== STR_UNDEFINED){
                destination[typeOfNamedProperty == 'string'? namedPropertyValue : propName] = source[propName]
            }
        }
    }

    return destination
}