<?php

/**
 * General tests for the advanced plugin
 *
 * @group tpl_bootstrap3
 * @group plugins
 */
class general_tpl_bootstrap3_test extends DokuWikiTest
{

    /**
     * Simple test to make sure the template.info.txt is in correct format
     */
    public function test_templateinfo()
    {
        $file = __DIR__ . '/../template.info.txt';
        $this->assertFileExists($file);

        $info = confToHash($file);

        $this->assertArrayHasKey('base', $info);
        $this->assertArrayHasKey('author', $info);
        $this->assertArrayHasKey('email', $info);
        $this->assertArrayHasKey('date', $info);
        $this->assertArrayHasKey('name', $info);
        $this->assertArrayHasKey('desc', $info);
        $this->assertArrayHasKey('url', $info);

        $this->assertEquals('bootstrap3', $info['base']);
        $this->assertRegExp('/^https?:\/\//', $info['url']);
        $this->assertTrue(mail_isvalid($info['email']));
        $this->assertRegExp('/^\d\d\d\d-\d\d-\d\d$/', $info['date']);
        $this->assertTrue(false !== strtotime($info['date']));
    }
}
