# -*- coding: utf8 -*-
# 23/09/2013: version reçue de Philippe Roy de Aix-Marseille
# 25/09/2103: intégration des modifications pour Fédération Parents sur multi-établissements
#fixes #21012 check if module LDAP exist
import imp
try:
    imp.find_module('ldap')
    import ldap
    LDAP_FOUND = True
except ImportError:
    LDAP_FOUND = False

def cleanString(s):
    import unicodedata
    """Enlève les accents"""
    if isinstance(s,str):
        s = unicode(s,"utf8","replace")
        s=unicodedata.normalize('NFD',s)
        return s.encode('ascii','ignore')
    return s

def calc_info(user_infos):
    """
    calcule ENTPersonProfils : Profil d'utilisateur ENT
    """
    if not LDAP_FOUND:
        return ["NODATA"];

    # Cas d'une authentification académique (ie l'attribut FrEduRne existe)
    a = user_infos.get('FrEduRne')
    # Cas d'une authentification depuis l'annuaire téléservices (ie l'attribut FrEduAffiliation existe)
    t = user_infos.get('FrEduAffiliation')
    if a != None:
        mail=user_infos.get('mail')[0].lower()

        # Recherche dans la base local (scribe)
        # l'intid (ENTPersonJointure) de la personne
        try:
            l=ldap.open("localhost")
            base="ou=education,o=gouv,c=fr"
            filtre="FederationKey="+mail
            result_id = l.search(base, ldap.SCOPE_SUBTREE, filtre, ['intid'])
            result_type, result_data = l.result(result_id, 100)
            if (result_data == []):
                key=["SESHATNoFederationKey from Replicat"]
            else:
                key=result_data[0][1]['intid']
        except ldap.LDAPError, error_message:
            key=["NODATA"]

    # Sinon si authentification sur l'annuaire téléservices
    elif t != None:
        import shelve
        from os.path import isfile
        from page import gen_page, trace, log

        Vecteur=user_infos.get('FrEduVecteur')

        fredu_db_path = '/usr/share/sso/reverseTeleservice.db'
        values = []
        if not isfile(fredu_db_path):
           key=["NODATA"]
        # récupération du dn dans la base sqlite
        db = shelve.open(fredu_db_path, 'r')

        user_intid=[]

        #Gestion du multi-établissement (FrEduVecteur multivalué)

        uaj=user_infos.get('uaj',[''])[0].upper()
        # UAJ est passé dans les user_infos
        # On va donc rechercher le non FrEduVecteur
        if uaj!='':
            for v in Vecteur:
                # Le 4 champ d'un FrEduVecteur contient le Code RNE
                if v.split("|")[4]==uaj:
                    user_intid = db.get(v, [])
                    if len(user_intid) != 0:
                        break


        # recherche de l'intid associé dans la base,
        # si user_intid n'est toujours pas trouvé
        if len(user_intid) == 0:
            for i in range(len(Vecteur)):
                user_intid = db.get(cleanString(Vecteur[i]), [])
                if len(user_intid) != 0:
                    break

        if not user_intid:
            key=["NODATA"]
        else:
            key=user_intid

    # Sinon authentification sur replicat des scribe
    # Récup l'intid=ENTPersonJointure

    else:
        key=[user_infos.get('intid')[0]]

    return key
