<?php

include_once "uinc.php";

define("REDIS_PERSISTENT",true);

function strtimeInFrench($str) {
    $d=str_replace('/', '-',$str);
    $d=str_replace('jour', 'day',$d);
    $d=str_replace('mois', 'month',$d);
    $d=str_replace('semaine', 'week',$d);
    $d=str_replace('heure', 'hour',$d);
    $d=str_replace('an', 'year',$d);
    $d=str_replace('hier', 'yesterday',$d);
    return strtotime($d);
}


if (!is_array($__METRICS)) die("CONF NOT FOUND");
if (!isset($__METRICS["slack"])) die("CONF NOT FOUND");
if (!isset($__METRICS["slack"]["bot_token"])) die("CONF NOT FOUND");

use Mpociot\BotMan\BotManFactory;
use Mpociot\BotMan\BotMan;


use React\EventLoop\Factory;
use Mpociot\BotMan\Messages\Message;

use Edispatcher\Bot\GrafanaWorkerThread;
use Edispatcher\Bot\GraphiqueConversation;


$loop = Factory::create();
$botman = BotManFactory::createForRTM([
    'slack_token' => $__METRICS["slack"]["bot_token"]
], $loop);

$metrics = \Edispatcher\Entity\Metrics::instance();

$client  = new \Maknz\Slack\Client($__METRICS["slack"]["hook_url"]);
GrafanaWorkerThread::init($client);

// give the bot something to listen for.
$botman->hears('^hello$|^bonjour$|^bonsoir$', function (BotMan $bot) use ($client,$metrics) {

  $hour = date('H');
  $dayTerm = ($hour > 17) ? "Bonsoir" : ($hour > 12) ? "Salut" : "Bonjour";

  $user=$bot->getMessage()->getUser();


  $bot->reply("$dayTerm <@$user>, comment va tu ?\n");

});

// ca va
$botman->hears('.*[ç|Ç]a va.*', function (BotMan $bot) use ($client,$metrics) {
    $fields = [];

    $health = $metrics->health();

    $message = "Merci de prende de mes nouvelles :wink:";

    $connexions = [
          'mrkdwn_in' => ['pretext', 'text'],
          "color" => "#275de8",
          "title" => "Connexions uniques",
          "text"  =>
"Sur la dernière *heure* il y a eu *{$health['hour']}* connexions\n".
"Sur *la journée* il y a déjà *{$health['day']}* connexions\n".
"Sur *le mois* il y a déjà *{$health['month']}* connexions représentant *{$health['month_percent']}*% des *{$health['accounts']}* comptes disponibles"
    ];

     $count = $metrics->getAvailableServers("hubole");
     $web = [
          'mrkdwn_in' => ['pretext', 'text'],
          "color" => $health['web_status'],
          "author_name" => "Données récoltées le " . date("d/m/Y à H:i:s",$health['web_time']),
          "title" => "Serveurs Applicatifs",
          "text"  => "Le pourcentage d'utilisation du CPU des serveurs applicatifs est de *{$health['web_cpu']}*%
Il reste *{$health['web_mem']}*% de mémoire vive disponible sur les serveurs applicatifs\n".
($health['web_swap']==0?"Le swap n'est pas utilisé ou très peu utilisé :white_check_mark:\n":"*{$health['web_swap']}Mo* du swap est utilisé\n").
"*".$count . "*% des serveurs sont disponibles"
];

      $count = $metrics->getAvailableServers("sso");
      $sso = [
           'mrkdwn_in' => ['pretext', 'text'],
           "color" => $health['sso_status'],
           "author_name" => "Données récoltées le " . date("d/m/Y à H:i:s",$health['sso_time']),
           "title" => "Serveurs SSO",
           "text"  => "Le pourcentage d'utilisation du CPU des serveurs sso est de *{$health['sso_cpu']}*%
Il reste *{$health['sso_mem']}*% de mémoire vive disponible sur les serveurs SSO\n".
($health['sso_swap']==0?"Le swap n'est pas utilisé ou très peu utilisé :white_check_mark:\n":"*{$health['sso_swap']}Mo* du swap est utilisé\n").
"*".$count. "*% des serveurs sont disponibles"

       ];

      $arena = [
          'mrkdwn_in' => ['pretext', 'text'],
          "color" => $health['arena_status'],
          "author_name" => "Données récoltées le " . date("d/m/Y H:i:s",$health['arena_time']),
          "title" => "Cache Arena",
          "text"  => "L'obsolescence moyenne du cache arena est de *{$health['arena_duration']}* heures".
          ($health['arena_obsolete']==0?" (Aucun cache obsolète)\n":"\n*{$health['arena_obsolete']}* caches obsolètes\n").
          "Durée moyenne de chargement du cache *{$health['arena_cache']}* ms"

      ];


    $client->to($bot->getMessage()->getChannel())
            ->attach($connexions)->attach($sso)->attach($web)->attach($arena)
            ->send($message);
});



// give the bot something to listen for.
$botman->hears('.*aide.*', function (BotMan $bot) use ($client,$metrics) {

  $bot->reply("Voici les commandes possibles :
  ```- visites par [heure|jour|mois|an][ au dd/mm/yy| à -x heure|jour|mois|an] : Affiche les visites pour la période demandée
- graphique : Propose un choix de graphiques disponibles
- graphique type[| depuis date]  : Affiche le graphique demandé avec possibilité de préciser la période

  ```
  "

  );

});

// Le nombes de connexion
$botman->hears('visites par {by}', function (BotMan $bot,$by) use ($client,$metrics) {

    $by=strtolower(trim($by));
    $b=preg_match('#visites par (heure|jour|mois|an)?$|visites par (heure|jour|mois|an)? [au|à]* (.*)#',"visites par $by",$matches);
    if (!$b || count($matches)<2 ) {
      $this->reply("Désolé, je ne comprends pas très bien !!!");
      return;
    }

    $by=$matches[1];
    $date = time();
    if (count($matches)==4) {
      $by=$matches[2];
      $date=strtimeInFrench($matches[3]);
      if ($date + 3600*2 < time()) {
        $date=strtotime(date("Ymd",$date));
      }
    }

    $b="";
    if ($by=="heure") $b="h";
    if ($by=="jour")  $b="d";
    if ($by=="mois")  $b="m";
    if ($by=="an")    $b="y";
    if (!$b) {
      $b="d";$by="jour";
    }
    $data = $metrics->accountsUsedByProfil($b,["time"=>$date]);
    $fields = [];
    foreach ($data as $field) {
      $fields[] = ["title" => $field->metric->profil,"value"=>$field->value[1],"short"=>true];
    }

    $attach = [
      'fallback' => "Voici les éléments pour ".date("d/m/Y H:i:s",$date),
      'fields'   => $fields,
      'title'    => "Voici les éléments pour ".date("d/m/Y H:i:s",$date),
      'color'    => "good"
    ];

    $client->to($bot->getMessage()->getChannel())
           ->attach($attach)
           ->send("Vous avez demandé le nombres de visites par *$by* au *".date("d/m/Y",$date)."*");
});

// Graphique ========================================================================================
$botman->hears('graphique {type}', function (BotMan $bot,$type) use ($client,$metrics) {

  $type=trim($type);

  $b=preg_match('#graphique ([A-Z,a-z,\-]*)$|graphique ([A-Z,a-z,\-]*) depuis (.*)#',"graphique $type",$matches);
  if (!$b || count($matches)<1 ) {
      $bot->reply("Désolé, je ne comprends pas très bien !!!");
      return;
  }

  $from=null;
  ///print_r($matches);

  if (count($matches)==4 && $matches[3]) {
      $type=$matches[2];
      $a=$matches[3][0];
      if (ctype_digit($a)) $matches[3]="- ".$matches[3];
      $from=strtimeInFrench($matches[3]);
  }

  $type=strtoupper($type);
  if (!isset(GrafanaWorkerThread::$GRAPHS[$type])) {
    $bot->reply("je ne trouve pas le graphique *$type* à générer");
    $bot->startConversation(new GraphiqueConversation($bot,$from));
    return;
  }

  GrafanaWorkerThread::GenerateGraphique($bot,$type,$from);

});

// Lance une conversation pour générer un graphique ===============================
$botman->hears('graphique', function (BotMan $bot) use ($client,$metrics) {
  $bot->startConversation(new GraphiqueConversation($bot));
});

// */10s Test la connection à Redis
$loop->addPeriodicTimer(10, function () use ($metrics) {
    $metrics->ping();
});


// */1h Check feedback
$loop->addPeriodicTimer(3600*1, function () use ($metrics,$client) {

    $redis = $metrics->getRedis();
    if (!$redis) return;

    $count=intval($redis->llen("feedback"));

    // Minimum 20 feedback
    if ($count < 20) {return ;}

    $z =0;
    $mire = 0; $app = 0; $bad = 1000; $good = -1000;$feedbackGood=null;$feedbackBad=null;
    for ($i=0;$i<$count;$i++) {
        $feedback=explode("|",$redis->lpop("feedback"));

        if (count($feedback)!=6) {
          continue;
        }

        if ($feedback[3]=="national_1") {
          continue;
        }

        $z++;
        $mire += intval($feedback[1]);
        $app  += intval($feedback[2]);

        $moy  = ($feedback[1]+$feedback[2])/2;

        if ($moy>=$good) {
            $good=$moy;
            $feedbackGood=$feedback;
        }

        if ($moy<=$bad) {
            $bad=$moy;
            $feedbackBad=$feedback;
        }
    }

    if ($z==0) {
        return;
    }

    $mire = ceil(($mire/$z)*10);
    $app  = ceil(($app/$z)*10);

    $goodAttach = [
         'mrkdwn_in' => ['pretext', 'text'],
         "color" => "good",
         "title" => "Bonne note",
         "text"  => $feedbackGood[0],
         "fields"  => [
             ["title"=>"Mire","value"=>$feedbackGood[1],"short"=>true],
             ["title"=>"App","value"=>$feedbackGood[2],"short"=>true],
             ["title"=>"profil","value"=>$feedbackGood[3],"short"=>true],
             ["title"=>"Navigateur","value"=>$feedbackGood[5],"short"=>true],
             ["title"=>"Temps chargement (s)","value"=>$feedbackGood[4],"short"=>true],
         ]
     ];

     $badAttach = null;
     /*if ($good != $bad) {
         $badAttach = [
              'mrkdwn_in' => ['pretext', 'text'],
              "color" => "danger",
              "title" => "Moins bonne note",
              "text"  => $feedbackBad[0],
              "fields"  => [
                  ["title"=>"Mire","value"=>$feedbackBad[1],"short"=>true],
                  ["title"=>"App","value"=>$feedbackBad[2],"short"=>true],
                  ["title"=>"profil","value"=>$feedbackBad[3],"short"=>true],
                  ["title"=>"Navigateur","value"=>$feedbackBad[5],"short"=>true],
                  ["title"=>"Temps chargement (s)","value"=>$feedbackBad[4],"short"=>true],
              ]
          ];
     }*/


    $message = "Voici le résumé des dernièrs feedbacks. $z feedback(s) ont été pris en compte\n*Notation* mire:$mire/20 app:$app/20";

    echo "Send Message feedback\n";
    $msg = $client->to("#feedback")->attach($goodAttach);
    if ($badAttach) {
        $msg = $msg->attach($badAttach);
    }
    $msg->send($message);

});


// start listening
$loop->run();
