<?php

include_once "uinc.php";

define("DBID",7);

// Check si redis est configuré
if (!is_array($__METRICS) && $__METRICS["mode"] != "redis")  {
  die("METRICS REDIS NOT DEFINED");
}

// Connection Redis
$redis = new \Redis();
if (!$redis->connect($__METRICS["redis"]["host"],$__METRICS["redis"]["port"])) {
    die("IMPOSSIBLE TO CONNECT AT REDIS ${$__METRICS["redis"]["host"]}:${$__METRICS["redis"]["port"]}");
};

if (!$redis->select(DBID)) {
  die("IMPOSSIBLE TO SELECT DATABASE ".DBID);
}

$metrics = \Edispatcher\Entity\Metrics::instance();

$etabs=\R::findAll( 'etab' );


function compute($moment,$by) {
  global $redis;
  global $metrics;
  global $etabs;
  echo str_pad($by,7)." |";

  $count = 0;
  $intids=[];
  $all=0;
  foreach ($etabs as $etab) {
    $uaj = $etab->uaj;


    $count++;
    if ($count % 15 == 0) echo ".";
    
    for($i=1;$i<8;$i++) {
      $ci=0;
      $x=$redis->sInter($etab->uaj,'national_'.$i,$moment);

      // On ne compte pas les intid déja utilisé
      // evite de compter une personen en multi affecations plusieurs fois
      foreach($x as $intid) {
        if (isset($intids[$intid])) {continue;}
        $intids[$intid]=true;
        $ci++;
      }

      $metrics->accountsUsed($by,$ci,'national_'.$i,$etab->uaj,$etab->type);
      $all=$all+$ci;

    }

  }

  echo " | $all\n";


}

echo "        |";
$count = 0;
foreach ($etabs as $etab) {
  $count++;
  if ($count % 15 == 0) echo ".";
}
echo " |\n";


// Hour
compute("time_".date('mdy:H',time()),"Hour");

// Day
compute("time_".date('mdy',time()),"Day");

// Month
compute("time_".date('my',time()),"Month");

// Year
compute("time_".date('y',time()),"Year");
