<?php

namespace Edispatcher\plugins\rocketchat\client;


use Httpful\Request;

class Client{

	public $api;

	function __construct(){
		$this->api = ROCKET_CHAT_INSTANCE . REST_API_ROOT;

		// set template request to send and expect JSON
		$tmp = Request::init()
			->sendsJson()
			->expectsJson();
		Request::ini( $tmp );
	}

	/**
	* Get version information. This simple method requires no authentication.
	*/
	public function version() {
		$response = \Httpful\Request::get( $this->api . 'info' )->send();
		return $response->body->info->version;
	}

	/**
	* Quick information about the authenticated user.
	*/
	public function me() {
		$response = Request::get( $this->api . 'me' )->send();

		if( $response->body->status != 'error' ) {
			if( isset($response->body->success) && $response->body->success == true ) {
				return $response->body;
			}
		} else {
			echo( $response->body->message . "\n" );
			return false;
		}
	}

	/**
	* List all of the users and their information.
	*
	* Gets all of the users in the system and their information, the result is
	* only limited to what the callee has access to view.
	*/
	public function list_users(){
		$response = Request::get( $this->api . 'users.list' )->send();

		if( $response->code == 200 && isset($response->body->success) && $response->body->success == true ) {
			return $response->body->users;
		} else {
			echo( $response->body->error . "\n" );
			return false;
		}
	}

	public function get($action) {
		//echo ($this->api . $action);
		$response = Request::get( $this->api . $action )->send();

		if( $response->code == 200 && isset($response->body->success) && $response->body->success == true ) {
			return $response->body;
		} else {
			//echo( $response->body->error . "\n" );
			return false;
		}
	}

	/**
	* List the private groups the caller is part of.
	*/
	public function list_groups() {
		$response = Request::get( $this->api . 'groups.list' )->send();

		if( $response->code == 200 && isset($response->body->success) && $response->body->success == true ) {
			$groups = array();
			foreach($response->body->groups as $group){
				$groups[] = new Group($group);
			}
			return $groups;
		} else {
			echo( $response->body->error . "\n" );
			return false;
		}
	}

	/**
	* List the channels the caller has access to.
	*/
	public function list_channels() {
		$response = Request::get( $this->api . 'channels.list' )->send();

		if( $response->code == 200 && isset($response->body->success) && $response->body->success == true ) {
			$groups = array();
			foreach($response->body->channels as $group){
				$groups[] = new Channel($group);
			}
			return $groups;
		} else {
			echo( $response->body->error . "\n" );
			return false;
		}
	}

	/**
	* List the channels the caller has access to.
	*/
	public function info_channel($channelName) {
		echo  $this->api . 'groups.info?roomName='.$channelName;
		$response = Request::get( $this->api . 'groups.info?roomName='.$channelName )->send();

		if( $response->code == 200 && isset($response->body->success) && $response->body->success == true ) {
			return $response->body;
		} /*else {
			print_r($response->body);
			return false;
		}*/
	}

	/**
	* List All
	*/
	public function listAll() {
		$response = Request::get( $this->api . 'groups.listAll?count=500' )->send();

		if( $response->code == 200 && isset($response->body->success) && $response->body->success == true ) {
			return $response->body;
		} /*else {
			print_r($response->body);
			return false;
		}*/
	}

	/**
	* Invite User To private Group
	*/
	public function groupInviteUser($roomId,$userId) {
		$response = Request::post( $this->api . 'groups.invite' )
			->body(array("roomId" => $roomId, 
						 "userId" => $userId))
			->send();
		if( $response->code == 200 && isset($response->body->success) && $response->body->success == true ) {
			return json_decode(json_encode($response->body->group),true);
		} else {
			return($response->body);
		}
	}

	/**
	* Remove User From private Group
	*/
	public function groupRemoveUser($roomId,$userId) {
		$response = Request::post( $this->api . 'groups.kick' )
			->body(array("roomId" => $roomId, 
						 "userId" => $userId))
			->send();
		if( $response->code == 200 && isset($response->body->success) && $response->body->success == true ) {
			return json_decode(json_encode($response->body->group),true);
		} else {
			return($response->body);
		}
	}

	/**
	* Find User
	*/
	public function createTokenForUsername($username,$password) {

		$user = $this->findUser($username);

		$response = Request::post( $this->api . 'users.update' )
			->body(array("userId" => $user->_id, "data" => array(
				'password' => $password,
			)))
			->send();

		if( $response->code == 200 && isset($response->body->success) && $response->body->success == true ) {
			return $response->body->user;
		} else {
			//echo( $response->body->error . "\n" );
			return false;
		}

	}

	/**
	* Find User
	*/
	public function authUser($username,$password) {

		$user = new User($username,$password);
		$data = $user->auth(true);

		return ["user"=>$user,"data"=>$data];

	}

	/**
	* Create User
	*/
	public function createUser($username,$displayName,$mail) {
		$response = Request::post( $this->api . 'users.create' )
			->body(array("email" => $mail, 
						 "name" => $displayName,
						 "password" => bin2hex(openssl_random_pseudo_bytes(10)),
						 "username" => $username,
						 "verified"=> true))
			->send();
	}

	/**
	* Create Group
	*/
	public function createGroup($name) {
		$response = Request::post( $this->api . 'groups.create' )
			->body(array("name" => $name))
			->send();

		if( $response->code == 200 && isset($response->body->success) && $response->body->success == true ) {
				return json_decode(json_encode($response->body->group),true);
		} else {
				//echo( $response->body->error . "\n" );
				return false;
		}
	}
	
	public function getUserRooms($username) {
		$url = $this->api . 'users.info?username='.$username.'&fields={"userRooms":1}';
		$response = Request::get( $url  )->send();

		if( $response->code == 200 && isset($response->body->success) && $response->body->success == true ) {
			//print_r($response->body->user); die();
			return ($response->body->user->rooms);
		} else {
			//print_r($response->body->error); die();
			echo( $response->body->error . "\n" );
			return false;
		}
	}

	/**
	* Find User
	*/
	public function findUser($username) {
		$response = Request::get( $this->api . 'users.info?username='.$username  )->send();

		if( $response->code == 200 && isset($response->body->success) && $response->body->success == true ) {
			return ($response->body->user);
		} else {
			echo( $response->body->error . "\n" );
			return false;
		}
	}

}
