<?php

namespace Edispatcher\plugins\rocketchat;
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Container;
use Edispatcher\Controllers\BaseController;

use Edispatcher\plugins\rocketchat\client\Client;
use Edispatcher\plugins\rocketchat\client\User;

function randomToken($len = 64, $output = 5, $standardChars = true, $specialChars = true, $chars = array()) {
        $out = '';
        $len = intval($len);
        $outputMap = array(1 => 2, 2 => 8, 3 => 10, 4=> 16, 5 => 10);
        if (!is_array($chars)) { $chars = array_unique(str_split($chars)); }
        if ($standardChars) { $chars = array_merge($chars, range(48, 57),range(65, 90), range(97, 122)); }
        if ($specialChars) { $chars = array_merge($chars, range(33, 47),range(58, 64), range(91, 96), range(123, 126)); }
        array_walk($chars, function(&$val) { if (!is_int($val)) { $val = ord($val); } });
        if (is_int($len)) {
            while ($len) {
                $tmp = ord(openssl_random_pseudo_bytes(1));
                if (in_array($tmp, $chars)) {
                    if (!$output || !in_array($output, range(1,5)) || $output == 3 || $output == 5) { $out .= ($output == 3) ? $tmp : chr($tmp);  }
                    else {
                        $based = base_convert($tmp, 10, $outputMap[$output]);
                        $out .= ((($output == 1) ? '00' : (($output == 4) ? '0x' : '')) . (($output == 2) ? sprintf('%03d', $based) : $based));
                    }
                    $len--;
                }
            }
        }
        return (empty($out)) ? false : $out;
    }

class Controller extends BaseController {

      protected $ci;

      //Constructor
      public function __construct(Container $ci) {
        $this->ci = $ci;
      }

      private function getUserInfos() {
        global $__PLUGINS;
        if (!isset($__PLUGINS['rocketchat']))              {die("NOT CONFIGURED");}
        if (!isset($__PLUGINS['rocketchat']["url"]))       {die("URL CHAT NON DEFINIE");}
        if (!isset($__PLUGINS['rocketchat']["username"]))  {die("ADMIN username NON DEFINI");}
        if (!isset($__PLUGINS['rocketchat']["password"]))  {die("ADMIN password NON DEFINI");}

        

        $profil = $this->getProfil();
        if (!$profil->isPersAcad()) {
            die("NO PERS ACAD");
        }
        $username = $profil->getUser();

        $url     = $__PLUGINS['rocketchat']["url"];
        $DBUser  = "rocketchatoken";
        $allow   = [];
        
        // Paramètred'accès au client API ==========================
        $adminname     = $__PLUGINS['rocketchat']["username"];
        $adminpassword = $__PLUGINS['rocketchat']["password"];
        if (isset($_GET["url"]))  
        {
          $url=$_GET["url"];
          if (isset($__PLUGINS['rocketchat'][$url]) && isset($__PLUGINS['rocketchat'][$url]["username"]) )   {
            $adminname = $__PLUGINS['rocketchat'][$url]["username"] ;
          }
          if (isset($__PLUGINS['rocketchat'][$url]) && isset($__PLUGINS['rocketchat'][$url]["password"] ))  {
            $adminpassword = $__PLUGINS['rocketchat'][$url]["password"] ;
          }
          if (isset($__PLUGINS['rocketchat'][$url]) && isset($__PLUGINS['rocketchat'][$url]["slug"]) )   {
            $DBUser = "rctoken" . $__PLUGINS['rocketchat'][$url]["slug"] ;
          }
          if (isset($__PLUGINS['rocketchat'][$url]) && isset($__PLUGINS['rocketchat'][$url]["allow"]) )   {
            $allow =  $__PLUGINS['rocketchat'][$url]["allow"];
          }
        }
        // ==========================================================

        define('REST_API_ROOT', '/api/v1/');
        define('ROCKET_CHAT_INSTANCE', $url);

        $api = new Client();
        $admin = new User($adminname, $adminpassword);
        if( ! $admin->login() ) {
          die("Oups");
        };

        if (!$profil->isPersAcad()) {
          die();
        }

        $user = $admin->findUser($username);

        // Si user n'existe pas on va le créer
        if (!$user) {

          // On va vérifier si l'utilisateur dispose des bons 
          // groupes pour accéder au service 
          if (count($allow)) {
            $intersection = array_intersect($allow,$profil->getGroupes());
            if (count($intersection)==0) {
              $nomPrenom = $profil->getDisplayName();
              $this->send403("$nomPrenom, autorisation refusée, vous ne disposez pas des bons groupes pour utiliser ce service <br>Autorisation donnée à <b>".
              implode(",",$allow) . "</b>"
              ); 
            }
          }

          $admin->createUser($username,$profil->getDisplayName(),$profil->getMail());
          $user = $admin->findUser($username);
        }
        
        $bCrypt = $user->services->password->bcrypt;
        
        $auth = \R::findOne($DBUser,"user = ? and bcrypt = ?",[$username,$bCrypt]);
        if (!$auth) {
            $password = randomToken(128, false, true, false);
            $user = $admin->createTokenForUsername($username,$password);
            //print_r($user);die();
            $auth = \R::dispense($DBUser);
            $auth->user      = $username;
            $auth->password  = $password;
            $auth->bcrypt    = $user->services->password->bcrypt?$user->services->password->bcrypt:$bCrypt;
            $auth->accessAt  = new \DateTime("now");
            \R::store($auth);
        } else {
            $auth->accessAt = new \DateTime("now");
            $password       = $auth->password;
            \R::store($auth);
        }
        
        return ["infos"=>$admin->authUser($username,$password),"admin"=>$admin,"api"=>$api];
      }

      public function loginAction(Request $request, Response $response, $args) {

          $params = [];

          $authData = $this->getUserInfos();
          $infos    = $authData["infos"];
          $admin    = $authData["admin"];
          $api      = $authData["api"];
          $params["data"] = $infos["data"];

          // Récupère de l'admin et des paramètres =======================
          global $__PLUGINS;
          $adminname     = $__PLUGINS['rocketchat']["username"];
          $adminpassword = $__PLUGINS['rocketchat']["password"];

          // Attributs SSO utilisé pour le mappings des salons
          $sso_attrs     = false;
          if (isset($__PLUGINS['rocketchat']["sso_attrs"])) {
            $sso_attrs=$__PLUGINS['rocketchat']["sso_attrs"];
          }

          if (isset($_GET["url"]))  
          {
            $url=$_GET["url"];
            if (isset($__PLUGINS['rocketchat'][$url]) && isset($__PLUGINS['rocketchat'][$url]["username"]) )   {
              $adminname = $__PLUGINS['rocketchat'][$url]["username"] ;
            }
            if (isset($__PLUGINS['rocketchat'][$url]) && isset($__PLUGINS['rocketchat'][$url]["password"] ))  {
              $adminpassword = $__PLUGINS['rocketchat'][$url]["password"] ;
            }
            if (isset($__PLUGINS['rocketchat'][$url]) && isset($__PLUGINS['rocketchat'][$url]["sso_attrs"] ))  {
              $sso_attrs = $__PLUGINS['rocketchat'][$url]["sso_attrs"];
            }
          }
          // ===============================================================


          //$api = new Client();
          $admin = new User($adminname,  $adminpassword );
          if( ! $admin->login() ) {
            die("Impossible de joindre ".ROCKET_CHAT_INSTANCE);
          };

          $user   = $infos["user"];
          $profil = $this->getProfil();

          if ($sso_attrs) 
          {

            // List des channels fourni par SSO
            $rooms = explode(",",$profil->getAttribute($sso_attrs,''));
            // Mapping par par nom
            $roomsSSOMap=[]; foreach($rooms as $room ) {$roomsSSOMap[strtolower($room)] = true;}
            //$rooms = array_filter( $rooms, 'strlen' ); // On enleve les chaines vides 

            if (count($rooms)==0) {
              $nomPrenom = $profil->getDisplayName();
              $this->send403("$nomPrenom , autorisation refusée, aucun salon($sso_attrs) de discussion trouvé  !!!"); 
            }

            // Username actuel de connexion SSO
            $username = $profil->getUser();

            // Tous les channels existants 
            // Remapping par groupname
            $allChannels=json_decode(json_encode($admin->listAll()),true);
            $alls=[];
            foreach($allChannels["groups"] as $group ) {$alls[strtolower($group["name"])] = $group;}

            // On recherche le user sur rocket.chat
            $user     = json_decode(json_encode($admin->findUser($username)),true);

            foreach($rooms as $room ) {

                if (!$room) {continue;}

                // Salon existe pas ?
                // on va le créer
                if (!array_key_exists(strtolower($room),$alls)) {
                  $group = $admin->createGroup($room);
                  $gid   = $group["_id"];
                } else {
                  $gid   = $alls[strtolower($room)]["_id"];
                }
                
                // On invit le user
                $result = $admin->groupInviteUser($gid,$user["_id"]); 
            }

          }

          // ==========================================================
          // Gestion de la suppression 
          //  - Récupérer tous les groupes d'un user 
          //  - Vérifier s'ils sont toujours transmis par l'attribut sso 
          //  - si ce n'est pas le cas supprimer le user du groupe 
          $currentUserRooms=json_decode(json_encode($admin->getUserRooms($username)),true);
          foreach( $currentUserRooms as $room) {
            $name = strtolower($room["name"]); // nom du groupe
            $gid  = $room["rid"];              // id du groupe
            // On ne traite que les groupes de type 
            // division_ ou service_
            if (strpos($name,"division_")===0 || 
                strpos($name,"service_")===0
            ) {
              // ce groupe n'est plus envoyé par SSO => on désabonne le user
              if (!isset($roomsSSOMap[$name])) {
                $admin->groupRemoveUser($gid,$user["_id"]); // Suppression
              }
            }
          }
          /// ================================================

          if (isset($_GET["url"]))  {
            $params["url"]=$_GET["url"];
            header("Access-Control-Allow-Origin: " . str_replace("https://", "", $_GET["url"]));
          } else {
            header("Access-Control-Allow-Origin: *");
          }
          
          return $this->ci["view"]->render($response, '@rocketchat/login.html.twig',$params);
      }

      public function send403($message) {
        die("<style> body{ color:#ab1818;background-color:#ab1818; }</style><div style='border-radius:40px;background-color:white; color: black;padding: 10px;text-align:center;margin-top:100px;font-size:22px;font-family: courier;'>!! $message</div>");
      }

      // Webservice permettant d'avoir sous forme de memo métice le 
      // nombre de message non lus 
      public function summaryAction(Request $request, Response $response, $args) {

          $profil = $this->getProfil();
          $uid    = $profil->getUser();
          if ($uid!="cleon" && $uid!="cjactard" && $uid!="arault" && $uid!="lbrillard" ) {
            die("");
          }

          $params = [];

          $infos  = $this->getUserInfos();
          $user   = $infos["user"];

          $subscriptions = $user->subscriptions();

          $unread=["p"  => [],
                   "d"  => [],
                   "c"  => []
                 ];

          foreach ($subscriptions as $subscription) {
            if ($subscription->_room->archived==1) {
              continue;
            }
            $name = $subscription->name;
            $messages = $user->getLastMessagesInRoom($subscription->rid,$subscription->t,$subscription->ls);
            $messages = array_filter($messages, function($m) use($user){return $m->u->_id != $user->id;});

            if (count($messages)!=0) {
              $unread[$subscription->t][$name] = [count($messages),$subscription->unread] ;
            }

          }

          $array = [ ["d" => $unread["d"]], ["p" => $unread["p"]] , ["c" => $unread["c"]]  ];

          $message = "";
          $count = 0; $private=0; $total = 0;
          foreach ($array as $values) {
            reset($values);
            $t = key($values);
            foreach ($values[$t] as $key=>$value) {
              $message.= $this->formatUnread($key,$value,$t);
              $total++;
              $count+=$value[0];
              $private+=$value[1];
              if ($total > 3 ) {
                break;
              }
            }
            if ($total > 3 ) {
              $message .= " ...";
              break;
            }
          }

          /*foreach ($unread["p"] as $key=>$value) {
            $message.= $this->formatUnread($key,$value,"p");
            $count+=$value[0];$private+=$value[1];
          }
          foreach ($unread["p"] as $key=>$value) {
            $message.= $this->formatUnread($key,$value,"p");
            $count+=$value[0];$private+=$value[1];
          }*/

          if ($message=="") {
            die("");
          }

          $header = "Vous avez <span class=\"badge\">".$count."</span> message" . ($count>1?"s":"");
          if ($private!=0) {
            $header .= " dont <span class=\"badge\">".$private."</span> vous cite" . ($private>1?"nt":"") . ".";
          }
          $header .= " , voici le détail :<br>";

          $this->sendResponse($count,$header.$message);



      }

      public function formatUnread($key,$counts,$t) {
        $m = "";
          $prefix = ""; $suffix= " ⇢";
          if ($t=="d") {$prefix="<span style=\"color:black\">💬</span> @";}
          if ($t=="p") {$prefix="🔒 <b>";$suffix="</b> ⇢";}
          if ($t=="c") {$prefix="# <b>";$suffix="</b> ⇢";}

          $m .=  $prefix . $key . $suffix . " <span class=\"badge\">".$counts[0]."</span>" ;
          if ($counts[0]!=$counts[1] && $counts[1] != 0 && $t != "d" ) {
            $m .= " (dont ". $counts[1]  . " 💬 " .")";
          }
          if ($counts[0]==$counts[1] && $counts[1] != 0) {
            $m .= "";
          }

        return $m. "<br>";
      }

      public function sendResponse($count,$message) {

          $json=json_encode(array("message"=>$message,"count"=>$count));
          if (isset($_GET["api"])) {
              $id=$_GET["id"];
              $api=$_GET["api"];
              header('Content-Type: text/javascript');
              echo "var data=$json;";
              echo "$api('$id',data);";
              die();
          }

          echo "<html><body>";
          echo "<form id='form2submit' name='form2submit' method='POST' action='".$_GET["callback"]."'>";
          echo "<input name='id' id='id' type='hidden' value='".$_GET["id"]."' />";
          echo "<input name='count' id='count' type='hidden' value='".$count."' />";
          echo "<input name='type' id='type' type='hidden' value='"."count"."' />";
          echo "<input name='message' id='message' type='hidden' value='$message' />";
          echo "</form>";
          echo "<script>";
          echo "document.form2submit.submit();";
          echo "</script>";
          echo "</body></html>";
      }


      public function apiAction(Request $request, Response $response, $args) {

          $params = [];
          header("Access-Control-Allow-Credentials: true");
          header("Access-Control-Allow-Methods: POST, GET, JSON");
          header("Access-Control-Allow-Origin: *");
          die("");
          return $this->ci["view"]->render($response, '@rocketchat/login.html.twig',$params);
      }

}
