<?php

namespace Edispatcher\plugins\profilage;
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Container;
use Edispatcher\Controllers\BaseController;


class Controller extends BaseController {

  public function applicationsJsonAction(Request $request, Response $response, $args) {

    global $__PLUGINS;
    $config = $__PLUGINS["profilage"];

    $headers = $request->getHeaders();
    $token = $headers['HTTP_EDKEY'][0];

    if ($token != $config["password"]) {
      return $response->withJson(["success"=>false]);
    }
    
    $apps = [];
    
    if (isset($args["uid"])) {
      $c = new \Edispatcher\Controllers\ArenaController($this->ci);
      $arenaData = $c->getData($request,$response,$args);
      foreach($arenaData["cachesArena"] as $cache) {
          foreach($cache->items as $item) {
        
            $apps[$item["libelle"]] = [
              "name"    => $item["name"],
              "libelle" => $item["libelle"],
              "url"     => $item["url"],
              "zone"    => $cache["zone"]
            ];
          };
      }
    }
    

    //print_r($apps);die();

    $data = $this->_getApplications($args);
    $data["applications"] = array_merge($data["applications"],$apps);

    foreach( $data["applications"] as &$item) {
      $url = \R::findOne('url','md5url = ?',[md5($item["url"])]);
      if ($url && $app = $url->getApp()) {
        if ($app->getIcon()) {
          $item["icon"] = _URL_DISPATCHER . $this->ci->get('router')->pathFor('app_icon',["id"=>$app->id]);
        }

        if ($categorie = $app->getCategory()) {
          $item["categorie"] = $categorie->json();
        }
        
        if (isset($app["description"])) {
          $item["description"] = $app["description"];
        }

        if (isset($app["details"])) {
          $item["details"] = $app["details"];
        }

      }
    }
    

    return $response->withJson($data);
  }

  public function applicationsAction(Request $request, Response $response, $args) {

    

    $data = $this->_getApplications($args);


    return $this->ci["view"]->render($response, '@profilage/applications.html.twig',$this->genParams($data));
  }

  private function _getApplications($args){
    global $__PLUGINS;
    $config = $__PLUGINS["profilage"];

    $username = $config["username"];
    $password = $config["password"];
    $context = stream_context_create(array(
      'http' => array(
          'header'  => "Authorization: Basic " . base64_encode("$username:$password")
      )
    ));

    $applications = file_get_contents("http://". $config["host"] ."/profilage/applications",false,$context);
    $applications = json_decode($applications,true);

    $profils = []; $uid ="";
    if (isset($args["uid"])) {
        $uid = $args["uid"];
        $all =  file_get_contents("http://". $config["host"] ."/applications/PersEducNat/" . $uid ,false,$context);
        $all = json_decode($all,true);
        foreach ($all as $p) {
            $profils[$p["name"]] = $p["profile"];
        }
    }


    foreach ($applications as $name => $app) {
      $url=\R::findOne( 'url', 'url  = ?',[$app["url"]]);
      if ($url ) {
        $applications[$name]["ref"] = $url->getApp();
      }
    }

    return ["success" =>true,  "applications"=>$applications,"profils"=>$profils,"uid"=>$uid];
  }

}
