<?php

namespace Edispatcher\plugins\pages;
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Container;
use Edispatcher\Controllers\BaseController;


class Controller extends BaseController {

    public function __construct(Container $ci) {
        $this->ci = $ci;
    }

    public function avenirAction(Request $request, Response $response, $args) {

        $profil = $this->ci["profil"];
        $source = $profil->getSource();

        $params = [];
        $params["persacad"]  = $profil->isPersAcad();
        $params["source"]    = $source;

        return $this->ci["view"]->render($response, '@pages/avenir.html.twig',$params);
    }

    public function eleaAction(Request $request, Response $response, $args) {

        $params=[];

        $bAccess = false;
        $identifiants = file(ROOT_DIR . "/data/elea-rne.txt", FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        $identifiants = array_flip($identifiants);

        $profil = $this->ci["profil"];

        $ctx = stream_context_create(['http'=> ['timeout' => 5]]);

        $plateformes=[ "nord" => "nord-est", "est" => "nord-est" , "sud" => "sud-ouest", "ouest" => "sud-ouest"];
        $instances  = [];

        @$rnes=array_unique(GetInfoArray("rne"));
        foreach ($rnes as $rne ) {

            if (!isset($identifiants[$rne])) {
                continue;
            }

            $bAccess=true;

            $data = file_get_contents("https://portail.ac-reunion.fr/swami/public/api/etablissements/".$rne,null,$ctx);
            if ($data) {
                $data =json_decode($data,true);
                if (isset($data["data"]["values"]["bassin"])) {
                    $bassin = strtolower(($data["data"]["values"]["bassin"]));
                    if ($bassin=="" && $rne=="9740049K") {
                        $bassin="nord";
                    }
                    if (isset($plateformes[$bassin])) {
                        $instances[$plateformes[$bassin]] = $plateformes[$bassin];
                    }
                }
            }
        }

        $params["instances"] = $instances;
        $params["access"]    = $bAccess;
        $params["persacad"]  = $profil->isPersAcad();


        return $this->ci["view"]->render($response, '@pages/elea.html.twig',$params);
    }
}