<?php

include_once(dirname(__FILE__).'/../include/dispatcher.config.php');

define("SEP_SIGAT","-sepSIGATsep-");
define("DEBUG",	(getenv("DEBUG") 	  ?: "false") == "true");

// Determine si c'est une URL public
// ie contient /pblic/
$path=parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$public = strpos($path,"/public/") !== false ;

// For CROS
// Check if Referer is allowed to CORS
// https is mandatory
if (!$public && isset($_SERVER['HTTP_REFERER'])) {
  $parsed=parse_url($_SERVER['HTTP_REFERER']);
  foreach ($__CORS_ORIGIN as $reg) {
    preg_match("/$reg/",$parsed["host"],$ouput);
    if (count($ouput)>0) {
        header("Access-Control-Allow-Origin: https://" . $parsed["host"]);
        break;
    }
  }
}

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
  header("Access-Control-Allow-Headers: accept, content-type, guid, X-Http-Method-Override, X");
  header("Access-Control-Allow-Methods: POST, GET, JSON");
  header("Access-Control-Allow-Origin: *");
  die();
}
// ====== VERSION =============
define("VERSION_ELEMENTS","v2025-06-07-2");

define( 'REDBEAN_MODEL_PREFIX', '\\Edispatcher\Entity\\' );

// Cas d'une authentification via header http
$headers=getallheaders();
if ( array_key_exists("guid",$headers)) {
  session_name("edispatcher");
  session_start();

  define("ROOT_DIR",dirname(__FILE__)."/..");
  define("INC_DIR",ROOT_DIR."/include");

  include_once(INC_DIR.'/dispatcher.config.php');
  include_once(INC_DIR.'/db.config.php');

  $token=R::findOne("token"," guid = ?",array($headers["guid"]));
  if ($token) {
    $_SESSION["CASATTRIBUTE"] = unserialize($token->attribues);
    $_SESSION["INTID"]        = $token->intid;
  } else {
    die("TOKEN KO [".$headers["guid"]."]");
  }
}
// accès normal -> authCas
else  {
  if ($public) define("NOCAS",true);
  include_once("../include/inc.php");
}


require '../vendor/autoload.php';

use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use \Edispatcher\Controllers\ApiController;
use \Edispatcher\Controllers\ArenaController;
use \Edispatcher\Controllers\DefaultController;
use \Edispatcher\Controllers\AppController;
use \Edispatcher\Controllers\DelegController;
use \Edispatcher\Controllers\DocController;
use \Edispatcher\Controllers\RedirectorController;
use \Edispatcher\Controllers\CategoryController;
use \Edispatcher\Controllers\ParamController;

use \Edispatcher\Entity\Profil;
use \Edispatcher\Entity\Metrics;

// App création =========================================================
$config = [
    'settings' => ['displayErrorDetails' => true  ],
];
$app = new \Slim\App($config);
$app->add(new \Slim\HttpCache\Cache('public', 86400));
// ======================================================================

define("DIR_VIEW",dirname(__FILE__).'/views');

// ref #24186 : Mettre en place dossier template local
$templatesPath=["__main__"=>[DIR_VIEW."/local",DIR_VIEW]];

$templatesPath["hub"]=DIR_VIEW."/hub";

$container = $app->getContainer();
$container['profil']        = function ($c)     {return new Profil();};

// Ajout des plugins ===========================================================
$pluginsDIR=ROOT_DIR."/ng/plugins";
$plugins=array_diff(scandir($pluginsDIR), array('..', '.'));
foreach ($plugins as $plugin) {
    if (file_exists($pluginsDIR."/".$plugin."/config.php")) {
        try {include $pluginsDIR."/".$plugin."/config.php";} catch( \Exception $e) {
            echo "//echec de chargement de $plugin";
            print_r($e);
        }
    }
}

// NOT FOUND TEMPLATE
$container['notFoundHandler'] = function ($c) {
  return function ($request, $response) use ($c) {
      return $c['view']->render($response->withStatus(404), '404.html.twig', [
          "myMagic" => "Let's roll"
      ]);
  };
};


$container['errorHandler'] = function ($c) {
  return function ($request, $response) use ($c) {
      return $c['view']->render($response->withStatus(500), '500.html.twig', [
          "myMagic" => "Let's roll"
      ]);
  };
};

// =============================================================================

// === Configuration des containers =====================================

if (isset($__METRICS)) {
    $container['metrics']   = function ($c)     {return Metrics::instance();};
}
$container['Api']           = function ($c)     {return new ApiController($c);};
$container['Default']       = function ($c)     {return new DefaultController($c);};
$container['Arena']         = function ($c)     {return new ArenaController($c);};
$container['App']           = function ($c)     {return new AppController($c);};
$container['Category']      = function ($c)     {return new CategoryController($c);};
$container['Doc']           = function ($c)     {return new DocController($c);};
$container['Deleg']         = function ($c)     {return new DelegController($c);};

$container['Param']         = function ($c)     {return new ParamController($c);};


ApiController::checkCacheIconDirectory();

$deleg =  new DelegController($container);

if (DEBUG) {
  define("__CACHE_DIR",false);
} else {
  define("__CACHE_DIR",dirname(__FILE__).'/cache');
}


$container['view']    = function ($c)  use($templatesPath)    {
    //print_r($templatesPath); die();

    $view = new \Slim\Views\Twig($templatesPath, [
        'cache' => __CACHE_DIR
    ]);
    $view->addExtension(new \Slim\Views\TwigExtension(
        $c['router'],
        $c['request']->getUri()
    ));
    $view->getEnvironment()->addGlobal('ELEMENTS_VERSION',VERSION_ELEMENTS);

    return $view;
};
$container['cache'] = function () {
    return new \Slim\HttpCache\CacheProvider();
};

// =======================================================================


function getConfigHostname() {
    global $_HOSTNAME;
    return (isset($_HOSTNAME) && $_HOSTNAME)?$_HOSTNAME:gethostname();
}


R::freeze( isset($_PRODUCTION_MODE) && $_PRODUCTION_MODE );
