<?php

namespace Edispatcher\Entity;

use Slim\Container;

class Profil   extends \RedBeanPHP\SimpleModel {

  private $attributes=[];
  private static $profiles=[];

  // fixes #25767 : Settings par user
  private static  $SETTINGS = null;

  //Constructor
  public function __construct() {

    if (session_status() == PHP_SESSION_ACTIVE) {

      if (! array_key_exists("CASATTRIBUTE", $_SESSION) ) {
          return;
      }

      $this->attributes=$_SESSION["CASATTRIBUTE"];

      //print_r($this->attributes); die();

      self::$profiles=["national_1"=>["eleve","eleve",'#3b8211'],
                       "national_2"=>["responsable","parent",'#57248c'],
                       "national_3"=>["enseignant","enseignant-2d",'#0e6586'],
                       "national_4"=>["direction","enseignant","#004d9a"],
                       "national_6"=>["administratif","personnel","#004d9a"],
                       "national_5"=>["vie scolaire","etablissement","#004d9a"],
                       "national_7"=>["academie","academie","#004d9a"],
                      ""=>["",""]
                  ];
    }

  }

  // fixes #25767 : Settings par user
  // permet de récupérer les settings pour un user
  public function getSetting($key) {

    // Recupère les settings pour avoir la valeur par défaut
    if (!self::$SETTINGS) {
        try {
            self::$SETTINGS = \Edispatcher\plugins\esettings\Controller::getDefaultSettings();
        } catch (\Exception $e) {
            self::$SETTINGS = [];
        }
    }

    // Pas de setting correspondant à la clef
    // on retourne false
    if (!isset(self::$SETTINGS[$key])) {
        return false;
    }

    return $this->getHubToken()->getSetting($key,self::$SETTINGS[$key]);
  }

  // Retourne True si le profil dispose des groupes qui sont dans groupesToFind
  public function hasGroupes($groupesToFind)
  {
     $groupes = $this->getGroupes();
     if (count($groupes)==0) return false;

     return count(array_intersect($groupes,$groupesToFind))!=0;
  }

  public function getAttribute($name,$default="") {
      if (! array_key_exists($name, $this->attributes) ) return $default;

      if (is_array($default)) {
          return $this->attributes[$name];
      }

      if (!is_array($this->attributes[$name])) {
          return $this->attributes[$name];
      }

      if (count($this->attributes[$name])==0) return $default;

      return $this->attributes[$name][0];

  }

  public function getEleveVecteur() {
      $vecteur = $this->getAttribute("EleveVecteur",[]);
      
      $ret     = [];
      foreach($vecteur as $item) {
        $item  = preg_replace('/\n?/', "", $item);
        if (strpos($item,'§')!==false) {
            $ret=array_merge(explode('§',$item),$ret);
        } else {
            $ret[] = $item;
        }  
      }
      return $ret;
  }

  public static function unicodeDecode($string) {
    return iconv("UTF-8", "ISO-8859-1", $string);
  }

  public function getDisplayName()
  {
        $string = $this->getAttribute("displayName");
        return self::unicodeDecode($string);
  }

  public function getMail()
  {
     return $this->getAttribute("mail","");
  }

  public function getGroupes()
  {
     return $this->getAttribute("groupes",[]);
  }

  public function hasDelegs($delegs)
  {
     //print_r($delegs);die();
     foreach ($delegs as $deleg) {
         if ($deleg->check($this)) return true;
     }
     return false;

  }

  public function getUid()
  {
     return $this->getAttribute("uid");
  }

  public function getIntid()
  {
     $intid = $this->getAttribute("intid");
     if (!$intid)    {$intid = $this->getAttribute("FederationKey");}
     # fixes # 24144 : Si pas de intid et pas de FederationKey, 
     # utilisation du mail, puis à défaut du user qui est toujours valué 
     if (!$intid) {$intid = $this->getAttribute("mail");}
     if (!$intid) {$intid = $this->getAttribute("user");}

     return $intid ;
  }

  public function getUser()
  {
     return $this->getAttribute("user");
  }

  public function isPersAcad() {
     // Pers Academique si non élève et non parent
     $profil=$this->getProfil();
     return ! in_array($profil,["national_1","national_2"]);
  }


  public function getSource()
  {
     return $this->getAttribute("source");
  }

  public function getProfilLibelle()
  {
     $profil=$this->getAttribute("profils","");
     return self::$profiles[strtolower($profil)][0];
  }

  public function getProfilClass()
  {
     $profil=$this->getAttribute("profils","");
     return self::$profiles[strtolower($profil)][1];
  }

  public function getProfilColor()
  {
     $profil=$this->getAttribute("profils","");
     return self::$profiles[strtolower($profil)][2];
  }

  public function getProfil()
  {
     $profil=$this->getAttribute("profils","");
     return strtolower($profil);
  }

  public function getHash()
  {
     return md5(strtolower($this->getIntid()));
  }

  public function getHashWithUser()
  {
     return md5(strtolower($this->getUser()));
  }

  public function getPortails() {
      if (isset($_SESSION["portails"])) return unserialize($_SESSION["portails"]);
      $_SESSION["portails"] = serialize(json_encode(getPortailsForCurrentUser()));

      return unserialize($_SESSION["portails"]);
  }

  public function saveToken($token) {
      //$_SESSION["hubtoken"]= serialize($token);
      try {
          \R::store($token);
      } catch (\Exception $e) {

      }
  }

  public function open() {

    if ($this->getProfil()=="national_1") {
        $token = \R::findOne( 'hubtoken','user = ? AND intid = ?',[$this->getUser(),$this->getIntid()]);
    } else {
        $token = \R::findOne( 'hubtoken','user = ? AND profil = ?',[$this->getUser(),$this->getProfil()]);
    }

    $this->bean->setMeta("token",$token);

  }

  public function getHubToken() {

      //if (isset($_SESSION["hubtoken"])) return unserialize($_SESSION["hubtoken"]);

      // Au cas de multi-établissement les élèves National_1 peuvent avoir le même uid
      // On se base donc sur intid (identifiant AAF)

      // Token en Meta pour eviter de persister en base et 
      // un appel à la bdd a chaque appel
      /*$token = $this->bean->getMeta("token");*/
      /*if ($this->token) {
          return $token;
      }*/

      

      // Récupère en base le token
      if ($this->getProfil()=="national_1") {
          $token = \R::findOne( 'hubtoken','user = ? AND intid = ?',[$this->getUser(),$this->getIntid()]);
      } else {
          $token = \R::findOne( 'hubtoken','user = ? AND profil = ?',[$this->getUser(),$this->getProfil()]);
      }

      //$this->bean->setMeta("token",$token);
      //$this->token = $token;
      //$_SESSION["hubtoken"]= serialize($token);

      return $token;

  }





}
