<?php

namespace Edispatcher\Controllers;
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Container;

use Prometheus\CollectorRegistry;
use Prometheus\RenderTextFormat;

use Edispatcher\Entity\Param;


class ParamController extends BaseController {

    public static function  getValue($name,$default = false){
        try {
            $param=\R::findOne( 'param','name = ?',[$name]);
            if (!$param) {
                return $default;
            }

            return $param->value;
        }  catch( \Exception $e) {
            return $default;
        }
    } 

    public static function  setValue($name,$value){
        $param=\R::findOne( 'param','name = ?',[$name]);
        if (!$param) {
            $param = \R::dispense("param");
            $param->name = $name;
        }

        $param->value = $value;
        \R::store($param);
    } 
}
