<?php

namespace Edispatcher\Controllers;
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Container;

use Edispatcher\Entity\Deleg;



class BaseController {

    protected $ci;

    //Constructor
    public function __construct(Container $ci) {
      $this->ci = $ci;
    }

    public function getSetting($key) {
        return $this->getProfil()->getSetting($key);
    }

    public function getProfil() {
        return $this->ci["profil"];
    }

    public function genParams($params) {
        return array_merge($params,["profil"     => $this->getProfil(),
                                    "isManager"  => $this->isManager(), "isCacheManager"  => $this->isCacheManager(), "isGest"  => $this->isGest(), "isReader" => $this->isReader() ,
                                    "hasMetrics" => $this->hasMetrics()
                                   ]);
    }

    public function hasMetrics() {
        global $__METRICS;
        return isset($__METRICS);
    }

    public function getMetrics() {
        return $this->hasMetrics()?$this->ci["metrics"]:false;
    }

    public function isManager() {
        $roleAdmin=\R::findOne("role","name = ?",[Deleg::ADMIN]);
        $delegs= \R::find( 'deleg',  'role_id = ?' , [$roleAdmin->id]);
        //print_r($delegs);die();
        return $this->ci['profil']->hasDelegs($delegs);
    }

    public function isGest() {
        if ($this->isManager()) {return true;}
        $roleAdmin=\R::findOne("role","name = ?",[Deleg::GEST]);
        $delegs= \R::find( 'deleg',  'role_id = ?' , [$roleAdmin->id]);
        //print_r($delegs);die();
        return $this->ci['profil']->hasDelegs($delegs);
    }

    public function isCacheManager() {
        if ($this->isManager()) return true;
        $roleCache=\R::findOne("role","name = ?",[Deleg::CACHE]);
        $delegs= \R::find( 'deleg',  'role_id = ?' , [$roleCache->id]);
        return $this->ci['profil']->hasDelegs($delegs);
    }

    public function isReader() {
        if ($this->isGest()) {return true;}
        $role=\R::findOne("role","name = ?",[Deleg::READER]);
        $roleAdmin=\R::findOne("role","name = ?",[Deleg::ADMIN]);
        $delegs= \R::find( 'deleg',  'role_id = ?  or role_id = ?', [$role->id,$roleAdmin->id]);

        return $this->ci['profil']->hasDelegs($delegs);
    }



    protected function requireManager() {
      if (!$this->isManager()) return $this->forbidden();
      return true;
    }

    protected function requireGest() {
      if (!$this->isGest()) return $this->forbidden();
      return true;
    }

    protected function requireCacheManager() {
      if (!$this->isCacheManager()) return $this->forbidden();
      return true;
    }

    protected function requireReader() {
      if (!$this->isReader()) return $this->forbidden();
      return true;
    }

    protected function notFound($message="") {
      header("HTTP/1.0 404 Not Found");
      die($message);
    }

    protected function forbidden() {
      header("HTTP/1.0 403 Forbidden");
      die();
    }

    public function getParamValue($name,$default=false) {
        return $this->ci['Param']->getValue($name,$default);
    }

}
