<?php

namespace Edispatcher\Controllers;
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Container;

use Prometheus\CollectorRegistry;
use Prometheus\RenderTextFormat;

use Edispatcher\Entity\Application;


class AppController extends BaseController  {

  public function urlListAction(Request $request, Response $response, $args) {
    $this->requireReader();
    $urls=\R::find( 'url','app_id  is not null ORDER BY libelle');
    $urlsNew = \R::find( 'url', 'where new = 1 ORDER by id');
    return $this->ci["view"]->render($response, 'app/urlList.html.twig',$this->genParams(["urls"=>$urls,"new"=>count($urlsNew)]));

  }

  public function urlArenaListAction(Request $request, Response $response, $args) {
    $this->requireReader();
    $urls=\R::find( 'url','app_id  is not null AND resarena is not null ORDER BY libelle');
    $urlsNew = \R::find( 'url', 'where new = 1 AND resarena is not null ORDER by id');
    return $this->ci["view"]->render($response, 'app/urlList.html.twig',$this->genParams(["urls"=>$urls,"new"=>count($urlsNew)]));

  }

  public function urlOrphanAction(Request $request, Response $response, $args) {
    $this->requireReader();
    $urls=\R::find( 'url', 'app_id  is null');
    return $this->ci["view"]->render($response, 'app/urls.html.twig',$this->genParams(["urls"=>$urls]));
  }

  public function urlOrphanSetAction(Request $request, Response $response, $args) {
    $this->requireReader();
    $urls=\R::find( 'url', 'app_id  is null');
    return $this->ci["view"]->render($response, 'app/urls.html.twig',$this->genParams(["urls"=>$urls]));
  }

  public function exportAppsAction(Request $request, Response $response, $args) {
      $this->requireReader();

      $apps=\R::find( 'app', ' ORDER by uid');

      $sep="|";
      $a = [implode($sep,["id","libelle","categorie","description","hebergeur"])];
      foreach ($apps as $app) {
          $data = $app->csv($sep);
          if (!$data) continue;
          $a[] = $data;
      }

      $body = $response->getBody();
      $body->write(implode("\n",$a));

      return $response->withHeader('Content-Type', 'text/csv; charset=utf-8')
                      ->withHeader("Content-Disposition","attachment; filename=apps_export.csv");

  }

  public function showAppsAction(Request $request, Response $response, $args) {

    $this->requireReader();

    $metrics = $this->getMetrics();

    $apps    = \R::find( 'app', ' ORDER by uid');
    $appsNew = \R::find( 'app', 'where new = 1 ORDER by uid');

    // counter des applications
    $appCounters=[];
    if ($metrics) {
        $counters=$this->ci["metrics"]->apps($request->getQueryParams());
        foreach ($counters as $key => $value) {
          $appCounters[$value->metric->appid]=$value->value[1];
        }
    }


    return $this->ci["view"]->render($response, 'app/list.html.twig',$this->genParams(["apps"=>$apps,"new"=>count($appsNew), "counters"=>$appCounters]));
  }



  public function accueilAction(Request $request, Response $response, $args) {

    if (!$this->isManager() || !$this->isGest() ) {
      $loc=$this->ci->get('router')->pathFor('hub');
      return $response->withRedirect($loc);
    }

    return $this->ci["view"]->render($response, 'app/accueil.html.twig');
  }

  public function viewAppAction(Request $request, Response $response, $args) {

    $isReader = $this->requireReader();

    $metrics = $this->getMetrics();

    // reader SEULEUMENT on recherche par uid
    $app=\R::findOne( 'app','uid = ?',[$args["id"]]);
    if (!$app && $isReader && ! $this->isManager()  && ! $this->isGest() ) $this->notFound();

    // manager et app non trouvé par uid -> recherche par id
    if (!$app) {
      $app=\R::findOne( 'app','id = ?',[$args["id"]]);
      if (!$app) $this->notFound();
    }

    $queryParams=$request->getQueryParams();
    $url=false;
    if (array_key_exists("url", $queryParams)) {
        $url=\R::findOne( 'url','id = ?',[$queryParams["url"]]);
    }

    if (!$url && ! $isReader ) return;

    // Nb favoris
    $favurl  = 0; $favapp= 0;
    if ($metrics) {
        $favapp  = $metrics->favApp($app->id);
        if ($url) {
          $favurl = $metrics->favUrl($url->id);
        }
    }


    if (array_key_exists("format", $queryParams) && $queryParams["format"]=="json" && $url) {
        $data = $url->json();
        $data["counter"] = $this->ci["metrics"]->url($url->id,$request->getQueryParams());
        $data["icon"]    = $this->ci->get('router')->pathFor('app_icon',["id"=>$app->id]);
        $data["fav"]     = $favurl;
        $response->withJson($data);
        return;
    }

    // counter des urls

    $urlCounters=[];
    if ($metrics) {
        $counters=$metrics->urls($request->getQueryParams());
        foreach ($counters as $key => $value) {
          $urlCounters[$value->metric->urlid]=$value->value[1];
        }
    }



    return $this->ci["view"]->render($response, 'app/view.html.twig',
     $this->genParams(["app"=>$app,"fav"=>[$favapp,$favurl], "url"=>$url,"counters"=>$urlCounters]));
  }

  public function viewUrlAction(Request $request, Response $response, $args) {

    $isManager = $this->isManager();

    $url=\R::findOne( 'url','id = ?',[$args["id"]]);
    if (!$url) return ;

    $loc=$this->ci->get('router')->pathFor('app_view',["id"=>$url->getApp()->uid])."?url=".$url->id;
    return $response->withRedirect($loc);
  }

  public function accessUajAction(Request $request, Response $response, $args) {
      $uaj = $args["uaj"];
      $delay = intval($args["delay"]);
      if ($delay<=0) $delay=300; // Par défaut 5mn
      $count= $this->ci["metrics"]->uajLastActivity($uaj,$delay);
      return $response->withJson(["count"=>$count]);
  }

  public function accessUajsAction(Request $request, Response $response, $args) {

      /*$etabs=\R::find( 'etab', ' ORDER by uaj');
      $labels=[];
      foreach ($etabs as $etab) {
        $labels[$etab->uaj]=$etab->json();
      }*/
      $delay = intval($args["delay"]);
      $result = $this->ci["metrics"]->uajsLastActivity($delay);
      return $response->withJson(["result"=>$result]);
  }



  public function viewUajAction(Request $request, Response $response, $args) {

    $this->requireManager();

    $uaj = $args["uaj"];
    $etab=\R::findOne( 'etab', ' uaj = ? ', [$uaj] );
    if (!$etab) {
      $etab=\R::findOne( 'etab', ' id = ? ', [$uaj] );
    }

    if (!$etab) $this->notFound();

    $isManager = $this->isManager();

    return $this->ci["view"]->render($response, 'app/etab.html.twig',["uaj"=>$etab->uaj,"etab"=>$etab,  "isManager"=>$isManager]);

  }

  public function editAppAction(Request $request, Response $response, $args) {
    global $__ARENA_ZONES;

    $this->requireGest();

    $app=\R::findOne( 'app','id = ?',[$args["id"]]);
    if (!$app) return ;

    $urls=\R::find( 'url', 'app_id  is null');

    $categories=\R::find( 'category',"order by libelle ASC");

    $tags=\R::findAll( 'tag',"order by name ASC");

    $hosts = \R::findAll( 'hoster') ;

    $apps=\R::find( 'app','id != ? and description is not null and libelle is not null and libelle != "" ORDER by libelle',[$args["id"]]);


    return $this->ci["view"]->render($response,
                                     'app/edit.html.twig',
                                     $this->genParams([ "zones" => $__ARENA_ZONES,
                                       "app"   => $app,
                                       "apps"  => $apps,
                                       "urls"  => $urls,
                                       "hosts" => $hosts,
                                       "tags" => $tags,
                                       "categories" => $categories
                                   ]));
  }

  public function createAppAction(Request $request, Response $response, $args) {

    $this->requireGest();

    $urls       = \R::find( 'url', 'app_id  is null');
    $categories = \R::find( 'category'," order by libelle ASC");
    $app        = \R::dispense("app");
    $hosts      = \R::findAll( 'hoster') ;

    $queryParams= $request->getQueryParams();
    $libelle    = "";

    // Si on précise des urls en paramètre, on va essayer de consctruire une nouvelle
    // application avec celle-ci
    if (array_key_exists("urls", $queryParams)) {
        $listUrls=explode(",",$queryParams["urls"]);
        $bArena     = false; $index =0;
        foreach ($listUrls as $urlId) {
            $url=\R::findOne( 'url','id = ?',[$urlId]);
            // urlid non trouvée
            if (!$url) {continue;}

            // Mis arena et non arena impossible
            if ($index!=0 && ( ($url->resarena && !$bArena) || (!$url->resarena && $bArena) ) )  {
                die("Vous ne pouvea pas mixer dans une mêmme application des ressources Arena et des ressources autres");
            }

            if ($url->resarena) $bArena = true;

            $libelle = $url->libelle;
            $app->addUrl($url);
            $index++;
        }
    }
    $app->libelle=$libelle;
    $app->description="Veuillez mettre une description";
    if ($bArena) {
        $app->origin="Arena";
    }

    return $this->ci["view"]->render($response, 'app/edit.html.twig',$this->genParams(["app"=>$app,"urls"=>$urls,"hosts"=>$hosts, "categories" => $categories]));
  }

  /// ============ stats app ===============================================
  public function statsAppsByProfilAppAction(Request $request, Response $response, $args) {

    $queryParams=$request->getQueryParams();
    $data =  $this->ci["metrics"]->appsByProfilApp($queryParams);
    $apps=\R::find( 'app', ' ORDER by uid');
    $labels=[];
    foreach ($apps as $app) {
      $labels[$app->id]=$app->json();
      $labels[$app->id]["icon"]=$this->ci->get('router')->pathFor('app_icon',["id"=>$app->id]);
    }

    $response->withJson(["data"=>$data,"x"=>$labels]);
  }

  public function statsAppsByProfilAction(Request $request, Response $response, $args) {

    $queryParams=$request->getQueryParams();
    $data =  $this->ci["metrics"]->appsByProfil($queryParams);
    $response->withJson($data);
  }



  public function statsAppAction(Request $request, Response $response, $args) {
    $app=\R::findOne( 'app','id = ?',[$args["id"]]);
    if (!$app) $this->notFound();

    die($this->ci["metrics"]->appStatsApp($app->id));
  }

  public function statsAppByProfilAction(Request $request, Response $response, $args) {
    $app=\R::findOne( 'app','id = ?',[$args["id"]]);
    if (!$app) $this->notFound();

    $queryParams=$request->getQueryParams();

    $response->withJson($this->ci["metrics"]->appByProfil($app->id,$queryParams));
  }

  public function statsAppByUajAction(Request $request, Response $response, $args) {
    $app=\R::findOne( 'app','id = ?',[$args["id"]]);
    if (!$app) $this->notFound();

    $queryParams=$request->getQueryParams();

    $response->withJson($this->ci["metrics"]->appByUaj($app->id,$queryParams));
  }

  // ================ Accounts =====================================================================

  public function statsAccountsAvailableByProfilAction(Request $request, Response $response, $args) {

    $queryParams=$request->getQueryParams();
    $data =  $this->ci["metrics"]->accountsByProfil($queryParams);
    $response->withJson($data);
  }

  public function statsAccountsUsedByProfilAction(Request $request, Response $response, $args) {

    $queryParams=$request->getQueryParams();
    $data =  $this->ci["metrics"]->accountsUsedByProfil($args["by"],$queryParams);
    $response->withJson($data);
  }

  public function statsAccountsAvailableUajByProfilAction(Request $request, Response $response, $args) {

    $queryParams=$request->getQueryParams();
    $data =  $this->ci["metrics"]->accountsUajByProfil($args["uaj"],$queryParams);
    $response->withJson($data);
  }

  public function statsAccountsUsedUajByProfilAction(Request $request, Response $response, $args) {

    $queryParams=$request->getQueryParams();
    $data =  $this->ci["metrics"]->accountsUsedUajByProfil($args["uaj"],$args["by"],$queryParams);
    $response->withJson($data);
  }

  public function statsAccountsUsedProfilByUajAction(Request $request, Response $response, $args) {

    $this->requireManager();

    $queryParams=$request->getQueryParams();
    $data =  $this->ci["metrics"]->accountsUsedProfilByUaj($args["profil"],$args["by"],$queryParams);

    if (isset($args["format"]) && $args["format"]=="csv" ) {

        $sep=",";
        $a = ["uaj".$sep."nb_accounts_".$args["profil"]."_used_by_".$args["by"]];

        foreach ($data as $value) {
            $a[]=$value->metric->uaj.$sep.$value->value[1];
        }

        $body = $response->getBody();
        $body->write(implode("\n",$a));

        return $response->withHeader('Content-Type', 'text/csv; charset=utf-8')
                        ->withHeader("Content-Disposition","attachment; filename=".date("Ymd")."_nb_accounts_".$args["profil"]."_used_by_".$args["by"].".csv");



    }

    $response->withJson($data);
  }

  public function statsAccountsDelayProfilAction(Request $request, Response $response, $args) {

    $queryParams=$request->getQueryParams();
    $data =  $this->ci["metrics"]->accountsDelayByProfil($queryParams);
    $response->withJson($data);
  }



  // ================ URL ==========================================================================

  public function statsUrlByProfilAction(Request $request, Response $response, $args) {
    $url=\R::findOne( 'url','id = ?',[$args["id"]]);
    if (!$url) $this->notFound();

    $queryParams=$request->getQueryParams();

    $response->withJson($this->ci["metrics"]->urlByProfil($url->id,$queryParams));
  }

  public function statsUrlsByProfilAction(Request $request, Response $response, $args) {
    $queryParams=$request->getQueryParams();
    $data =  $this->ci["metrics"]->urlsByProfil($queryParams);
    $urls=\R::find( 'url', ' ORDER by uid');
    $labels=[];
    foreach ($urls as $url) {
      $labels[$url->id]=$app->json();
      $labels[$url->id]["icon"]=$this->ci->get('router')->pathFor('app_icon',["id"=>$url->getApp()->id]);
    }

    $response->withJson(["data"=>$data,"x"=>$labels]);
  }

  public function statsUrlByUajAction(Request $request, Response $response, $args) {
    $url=\R::findOne( 'url','id = ?',[$args["id"]]);
    if (!$url) $this->notFound();

    $queryParams=$request->getQueryParams();

    $response->withJson($this->ci["metrics"]->urlByUaj($url->id,$queryParams));
  }

  public function statsUrlAction(Request $request, Response $response, $args) {
    $url=\R::findOne( 'url','id = ?',[$args["id"]]);
    if (!$url) $this->notFound();

    die($this->ci["metrics"]->urlStatsApp($url->id));
  }

  public function jsonUrlAction(Request $request, Response $response, $args) {
    $url=\R::findOne( 'url','id = ?',[$args["id"]]);
    if (!$url) $this->notFound();

    $json = $url->json();
    $json["icon"]=$this->ci->get('router')->pathFor('app_icon',["id"=>$url->getApp()->id]);

    $response->withJson($json);
  }

  // =============================================================================================

  public function statsUajByUrlAction(Request $request, Response $response, $args) {
    $queryParams = $request->getQueryParams();
    $data        = $this->ci["metrics"]->uajByUrl($args["uaj"],$queryParams);
    $response->withJson($data);
  }

  public function statsUajByAppAction(Request $request, Response $response, $args) {
    $queryParams=$request->getQueryParams();
    $response->withJson($this->ci["metrics"]->uajByApp($args["uaj"],$queryParams));
  }

  public function statsUajByProfilAction(Request $request, Response $response, $args) {
    $queryParams=$request->getQueryParams();
    $response->withJson($this->ci["metrics"]->uajByProfil($args["uaj"],$queryParams));
  }

  public function statsUajsByProfilAction(Request $request, Response $response, $args) {
    $queryParams=$request->getQueryParams();
    $data =  $this->ci["metrics"]->uajsByProfil($queryParams);
    $etabs=\R::find( 'etab', ' ORDER by uaj');
    $labels=[];
    foreach ($etabs as $etab) {
      $labels[$etab->uaj]=$etab->json();
    }

    $response->withJson(["data"=>$data,"x"=>$labels]);
  }


  // ==== Sauvegarde d'une application ====
  public function saveAppAction(Request $request, Response $response, $args) {

    $this->requireGest();

    $app=\R::findOne( 'app','id = ?',[$args["id"]]);
    if (!$app) {
      $app = \R::dispense("app");
    }

    if (!$app->uid) {
      $data=openssl_random_pseudo_bytes(16);
      $guid=vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
      $app->uid=(time()) . $guid;
    }

    $post = $request->getParsedBody();

   $app->description=$post['description'];
   $app->used=isset($post['used']) && $post['used'];
   $app->libelle=$post['libelle'];
   $app->details=$post['details'];
   $app->pattern=$post['pattern'];
   $app->zone=$post['zone'];
   $app->new = false;

    $files = $request->getUploadedFiles();
    if (!empty($files['icon'])) {
      $newfile = $files['icon'];
      if ($newfile->getError() === UPLOAD_ERR_OK) 
      {
        $filecontent = file_get_contents($_FILES['icon']['tmp_name']);
        $icon = \R::findOne( 'icon', 'md5icon = ?', [md5($filecontent)]);
        if (!$icon) {
            $icon = \R::dispense("icon");
            $icon->icon = $filecontent;
            $icon->md5icon = md5($filecontent);
            $icon->svg = strpos( $filecontent, "<svg ");
            \R::store($icon);
        } 

        $app->icon = $icon;
        // Si Icon en FS on la modifie
        if ($path = ApiController::_hasIconPath("app",$args["id"],$this->ci["router"])) {
            $filename = ApiController::getIconPath("app",$args["id"]) ;
            file_put_contents($filename,$icon->icon);

            if ($path = ApiController::_hasIconPath("icon",$icon->id,$this->ci["router"])) {
                $filename = ApiController::getIconPath("icon",$icon->id) ;
                file_put_contents($filename,$icon->icon);
            }
        }

      } // END === UPLOAD_ERR_OK
    } // END !empty($files['icon'] 

    // Enregistre les tags =====================================
    $tags="";
    if (isset($post['tags'])) {
        foreach ($post['tags'] as $key=>$name) {
            $tag=\R::findOne( 'tag','name = ?',[$name]);
            if (!$tag) {
                $tag=\R::dispense("tag");
                $tag->name=$name;
                \R::store($tag);
            }
        }
        $tags=implode(",",$post['tags']);
    }
   $app->tags=$tags;
    // =========================================================

    $ids = $post['url_id'];

    foreach ( $app->getUrls() as $url) {
        if (!array_key_exists(intval($url->id), $ids)) {
            unset( $app->ownUrlList[$url->id] );
        $url->app = null;
        \R::store($url);
      }
    }
    $cat=\R::findOne( 'category','id = ?',[$post['category']]);
    if ($cat) {
      $app->category = $cat;
    }
    $host=\R::findOne( 'hoster','id = ?',[$post['host']]);
    if ($host) {
      $app->hoster = $host;
    }

    $urlToStore = [];


    foreach ($ids as $id=>$value) {
      $bChanged = false;

      $url=\R::findOne( 'url','id = ?',[$id]);
      if (!$url) continue;
      $app->ownUrlList[] = $url;
      if ($url->app != $app) {
        $url->app          = $app;
        $bChanged  = true;
      }

      if ($post['url_libelle'][$id] && $url->libelle != $post['url_libelle'][$id]) {
        $url->libelle  = $post['url_libelle'][$id];
        $bChanged  = true;
      }

      if ($post['url_description'][$id] && $url->description  != $post['url_description'][$id]) {
        $url->description  = $post['url_description'][$id];
        $bChanged  = true;
      }

     if (!empty($files['url_icon'][$id])) {
       $newfile = $files['url_icon'][$id];
       if ($newfile->getError() === UPLOAD_ERR_OK) {

            $filecontent = file_get_contents($_FILES['url_icon']['tmp_name'][$id]);
            $icon = \R::findOne( 'icon', 'md5icon = ?', [md5($filecontent)]);
            if (!$icon) {
               $icon = \R::dispense("icon");
               $icon->icon = $filecontent;
               $icon->svg = strpos( $filecontent, "<svg ");
               $icon->md5icon = md5($filecontent);
               \R::store($icon);
            }

            $url->icon = $icon;
            // Si Icon en FS on la modifie
            if ($path = ApiController::_hasIconPath("url",$id,$this->ci["router"])) {
                $filename = ApiController::getIconPath("url",$id) ;
                file_put_contents($filename,$icon->icon);
            }
            if ($path = ApiController::_hasIconPath("icon",$icon->id,$this->ci["router"])) {
                $filename = ApiController::getIconPath("icon",$icon->id) ;
                file_put_contents($filename,$icon->icon);
            }
       }
     }
      // categorie de l'url différente de celle de l'appli
      // on va l'utiliser
    if ($post['url_category'][$id]) {
        if ($post['url_category'][$id] != $post['category'] ) {
            $catUrl=\R::findOne( 'category','id = ?',[$post['url_category'][$id]]);
            if ($catUrl) {
                $url->category = $catUrl;
            }
            } else {
                $url->category = null;
            }
    }
      // zone
    if ($post['url_zone'][$id]) {
        if ($post['url_zone'][$id] != $post['zone'] ) {
            $url->zone = $post['url_zone'][$id];
        } else {
          $url->zone = null;
        }
    }
    
      // host de l'url différente de celle de l'appli
      // on va l'utiliser
    if ($post['url_host'][$id]) {
          if ($post['url_host'][$id] != $post['host'] ) {
            $hoster=\R::findOne( 'hoster','id = ?',[$post['url_host'][$id]]);
            if ($hoster) {
                $url->hoster = $hoster;
            }
            } else {
                $url->hoster = null;
            }
    }
    
      if ($bChanged || $url->hasChanged( 'hoster' )
                    || $url->hasChanged( 'zone' )
                    || $url->hasChanged( 'category' )
         ) {
                $url->new = false;
                 $urlToStore[] = $url;
         }
    } // Fin du for ID foreach ($ids as $id=>$value)

    \R::storeAll($urlToStore);
    \R::store($app);

    foreach ($post['url_application'] as $urlId => $appId) {
        $urlToChange=\R::findOne( 'url','id = ?',[$urlId]);
        $appForChange=\R::findOne( 'url','id = ?',[$appId]);
        if ($urlToChange && $appForChange) {
            $appForChange->addUrl($urlToChange);
            $urlToChange->app = $appForChange;
            \R::store($appForChange);
            \R::store($urlToChange);
        }
    }

    $app->reorg(false);


    if ($post['apply']=="yes") {
      return $response->withRedirect($this->ci->get('router')->pathFor('app_edit',['id'=>$app->id]));
    }

    return $response->withRedirect($this->ci->get('router')->pathFor('apps'));
 
    
  }



  private function objectToArray($item) {
      $array = $item;
      if  (!(is_array($item))) {
            $array = array($item);
      }
    return $array;
  }

  private function arenaRessource($url){
      $ress=explode(SEP_SIGAT,$url);
      if (strpos($url,"redirect.jsp?applicationname=") !== false) {
          $tmp=array_pop($ress);
          // $tmp est une url qui ressemble a xxx/redirect.jsp?applicationname=app_xyz
          $aurl=explode("=",$tmp);$app=explode("_",$aurl[1]);
          $ress[]=$app[0]; // recuperation du nom de l'appli
      }
      return implode(SEP_SIGAT,$ress);
  }

 public function initAction(Request $request, Response $response, $args) {
    $this->requireManager();
//on initalise 2 tableaux : un de sous-domaines/apps, un de ressources/urls
//ces tableaux permettront de confronter les éléments existants dans la base avec ceux récupérés d'arena et de vérifier les éléments obsolètes (qui n'existent plus dans arena)
$apparenaids = array();
$urlsarenaids = array();

    $client = new \SoapClient(__ARENA_WSIDENTITE);

    $result=$client->getAllRessources(0,0,1);
/*        $items=objectToArray($result);
        if (!is_array($items) || count($items)==0) {
          continue;
        }
 */
//    print_r($result);
    echo "<a href='../app/list'>Retour à la liste</a><br><br>";
    $cpt=0;$cptNewApp=0;
    // on parcours les domaines ARENA (categories)
    echo "<h2>Parcours des ressources ARENA</h2>";
    foreach ($result->item as $domaine) {
        echo "<b>- ".$domaine->libelleDomaine."</b><br>";
        // on verifie si une categorie avec le meme arenaid correspond dans la base
        $cat = \R::findOne('category','arenaid = ?', [$domaine->idDomaine]);
        //si elle n'existe pas on la cree
        if (!$cat) {
            echo "<br>Non trouvé dans la base<br>";
            $cat = \R::dispense('category');
            $cat->libelle = $domaine->libelleDomaine;
            $cat->name = preg_replace("%[^a-zA-Z0-9 ]%","",$domaine->libelleDomaine);
            $cat->arenaid = $domaine->idDomaine;
            \R::store($cat);
            echo "<br>       => Nouvelle Catégorie créée dans la base : id=". $cat->id." libelle=".$cat->libelle."<br>";
        }
        // on parcours les sous-domaines ARENA (applis)
        $sousDomaines = $this->objectToArray($domaine->sousDomaines);

        foreach ($sousDomaines as $sousDomaine) {
            //on alimente le tableau des arenaids récupérés d'arena
            $apparenaids[] = $sousDomaine->idDomaine;
            // On verifie si une appli avec le meme arenaid correspond dans la base
            $app = \R::findOne('app','arenaid = ?',[$sousDomaine->idDomaine]);
            //si elle n'existe pas on la cree
            if (!$app) {
                echo "Sous-domaine ".$sousDomaine->libelleDomaine." non trouvé dans la base<br>";
                $newapp=1;
                $app = \R::dispense('app');
                //TODO : remplacer par random_bytes au passage en php7
                $app->uid = bin2hex(openssl_random_pseudo_bytes(16));
                $app->libelle = $sousDomaine->libelleDomaine;
                $app->arenaid = $sousDomaine->idDomaine;
                $app->origin  = "Arena";
                $app->new     = true;
                $app->category = $cat;
                echo "<br>      => Nouvelle application créée dans la base : ".$app->libelle." (arenaid : ".$app->arenaid.")<br>";
            }
            else {
                $newapp=0;
                if ($app->new  == true) {
                    $app->new     = false;
                    \R::store($app);
                }
                //echo "<br>Appli déjà existante dans la base, ne sera pas écrasée<br>";
            }

            // on parcours les ressourcs ARENA (urls)
            $ressources = $this->objectToArray($sousDomaine->ressources);
            foreach ($ressources as $ressource) {

                // En cas de Ressource non accessible on ne fait rien
                if ( $ressource->urlComplete == "nonAccessible") {
                   continue;
                }

                $resarena= $this->arenaRessource($domaine->libelleDomaine.SEP_SIGAT.$sousDomaine->libelleDomain.SEP_SIGAT.$ressource->urlCT);
                $bUpdateUrl = false;
                //on alimente le tableau des urls récupérées d'arena
                $urlsrecuperees[] = "'".$ressource->urlComplete."'";
                // On verifie si une url identique correspond dans la base (on utilise le md5 indexé)
                if ($url = \R::findOne('url','md5url = ?',[md5($ressource->urlComplete)])) {
                    //vérification du arenaid
                    if (!$url->arenaid) {
                        echo "<br>L'url ".$url->url." n'a pas d'arenaid dans la base, on l'update avec l'idressource issu d'arena : ".$ressource->idRessource."<br>";
                        $url->arenaid = $ressource->idRessource;
                        $bUpdateUrl = true;
                    }
                    //test sur arenaid et idressource pour vérifier si urls identiques dans arena avec des id différents
                    if (strcmp($ressource->idRessource,$url->arenaid) !== 0) {
                        echo "<br>Attention : on est entrain de traiter ".$ressource->urlComplete." qui a pour IDRESSOURCE : ".$ressource->idRessource." alors que l'url trouvée dans la base (".$url->url.") a pour ARENAID : ".$url->arenaid.". Cela signifie que deux urls identiques existent dans ARENA (avec des ids différents). Cela peut poser un pb lors de l'étape suivante (vérification du resarena)<br>";
                    }

                    if (!$url->urlct) {
                        echo "<br>L'urlct de la ressource ".$ressource->urlComplete." est vide, on le met à jour<br>";
                        $url->urlct = $ressource->urlCT;
                        $bUpdateUrl = true;
                    }

                    //echo "<br> - URL ".$ressource->libelleRessource."  (  ". $ressource->urlComplete. ")<br>
                    //Déjà existante dans la base, ne sera pas écrasée<br>";
                    //Si son resarena est différent on lui réaffecte celui d'ARENA
                    if (strcmp($url->resarena,$resarena) !== 0) {
                        echo "<br>Le resarena de l'url ".$url->url."  (".$url->resarena.", arenaid : ".$url->arenaid.") ne matche pas avec celui d'arena (".$resarena.", idressource : ".$ressource->idRessource."), on l'update<br>";
                        $url->resarena = $resarena;
                        $url->updatedAt = new \DateTime();
                        $bUpdateUrl = true;
                    }
                    //si l'url n'a pas de updatedAt, on enclenche un update de l'url
                    if (!$url->updatedAt) {
                        $url->updatedAt = new \DateTime();
                        $bUpdateUrl = true;
                        echo " <br>L'url ".$url->url." n'a pas de updatedat, on la met à jour pour le créer<br>";

                    }
                    if ($url->new == true) {
                        $url->new = false;
                        echo "<br>L'url ".$url->url." était marqué comme nouvelle, on la passe à ancienne<br>";
                        $bUpdateUrl = true;
                    }



                // l'url n'existe pas dans la base
                } else {
                    // on la crée
                    echo "<br>URL ".$ressource->urlComplete." non trouvée dans la base<br>";
                    $url = \R::dispense('url');
                    $cpt++;

                    echo "<br>     => Nouvelle URL  ".$cpt." : ".$ressource->libelleRessource."  (  ". $ressource->urlComplete. " ) [".$ressource->urlCT."]<br>";
                    $url->resarena   = $resarena;
                    $url->url        = $ressource->urlComplete;
                    $url->md5url        = md5($ressource->urlComplete);
                    $url->libelle    = $ressource->libelleRessource;
                    $url->arenaid    = $ressource->idRessource;
                    $url->urlct      = $ressource->urlCT;
                    $url->updatedAt = new \DateTime();
                    $url->new = true;
                    $bUpdateUrl      = true;
                    // on cherche si une url identique mais d'une autre zone existe déjà dans la base
                    $likeUrl = \R::findOne('url','url like ? AND timediff(now() , updated_at) > "00:00:02"',["%".$ressource->urlCT]);
                    if ($likeUrl && $likeUrl->app) {
                        echo " <br> --- une URL similaire a été trouvée dans la base pour ".$ressource->urlCT." : ".$likeUrl->url;
                        $likeApp = $likeUrl->app;   //NE SURTOUT PAS UTILISER LA VARIABLE $app car déjà définie auparavant
                        echo " --- Elle a pour application : ".$likeApp->libelle;

                       // si c'est le cas on affecte à la nouvelle url l'appli de l'url déjà existante
                            echo " --- on affecte celle-ci à la nouvelle url<br>";
                            $url->app   = $likeApp;
                     }
                    else {
                        $url->app   = $app;
                    }
                    //AFFECTATION ICONE A URL
                    $appli = "";
                    $icon = false;
                    //on tente de trouver une racine au nom d'une appli
                    //si appli en fédération ce sera la chaine située après applicationname
                    if (strpos($ressource->urlCT,"redirectionhub/redirect.jsp?applicationname=")!==false) {
                        //echo "<br>APPLI EN FEDERATION<br>";
                        $arrUrl=explode("=",$ressource->urlCT);
                        $appli=strtr($arrUrl[1],array("_in"=>"", "-in"=>"", "_etab"=>"", "-etab"=>""));
                        //echo "<br>URL BASE : " . $appli ."<br>";
                    }
                    //si appli locale ce sera la chaine après le 1er /
                    else {
                         $urlarray = explode( '/', $ressource->urlCT);
                         $appli = $urlarray[1];
                    }
                    //on cherche si une icone existe dans le FS de l'ancien dispatcher avec pour nom la racine trouvée
                    if (file_exists("/var/www/html/edispatcher/icones/" . $appli . ".png")) {
                         $icon="/var/www/html/edispatcher/icones/" .  $appli . ".png";
                    }

                    //echo "<br>    URL BASE : " . $appli;

                    //si une icone existe et que l'app ou la likeApp de l'url n'en ont pas, on associe l'icone à l'url, puis à l'app si elle n'en a pas
                    if ($icon) {
                        echo "<br> --- Une icône " . $icon . " a été trouvée pour cette URL <br>";
                        echo "<br> --- On affecte l'icone ".$icon." a l'url ".$url->url."<br>";
                        $blobicon = file_get_contents($icon);
                        $md5icon = md5($blobicon);
                        $icone = \R::findone('icon', 'md5icon = ?', [$md5icon]);
                        if (!$icone) {
                            $icone = \R::dispense('icon');
                            $icone->icon = $blobicon;
                            $icone->md5icon = $md5icon;
                            $icon->updated_at = new \DateTime();
                            \R::store($icone);
                        }
                        $url->icon = $icone;                        
                        $url->iconUpdatedAt = new \DateTime();
                        $bUpdateUrl = true;
                        if ($newapp == 1 && !$likeApp->icon && !$app->icon) {
                            echo "<br> --- On affecte l'icone ".$icon." a l'app ".$app->libelle."<br>";
                            $app->icon = $icone;
                        }

                    }
                } //FIN DU ELSE (nouvelle url)
                // si on doit updater l'url on met à jour le updatedAt
                if ($bUpdateUrl) {
                    echo " <br>     => On enregistre l'url ".$url->url." dans la base<br><br>";
                    \R::store($url);
                }
            } // FIN DU FOREACH RESSOURCE / URL
            // si l'appli est à créer
            if ($newapp == 1) {
                //si une icone existe et que l'appli n'en a pas
                if ($icon && !$app->icon) {
                    //on lui affecte par défaut comme icone celle de la dernière url trouvée
                    echo "<br>On affecte l'icone ".$icon."  a l'app ".$app->libelle."<br>";
                    $app->icon = $icone;
                    $app->iconUpdatedAt = new \DateTime();
                }
                $cptNewApp++;
                echo "  => On enregistre l'app ".$app->libelle."<br><br><br>";
                \R::store($app);
            }
        } //FIN DU FOREACH SOUS-DOMAINE / APP
    } // FIN DU FOREACH DOMAINE / CAT

        echo "<br><hr><br>
        <h2>Résultats</h2>";
        echo $cptNewApp?"$cptNewApp Nouvelle(s) application(s)":"Aucune nouvelle application";
        echo "<br>";
        echo $cpt?"$cpt Nouvelle(s) url(s)":"Aucune nouvelle url";
        echo "<br>";

        // Réorg des applis si nécessaire
        echo "<h2>Réorganisations par motif</h2>";
        $apps=\R::find( 'app',"pattern is not null and pattern != '' ");
        $cptReorg = 0;
        $appWithNoUrl = [];
        foreach ($apps as $app) {
          //echo $app->libelle." (". $app->id .") [". $app->pattern ."]\n";
          if ($app->reorg(true)) {
            $cptReorg++;
          }

          //echo " \n";
        }
        echo $cptReorg?"$cptReorg réorganisation(s)":"Aucune réorganisation";
        echo "<br>";



        //print_r($apparenaids);
        //print_r($urlsrecuperees);

        //\R::debug( TRUE, 0 ); //select MODE 2 to see parameters filled in
        //\R::Debug();   //since 4.2
        $apparenaidslist = implode(',', $apparenaids);
        $urlsrecupereesslist = implode(',', $urlsrecuperees);
        //echo $urlsrecupereesslist; exit();
        $cptobsoletes = 0;
        //echo "<br>Liste des appsarenaids récupérés : <br>".$apparenaidslist."<br>";
        echo "<h2>Flag des éléments obsolètes de la base</h2>
        <small>(NB : il s'agit des apps ou urls qui sont présentes dans la base et ont un id arena, mais dont l'id arena n'a pas été trouvé lors du parcours ARENA.<br>L'élément est alors flagué à OBSOLETE</small><br><br>";

        $apparenaidsobsoletes = \R::find( 'app', "arenaid is not null and arenaid  not in (".$apparenaidslist.")");
         //print_r($apparenaidsobsoletes);
         foreach ($apparenaidsobsoletes as $apparenaidsobsolete) {
             $apparenaidsobsolete->obsolete = true;
             //on passe le flag new à flase au cas ou l'appli aurait été flaguée à new
             $apparenaidsobsolete->new = false;
             echo "<br>Application de la base : ".$apparenaidsobsolete->libelle." ( ".$apparenaidsobsolete->id.", ArenaID : ".$apparenaidsobsolete->arenaid." ) OBSOLETE<br>";
             \R::store($apparenaidsobsolete);
             $cptobsoletes++;
         }
        $urlsarenaidobsoletes = \R::find( 'url', "(arenaid  is not null OR resarena is not null) and url not in (".$urlsrecupereesslist.")");
        foreach ($urlsarenaidobsoletes as $urlobsolete) {
             $urlobsolete->obsolete = true;
             //on passe le flag new à flase au cas ou l'url aurait été flaguée à new
             $urlobsolete->new = false;
             echo "<br>URL de la base : ".$urlobsolete->libelle." ( ".$urlobsolete->id.", ArenaID : ".$urlobsolete->arenaid." ) OBSOLETE<br>";
             \R::store($urlobsolete);
             $cptobsoletes++;
        }
        echo "<br>".$cptobsoletes." élément(s) obsolète(s)<br>";
         //print_r($urlsarenaidsobsoletes);

        echo "<br><br><a href='../app/list'>Retour à la liste</a><br><br>";
 }

  public function verifAppAction(Request $request, Response $response, $args) {
    $this->requireReader();
    $apps=\R::find( 'app' );
    $appsWithNoUrl=[];
    $appsWithNoidArena = [];
    $appsWithNoOriginArena=[];
    $appsObsoletes=[];

    foreach ($apps as $app) {
        if ($app->isArena() && $app->getNbUrls()==0 ) {
            $appsWithNoUrl[] = $app;
        }
        if ($app->isArena() && !$app->arenaid) {
            $appsWithNoidArena[] = $app;
        }
        if (!$app->isArena() && $app->obsolete == false && $app->arenaid) {
            $appsWithNoOriginArena[] = $app;
        }
        if ($app->obsolete == true) {
            $appsObsoletes[] = $app;
        }
    }

    return $this->ci["view"]->render($response,
                                     'app/verif.html.twig',
                                     $this->genParams([
                                     "appswithnourl"   => $appsWithNoUrl,
                                     "appswithnoidarena" =>  $appsWithNoidArena,
                                     "appsWithNoOriginArena" => $appsWithNoOriginArena,
                                     "appsObsoletes" => $appsObsoletes
                                     ]));
  }

  public function verifUrlAction(Request $request, Response $response, $args) {
    $this->requireReader();
    $urls=\R::find( 'url' );
    $urlsWithNoresarena=[];
    $urlsWithNoidArena = [];
    $urlsObsoletes=[];
    $urlsWithNourlct = [];

    foreach ($urls as $url) {
        //urls avec arenaid ou urlct mais sans resarena
        if (($url->arenaid || $url->urlct) && !$url->resarena ) {
            $urlsWithNoresarena[] = $url;
        }
        //urls avec resarena ou urlct mais sans arenaid
        if (!$url->arenaid && ($url->resarena || $url->urlct)) {
            $urlsWithNoidArena[] = $url;
        }

        //urls avec resarena mais sans urlct
        if (!$url->urlct && ($url->resarena || $url->arenaid)) {
            $urlsWithNourlct[] = $url;
        }

        if ($url->obsolete == true) {
            $urlsObsoletes[] = $url;
        }
    }

    return $this->ci["view"]->render($response,
                                     'app/urlverif.html.twig',
                                     $this->genParams([
                                     "urlsWithNoresarena"   => $urlsWithNoresarena,
                                     "urlsWithNoidArena" =>  $urlsWithNoidArena,
                                     "urlsObsoletes" => $urlsObsoletes,
                                     "urlsWithNourlct" => $urlsWithNourlct
                                     ]));
  }

}
