<?php

namespace Edispatcher\Bot;

use Mpociot\BotMan\Conversation;
use Mpociot\BotMan\Answer;
use Mpociot\BotMan\Question;
use Mpociot\BotMan\Button;

class GraphiqueConversation extends Conversation
{
    protected $type;
    protected $nb;
    protected $bot;
    protected $question;

    public function __construct($bot,$from=false) {
        $this->bot = $bot;
        $this->from=$from;
    }

    public function askType()
    {

        $choices=['Voici les graphiques que je peux vous proposer'];
        $c = 0;
        foreach (GrafanaWorkerThread::$GRAPHS as $key => $data) {
          $c++;
          $choices[]="$c : *$key* : ".$data["message"];
        }


        $this->ask(implode("\n",$choices)."\nQuel est votre choix, veuillez saisir un nombre entre 1 et $c?", function(Answer $answer)  {

            $index = intval(trim($answer->getText()))-1;

            if ($index <0 || $index >= count(GrafanaWorkerThread::$GRAPHS) ) {
              $this->bot->reply("Désolé, votre reponse est incorrecte");
              return;
            }

            $this->type=array_keys(GrafanaWorkerThread::$GRAPHS)[$index];
            GrafanaWorkerThread::GenerateGraphique($this->bot,$this->type,$this->from);

        });
    }

    public function run()
    {
        // This will be called immediately
        $this->nb = 0;
        $this->askType();
    }
}
