<?php
if (!defined("INC_DIR")) {
  define("ROOT_DIR",dirname(__FILE__)."/..");
  define("INC_DIR",ROOT_DIR."/include");
}
// ======================================================================
// Gestion de l'authentification
// Mis en commentaire bug firefox non présent
/*if (session_status() == PHP_SESSION_NONE) {

    $sessionName = "edispatcher";
    session_name($sessionName);
    # ref #23977 : check correct Session ID
    if (isset($_COOKIE[$sessionName]) && (
        empty($_COOKIE[$sessionName]) || preg_match('/^[a-z0-9A-Z\-]+$/', $_COOKIE[$sessionName]) === 0 ) ) 
    {
      // This happens when someone does "clear cookie" in Firebug; it causes session_start()
      // to trigger a warning. session_start() relies on $_COOKIE[$session_name], thus:
      unset($_COOKIE[$sessionName]);
    }
    $ok = @session_start();
    if(!$ok){
        session_regenerate_id(true); // replace the Session ID
        session_start();
    }
}*/

include_once(INC_DIR.'/dispatcher.config.php');
include_once(INC_DIR.'/db.config.php');

function DisplayAppli($message,$param,$type) {
    if($type=="ERREUR")
        $message="<div style='background-color:red; color:#FFF; font-weight: bold; padding:10px;'>".$message."</div>";
    return $message;
}

if (/*!isset($_SESSION["CASATTRIBUTE"]) && */ !defined("NOCAS") ) {
    // Lib CAS
    include_once(INC_DIR."/cas.php");
}


// ======================================================================

# Quelques fonctions utiles
include_once(INC_DIR.'/fonctions.php');

#--------------------------------------------------------------------------
# GetPortailHost(): Récupération du portail en fonction de l'IP du client
#--------------------------------------------------------------------------
# Se base sur le fichier portails.ini
function GetPortailHost()
{
    $portail=_URL_PORTAIL_DEFAUT;
    # Si OTP, on redirige directement sur portail
    if ($portail!= "" && IsOTP())
    {
        return $portail;
    }

    $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    if (isset($_SESSION["IP_CLIENT"]))
    {
        $ip=$_SESSION["IP_CLIENT"];
    }

    $les_portails=parse_ini_file("utils/portails.ini",true);

    if ($les_portails){
        foreach ($les_portails as $addr => $un_portail) {
            if (ip_in_network($ip,$addr,$un_portail['mask'])){
                $portail=$un_portail['portail'];
            }
        }
    }

    return $portail;
}
#--------------------------------------------------------------------------


/* =========================================================*/
/* Fonctions permettant d'affihcer les Applications la mode Arena*/
function Arena_BeginDomaine($TITRE)	{echo "<div id='$TITRE'><div class='col'>";}
function Arena_EndDomaine()		{echo "</div></div>";}
function Arena_SousDomaine($TITRE)	{echo "<h2>$TITRE</h2>";}
function Arena_SousSousDomaine($TITRE)	{echo "<h4>$TITRE</h4>";}


function Arena_Appli($TITRE,$URL="",$flag="",$TARGET=false)
{
	$s="";
	switch ($flag)
	{
		case "ERREUR" :$s="cross.png";$color="#F99";break;
		case "OK" :$s="check_verte.png";$color="#3A3";break;
		case "WARNING":$s="warning.png";$color="#cca12e";break;
		case "TODO":$s="todo.png";$color="#F28288";break;

	}

	if ($s != "" )
	{
		$TITRE= "<font color='$color'><img ALIGN='ABSMIDDLE' src='images/$s'>&nbsp;&nbsp;&nbsp;" . $TITRE . "</font>";
	}

	if ($URL!="")
	{
		if ($TARGET==false) echo "<h3><a href='$URL' target='_blank'><span title>$TITRE</span></a></h3>";
		else  echo "<h3><a href='$URL' target='$TARGET' ><span title>$TITRE</span></a></h3>";
	} else
	{
		echo "<h3><span title>$TITRE</span></h3>";
	}
}
/* =========================================================*/

?>
