#pragma once
/*
 *  $Id: gwyapp.h 29094 2026-01-06 17:53:17Z yeti-dn $
 *  Copyright (C) 2003-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYAPP_GWYAPP_H__
#define __GWYAPP_GWYAPP_H__

#include <libgwyui/gwyui.h>

#include <libgwyapp/types.h>
#include <libgwyapp/app.h>
#include <libgwyapp/app-graph-window.h>
#include <libgwyapp/app-image-window.h>
#include <libgwyapp/data-browser.h>
#include <libgwyapp/data-chooser.h>
#include <libgwyapp/dialog.h>
#include <libgwyapp/file.h>
#include <libgwyapp/file-ops.h>
#include <libgwyapp/filelist.h>
#include <libgwyapp/glmaterial-editor.h>
#include <libgwyapp/gradient-editor.h>
#include <libgwyapp/gwytool.h>
#include <libgwyapp/gwyplaintool.h>
#include <libgwyapp/help.h>
#include <libgwyapp/log.h>
#include <libgwyapp/log-browser.h>
#include <libgwyapp/logging.h>
#include <libgwyapp/menu.h>
#include <libgwyapp/menu-recent-files.h>
#include <libgwyapp/meta-browser.h>
#include <libgwyapp/module-browser.h>
#include <libgwyapp/module-cmap.h>
#include <libgwyapp/module-file.h>
#include <libgwyapp/module-graph.h>
#include <libgwyapp/module-loader.h>
#include <libgwyapp/module-process.h>
#include <libgwyapp/module-synth.h>
#include <libgwyapp/module-tool.h>
#include <libgwyapp/module-volume.h>
#include <libgwyapp/module-xyz.h>
#include <libgwyapp/module-utils.h>
#include <libgwyapp/module-utils-file.h>
#include <libgwyapp/module-utils-synth.h>
#include <libgwyapp/param-def.h>
#include <libgwyapp/params.h>
#include <libgwyapp/param-resource.h>
#include <libgwyapp/param-table.h>
#include <libgwyapp/resource-editor.h>
#include <libgwyapp/results-export.h>
#include <libgwyapp/settings.h>
#include <libgwyapp/thumbnail.h>
#include <libgwyapp/undo.h>
#include <libgwyapp/validate.h>
#include <libgwyapp/wait.h>

void         gwy_app_init_widget_styles (GdkScreen *screen);
void         gwy_app_init               (gboolean for_gui,
                                         const gchar *option,
                                         ...);
const gchar* gwy_app_get_tree_model_kind(GtkTreeModel *model);
void         gwy_app_set_tree_model_kind(GtkTreeModel *model,
                                         const gchar *kind);

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
