<?php

declare(strict_types = 1);

use \PHPUnit\Framework\TestCase;
use \ReCaptcha\ReCaptcha;

require_once __DIR__ . '/FakeCheck.php';

final class SimpleTest extends TestCase
{
    public function testImplementation(): void
    {
        $secret = 'xxxxxxx';
        $requestMethod = new FakeCheck();
        $recaptcha = new \ReCaptcha\ReCaptcha($secret, $requestMethod);
        $this->assertSame([
            'success' => true,
            'hostname' => 'debian.local',
            'challenge_ts' => '',
            'apk_package_name' => '',
            'score' => null,
            'action' => '',
            'error-codes' => [],
        ], $recaptcha->verify('response')->toArray());
    }
}
