// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/apps/drive/activity/v2/action.proto

package activity

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of deletion.
type Delete_Type int32

const (
	// Deletion type is not available.
	Delete_TYPE_UNSPECIFIED Delete_Type = 0
	// An object was put into the trash.
	Delete_TRASH Delete_Type = 1
	// An object was deleted permanently.
	Delete_PERMANENT_DELETE Delete_Type = 2
)

// Enum value maps for Delete_Type.
var (
	Delete_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "TRASH",
		2: "PERMANENT_DELETE",
	}
	Delete_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"TRASH":            1,
		"PERMANENT_DELETE": 2,
	}
)

func (x Delete_Type) Enum() *Delete_Type {
	p := new(Delete_Type)
	*p = x
	return p
}

func (x Delete_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Delete_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_drive_activity_v2_action_proto_enumTypes[0].Descriptor()
}

func (Delete_Type) Type() protoreflect.EnumType {
	return &file_google_apps_drive_activity_v2_action_proto_enumTypes[0]
}

func (x Delete_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Delete_Type.Descriptor instead.
func (Delete_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{6, 0}
}

// The type of restoration.
type Restore_Type int32

const (
	// The type is not available.
	Restore_TYPE_UNSPECIFIED Restore_Type = 0
	// An object was restored from the trash.
	Restore_UNTRASH Restore_Type = 1
)

// Enum value maps for Restore_Type.
var (
	Restore_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "UNTRASH",
	}
	Restore_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"UNTRASH":          1,
	}
)

func (x Restore_Type) Enum() *Restore_Type {
	p := new(Restore_Type)
	*p = x
	return p
}

func (x Restore_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Restore_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_drive_activity_v2_action_proto_enumTypes[1].Descriptor()
}

func (Restore_Type) Type() protoreflect.EnumType {
	return &file_google_apps_drive_activity_v2_action_proto_enumTypes[1]
}

func (x Restore_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Restore_Type.Descriptor instead.
func (Restore_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{7, 0}
}

// The [Google Drive permissions
// roles](https://developers.google.com/drive/web/manage-sharing#roles).
type Permission_Role int32

const (
	// The role is not available.
	Permission_ROLE_UNSPECIFIED Permission_Role = 0
	// A role granting full access.
	Permission_OWNER Permission_Role = 1
	// A role granting the ability to manage people and settings.
	Permission_ORGANIZER Permission_Role = 2
	// A role granting the ability to contribute and manage content.
	Permission_FILE_ORGANIZER Permission_Role = 3
	// A role granting the ability to contribute content. This role is sometimes
	// also known as "writer".
	Permission_EDITOR Permission_Role = 4
	// A role granting the ability to view and comment on content.
	Permission_COMMENTER Permission_Role = 5
	// A role granting the ability to view content. This role is sometimes also
	// known as "reader".
	Permission_VIEWER Permission_Role = 6
	// A role granting the ability to view content only after it has been
	// published to the web. This role is sometimes also known as "published
	// reader". See https://support.google.com/sites/answer/6372880 for more
	// information.
	Permission_PUBLISHED_VIEWER Permission_Role = 7
)

// Enum value maps for Permission_Role.
var (
	Permission_Role_name = map[int32]string{
		0: "ROLE_UNSPECIFIED",
		1: "OWNER",
		2: "ORGANIZER",
		3: "FILE_ORGANIZER",
		4: "EDITOR",
		5: "COMMENTER",
		6: "VIEWER",
		7: "PUBLISHED_VIEWER",
	}
	Permission_Role_value = map[string]int32{
		"ROLE_UNSPECIFIED": 0,
		"OWNER":            1,
		"ORGANIZER":        2,
		"FILE_ORGANIZER":   3,
		"EDITOR":           4,
		"COMMENTER":        5,
		"VIEWER":           6,
		"PUBLISHED_VIEWER": 7,
	}
)

func (x Permission_Role) Enum() *Permission_Role {
	p := new(Permission_Role)
	*p = x
	return p
}

func (x Permission_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Permission_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_drive_activity_v2_action_proto_enumTypes[2].Descriptor()
}

func (Permission_Role) Type() protoreflect.EnumType {
	return &file_google_apps_drive_activity_v2_action_proto_enumTypes[2]
}

func (x Permission_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Permission_Role.Descriptor instead.
func (Permission_Role) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{9, 0}
}

// More detailed information about the change.
type Comment_Post_Subtype int32

const (
	// Subtype not available.
	Comment_Post_SUBTYPE_UNSPECIFIED Comment_Post_Subtype = 0
	// A post was added.
	Comment_Post_ADDED Comment_Post_Subtype = 1
	// A post was deleted.
	Comment_Post_DELETED Comment_Post_Subtype = 2
	// A reply was added.
	Comment_Post_REPLY_ADDED Comment_Post_Subtype = 3
	// A reply was deleted.
	Comment_Post_REPLY_DELETED Comment_Post_Subtype = 4
	// A posted comment was resolved.
	Comment_Post_RESOLVED Comment_Post_Subtype = 5
	// A posted comment was reopened.
	Comment_Post_REOPENED Comment_Post_Subtype = 6
)

// Enum value maps for Comment_Post_Subtype.
var (
	Comment_Post_Subtype_name = map[int32]string{
		0: "SUBTYPE_UNSPECIFIED",
		1: "ADDED",
		2: "DELETED",
		3: "REPLY_ADDED",
		4: "REPLY_DELETED",
		5: "RESOLVED",
		6: "REOPENED",
	}
	Comment_Post_Subtype_value = map[string]int32{
		"SUBTYPE_UNSPECIFIED": 0,
		"ADDED":               1,
		"DELETED":             2,
		"REPLY_ADDED":         3,
		"REPLY_DELETED":       4,
		"RESOLVED":            5,
		"REOPENED":            6,
	}
)

func (x Comment_Post_Subtype) Enum() *Comment_Post_Subtype {
	p := new(Comment_Post_Subtype)
	*p = x
	return p
}

func (x Comment_Post_Subtype) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Comment_Post_Subtype) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_drive_activity_v2_action_proto_enumTypes[3].Descriptor()
}

func (Comment_Post_Subtype) Type() protoreflect.EnumType {
	return &file_google_apps_drive_activity_v2_action_proto_enumTypes[3]
}

func (x Comment_Post_Subtype) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Comment_Post_Subtype.Descriptor instead.
func (Comment_Post_Subtype) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{10, 0, 0}
}

// More detailed information about the change.
type Comment_Assignment_Subtype int32

const (
	// Subtype not available.
	Comment_Assignment_SUBTYPE_UNSPECIFIED Comment_Assignment_Subtype = 0
	// An assignment was added.
	Comment_Assignment_ADDED Comment_Assignment_Subtype = 1
	// An assignment was deleted.
	Comment_Assignment_DELETED Comment_Assignment_Subtype = 2
	// An assignment reply was added.
	Comment_Assignment_REPLY_ADDED Comment_Assignment_Subtype = 3
	// An assignment reply was deleted.
	Comment_Assignment_REPLY_DELETED Comment_Assignment_Subtype = 4
	// An assignment was resolved.
	Comment_Assignment_RESOLVED Comment_Assignment_Subtype = 5
	// A resolved assignment was reopened.
	Comment_Assignment_REOPENED Comment_Assignment_Subtype = 6
	// An assignment was reassigned.
	Comment_Assignment_REASSIGNED Comment_Assignment_Subtype = 7
)

// Enum value maps for Comment_Assignment_Subtype.
var (
	Comment_Assignment_Subtype_name = map[int32]string{
		0: "SUBTYPE_UNSPECIFIED",
		1: "ADDED",
		2: "DELETED",
		3: "REPLY_ADDED",
		4: "REPLY_DELETED",
		5: "RESOLVED",
		6: "REOPENED",
		7: "REASSIGNED",
	}
	Comment_Assignment_Subtype_value = map[string]int32{
		"SUBTYPE_UNSPECIFIED": 0,
		"ADDED":               1,
		"DELETED":             2,
		"REPLY_ADDED":         3,
		"REPLY_DELETED":       4,
		"RESOLVED":            5,
		"REOPENED":            6,
		"REASSIGNED":          7,
	}
)

func (x Comment_Assignment_Subtype) Enum() *Comment_Assignment_Subtype {
	p := new(Comment_Assignment_Subtype)
	*p = x
	return p
}

func (x Comment_Assignment_Subtype) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Comment_Assignment_Subtype) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_drive_activity_v2_action_proto_enumTypes[4].Descriptor()
}

func (Comment_Assignment_Subtype) Type() protoreflect.EnumType {
	return &file_google_apps_drive_activity_v2_action_proto_enumTypes[4]
}

func (x Comment_Assignment_Subtype) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Comment_Assignment_Subtype.Descriptor instead.
func (Comment_Assignment_Subtype) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{10, 1, 0}
}

// More detailed information about the change.
type Comment_Suggestion_Subtype int32

const (
	// Subtype not available.
	Comment_Suggestion_SUBTYPE_UNSPECIFIED Comment_Suggestion_Subtype = 0
	// A suggestion was added.
	Comment_Suggestion_ADDED Comment_Suggestion_Subtype = 1
	// A suggestion was deleted.
	Comment_Suggestion_DELETED Comment_Suggestion_Subtype = 2
	// A suggestion reply was added.
	Comment_Suggestion_REPLY_ADDED Comment_Suggestion_Subtype = 3
	// A suggestion reply was deleted.
	Comment_Suggestion_REPLY_DELETED Comment_Suggestion_Subtype = 4
	// A suggestion was accepted.
	Comment_Suggestion_ACCEPTED Comment_Suggestion_Subtype = 7
	// A suggestion was rejected.
	Comment_Suggestion_REJECTED Comment_Suggestion_Subtype = 8
	// An accepted suggestion was deleted.
	Comment_Suggestion_ACCEPT_DELETED Comment_Suggestion_Subtype = 9
	// A rejected suggestion was deleted.
	Comment_Suggestion_REJECT_DELETED Comment_Suggestion_Subtype = 10
)

// Enum value maps for Comment_Suggestion_Subtype.
var (
	Comment_Suggestion_Subtype_name = map[int32]string{
		0:  "SUBTYPE_UNSPECIFIED",
		1:  "ADDED",
		2:  "DELETED",
		3:  "REPLY_ADDED",
		4:  "REPLY_DELETED",
		7:  "ACCEPTED",
		8:  "REJECTED",
		9:  "ACCEPT_DELETED",
		10: "REJECT_DELETED",
	}
	Comment_Suggestion_Subtype_value = map[string]int32{
		"SUBTYPE_UNSPECIFIED": 0,
		"ADDED":               1,
		"DELETED":             2,
		"REPLY_ADDED":         3,
		"REPLY_DELETED":       4,
		"ACCEPTED":            7,
		"REJECTED":            8,
		"ACCEPT_DELETED":      9,
		"REJECT_DELETED":      10,
	}
)

func (x Comment_Suggestion_Subtype) Enum() *Comment_Suggestion_Subtype {
	p := new(Comment_Suggestion_Subtype)
	*p = x
	return p
}

func (x Comment_Suggestion_Subtype) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Comment_Suggestion_Subtype) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_drive_activity_v2_action_proto_enumTypes[5].Descriptor()
}

func (Comment_Suggestion_Subtype) Type() protoreflect.EnumType {
	return &file_google_apps_drive_activity_v2_action_proto_enumTypes[5]
}

func (x Comment_Suggestion_Subtype) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Comment_Suggestion_Subtype.Descriptor instead.
func (Comment_Suggestion_Subtype) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{10, 2, 0}
}

// The type of the change.
type DataLeakPreventionChange_Type int32

const (
	// An update to the DLP state that is neither FLAGGED or CLEARED.
	DataLeakPreventionChange_TYPE_UNSPECIFIED DataLeakPreventionChange_Type = 0
	// Document has been flagged as containing sensitive content.
	DataLeakPreventionChange_FLAGGED DataLeakPreventionChange_Type = 1
	// Document is no longer flagged as containing sensitive content.
	DataLeakPreventionChange_CLEARED DataLeakPreventionChange_Type = 2
)

// Enum value maps for DataLeakPreventionChange_Type.
var (
	DataLeakPreventionChange_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "FLAGGED",
		2: "CLEARED",
	}
	DataLeakPreventionChange_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"FLAGGED":          1,
		"CLEARED":          2,
	}
)

func (x DataLeakPreventionChange_Type) Enum() *DataLeakPreventionChange_Type {
	p := new(DataLeakPreventionChange_Type)
	*p = x
	return p
}

func (x DataLeakPreventionChange_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataLeakPreventionChange_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_drive_activity_v2_action_proto_enumTypes[6].Descriptor()
}

func (DataLeakPreventionChange_Type) Type() protoreflect.EnumType {
	return &file_google_apps_drive_activity_v2_action_proto_enumTypes[6]
}

func (x DataLeakPreventionChange_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataLeakPreventionChange_Type.Descriptor instead.
func (DataLeakPreventionChange_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{11, 0}
}

// The type of the action.
type ApplicationReference_Type int32

const (
	// The type is not available.
	ApplicationReference_UNSPECIFIED_REFERENCE_TYPE ApplicationReference_Type = 0
	// The links of one or more Drive items were posted.
	ApplicationReference_LINK ApplicationReference_Type = 1
	// Comments were made regarding a Drive item.
	ApplicationReference_DISCUSS ApplicationReference_Type = 2
)

// Enum value maps for ApplicationReference_Type.
var (
	ApplicationReference_Type_name = map[int32]string{
		0: "UNSPECIFIED_REFERENCE_TYPE",
		1: "LINK",
		2: "DISCUSS",
	}
	ApplicationReference_Type_value = map[string]int32{
		"UNSPECIFIED_REFERENCE_TYPE": 0,
		"LINK":                       1,
		"DISCUSS":                    2,
	}
)

func (x ApplicationReference_Type) Enum() *ApplicationReference_Type {
	p := new(ApplicationReference_Type)
	*p = x
	return p
}

func (x ApplicationReference_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ApplicationReference_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_drive_activity_v2_action_proto_enumTypes[7].Descriptor()
}

func (ApplicationReference_Type) Type() protoreflect.EnumType {
	return &file_google_apps_drive_activity_v2_action_proto_enumTypes[7]
}

func (x ApplicationReference_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ApplicationReference_Type.Descriptor instead.
func (ApplicationReference_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{12, 0}
}

// The feature which had changes to its restriction policy.
type SettingsChange_RestrictionChange_Feature int32

const (
	// The feature which changed restriction settings was not available.
	SettingsChange_RestrictionChange_FEATURE_UNSPECIFIED SettingsChange_RestrictionChange_Feature = 0
	// When restricted, this prevents items from being shared outside the
	// domain.
	SettingsChange_RestrictionChange_SHARING_OUTSIDE_DOMAIN SettingsChange_RestrictionChange_Feature = 1
	// When restricted, this prevents direct sharing of individual items.
	SettingsChange_RestrictionChange_DIRECT_SHARING SettingsChange_RestrictionChange_Feature = 2
	// When restricted, this prevents actions like copy, download, and print
	// that might result in uncontrolled duplicates of items.
	SettingsChange_RestrictionChange_ITEM_DUPLICATION SettingsChange_RestrictionChange_Feature = 3
	// When restricted, this prevents use of Drive File Stream.
	SettingsChange_RestrictionChange_DRIVE_FILE_STREAM SettingsChange_RestrictionChange_Feature = 4
)

// Enum value maps for SettingsChange_RestrictionChange_Feature.
var (
	SettingsChange_RestrictionChange_Feature_name = map[int32]string{
		0: "FEATURE_UNSPECIFIED",
		1: "SHARING_OUTSIDE_DOMAIN",
		2: "DIRECT_SHARING",
		3: "ITEM_DUPLICATION",
		4: "DRIVE_FILE_STREAM",
	}
	SettingsChange_RestrictionChange_Feature_value = map[string]int32{
		"FEATURE_UNSPECIFIED":    0,
		"SHARING_OUTSIDE_DOMAIN": 1,
		"DIRECT_SHARING":         2,
		"ITEM_DUPLICATION":       3,
		"DRIVE_FILE_STREAM":      4,
	}
)

func (x SettingsChange_RestrictionChange_Feature) Enum() *SettingsChange_RestrictionChange_Feature {
	p := new(SettingsChange_RestrictionChange_Feature)
	*p = x
	return p
}

func (x SettingsChange_RestrictionChange_Feature) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SettingsChange_RestrictionChange_Feature) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_drive_activity_v2_action_proto_enumTypes[8].Descriptor()
}

func (SettingsChange_RestrictionChange_Feature) Type() protoreflect.EnumType {
	return &file_google_apps_drive_activity_v2_action_proto_enumTypes[8]
}

func (x SettingsChange_RestrictionChange_Feature) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SettingsChange_RestrictionChange_Feature.Descriptor instead.
func (SettingsChange_RestrictionChange_Feature) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{13, 0, 0}
}

// The restriction applicable to a feature.
type SettingsChange_RestrictionChange_Restriction int32

const (
	// The type of restriction is not available.
	SettingsChange_RestrictionChange_RESTRICTION_UNSPECIFIED SettingsChange_RestrictionChange_Restriction = 0
	// The feature is available without restriction.
	SettingsChange_RestrictionChange_UNRESTRICTED SettingsChange_RestrictionChange_Restriction = 1
	// The use of this feature is fully restricted.
	SettingsChange_RestrictionChange_FULLY_RESTRICTED SettingsChange_RestrictionChange_Restriction = 2
)

// Enum value maps for SettingsChange_RestrictionChange_Restriction.
var (
	SettingsChange_RestrictionChange_Restriction_name = map[int32]string{
		0: "RESTRICTION_UNSPECIFIED",
		1: "UNRESTRICTED",
		2: "FULLY_RESTRICTED",
	}
	SettingsChange_RestrictionChange_Restriction_value = map[string]int32{
		"RESTRICTION_UNSPECIFIED": 0,
		"UNRESTRICTED":            1,
		"FULLY_RESTRICTED":        2,
	}
)

func (x SettingsChange_RestrictionChange_Restriction) Enum() *SettingsChange_RestrictionChange_Restriction {
	p := new(SettingsChange_RestrictionChange_Restriction)
	*p = x
	return p
}

func (x SettingsChange_RestrictionChange_Restriction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SettingsChange_RestrictionChange_Restriction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_drive_activity_v2_action_proto_enumTypes[9].Descriptor()
}

func (SettingsChange_RestrictionChange_Restriction) Type() protoreflect.EnumType {
	return &file_google_apps_drive_activity_v2_action_proto_enumTypes[9]
}

func (x SettingsChange_RestrictionChange_Restriction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SettingsChange_RestrictionChange_Restriction.Descriptor instead.
func (SettingsChange_RestrictionChange_Restriction) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{13, 0, 1}
}

// Information about the action.
type Action struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type and detailed information about the action.
	Detail *ActionDetail `protobuf:"bytes,1,opt,name=detail,proto3" json:"detail,omitempty"`
	// The actor responsible for this action (or empty if all actors are
	// responsible).
	Actor *Actor `protobuf:"bytes,3,opt,name=actor,proto3" json:"actor,omitempty"`
	// The target this action affects (or empty if affecting all targets). This
	// represents the state of the target immediately after this action occurred.
	Target *Target `protobuf:"bytes,4,opt,name=target,proto3" json:"target,omitempty"`
	// When the action occurred (or empty if same time as entire activity).
	//
	// Types that are assignable to Time:
	//	*Action_Timestamp
	//	*Action_TimeRange
	Time isAction_Time `protobuf_oneof:"time"`
}

func (x *Action) Reset() {
	*x = Action{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action) ProtoMessage() {}

func (x *Action) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action.ProtoReflect.Descriptor instead.
func (*Action) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{0}
}

func (x *Action) GetDetail() *ActionDetail {
	if x != nil {
		return x.Detail
	}
	return nil
}

func (x *Action) GetActor() *Actor {
	if x != nil {
		return x.Actor
	}
	return nil
}

func (x *Action) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (m *Action) GetTime() isAction_Time {
	if m != nil {
		return m.Time
	}
	return nil
}

func (x *Action) GetTimestamp() *timestamppb.Timestamp {
	if x, ok := x.GetTime().(*Action_Timestamp); ok {
		return x.Timestamp
	}
	return nil
}

func (x *Action) GetTimeRange() *TimeRange {
	if x, ok := x.GetTime().(*Action_TimeRange); ok {
		return x.TimeRange
	}
	return nil
}

type isAction_Time interface {
	isAction_Time()
}

type Action_Timestamp struct {
	// The action occurred at this specific time.
	Timestamp *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=timestamp,proto3,oneof"`
}

type Action_TimeRange struct {
	// The action occurred over this time range.
	TimeRange *TimeRange `protobuf:"bytes,6,opt,name=time_range,json=timeRange,proto3,oneof"`
}

func (*Action_Timestamp) isAction_Time() {}

func (*Action_TimeRange) isAction_Time() {}

// Data describing the type and additional information of an action.
type ActionDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data describing the type and additional information of an action.
	//
	// Types that are assignable to ActionDetail:
	//	*ActionDetail_Create
	//	*ActionDetail_Edit
	//	*ActionDetail_Move
	//	*ActionDetail_Rename
	//	*ActionDetail_Delete
	//	*ActionDetail_Restore
	//	*ActionDetail_PermissionChange
	//	*ActionDetail_Comment
	//	*ActionDetail_DlpChange
	//	*ActionDetail_Reference
	//	*ActionDetail_SettingsChange
	ActionDetail isActionDetail_ActionDetail `protobuf_oneof:"action_detail"`
}

func (x *ActionDetail) Reset() {
	*x = ActionDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionDetail) ProtoMessage() {}

func (x *ActionDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionDetail.ProtoReflect.Descriptor instead.
func (*ActionDetail) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{1}
}

func (m *ActionDetail) GetActionDetail() isActionDetail_ActionDetail {
	if m != nil {
		return m.ActionDetail
	}
	return nil
}

func (x *ActionDetail) GetCreate() *Create {
	if x, ok := x.GetActionDetail().(*ActionDetail_Create); ok {
		return x.Create
	}
	return nil
}

func (x *ActionDetail) GetEdit() *Edit {
	if x, ok := x.GetActionDetail().(*ActionDetail_Edit); ok {
		return x.Edit
	}
	return nil
}

func (x *ActionDetail) GetMove() *Move {
	if x, ok := x.GetActionDetail().(*ActionDetail_Move); ok {
		return x.Move
	}
	return nil
}

func (x *ActionDetail) GetRename() *Rename {
	if x, ok := x.GetActionDetail().(*ActionDetail_Rename); ok {
		return x.Rename
	}
	return nil
}

func (x *ActionDetail) GetDelete() *Delete {
	if x, ok := x.GetActionDetail().(*ActionDetail_Delete); ok {
		return x.Delete
	}
	return nil
}

func (x *ActionDetail) GetRestore() *Restore {
	if x, ok := x.GetActionDetail().(*ActionDetail_Restore); ok {
		return x.Restore
	}
	return nil
}

func (x *ActionDetail) GetPermissionChange() *PermissionChange {
	if x, ok := x.GetActionDetail().(*ActionDetail_PermissionChange); ok {
		return x.PermissionChange
	}
	return nil
}

func (x *ActionDetail) GetComment() *Comment {
	if x, ok := x.GetActionDetail().(*ActionDetail_Comment); ok {
		return x.Comment
	}
	return nil
}

func (x *ActionDetail) GetDlpChange() *DataLeakPreventionChange {
	if x, ok := x.GetActionDetail().(*ActionDetail_DlpChange); ok {
		return x.DlpChange
	}
	return nil
}

func (x *ActionDetail) GetReference() *ApplicationReference {
	if x, ok := x.GetActionDetail().(*ActionDetail_Reference); ok {
		return x.Reference
	}
	return nil
}

func (x *ActionDetail) GetSettingsChange() *SettingsChange {
	if x, ok := x.GetActionDetail().(*ActionDetail_SettingsChange); ok {
		return x.SettingsChange
	}
	return nil
}

type isActionDetail_ActionDetail interface {
	isActionDetail_ActionDetail()
}

type ActionDetail_Create struct {
	// An object was created.
	Create *Create `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type ActionDetail_Edit struct {
	// An object was edited.
	Edit *Edit `protobuf:"bytes,2,opt,name=edit,proto3,oneof"`
}

type ActionDetail_Move struct {
	// An object was moved.
	Move *Move `protobuf:"bytes,3,opt,name=move,proto3,oneof"`
}

type ActionDetail_Rename struct {
	// An object was renamed.
	Rename *Rename `protobuf:"bytes,4,opt,name=rename,proto3,oneof"`
}

type ActionDetail_Delete struct {
	// An object was deleted.
	Delete *Delete `protobuf:"bytes,5,opt,name=delete,proto3,oneof"`
}

type ActionDetail_Restore struct {
	// A deleted object was restored.
	Restore *Restore `protobuf:"bytes,6,opt,name=restore,proto3,oneof"`
}

type ActionDetail_PermissionChange struct {
	// The permission on an object was changed.
	PermissionChange *PermissionChange `protobuf:"bytes,7,opt,name=permission_change,json=permissionChange,proto3,oneof"`
}

type ActionDetail_Comment struct {
	// A change about comments was made.
	Comment *Comment `protobuf:"bytes,8,opt,name=comment,proto3,oneof"`
}

type ActionDetail_DlpChange struct {
	// A change happened in data leak prevention status.
	DlpChange *DataLeakPreventionChange `protobuf:"bytes,9,opt,name=dlp_change,json=dlpChange,proto3,oneof"`
}

type ActionDetail_Reference struct {
	// An object was referenced in an application outside of Drive/Docs.
	Reference *ApplicationReference `protobuf:"bytes,12,opt,name=reference,proto3,oneof"`
}

type ActionDetail_SettingsChange struct {
	// Settings were changed.
	SettingsChange *SettingsChange `protobuf:"bytes,13,opt,name=settings_change,json=settingsChange,proto3,oneof"`
}

func (*ActionDetail_Create) isActionDetail_ActionDetail() {}

func (*ActionDetail_Edit) isActionDetail_ActionDetail() {}

func (*ActionDetail_Move) isActionDetail_ActionDetail() {}

func (*ActionDetail_Rename) isActionDetail_ActionDetail() {}

func (*ActionDetail_Delete) isActionDetail_ActionDetail() {}

func (*ActionDetail_Restore) isActionDetail_ActionDetail() {}

func (*ActionDetail_PermissionChange) isActionDetail_ActionDetail() {}

func (*ActionDetail_Comment) isActionDetail_ActionDetail() {}

func (*ActionDetail_DlpChange) isActionDetail_ActionDetail() {}

func (*ActionDetail_Reference) isActionDetail_ActionDetail() {}

func (*ActionDetail_SettingsChange) isActionDetail_ActionDetail() {}

// An object was created.
type Create struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The origin of the new object.
	//
	// Types that are assignable to Origin:
	//	*Create_New_
	//	*Create_Upload_
	//	*Create_Copy_
	Origin isCreate_Origin `protobuf_oneof:"origin"`
}

func (x *Create) Reset() {
	*x = Create{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Create) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Create) ProtoMessage() {}

func (x *Create) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Create.ProtoReflect.Descriptor instead.
func (*Create) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{2}
}

func (m *Create) GetOrigin() isCreate_Origin {
	if m != nil {
		return m.Origin
	}
	return nil
}

func (x *Create) GetNew() *Create_New {
	if x, ok := x.GetOrigin().(*Create_New_); ok {
		return x.New
	}
	return nil
}

func (x *Create) GetUpload() *Create_Upload {
	if x, ok := x.GetOrigin().(*Create_Upload_); ok {
		return x.Upload
	}
	return nil
}

func (x *Create) GetCopy() *Create_Copy {
	if x, ok := x.GetOrigin().(*Create_Copy_); ok {
		return x.Copy
	}
	return nil
}

type isCreate_Origin interface {
	isCreate_Origin()
}

type Create_New_ struct {
	// If present, indicates the object was newly created (e.g. as a blank
	// document), not derived from a Drive object or external object.
	New *Create_New `protobuf:"bytes,1,opt,name=new,proto3,oneof"`
}

type Create_Upload_ struct {
	// If present, indicates the object originated externally and was uploaded
	// to Drive.
	Upload *Create_Upload `protobuf:"bytes,2,opt,name=upload,proto3,oneof"`
}

type Create_Copy_ struct {
	// If present, indicates the object was created by copying an existing Drive
	// object.
	Copy *Create_Copy `protobuf:"bytes,3,opt,name=copy,proto3,oneof"`
}

func (*Create_New_) isCreate_Origin() {}

func (*Create_Upload_) isCreate_Origin() {}

func (*Create_Copy_) isCreate_Origin() {}

// An empty message indicating an object was edited.
type Edit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Edit) Reset() {
	*x = Edit{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Edit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Edit) ProtoMessage() {}

func (x *Edit) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Edit.ProtoReflect.Descriptor instead.
func (*Edit) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{3}
}

// An object was moved.
type Move struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The added parent object(s).
	AddedParents []*TargetReference `protobuf:"bytes,1,rep,name=added_parents,json=addedParents,proto3" json:"added_parents,omitempty"`
	// The removed parent object(s).
	RemovedParents []*TargetReference `protobuf:"bytes,2,rep,name=removed_parents,json=removedParents,proto3" json:"removed_parents,omitempty"`
}

func (x *Move) Reset() {
	*x = Move{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Move) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Move) ProtoMessage() {}

func (x *Move) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Move.ProtoReflect.Descriptor instead.
func (*Move) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{4}
}

func (x *Move) GetAddedParents() []*TargetReference {
	if x != nil {
		return x.AddedParents
	}
	return nil
}

func (x *Move) GetRemovedParents() []*TargetReference {
	if x != nil {
		return x.RemovedParents
	}
	return nil
}

// An object was renamed.
type Rename struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The previous title of the drive object.
	OldTitle string `protobuf:"bytes,1,opt,name=old_title,json=oldTitle,proto3" json:"old_title,omitempty"`
	// The new title of the drive object.
	NewTitle string `protobuf:"bytes,2,opt,name=new_title,json=newTitle,proto3" json:"new_title,omitempty"`
}

func (x *Rename) Reset() {
	*x = Rename{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rename) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rename) ProtoMessage() {}

func (x *Rename) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rename.ProtoReflect.Descriptor instead.
func (*Rename) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{5}
}

func (x *Rename) GetOldTitle() string {
	if x != nil {
		return x.OldTitle
	}
	return ""
}

func (x *Rename) GetNewTitle() string {
	if x != nil {
		return x.NewTitle
	}
	return ""
}

// An object was deleted.
type Delete struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of delete action taken.
	Type Delete_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.apps.drive.activity.v2.Delete_Type" json:"type,omitempty"`
}

func (x *Delete) Reset() {
	*x = Delete{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Delete) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Delete) ProtoMessage() {}

func (x *Delete) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Delete.ProtoReflect.Descriptor instead.
func (*Delete) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{6}
}

func (x *Delete) GetType() Delete_Type {
	if x != nil {
		return x.Type
	}
	return Delete_TYPE_UNSPECIFIED
}

// A deleted object was restored.
type Restore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of restore action taken.
	Type Restore_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.apps.drive.activity.v2.Restore_Type" json:"type,omitempty"`
}

func (x *Restore) Reset() {
	*x = Restore{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Restore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Restore) ProtoMessage() {}

func (x *Restore) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Restore.ProtoReflect.Descriptor instead.
func (*Restore) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{7}
}

func (x *Restore) GetType() Restore_Type {
	if x != nil {
		return x.Type
	}
	return Restore_TYPE_UNSPECIFIED
}

// A change of the permission setting on an item.
type PermissionChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of permissions added by this change.
	AddedPermissions []*Permission `protobuf:"bytes,1,rep,name=added_permissions,json=addedPermissions,proto3" json:"added_permissions,omitempty"`
	// The set of permissions removed by this change.
	RemovedPermissions []*Permission `protobuf:"bytes,2,rep,name=removed_permissions,json=removedPermissions,proto3" json:"removed_permissions,omitempty"`
}

func (x *PermissionChange) Reset() {
	*x = PermissionChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PermissionChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PermissionChange) ProtoMessage() {}

func (x *PermissionChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PermissionChange.ProtoReflect.Descriptor instead.
func (*PermissionChange) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{8}
}

func (x *PermissionChange) GetAddedPermissions() []*Permission {
	if x != nil {
		return x.AddedPermissions
	}
	return nil
}

func (x *PermissionChange) GetRemovedPermissions() []*Permission {
	if x != nil {
		return x.RemovedPermissions
	}
	return nil
}

// The permission setting of an object.
type Permission struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates the
	// [Google Drive permissions
	// role](https://developers.google.com/drive/web/manage-sharing#roles). The
	// role determines a user's ability to read, write, and comment on items.
	Role Permission_Role `protobuf:"varint,1,opt,name=role,proto3,enum=google.apps.drive.activity.v2.Permission_Role" json:"role,omitempty"`
	// The entity granted the role.
	//
	// Types that are assignable to Scope:
	//	*Permission_User
	//	*Permission_Group
	//	*Permission_Domain
	//	*Permission_Anyone_
	Scope isPermission_Scope `protobuf_oneof:"scope"`
	// If true, the item can be discovered (e.g. in the user's "Shared with me"
	// collection) without needing a link to the item.
	AllowDiscovery bool `protobuf:"varint,6,opt,name=allow_discovery,json=allowDiscovery,proto3" json:"allow_discovery,omitempty"`
}

func (x *Permission) Reset() {
	*x = Permission{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Permission) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Permission) ProtoMessage() {}

func (x *Permission) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Permission.ProtoReflect.Descriptor instead.
func (*Permission) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{9}
}

func (x *Permission) GetRole() Permission_Role {
	if x != nil {
		return x.Role
	}
	return Permission_ROLE_UNSPECIFIED
}

func (m *Permission) GetScope() isPermission_Scope {
	if m != nil {
		return m.Scope
	}
	return nil
}

func (x *Permission) GetUser() *User {
	if x, ok := x.GetScope().(*Permission_User); ok {
		return x.User
	}
	return nil
}

func (x *Permission) GetGroup() *Group {
	if x, ok := x.GetScope().(*Permission_Group); ok {
		return x.Group
	}
	return nil
}

func (x *Permission) GetDomain() *Domain {
	if x, ok := x.GetScope().(*Permission_Domain); ok {
		return x.Domain
	}
	return nil
}

func (x *Permission) GetAnyone() *Permission_Anyone {
	if x, ok := x.GetScope().(*Permission_Anyone_); ok {
		return x.Anyone
	}
	return nil
}

func (x *Permission) GetAllowDiscovery() bool {
	if x != nil {
		return x.AllowDiscovery
	}
	return false
}

type isPermission_Scope interface {
	isPermission_Scope()
}

type Permission_User struct {
	// The user to whom this permission applies.
	User *User `protobuf:"bytes,2,opt,name=user,proto3,oneof"`
}

type Permission_Group struct {
	// The group to whom this permission applies.
	Group *Group `protobuf:"bytes,3,opt,name=group,proto3,oneof"`
}

type Permission_Domain struct {
	// The domain to whom this permission applies.
	Domain *Domain `protobuf:"bytes,4,opt,name=domain,proto3,oneof"`
}

type Permission_Anyone_ struct {
	// If set, this permission applies to anyone, even logged out users.
	Anyone *Permission_Anyone `protobuf:"bytes,5,opt,name=anyone,proto3,oneof"`
}

func (*Permission_User) isPermission_Scope() {}

func (*Permission_Group) isPermission_Scope() {}

func (*Permission_Domain) isPermission_Scope() {}

func (*Permission_Anyone_) isPermission_Scope() {}

// A change about comments on an object.
type Comment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of changed comment.
	//
	// Types that are assignable to Type:
	//	*Comment_Post_
	//	*Comment_Assignment_
	//	*Comment_Suggestion_
	Type isComment_Type `protobuf_oneof:"type"`
	// Users who are mentioned in this comment.
	MentionedUsers []*User `protobuf:"bytes,7,rep,name=mentioned_users,json=mentionedUsers,proto3" json:"mentioned_users,omitempty"`
}

func (x *Comment) Reset() {
	*x = Comment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Comment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Comment) ProtoMessage() {}

func (x *Comment) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Comment.ProtoReflect.Descriptor instead.
func (*Comment) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{10}
}

func (m *Comment) GetType() isComment_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *Comment) GetPost() *Comment_Post {
	if x, ok := x.GetType().(*Comment_Post_); ok {
		return x.Post
	}
	return nil
}

func (x *Comment) GetAssignment() *Comment_Assignment {
	if x, ok := x.GetType().(*Comment_Assignment_); ok {
		return x.Assignment
	}
	return nil
}

func (x *Comment) GetSuggestion() *Comment_Suggestion {
	if x, ok := x.GetType().(*Comment_Suggestion_); ok {
		return x.Suggestion
	}
	return nil
}

func (x *Comment) GetMentionedUsers() []*User {
	if x != nil {
		return x.MentionedUsers
	}
	return nil
}

type isComment_Type interface {
	isComment_Type()
}

type Comment_Post_ struct {
	// A change on a regular posted comment.
	Post *Comment_Post `protobuf:"bytes,1,opt,name=post,proto3,oneof"`
}

type Comment_Assignment_ struct {
	// A change on an assignment.
	Assignment *Comment_Assignment `protobuf:"bytes,2,opt,name=assignment,proto3,oneof"`
}

type Comment_Suggestion_ struct {
	// A change on a suggestion.
	Suggestion *Comment_Suggestion `protobuf:"bytes,3,opt,name=suggestion,proto3,oneof"`
}

func (*Comment_Post_) isComment_Type() {}

func (*Comment_Assignment_) isComment_Type() {}

func (*Comment_Suggestion_) isComment_Type() {}

// A change in the object's data leak prevention status.
type DataLeakPreventionChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of Data Leak Prevention (DLP) change.
	Type DataLeakPreventionChange_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.apps.drive.activity.v2.DataLeakPreventionChange_Type" json:"type,omitempty"`
}

func (x *DataLeakPreventionChange) Reset() {
	*x = DataLeakPreventionChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataLeakPreventionChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataLeakPreventionChange) ProtoMessage() {}

func (x *DataLeakPreventionChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataLeakPreventionChange.ProtoReflect.Descriptor instead.
func (*DataLeakPreventionChange) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{11}
}

func (x *DataLeakPreventionChange) GetType() DataLeakPreventionChange_Type {
	if x != nil {
		return x.Type
	}
	return DataLeakPreventionChange_TYPE_UNSPECIFIED
}

// Activity in applications other than Drive.
type ApplicationReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The reference type corresponding to this event.
	Type ApplicationReference_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.apps.drive.activity.v2.ApplicationReference_Type" json:"type,omitempty"`
}

func (x *ApplicationReference) Reset() {
	*x = ApplicationReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationReference) ProtoMessage() {}

func (x *ApplicationReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationReference.ProtoReflect.Descriptor instead.
func (*ApplicationReference) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{12}
}

func (x *ApplicationReference) GetType() ApplicationReference_Type {
	if x != nil {
		return x.Type
	}
	return ApplicationReference_UNSPECIFIED_REFERENCE_TYPE
}

// Information about settings changes.
type SettingsChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of changes made to restrictions.
	RestrictionChanges []*SettingsChange_RestrictionChange `protobuf:"bytes,1,rep,name=restriction_changes,json=restrictionChanges,proto3" json:"restriction_changes,omitempty"`
}

func (x *SettingsChange) Reset() {
	*x = SettingsChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SettingsChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SettingsChange) ProtoMessage() {}

func (x *SettingsChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SettingsChange.ProtoReflect.Descriptor instead.
func (*SettingsChange) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{13}
}

func (x *SettingsChange) GetRestrictionChanges() []*SettingsChange_RestrictionChange {
	if x != nil {
		return x.RestrictionChanges
	}
	return nil
}

// An object was created from scratch.
type Create_New struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Create_New) Reset() {
	*x = Create_New{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Create_New) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Create_New) ProtoMessage() {}

func (x *Create_New) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Create_New.ProtoReflect.Descriptor instead.
func (*Create_New) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{2, 0}
}

// An object was uploaded into Drive.
type Create_Upload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Create_Upload) Reset() {
	*x = Create_Upload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Create_Upload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Create_Upload) ProtoMessage() {}

func (x *Create_Upload) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Create_Upload.ProtoReflect.Descriptor instead.
func (*Create_Upload) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{2, 1}
}

// An object was created by copying an existing object.
type Create_Copy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The original object.
	OriginalObject *TargetReference `protobuf:"bytes,1,opt,name=original_object,json=originalObject,proto3" json:"original_object,omitempty"`
}

func (x *Create_Copy) Reset() {
	*x = Create_Copy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Create_Copy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Create_Copy) ProtoMessage() {}

func (x *Create_Copy) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Create_Copy.ProtoReflect.Descriptor instead.
func (*Create_Copy) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{2, 2}
}

func (x *Create_Copy) GetOriginalObject() *TargetReference {
	if x != nil {
		return x.OriginalObject
	}
	return nil
}

// Represents any user (including a logged out user).
type Permission_Anyone struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Permission_Anyone) Reset() {
	*x = Permission_Anyone{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Permission_Anyone) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Permission_Anyone) ProtoMessage() {}

func (x *Permission_Anyone) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Permission_Anyone.ProtoReflect.Descriptor instead.
func (*Permission_Anyone) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{9, 0}
}

// A regular posted comment.
type Comment_Post struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The sub-type of this event.
	Subtype Comment_Post_Subtype `protobuf:"varint,1,opt,name=subtype,proto3,enum=google.apps.drive.activity.v2.Comment_Post_Subtype" json:"subtype,omitempty"`
}

func (x *Comment_Post) Reset() {
	*x = Comment_Post{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Comment_Post) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Comment_Post) ProtoMessage() {}

func (x *Comment_Post) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Comment_Post.ProtoReflect.Descriptor instead.
func (*Comment_Post) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{10, 0}
}

func (x *Comment_Post) GetSubtype() Comment_Post_Subtype {
	if x != nil {
		return x.Subtype
	}
	return Comment_Post_SUBTYPE_UNSPECIFIED
}

// A comment with an assignment.
type Comment_Assignment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The sub-type of this event.
	Subtype Comment_Assignment_Subtype `protobuf:"varint,1,opt,name=subtype,proto3,enum=google.apps.drive.activity.v2.Comment_Assignment_Subtype" json:"subtype,omitempty"`
	// The user to whom the comment was assigned.
	AssignedUser *User `protobuf:"bytes,7,opt,name=assigned_user,json=assignedUser,proto3" json:"assigned_user,omitempty"`
}

func (x *Comment_Assignment) Reset() {
	*x = Comment_Assignment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Comment_Assignment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Comment_Assignment) ProtoMessage() {}

func (x *Comment_Assignment) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Comment_Assignment.ProtoReflect.Descriptor instead.
func (*Comment_Assignment) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{10, 1}
}

func (x *Comment_Assignment) GetSubtype() Comment_Assignment_Subtype {
	if x != nil {
		return x.Subtype
	}
	return Comment_Assignment_SUBTYPE_UNSPECIFIED
}

func (x *Comment_Assignment) GetAssignedUser() *User {
	if x != nil {
		return x.AssignedUser
	}
	return nil
}

// A suggestion.
type Comment_Suggestion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The sub-type of this event.
	Subtype Comment_Suggestion_Subtype `protobuf:"varint,1,opt,name=subtype,proto3,enum=google.apps.drive.activity.v2.Comment_Suggestion_Subtype" json:"subtype,omitempty"`
}

func (x *Comment_Suggestion) Reset() {
	*x = Comment_Suggestion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Comment_Suggestion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Comment_Suggestion) ProtoMessage() {}

func (x *Comment_Suggestion) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Comment_Suggestion.ProtoReflect.Descriptor instead.
func (*Comment_Suggestion) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{10, 2}
}

func (x *Comment_Suggestion) GetSubtype() Comment_Suggestion_Subtype {
	if x != nil {
		return x.Subtype
	}
	return Comment_Suggestion_SUBTYPE_UNSPECIFIED
}

// Information about restriction policy changes to a feature.
type SettingsChange_RestrictionChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The feature which had a change in restriction policy.
	Feature SettingsChange_RestrictionChange_Feature `protobuf:"varint,1,opt,name=feature,proto3,enum=google.apps.drive.activity.v2.SettingsChange_RestrictionChange_Feature" json:"feature,omitempty"`
	// The restriction in place after the change.
	NewRestriction SettingsChange_RestrictionChange_Restriction `protobuf:"varint,2,opt,name=new_restriction,json=newRestriction,proto3,enum=google.apps.drive.activity.v2.SettingsChange_RestrictionChange_Restriction" json:"new_restriction,omitempty"`
}

func (x *SettingsChange_RestrictionChange) Reset() {
	*x = SettingsChange_RestrictionChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SettingsChange_RestrictionChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SettingsChange_RestrictionChange) ProtoMessage() {}

func (x *SettingsChange_RestrictionChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_action_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SettingsChange_RestrictionChange.ProtoReflect.Descriptor instead.
func (*SettingsChange_RestrictionChange) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_action_proto_rawDescGZIP(), []int{13, 0}
}

func (x *SettingsChange_RestrictionChange) GetFeature() SettingsChange_RestrictionChange_Feature {
	if x != nil {
		return x.Feature
	}
	return SettingsChange_RestrictionChange_FEATURE_UNSPECIFIED
}

func (x *SettingsChange_RestrictionChange) GetNewRestriction() SettingsChange_RestrictionChange_Restriction {
	if x != nil {
		return x.NewRestriction
	}
	return SettingsChange_RestrictionChange_RESTRICTION_UNSPECIFIED
}

var File_google_apps_drive_activity_v2_action_proto protoreflect.FileDescriptor

var file_google_apps_drive_activity_v2_action_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2f, 0x76, 0x32, 0x2f,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x1a, 0x29, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2f, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x63, 0x74, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x70, 0x73, 0x2f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2f, 0x76,
	0x32, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xd7, 0x02, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x06, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12,
	0x3a, 0x0a, 0x05, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69,
	0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x41,
	0x63, 0x74, 0x6f, 0x72, 0x52, 0x05, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x3d, 0x0a, 0x06, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x3a, 0x0a, 0x09, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00, 0x52, 0x09, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x49, 0x0a, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x72,
	0x61, 0x6e, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xc9, 0x06, 0x0a, 0x0c, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x3f, 0x0a, 0x06, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x48, 0x00, 0x52, 0x06, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x12, 0x39, 0x0a, 0x04, 0x65,
	0x64, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x64, 0x69, 0x74, 0x48, 0x00,
	0x52, 0x04, 0x65, 0x64, 0x69, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6d, 0x6f, 0x76, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x76, 0x65, 0x48, 0x00, 0x52, 0x04, 0x6d, 0x6f, 0x76,
	0x65, 0x12, 0x3f, 0x0a, 0x06, 0x72, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76,
	0x32, 0x2e, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x48, 0x00, 0x52, 0x06, 0x72, 0x65, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x06, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x48, 0x00, 0x52, 0x06, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x12, 0x42, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x48, 0x00, 0x52, 0x07,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x5e, 0x0a, 0x11, 0x70, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x32, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x10, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x42, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74,
	0x48, 0x00, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x58, 0x0a, 0x0a, 0x64,
	0x6c, 0x70, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x4c, 0x65, 0x61, 0x6b, 0x50, 0x72, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x09, 0x64, 0x6c, 0x70, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x53, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52,
	0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x58, 0x0a, 0x0f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x22, 0xcd, 0x02, 0x0a, 0x06, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x12, 0x3d, 0x0a, 0x03, 0x6e, 0x65, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76,
	0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x2e, 0x4e, 0x65, 0x77, 0x48, 0x00, 0x52, 0x03, 0x6e, 0x65, 0x77, 0x12,
	0x46, 0x0a, 0x06, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52,
	0x06, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x40, 0x0a, 0x04, 0x63, 0x6f, 0x70, 0x79, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x6f, 0x70,
	0x79, 0x48, 0x00, 0x52, 0x04, 0x63, 0x6f, 0x70, 0x79, 0x1a, 0x05, 0x0a, 0x03, 0x4e, 0x65, 0x77,
	0x1a, 0x08, 0x0a, 0x06, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x1a, 0x5f, 0x0a, 0x04, 0x43, 0x6f,
	0x70, 0x79, 0x12, 0x57, 0x0a, 0x0f, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x6f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0e, 0x6f, 0x72, 0x69,
	0x67, 0x69, 0x6e, 0x61, 0x6c, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x42, 0x08, 0x0a, 0x06, 0x6f,
	0x72, 0x69, 0x67, 0x69, 0x6e, 0x22, 0x06, 0x0a, 0x04, 0x45, 0x64, 0x69, 0x74, 0x22, 0xb4, 0x01,
	0x0a, 0x04, 0x4d, 0x6f, 0x76, 0x65, 0x12, 0x53, 0x0a, 0x0d, 0x61, 0x64, 0x64, 0x65, 0x64, 0x5f,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76,
	0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0c, 0x61,
	0x64, 0x64, 0x65, 0x64, 0x50, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x57, 0x0a, 0x0f, 0x72,
	0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x52, 0x0e, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x50, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x73, 0x22, 0x42, 0x0a, 0x06, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b,
	0x0a, 0x09, 0x6f, 0x6c, 0x64, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x6f, 0x6c, 0x64, 0x54, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6e,
	0x65, 0x77, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x6e, 0x65, 0x77, 0x54, 0x69, 0x74, 0x6c, 0x65, 0x22, 0x87, 0x01, 0x0a, 0x06, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x12, 0x3e, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76,
	0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x22, 0x3d, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x52, 0x41, 0x53, 0x48, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10,
	0x50, 0x45, 0x52, 0x4d, 0x41, 0x4e, 0x45, 0x4e, 0x54, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45,
	0x10, 0x02, 0x22, 0x75, 0x0a, 0x07, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x3f, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x29,
	0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x55, 0x4e, 0x54, 0x52, 0x41, 0x53, 0x48, 0x10, 0x01, 0x22, 0xc6, 0x01, 0x0a, 0x10, 0x50, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x56,
	0x0a, 0x11, 0x61, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x61, 0x64, 0x64, 0x65, 0x64, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5a, 0x0a, 0x13, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65,
	0x64, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x2e, 0x76, 0x32, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x12,
	0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x22, 0x9c, 0x04, 0x0a, 0x0a, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x42, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x52,
	0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x39, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x2e, 0x76, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x48, 0x00, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72,
	0x12, 0x3c, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x48, 0x00, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x3f,
	0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69,
	0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x48, 0x00, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12,
	0x4a, 0x0a, 0x06, 0x61, 0x6e, 0x79, 0x6f, 0x6e, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x6e, 0x79, 0x6f, 0x6e,
	0x65, 0x48, 0x00, 0x52, 0x06, 0x61, 0x6e, 0x79, 0x6f, 0x6e, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x44, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x1a, 0x08, 0x0a, 0x06, 0x41, 0x6e, 0x79, 0x6f, 0x6e, 0x65, 0x22, 0x87,
	0x01, 0x0a, 0x04, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x4f, 0x4c, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a,
	0x05, 0x4f, 0x57, 0x4e, 0x45, 0x52, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x4f, 0x52, 0x47, 0x41,
	0x4e, 0x49, 0x5a, 0x45, 0x52, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x46, 0x49, 0x4c, 0x45, 0x5f,
	0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x45, 0x52, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x45,
	0x44, 0x49, 0x54, 0x4f, 0x52, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4f, 0x4d, 0x4d, 0x45,
	0x4e, 0x54, 0x45, 0x52, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x56, 0x49, 0x45, 0x57, 0x45, 0x52,
	0x10, 0x06, 0x12, 0x14, 0x0a, 0x10, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x45, 0x44, 0x5f,
	0x56, 0x49, 0x45, 0x57, 0x45, 0x52, 0x10, 0x07, 0x42, 0x07, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70,
	0x65, 0x22, 0xe4, 0x08, 0x0a, 0x07, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x41, 0x0a,
	0x04, 0x70, 0x6f, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x48, 0x00, 0x52, 0x04, 0x70, 0x6f, 0x73, 0x74,
	0x12, 0x53, 0x0a, 0x0a, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x53, 0x0a, 0x0a, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0a,
	0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4c, 0x0a, 0x0f, 0x6d, 0x65,
	0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x73, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x2e, 0x76, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x52, 0x0e, 0x6d, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x73, 0x1a, 0xd1, 0x01, 0x0a, 0x04, 0x50, 0x6f, 0x73,
	0x74, 0x12, 0x4d, 0x0a, 0x07, 0x73, 0x75, 0x62, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x2e,
	0x53, 0x75, 0x62, 0x74, 0x79, 0x70, 0x65, 0x52, 0x07, 0x73, 0x75, 0x62, 0x74, 0x79, 0x70, 0x65,
	0x22, 0x7a, 0x0a, 0x07, 0x53, 0x75, 0x62, 0x74, 0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x13, 0x53,
	0x55, 0x42, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x44, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b,
	0x52, 0x45, 0x50, 0x4c, 0x59, 0x5f, 0x41, 0x44, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x11, 0x0a,
	0x0d, 0x52, 0x45, 0x50, 0x4c, 0x59, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x04,
	0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x56, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0c,
	0x0a, 0x08, 0x52, 0x45, 0x4f, 0x50, 0x45, 0x4e, 0x45, 0x44, 0x10, 0x06, 0x1a, 0xb8, 0x02, 0x0a,
	0x0a, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x53, 0x0a, 0x07, 0x73,
	0x75, 0x62, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65,
	0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x53, 0x75, 0x62, 0x74, 0x79, 0x70, 0x65, 0x52, 0x07, 0x73, 0x75, 0x62, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x48, 0x0a, 0x0d, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f, 0x75, 0x73, 0x65,
	0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x52, 0x0c, 0x61, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x22, 0x8a, 0x01, 0x0a, 0x07, 0x53,
	0x75, 0x62, 0x74, 0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x55, 0x42, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x09, 0x0a, 0x05, 0x41, 0x44, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x50, 0x4c, 0x59,
	0x5f, 0x41, 0x44, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x45, 0x50, 0x4c,
	0x59, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x52,
	0x45, 0x53, 0x4f, 0x4c, 0x56, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x4f,
	0x50, 0x45, 0x4e, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x41, 0x53, 0x53,
	0x49, 0x47, 0x4e, 0x45, 0x44, 0x10, 0x07, 0x1a, 0x86, 0x02, 0x0a, 0x0a, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x07, 0x73, 0x75, 0x62, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x75, 0x62, 0x74, 0x79,
	0x70, 0x65, 0x52, 0x07, 0x73, 0x75, 0x62, 0x74, 0x79, 0x70, 0x65, 0x22, 0xa2, 0x01, 0x0a, 0x07,
	0x53, 0x75, 0x62, 0x74, 0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x55, 0x42, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x09, 0x0a, 0x05, 0x41, 0x44, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x44,
	0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x50, 0x4c,
	0x59, 0x5f, 0x41, 0x44, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x45, 0x50,
	0x4c, 0x59, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08,
	0x41, 0x43, 0x43, 0x45, 0x50, 0x54, 0x45, 0x44, 0x10, 0x07, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45,
	0x4a, 0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x08, 0x12, 0x12, 0x0a, 0x0e, 0x41, 0x43, 0x43, 0x45,
	0x50, 0x54, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x09, 0x12, 0x12, 0x0a, 0x0e,
	0x52, 0x45, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x0a,
	0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0xa4, 0x01, 0x0a, 0x18, 0x44, 0x61, 0x74,
	0x61, 0x4c, 0x65, 0x61, 0x6b, 0x50, 0x72, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x50, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x65, 0x61, 0x6b, 0x50, 0x72, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x36, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x4c, 0x41, 0x47, 0x47, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x4c, 0x45, 0x41, 0x52, 0x45, 0x44, 0x10, 0x02, 0x22,
	0xa3, 0x01, 0x0a, 0x14, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x4c, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x3d, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e,
	0x0a, 0x1a, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x5f, 0x52, 0x45,
	0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x00, 0x12, 0x08,
	0x0a, 0x04, 0x4c, 0x49, 0x4e, 0x4b, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x49, 0x53, 0x43,
	0x55, 0x53, 0x53, 0x10, 0x02, 0x22, 0xc6, 0x04, 0x0a, 0x0e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x70, 0x0a, 0x13, 0x72, 0x65, 0x73, 0x74,
	0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x12, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x1a, 0xc1, 0x03, 0x0a, 0x11, 0x52,
	0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x61, 0x0a, 0x07, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x2e, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x07, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x12, 0x74, 0x0a, 0x0f, 0x6e, 0x65, 0x77, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x72,
	0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65,
	0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x74,
	0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x52, 0x65,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x6e, 0x65, 0x77, 0x52, 0x65,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7f, 0x0a, 0x07, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x12, 0x17, 0x0a, 0x13, 0x46, 0x45, 0x41, 0x54, 0x55, 0x52, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a,
	0x16, 0x53, 0x48, 0x41, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x4f, 0x55, 0x54, 0x53, 0x49, 0x44, 0x45,
	0x5f, 0x44, 0x4f, 0x4d, 0x41, 0x49, 0x4e, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x49, 0x52,
	0x45, 0x43, 0x54, 0x5f, 0x53, 0x48, 0x41, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x14, 0x0a,
	0x10, 0x49, 0x54, 0x45, 0x4d, 0x5f, 0x44, 0x55, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x03, 0x12, 0x15, 0x0a, 0x11, 0x44, 0x52, 0x49, 0x56, 0x45, 0x5f, 0x46, 0x49, 0x4c,
	0x45, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x10, 0x04, 0x22, 0x52, 0x0a, 0x0b, 0x52, 0x65,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x17, 0x52, 0x45, 0x53,
	0x54, 0x52, 0x49, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x55, 0x4e, 0x52, 0x45, 0x53, 0x54,
	0x52, 0x49, 0x43, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x46, 0x55, 0x4c, 0x4c,
	0x59, 0x5f, 0x52, 0x45, 0x53, 0x54, 0x52, 0x49, 0x43, 0x54, 0x45, 0x44, 0x10, 0x02, 0x42, 0xc0,
	0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x76, 0x32, 0x42, 0x0b, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2f, 0x76,
	0x32, 0x3b, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0xa2, 0x02, 0x04, 0x47, 0x41, 0x44,
	0x41, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x70, 0x70, 0x73, 0x2e,
	0x44, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x56,
	0x32, 0xca, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x70, 0x70, 0x73, 0x5c,
	0x44, 0x72, 0x69, 0x76, 0x65, 0x5c, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x5c, 0x56,
	0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_apps_drive_activity_v2_action_proto_rawDescOnce sync.Once
	file_google_apps_drive_activity_v2_action_proto_rawDescData = file_google_apps_drive_activity_v2_action_proto_rawDesc
)

func file_google_apps_drive_activity_v2_action_proto_rawDescGZIP() []byte {
	file_google_apps_drive_activity_v2_action_proto_rawDescOnce.Do(func() {
		file_google_apps_drive_activity_v2_action_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_apps_drive_activity_v2_action_proto_rawDescData)
	})
	return file_google_apps_drive_activity_v2_action_proto_rawDescData
}

var file_google_apps_drive_activity_v2_action_proto_enumTypes = make([]protoimpl.EnumInfo, 10)
var file_google_apps_drive_activity_v2_action_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_google_apps_drive_activity_v2_action_proto_goTypes = []interface{}{
	(Delete_Type)(0),                                  // 0: google.apps.drive.activity.v2.Delete.Type
	(Restore_Type)(0),                                 // 1: google.apps.drive.activity.v2.Restore.Type
	(Permission_Role)(0),                              // 2: google.apps.drive.activity.v2.Permission.Role
	(Comment_Post_Subtype)(0),                         // 3: google.apps.drive.activity.v2.Comment.Post.Subtype
	(Comment_Assignment_Subtype)(0),                   // 4: google.apps.drive.activity.v2.Comment.Assignment.Subtype
	(Comment_Suggestion_Subtype)(0),                   // 5: google.apps.drive.activity.v2.Comment.Suggestion.Subtype
	(DataLeakPreventionChange_Type)(0),                // 6: google.apps.drive.activity.v2.DataLeakPreventionChange.Type
	(ApplicationReference_Type)(0),                    // 7: google.apps.drive.activity.v2.ApplicationReference.Type
	(SettingsChange_RestrictionChange_Feature)(0),     // 8: google.apps.drive.activity.v2.SettingsChange.RestrictionChange.Feature
	(SettingsChange_RestrictionChange_Restriction)(0), // 9: google.apps.drive.activity.v2.SettingsChange.RestrictionChange.Restriction
	(*Action)(nil),                                    // 10: google.apps.drive.activity.v2.Action
	(*ActionDetail)(nil),                              // 11: google.apps.drive.activity.v2.ActionDetail
	(*Create)(nil),                                    // 12: google.apps.drive.activity.v2.Create
	(*Edit)(nil),                                      // 13: google.apps.drive.activity.v2.Edit
	(*Move)(nil),                                      // 14: google.apps.drive.activity.v2.Move
	(*Rename)(nil),                                    // 15: google.apps.drive.activity.v2.Rename
	(*Delete)(nil),                                    // 16: google.apps.drive.activity.v2.Delete
	(*Restore)(nil),                                   // 17: google.apps.drive.activity.v2.Restore
	(*PermissionChange)(nil),                          // 18: google.apps.drive.activity.v2.PermissionChange
	(*Permission)(nil),                                // 19: google.apps.drive.activity.v2.Permission
	(*Comment)(nil),                                   // 20: google.apps.drive.activity.v2.Comment
	(*DataLeakPreventionChange)(nil),                  // 21: google.apps.drive.activity.v2.DataLeakPreventionChange
	(*ApplicationReference)(nil),                      // 22: google.apps.drive.activity.v2.ApplicationReference
	(*SettingsChange)(nil),                            // 23: google.apps.drive.activity.v2.SettingsChange
	(*Create_New)(nil),                                // 24: google.apps.drive.activity.v2.Create.New
	(*Create_Upload)(nil),                             // 25: google.apps.drive.activity.v2.Create.Upload
	(*Create_Copy)(nil),                               // 26: google.apps.drive.activity.v2.Create.Copy
	(*Permission_Anyone)(nil),                         // 27: google.apps.drive.activity.v2.Permission.Anyone
	(*Comment_Post)(nil),                              // 28: google.apps.drive.activity.v2.Comment.Post
	(*Comment_Assignment)(nil),                        // 29: google.apps.drive.activity.v2.Comment.Assignment
	(*Comment_Suggestion)(nil),                        // 30: google.apps.drive.activity.v2.Comment.Suggestion
	(*SettingsChange_RestrictionChange)(nil),          // 31: google.apps.drive.activity.v2.SettingsChange.RestrictionChange
	(*Actor)(nil),                                     // 32: google.apps.drive.activity.v2.Actor
	(*Target)(nil),                                    // 33: google.apps.drive.activity.v2.Target
	(*timestamppb.Timestamp)(nil),                     // 34: google.protobuf.Timestamp
	(*TimeRange)(nil),                                 // 35: google.apps.drive.activity.v2.TimeRange
	(*TargetReference)(nil),                           // 36: google.apps.drive.activity.v2.TargetReference
	(*User)(nil),                                      // 37: google.apps.drive.activity.v2.User
	(*Group)(nil),                                     // 38: google.apps.drive.activity.v2.Group
	(*Domain)(nil),                                    // 39: google.apps.drive.activity.v2.Domain
}
var file_google_apps_drive_activity_v2_action_proto_depIdxs = []int32{
	11, // 0: google.apps.drive.activity.v2.Action.detail:type_name -> google.apps.drive.activity.v2.ActionDetail
	32, // 1: google.apps.drive.activity.v2.Action.actor:type_name -> google.apps.drive.activity.v2.Actor
	33, // 2: google.apps.drive.activity.v2.Action.target:type_name -> google.apps.drive.activity.v2.Target
	34, // 3: google.apps.drive.activity.v2.Action.timestamp:type_name -> google.protobuf.Timestamp
	35, // 4: google.apps.drive.activity.v2.Action.time_range:type_name -> google.apps.drive.activity.v2.TimeRange
	12, // 5: google.apps.drive.activity.v2.ActionDetail.create:type_name -> google.apps.drive.activity.v2.Create
	13, // 6: google.apps.drive.activity.v2.ActionDetail.edit:type_name -> google.apps.drive.activity.v2.Edit
	14, // 7: google.apps.drive.activity.v2.ActionDetail.move:type_name -> google.apps.drive.activity.v2.Move
	15, // 8: google.apps.drive.activity.v2.ActionDetail.rename:type_name -> google.apps.drive.activity.v2.Rename
	16, // 9: google.apps.drive.activity.v2.ActionDetail.delete:type_name -> google.apps.drive.activity.v2.Delete
	17, // 10: google.apps.drive.activity.v2.ActionDetail.restore:type_name -> google.apps.drive.activity.v2.Restore
	18, // 11: google.apps.drive.activity.v2.ActionDetail.permission_change:type_name -> google.apps.drive.activity.v2.PermissionChange
	20, // 12: google.apps.drive.activity.v2.ActionDetail.comment:type_name -> google.apps.drive.activity.v2.Comment
	21, // 13: google.apps.drive.activity.v2.ActionDetail.dlp_change:type_name -> google.apps.drive.activity.v2.DataLeakPreventionChange
	22, // 14: google.apps.drive.activity.v2.ActionDetail.reference:type_name -> google.apps.drive.activity.v2.ApplicationReference
	23, // 15: google.apps.drive.activity.v2.ActionDetail.settings_change:type_name -> google.apps.drive.activity.v2.SettingsChange
	24, // 16: google.apps.drive.activity.v2.Create.new:type_name -> google.apps.drive.activity.v2.Create.New
	25, // 17: google.apps.drive.activity.v2.Create.upload:type_name -> google.apps.drive.activity.v2.Create.Upload
	26, // 18: google.apps.drive.activity.v2.Create.copy:type_name -> google.apps.drive.activity.v2.Create.Copy
	36, // 19: google.apps.drive.activity.v2.Move.added_parents:type_name -> google.apps.drive.activity.v2.TargetReference
	36, // 20: google.apps.drive.activity.v2.Move.removed_parents:type_name -> google.apps.drive.activity.v2.TargetReference
	0,  // 21: google.apps.drive.activity.v2.Delete.type:type_name -> google.apps.drive.activity.v2.Delete.Type
	1,  // 22: google.apps.drive.activity.v2.Restore.type:type_name -> google.apps.drive.activity.v2.Restore.Type
	19, // 23: google.apps.drive.activity.v2.PermissionChange.added_permissions:type_name -> google.apps.drive.activity.v2.Permission
	19, // 24: google.apps.drive.activity.v2.PermissionChange.removed_permissions:type_name -> google.apps.drive.activity.v2.Permission
	2,  // 25: google.apps.drive.activity.v2.Permission.role:type_name -> google.apps.drive.activity.v2.Permission.Role
	37, // 26: google.apps.drive.activity.v2.Permission.user:type_name -> google.apps.drive.activity.v2.User
	38, // 27: google.apps.drive.activity.v2.Permission.group:type_name -> google.apps.drive.activity.v2.Group
	39, // 28: google.apps.drive.activity.v2.Permission.domain:type_name -> google.apps.drive.activity.v2.Domain
	27, // 29: google.apps.drive.activity.v2.Permission.anyone:type_name -> google.apps.drive.activity.v2.Permission.Anyone
	28, // 30: google.apps.drive.activity.v2.Comment.post:type_name -> google.apps.drive.activity.v2.Comment.Post
	29, // 31: google.apps.drive.activity.v2.Comment.assignment:type_name -> google.apps.drive.activity.v2.Comment.Assignment
	30, // 32: google.apps.drive.activity.v2.Comment.suggestion:type_name -> google.apps.drive.activity.v2.Comment.Suggestion
	37, // 33: google.apps.drive.activity.v2.Comment.mentioned_users:type_name -> google.apps.drive.activity.v2.User
	6,  // 34: google.apps.drive.activity.v2.DataLeakPreventionChange.type:type_name -> google.apps.drive.activity.v2.DataLeakPreventionChange.Type
	7,  // 35: google.apps.drive.activity.v2.ApplicationReference.type:type_name -> google.apps.drive.activity.v2.ApplicationReference.Type
	31, // 36: google.apps.drive.activity.v2.SettingsChange.restriction_changes:type_name -> google.apps.drive.activity.v2.SettingsChange.RestrictionChange
	36, // 37: google.apps.drive.activity.v2.Create.Copy.original_object:type_name -> google.apps.drive.activity.v2.TargetReference
	3,  // 38: google.apps.drive.activity.v2.Comment.Post.subtype:type_name -> google.apps.drive.activity.v2.Comment.Post.Subtype
	4,  // 39: google.apps.drive.activity.v2.Comment.Assignment.subtype:type_name -> google.apps.drive.activity.v2.Comment.Assignment.Subtype
	37, // 40: google.apps.drive.activity.v2.Comment.Assignment.assigned_user:type_name -> google.apps.drive.activity.v2.User
	5,  // 41: google.apps.drive.activity.v2.Comment.Suggestion.subtype:type_name -> google.apps.drive.activity.v2.Comment.Suggestion.Subtype
	8,  // 42: google.apps.drive.activity.v2.SettingsChange.RestrictionChange.feature:type_name -> google.apps.drive.activity.v2.SettingsChange.RestrictionChange.Feature
	9,  // 43: google.apps.drive.activity.v2.SettingsChange.RestrictionChange.new_restriction:type_name -> google.apps.drive.activity.v2.SettingsChange.RestrictionChange.Restriction
	44, // [44:44] is the sub-list for method output_type
	44, // [44:44] is the sub-list for method input_type
	44, // [44:44] is the sub-list for extension type_name
	44, // [44:44] is the sub-list for extension extendee
	0,  // [0:44] is the sub-list for field type_name
}

func init() { file_google_apps_drive_activity_v2_action_proto_init() }
func file_google_apps_drive_activity_v2_action_proto_init() {
	if File_google_apps_drive_activity_v2_action_proto != nil {
		return
	}
	file_google_apps_drive_activity_v2_actor_proto_init()
	file_google_apps_drive_activity_v2_common_proto_init()
	file_google_apps_drive_activity_v2_target_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_apps_drive_activity_v2_action_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_action_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_action_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Create); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_action_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Edit); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_action_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Move); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_action_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rename); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_action_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Delete); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_action_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Restore); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_action_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PermissionChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_action_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Permission); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_action_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Comment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_action_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataLeakPreventionChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_action_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_action_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SettingsChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_action_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Create_New); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_action_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Create_Upload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_action_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Create_Copy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_action_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Permission_Anyone); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_action_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Comment_Post); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_action_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Comment_Assignment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_action_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Comment_Suggestion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_action_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SettingsChange_RestrictionChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_apps_drive_activity_v2_action_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Action_Timestamp)(nil),
		(*Action_TimeRange)(nil),
	}
	file_google_apps_drive_activity_v2_action_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*ActionDetail_Create)(nil),
		(*ActionDetail_Edit)(nil),
		(*ActionDetail_Move)(nil),
		(*ActionDetail_Rename)(nil),
		(*ActionDetail_Delete)(nil),
		(*ActionDetail_Restore)(nil),
		(*ActionDetail_PermissionChange)(nil),
		(*ActionDetail_Comment)(nil),
		(*ActionDetail_DlpChange)(nil),
		(*ActionDetail_Reference)(nil),
		(*ActionDetail_SettingsChange)(nil),
	}
	file_google_apps_drive_activity_v2_action_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*Create_New_)(nil),
		(*Create_Upload_)(nil),
		(*Create_Copy_)(nil),
	}
	file_google_apps_drive_activity_v2_action_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*Permission_User)(nil),
		(*Permission_Group)(nil),
		(*Permission_Domain)(nil),
		(*Permission_Anyone_)(nil),
	}
	file_google_apps_drive_activity_v2_action_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*Comment_Post_)(nil),
		(*Comment_Assignment_)(nil),
		(*Comment_Suggestion_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_apps_drive_activity_v2_action_proto_rawDesc,
			NumEnums:      10,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_apps_drive_activity_v2_action_proto_goTypes,
		DependencyIndexes: file_google_apps_drive_activity_v2_action_proto_depIdxs,
		EnumInfos:         file_google_apps_drive_activity_v2_action_proto_enumTypes,
		MessageInfos:      file_google_apps_drive_activity_v2_action_proto_msgTypes,
	}.Build()
	File_google_apps_drive_activity_v2_action_proto = out.File
	file_google_apps_drive_activity_v2_action_proto_rawDesc = nil
	file_google_apps_drive_activity_v2_action_proto_goTypes = nil
	file_google_apps_drive_activity_v2_action_proto_depIdxs = nil
}
