// Code generated by smithy-go-codegen DO NOT EDIT.

package robomaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/robomaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list simulation job batches. You can optionally provide filters to
// retrieve specific simulation batch jobs.
func (c *Client) ListSimulationJobBatches(ctx context.Context, params *ListSimulationJobBatchesInput, optFns ...func(*Options)) (*ListSimulationJobBatchesOutput, error) {
	if params == nil {
		params = &ListSimulationJobBatchesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSimulationJobBatches", params, optFns, c.addOperationListSimulationJobBatchesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSimulationJobBatchesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSimulationJobBatchesInput struct {

	// Optional filters to limit results.
	Filters []types.Filter

	// When this parameter is used, ListSimulationJobBatches only returns maxResults
	// results in a single page along with a nextToken response element. The remaining
	// results of the initial request can be seen by sending another
	// ListSimulationJobBatches request with the returned nextToken value.
	MaxResults *int32

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListSimulationJobBatches again and assign that
	// token to the request object's nextToken parameter. If there are no remaining
	// results, the previous response object's NextToken parameter is set to null.
	NextToken *string

	noSmithyDocumentSerde
}

type ListSimulationJobBatchesOutput struct {

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListSimulationJobBatches again and assign that
	// token to the request object's nextToken parameter. If there are no remaining
	// results, the previous response object's NextToken parameter is set to null.
	NextToken *string

	// A list of simulation job batch summaries.
	SimulationJobBatchSummaries []types.SimulationJobBatchSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSimulationJobBatchesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListSimulationJobBatches{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListSimulationJobBatches{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListSimulationJobBatches"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSimulationJobBatches(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListSimulationJobBatchesAPIClient is a client that implements the
// ListSimulationJobBatches operation.
type ListSimulationJobBatchesAPIClient interface {
	ListSimulationJobBatches(context.Context, *ListSimulationJobBatchesInput, ...func(*Options)) (*ListSimulationJobBatchesOutput, error)
}

var _ ListSimulationJobBatchesAPIClient = (*Client)(nil)

// ListSimulationJobBatchesPaginatorOptions is the paginator options for
// ListSimulationJobBatches
type ListSimulationJobBatchesPaginatorOptions struct {
	// When this parameter is used, ListSimulationJobBatches only returns maxResults
	// results in a single page along with a nextToken response element. The remaining
	// results of the initial request can be seen by sending another
	// ListSimulationJobBatches request with the returned nextToken value.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSimulationJobBatchesPaginator is a paginator for ListSimulationJobBatches
type ListSimulationJobBatchesPaginator struct {
	options   ListSimulationJobBatchesPaginatorOptions
	client    ListSimulationJobBatchesAPIClient
	params    *ListSimulationJobBatchesInput
	nextToken *string
	firstPage bool
}

// NewListSimulationJobBatchesPaginator returns a new
// ListSimulationJobBatchesPaginator
func NewListSimulationJobBatchesPaginator(client ListSimulationJobBatchesAPIClient, params *ListSimulationJobBatchesInput, optFns ...func(*ListSimulationJobBatchesPaginatorOptions)) *ListSimulationJobBatchesPaginator {
	if params == nil {
		params = &ListSimulationJobBatchesInput{}
	}

	options := ListSimulationJobBatchesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSimulationJobBatchesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSimulationJobBatchesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListSimulationJobBatches page.
func (p *ListSimulationJobBatchesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSimulationJobBatchesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListSimulationJobBatches(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListSimulationJobBatches(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListSimulationJobBatches",
	}
}
