// Code generated by smithy-go-codegen DO NOT EDIT.

package mediapackagev2

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/mediapackagev2/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpCreateChannel struct {
}

func (*awsRestjson1_serializeOpCreateChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channelGroup/{ChannelGroupName}/channel")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateChannelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateChannelInput(v *CreateChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelGroupName == nil || len(*v.ChannelGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelGroupName must not be empty")}
	}
	if v.ChannelGroupName != nil {
		if err := encoder.SetURI("ChannelGroupName").String(*v.ChannelGroupName); err != nil {
			return err
		}
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amzn-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateChannelInput(v *CreateChannelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelName != nil {
		ok := object.Key("ChannelName")
		ok.String(*v.ChannelName)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateChannelGroup struct {
}

func (*awsRestjson1_serializeOpCreateChannelGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateChannelGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateChannelGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channelGroup")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateChannelGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateChannelGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateChannelGroupInput(v *CreateChannelGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amzn-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateChannelGroupInput(v *CreateChannelGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelGroupName != nil {
		ok := object.Key("ChannelGroupName")
		ok.String(*v.ChannelGroupName)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateOriginEndpoint struct {
}

func (*awsRestjson1_serializeOpCreateOriginEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateOriginEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateOriginEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channelGroup/{ChannelGroupName}/channel/{ChannelName}/originEndpoint")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateOriginEndpointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateOriginEndpointInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateOriginEndpointInput(v *CreateOriginEndpointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelGroupName == nil || len(*v.ChannelGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelGroupName must not be empty")}
	}
	if v.ChannelGroupName != nil {
		if err := encoder.SetURI("ChannelGroupName").String(*v.ChannelGroupName); err != nil {
			return err
		}
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amzn-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateOriginEndpointInput(v *CreateOriginEndpointInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ContainerType) > 0 {
		ok := object.Key("ContainerType")
		ok.String(string(v.ContainerType))
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.HlsManifests != nil {
		ok := object.Key("HlsManifests")
		if err := awsRestjson1_serializeDocumentCreateHlsManifests(v.HlsManifests, ok); err != nil {
			return err
		}
	}

	if v.LowLatencyHlsManifests != nil {
		ok := object.Key("LowLatencyHlsManifests")
		if err := awsRestjson1_serializeDocumentCreateLowLatencyHlsManifests(v.LowLatencyHlsManifests, ok); err != nil {
			return err
		}
	}

	if v.OriginEndpointName != nil {
		ok := object.Key("OriginEndpointName")
		ok.String(*v.OriginEndpointName)
	}

	if v.Segment != nil {
		ok := object.Key("Segment")
		if err := awsRestjson1_serializeDocumentSegment(v.Segment, ok); err != nil {
			return err
		}
	}

	if v.StartoverWindowSeconds != nil {
		ok := object.Key("StartoverWindowSeconds")
		ok.Integer(*v.StartoverWindowSeconds)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteChannel struct {
}

func (*awsRestjson1_serializeOpDeleteChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channelGroup/{ChannelGroupName}/channel/{ChannelName}/")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteChannelInput(v *DeleteChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelGroupName == nil || len(*v.ChannelGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelGroupName must not be empty")}
	}
	if v.ChannelGroupName != nil {
		if err := encoder.SetURI("ChannelGroupName").String(*v.ChannelGroupName); err != nil {
			return err
		}
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteChannelGroup struct {
}

func (*awsRestjson1_serializeOpDeleteChannelGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteChannelGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteChannelGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channelGroup/{ChannelGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteChannelGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteChannelGroupInput(v *DeleteChannelGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelGroupName == nil || len(*v.ChannelGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelGroupName must not be empty")}
	}
	if v.ChannelGroupName != nil {
		if err := encoder.SetURI("ChannelGroupName").String(*v.ChannelGroupName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteChannelPolicy struct {
}

func (*awsRestjson1_serializeOpDeleteChannelPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteChannelPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteChannelPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channelGroup/{ChannelGroupName}/channel/{ChannelName}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteChannelPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteChannelPolicyInput(v *DeleteChannelPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelGroupName == nil || len(*v.ChannelGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelGroupName must not be empty")}
	}
	if v.ChannelGroupName != nil {
		if err := encoder.SetURI("ChannelGroupName").String(*v.ChannelGroupName); err != nil {
			return err
		}
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteOriginEndpoint struct {
}

func (*awsRestjson1_serializeOpDeleteOriginEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteOriginEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteOriginEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channelGroup/{ChannelGroupName}/channel/{ChannelName}/originEndpoint/{OriginEndpointName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteOriginEndpointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteOriginEndpointInput(v *DeleteOriginEndpointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelGroupName == nil || len(*v.ChannelGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelGroupName must not be empty")}
	}
	if v.ChannelGroupName != nil {
		if err := encoder.SetURI("ChannelGroupName").String(*v.ChannelGroupName); err != nil {
			return err
		}
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	if v.OriginEndpointName == nil || len(*v.OriginEndpointName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member OriginEndpointName must not be empty")}
	}
	if v.OriginEndpointName != nil {
		if err := encoder.SetURI("OriginEndpointName").String(*v.OriginEndpointName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteOriginEndpointPolicy struct {
}

func (*awsRestjson1_serializeOpDeleteOriginEndpointPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteOriginEndpointPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteOriginEndpointPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channelGroup/{ChannelGroupName}/channel/{ChannelName}/originEndpoint/{OriginEndpointName}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteOriginEndpointPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteOriginEndpointPolicyInput(v *DeleteOriginEndpointPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelGroupName == nil || len(*v.ChannelGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelGroupName must not be empty")}
	}
	if v.ChannelGroupName != nil {
		if err := encoder.SetURI("ChannelGroupName").String(*v.ChannelGroupName); err != nil {
			return err
		}
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	if v.OriginEndpointName == nil || len(*v.OriginEndpointName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member OriginEndpointName must not be empty")}
	}
	if v.OriginEndpointName != nil {
		if err := encoder.SetURI("OriginEndpointName").String(*v.OriginEndpointName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetChannel struct {
}

func (*awsRestjson1_serializeOpGetChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channelGroup/{ChannelGroupName}/channel/{ChannelName}/")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetChannelInput(v *GetChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelGroupName == nil || len(*v.ChannelGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelGroupName must not be empty")}
	}
	if v.ChannelGroupName != nil {
		if err := encoder.SetURI("ChannelGroupName").String(*v.ChannelGroupName); err != nil {
			return err
		}
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetChannelGroup struct {
}

func (*awsRestjson1_serializeOpGetChannelGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetChannelGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetChannelGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channelGroup/{ChannelGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetChannelGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetChannelGroupInput(v *GetChannelGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelGroupName == nil || len(*v.ChannelGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelGroupName must not be empty")}
	}
	if v.ChannelGroupName != nil {
		if err := encoder.SetURI("ChannelGroupName").String(*v.ChannelGroupName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetChannelPolicy struct {
}

func (*awsRestjson1_serializeOpGetChannelPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetChannelPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetChannelPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channelGroup/{ChannelGroupName}/channel/{ChannelName}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetChannelPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetChannelPolicyInput(v *GetChannelPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelGroupName == nil || len(*v.ChannelGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelGroupName must not be empty")}
	}
	if v.ChannelGroupName != nil {
		if err := encoder.SetURI("ChannelGroupName").String(*v.ChannelGroupName); err != nil {
			return err
		}
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetOriginEndpoint struct {
}

func (*awsRestjson1_serializeOpGetOriginEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetOriginEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetOriginEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channelGroup/{ChannelGroupName}/channel/{ChannelName}/originEndpoint/{OriginEndpointName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetOriginEndpointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetOriginEndpointInput(v *GetOriginEndpointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelGroupName == nil || len(*v.ChannelGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelGroupName must not be empty")}
	}
	if v.ChannelGroupName != nil {
		if err := encoder.SetURI("ChannelGroupName").String(*v.ChannelGroupName); err != nil {
			return err
		}
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	if v.OriginEndpointName == nil || len(*v.OriginEndpointName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member OriginEndpointName must not be empty")}
	}
	if v.OriginEndpointName != nil {
		if err := encoder.SetURI("OriginEndpointName").String(*v.OriginEndpointName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetOriginEndpointPolicy struct {
}

func (*awsRestjson1_serializeOpGetOriginEndpointPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetOriginEndpointPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetOriginEndpointPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channelGroup/{ChannelGroupName}/channel/{ChannelName}/originEndpoint/{OriginEndpointName}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetOriginEndpointPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetOriginEndpointPolicyInput(v *GetOriginEndpointPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelGroupName == nil || len(*v.ChannelGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelGroupName must not be empty")}
	}
	if v.ChannelGroupName != nil {
		if err := encoder.SetURI("ChannelGroupName").String(*v.ChannelGroupName); err != nil {
			return err
		}
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	if v.OriginEndpointName == nil || len(*v.OriginEndpointName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member OriginEndpointName must not be empty")}
	}
	if v.OriginEndpointName != nil {
		if err := encoder.SetURI("OriginEndpointName").String(*v.OriginEndpointName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListChannelGroups struct {
}

func (*awsRestjson1_serializeOpListChannelGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListChannelGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListChannelGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channelGroup")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListChannelGroupsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListChannelGroupsInput(v *ListChannelGroupsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListChannels struct {
}

func (*awsRestjson1_serializeOpListChannels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListChannels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListChannelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channelGroup/{ChannelGroupName}/channel")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListChannelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListChannelsInput(v *ListChannelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelGroupName == nil || len(*v.ChannelGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelGroupName must not be empty")}
	}
	if v.ChannelGroupName != nil {
		if err := encoder.SetURI("ChannelGroupName").String(*v.ChannelGroupName); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListOriginEndpoints struct {
}

func (*awsRestjson1_serializeOpListOriginEndpoints) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListOriginEndpoints) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListOriginEndpointsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channelGroup/{ChannelGroupName}/channel/{ChannelName}/originEndpoint")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListOriginEndpointsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListOriginEndpointsInput(v *ListOriginEndpointsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelGroupName == nil || len(*v.ChannelGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelGroupName must not be empty")}
	}
	if v.ChannelGroupName != nil {
		if err := encoder.SetURI("ChannelGroupName").String(*v.ChannelGroupName); err != nil {
			return err
		}
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPutChannelPolicy struct {
}

func (*awsRestjson1_serializeOpPutChannelPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutChannelPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutChannelPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channelGroup/{ChannelGroupName}/channel/{ChannelName}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutChannelPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutChannelPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutChannelPolicyInput(v *PutChannelPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelGroupName == nil || len(*v.ChannelGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelGroupName must not be empty")}
	}
	if v.ChannelGroupName != nil {
		if err := encoder.SetURI("ChannelGroupName").String(*v.ChannelGroupName); err != nil {
			return err
		}
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutChannelPolicyInput(v *PutChannelPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Policy != nil {
		ok := object.Key("Policy")
		ok.String(*v.Policy)
	}

	return nil
}

type awsRestjson1_serializeOpPutOriginEndpointPolicy struct {
}

func (*awsRestjson1_serializeOpPutOriginEndpointPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutOriginEndpointPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutOriginEndpointPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channelGroup/{ChannelGroupName}/channel/{ChannelName}/originEndpoint/{OriginEndpointName}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutOriginEndpointPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutOriginEndpointPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutOriginEndpointPolicyInput(v *PutOriginEndpointPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelGroupName == nil || len(*v.ChannelGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelGroupName must not be empty")}
	}
	if v.ChannelGroupName != nil {
		if err := encoder.SetURI("ChannelGroupName").String(*v.ChannelGroupName); err != nil {
			return err
		}
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	if v.OriginEndpointName == nil || len(*v.OriginEndpointName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member OriginEndpointName must not be empty")}
	}
	if v.OriginEndpointName != nil {
		if err := encoder.SetURI("OriginEndpointName").String(*v.OriginEndpointName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutOriginEndpointPolicyInput(v *PutOriginEndpointPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Policy != nil {
		ok := object.Key("Policy")
		ok.String(*v.Policy)
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateChannel struct {
}

func (*awsRestjson1_serializeOpUpdateChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channelGroup/{ChannelGroupName}/channel/{ChannelName}/")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateChannelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateChannelInput(v *UpdateChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelGroupName == nil || len(*v.ChannelGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelGroupName must not be empty")}
	}
	if v.ChannelGroupName != nil {
		if err := encoder.SetURI("ChannelGroupName").String(*v.ChannelGroupName); err != nil {
			return err
		}
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateChannelInput(v *UpdateChannelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateChannelGroup struct {
}

func (*awsRestjson1_serializeOpUpdateChannelGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateChannelGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateChannelGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channelGroup/{ChannelGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateChannelGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateChannelGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateChannelGroupInput(v *UpdateChannelGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelGroupName == nil || len(*v.ChannelGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelGroupName must not be empty")}
	}
	if v.ChannelGroupName != nil {
		if err := encoder.SetURI("ChannelGroupName").String(*v.ChannelGroupName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateChannelGroupInput(v *UpdateChannelGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateOriginEndpoint struct {
}

func (*awsRestjson1_serializeOpUpdateOriginEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateOriginEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateOriginEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channelGroup/{ChannelGroupName}/channel/{ChannelName}/originEndpoint/{OriginEndpointName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateOriginEndpointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateOriginEndpointInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateOriginEndpointInput(v *UpdateOriginEndpointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelGroupName == nil || len(*v.ChannelGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelGroupName must not be empty")}
	}
	if v.ChannelGroupName != nil {
		if err := encoder.SetURI("ChannelGroupName").String(*v.ChannelGroupName); err != nil {
			return err
		}
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	if v.OriginEndpointName == nil || len(*v.OriginEndpointName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member OriginEndpointName must not be empty")}
	}
	if v.OriginEndpointName != nil {
		if err := encoder.SetURI("OriginEndpointName").String(*v.OriginEndpointName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateOriginEndpointInput(v *UpdateOriginEndpointInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ContainerType) > 0 {
		ok := object.Key("ContainerType")
		ok.String(string(v.ContainerType))
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.HlsManifests != nil {
		ok := object.Key("HlsManifests")
		if err := awsRestjson1_serializeDocumentCreateHlsManifests(v.HlsManifests, ok); err != nil {
			return err
		}
	}

	if v.LowLatencyHlsManifests != nil {
		ok := object.Key("LowLatencyHlsManifests")
		if err := awsRestjson1_serializeDocumentCreateLowLatencyHlsManifests(v.LowLatencyHlsManifests, ok); err != nil {
			return err
		}
	}

	if v.Segment != nil {
		ok := object.Key("Segment")
		if err := awsRestjson1_serializeDocumentSegment(v.Segment, ok); err != nil {
			return err
		}
	}

	if v.StartoverWindowSeconds != nil {
		ok := object.Key("StartoverWindowSeconds")
		ok.Integer(*v.StartoverWindowSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateHlsManifestConfiguration(v *types.CreateHlsManifestConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChildManifestName != nil {
		ok := object.Key("ChildManifestName")
		ok.String(*v.ChildManifestName)
	}

	if v.FilterConfiguration != nil {
		ok := object.Key("FilterConfiguration")
		if err := awsRestjson1_serializeDocumentFilterConfiguration(v.FilterConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ManifestName != nil {
		ok := object.Key("ManifestName")
		ok.String(*v.ManifestName)
	}

	if v.ManifestWindowSeconds != nil {
		ok := object.Key("ManifestWindowSeconds")
		ok.Integer(*v.ManifestWindowSeconds)
	}

	if v.ProgramDateTimeIntervalSeconds != nil {
		ok := object.Key("ProgramDateTimeIntervalSeconds")
		ok.Integer(*v.ProgramDateTimeIntervalSeconds)
	}

	if v.ScteHls != nil {
		ok := object.Key("ScteHls")
		if err := awsRestjson1_serializeDocumentScteHls(v.ScteHls, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateHlsManifests(v []types.CreateHlsManifestConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCreateHlsManifestConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCreateLowLatencyHlsManifestConfiguration(v *types.CreateLowLatencyHlsManifestConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChildManifestName != nil {
		ok := object.Key("ChildManifestName")
		ok.String(*v.ChildManifestName)
	}

	if v.FilterConfiguration != nil {
		ok := object.Key("FilterConfiguration")
		if err := awsRestjson1_serializeDocumentFilterConfiguration(v.FilterConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ManifestName != nil {
		ok := object.Key("ManifestName")
		ok.String(*v.ManifestName)
	}

	if v.ManifestWindowSeconds != nil {
		ok := object.Key("ManifestWindowSeconds")
		ok.Integer(*v.ManifestWindowSeconds)
	}

	if v.ProgramDateTimeIntervalSeconds != nil {
		ok := object.Key("ProgramDateTimeIntervalSeconds")
		ok.Integer(*v.ProgramDateTimeIntervalSeconds)
	}

	if v.ScteHls != nil {
		ok := object.Key("ScteHls")
		if err := awsRestjson1_serializeDocumentScteHls(v.ScteHls, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateLowLatencyHlsManifests(v []types.CreateLowLatencyHlsManifestConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCreateLowLatencyHlsManifestConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDrmSystems(v []types.DrmSystem, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentEncryption(v *types.Encryption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConstantInitializationVector != nil {
		ok := object.Key("ConstantInitializationVector")
		ok.String(*v.ConstantInitializationVector)
	}

	if v.EncryptionMethod != nil {
		ok := object.Key("EncryptionMethod")
		if err := awsRestjson1_serializeDocumentEncryptionMethod(v.EncryptionMethod, ok); err != nil {
			return err
		}
	}

	if v.KeyRotationIntervalSeconds != nil {
		ok := object.Key("KeyRotationIntervalSeconds")
		ok.Integer(*v.KeyRotationIntervalSeconds)
	}

	if v.SpekeKeyProvider != nil {
		ok := object.Key("SpekeKeyProvider")
		if err := awsRestjson1_serializeDocumentSpekeKeyProvider(v.SpekeKeyProvider, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEncryptionContractConfiguration(v *types.EncryptionContractConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.PresetSpeke20Audio) > 0 {
		ok := object.Key("PresetSpeke20Audio")
		ok.String(string(v.PresetSpeke20Audio))
	}

	if len(v.PresetSpeke20Video) > 0 {
		ok := object.Key("PresetSpeke20Video")
		ok.String(string(v.PresetSpeke20Video))
	}

	return nil
}

func awsRestjson1_serializeDocumentEncryptionMethod(v *types.EncryptionMethod, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CmafEncryptionMethod) > 0 {
		ok := object.Key("CmafEncryptionMethod")
		ok.String(string(v.CmafEncryptionMethod))
	}

	if len(v.TsEncryptionMethod) > 0 {
		ok := object.Key("TsEncryptionMethod")
		ok.String(string(v.TsEncryptionMethod))
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterConfiguration(v *types.FilterConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.End != nil {
		ok := object.Key("End")
		ok.Double(smithytime.FormatEpochSeconds(*v.End))
	}

	if v.ManifestFilter != nil {
		ok := object.Key("ManifestFilter")
		ok.String(*v.ManifestFilter)
	}

	if v.Start != nil {
		ok := object.Key("Start")
		ok.Double(smithytime.FormatEpochSeconds(*v.Start))
	}

	if v.TimeDelaySeconds != nil {
		ok := object.Key("TimeDelaySeconds")
		ok.Integer(*v.TimeDelaySeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentScte(v *types.Scte, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ScteFilter != nil {
		ok := object.Key("ScteFilter")
		if err := awsRestjson1_serializeDocumentScteFilterList(v.ScteFilter, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentScteFilterList(v []types.ScteFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentScteHls(v *types.ScteHls, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AdMarkerHls) > 0 {
		ok := object.Key("AdMarkerHls")
		ok.String(string(v.AdMarkerHls))
	}

	return nil
}

func awsRestjson1_serializeDocumentSegment(v *types.Segment, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Encryption != nil {
		ok := object.Key("Encryption")
		if err := awsRestjson1_serializeDocumentEncryption(v.Encryption, ok); err != nil {
			return err
		}
	}

	if v.IncludeIframeOnlyStreams != nil {
		ok := object.Key("IncludeIframeOnlyStreams")
		ok.Boolean(*v.IncludeIframeOnlyStreams)
	}

	if v.Scte != nil {
		ok := object.Key("Scte")
		if err := awsRestjson1_serializeDocumentScte(v.Scte, ok); err != nil {
			return err
		}
	}

	if v.SegmentDurationSeconds != nil {
		ok := object.Key("SegmentDurationSeconds")
		ok.Integer(*v.SegmentDurationSeconds)
	}

	if v.SegmentName != nil {
		ok := object.Key("SegmentName")
		ok.String(*v.SegmentName)
	}

	if v.TsIncludeDvbSubtitles != nil {
		ok := object.Key("TsIncludeDvbSubtitles")
		ok.Boolean(*v.TsIncludeDvbSubtitles)
	}

	if v.TsUseAudioRenditionGroup != nil {
		ok := object.Key("TsUseAudioRenditionGroup")
		ok.Boolean(*v.TsUseAudioRenditionGroup)
	}

	return nil
}

func awsRestjson1_serializeDocumentSpekeKeyProvider(v *types.SpekeKeyProvider, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DrmSystems != nil {
		ok := object.Key("DrmSystems")
		if err := awsRestjson1_serializeDocumentDrmSystems(v.DrmSystems, ok); err != nil {
			return err
		}
	}

	if v.EncryptionContractConfiguration != nil {
		ok := object.Key("EncryptionContractConfiguration")
		if err := awsRestjson1_serializeDocumentEncryptionContractConfiguration(v.EncryptionContractConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ResourceId != nil {
		ok := object.Key("ResourceId")
		ok.String(*v.ResourceId)
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.Url != nil {
		ok := object.Key("Url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}
