// Code generated by smithy-go-codegen DO NOT EDIT.

package elasticache

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/elasticache/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns information about a specific serverless cache. If no identifier is
// specified, then the API returns information on all the serverless caches
// belonging to this Amazon Web Services account.
func (c *Client) DescribeServerlessCaches(ctx context.Context, params *DescribeServerlessCachesInput, optFns ...func(*Options)) (*DescribeServerlessCachesOutput, error) {
	if params == nil {
		params = &DescribeServerlessCachesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeServerlessCaches", params, optFns, c.addOperationDescribeServerlessCachesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeServerlessCachesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeServerlessCachesInput struct {

	// The maximum number of records in the response. If more records exist than the
	// specified max-records value, the next token is included in the response so that
	// remaining results can be retrieved. The default is 50.
	MaxResults *int32

	// An optional marker returned from a prior request to support pagination of
	// results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by
	// MaxResults.
	NextToken *string

	// The identifier for the serverless cache. If this parameter is specified, only
	// information about that specific serverless cache is returned. Default: NULL
	ServerlessCacheName *string

	noSmithyDocumentSerde
}

type DescribeServerlessCachesOutput struct {

	// An optional marker returned from a prior request to support pagination of
	// results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by
	// MaxResults.
	NextToken *string

	// The serverless caches associated with a given description request.
	ServerlessCaches []types.ServerlessCache

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeServerlessCachesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpDescribeServerlessCaches{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpDescribeServerlessCaches{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeServerlessCaches"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeServerlessCaches(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeServerlessCachesAPIClient is a client that implements the
// DescribeServerlessCaches operation.
type DescribeServerlessCachesAPIClient interface {
	DescribeServerlessCaches(context.Context, *DescribeServerlessCachesInput, ...func(*Options)) (*DescribeServerlessCachesOutput, error)
}

var _ DescribeServerlessCachesAPIClient = (*Client)(nil)

// DescribeServerlessCachesPaginatorOptions is the paginator options for
// DescribeServerlessCaches
type DescribeServerlessCachesPaginatorOptions struct {
	// The maximum number of records in the response. If more records exist than the
	// specified max-records value, the next token is included in the response so that
	// remaining results can be retrieved. The default is 50.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeServerlessCachesPaginator is a paginator for DescribeServerlessCaches
type DescribeServerlessCachesPaginator struct {
	options   DescribeServerlessCachesPaginatorOptions
	client    DescribeServerlessCachesAPIClient
	params    *DescribeServerlessCachesInput
	nextToken *string
	firstPage bool
}

// NewDescribeServerlessCachesPaginator returns a new
// DescribeServerlessCachesPaginator
func NewDescribeServerlessCachesPaginator(client DescribeServerlessCachesAPIClient, params *DescribeServerlessCachesInput, optFns ...func(*DescribeServerlessCachesPaginatorOptions)) *DescribeServerlessCachesPaginator {
	if params == nil {
		params = &DescribeServerlessCachesInput{}
	}

	options := DescribeServerlessCachesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeServerlessCachesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeServerlessCachesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeServerlessCaches page.
func (p *DescribeServerlessCachesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeServerlessCachesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.DescribeServerlessCaches(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeServerlessCaches(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeServerlessCaches",
	}
}
