// Code generated by smithy-go-codegen DO NOT EDIT.

package elastictranscoder

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/elastictranscoder/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpCancelJob struct {
}

func (*awsRestjson1_serializeOpCancelJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2012-09-25/jobs/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCancelJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelJobInput(v *CancelJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateJob struct {
}

func (*awsRestjson1_serializeOpCreateJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2012-09-25/jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateJobInput(v *CreateJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateJobInput(v *CreateJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Input != nil {
		ok := object.Key("Input")
		if err := awsRestjson1_serializeDocumentJobInput(v.Input, ok); err != nil {
			return err
		}
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsRestjson1_serializeDocumentJobInputs(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Output != nil {
		ok := object.Key("Output")
		if err := awsRestjson1_serializeDocumentCreateJobOutput(v.Output, ok); err != nil {
			return err
		}
	}

	if v.OutputKeyPrefix != nil {
		ok := object.Key("OutputKeyPrefix")
		ok.String(*v.OutputKeyPrefix)
	}

	if v.Outputs != nil {
		ok := object.Key("Outputs")
		if err := awsRestjson1_serializeDocumentCreateJobOutputs(v.Outputs, ok); err != nil {
			return err
		}
	}

	if v.PipelineId != nil {
		ok := object.Key("PipelineId")
		ok.String(*v.PipelineId)
	}

	if v.Playlists != nil {
		ok := object.Key("Playlists")
		if err := awsRestjson1_serializeDocumentCreateJobPlaylists(v.Playlists, ok); err != nil {
			return err
		}
	}

	if v.UserMetadata != nil {
		ok := object.Key("UserMetadata")
		if err := awsRestjson1_serializeDocumentUserMetadata(v.UserMetadata, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreatePipeline struct {
}

func (*awsRestjson1_serializeOpCreatePipeline) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreatePipeline) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePipelineInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2012-09-25/pipelines")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreatePipelineInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreatePipelineInput(v *CreatePipelineInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreatePipelineInput(v *CreatePipelineInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AwsKmsKeyArn != nil {
		ok := object.Key("AwsKmsKeyArn")
		ok.String(*v.AwsKmsKeyArn)
	}

	if v.ContentConfig != nil {
		ok := object.Key("ContentConfig")
		if err := awsRestjson1_serializeDocumentPipelineOutputConfig(v.ContentConfig, ok); err != nil {
			return err
		}
	}

	if v.InputBucket != nil {
		ok := object.Key("InputBucket")
		ok.String(*v.InputBucket)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Notifications != nil {
		ok := object.Key("Notifications")
		if err := awsRestjson1_serializeDocumentNotifications(v.Notifications, ok); err != nil {
			return err
		}
	}

	if v.OutputBucket != nil {
		ok := object.Key("OutputBucket")
		ok.String(*v.OutputBucket)
	}

	if v.Role != nil {
		ok := object.Key("Role")
		ok.String(*v.Role)
	}

	if v.ThumbnailConfig != nil {
		ok := object.Key("ThumbnailConfig")
		if err := awsRestjson1_serializeDocumentPipelineOutputConfig(v.ThumbnailConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreatePreset struct {
}

func (*awsRestjson1_serializeOpCreatePreset) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreatePreset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePresetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2012-09-25/presets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreatePresetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreatePresetInput(v *CreatePresetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreatePresetInput(v *CreatePresetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Audio != nil {
		ok := object.Key("Audio")
		if err := awsRestjson1_serializeDocumentAudioParameters(v.Audio, ok); err != nil {
			return err
		}
	}

	if v.Container != nil {
		ok := object.Key("Container")
		ok.String(*v.Container)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Thumbnails != nil {
		ok := object.Key("Thumbnails")
		if err := awsRestjson1_serializeDocumentThumbnails(v.Thumbnails, ok); err != nil {
			return err
		}
	}

	if v.Video != nil {
		ok := object.Key("Video")
		if err := awsRestjson1_serializeDocumentVideoParameters(v.Video, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeletePipeline struct {
}

func (*awsRestjson1_serializeOpDeletePipeline) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeletePipeline) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePipelineInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2012-09-25/pipelines/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeletePipelineInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeletePipelineInput(v *DeletePipelineInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeletePreset struct {
}

func (*awsRestjson1_serializeOpDeletePreset) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeletePreset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePresetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2012-09-25/presets/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeletePresetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeletePresetInput(v *DeletePresetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListJobsByPipeline struct {
}

func (*awsRestjson1_serializeOpListJobsByPipeline) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListJobsByPipeline) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListJobsByPipelineInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2012-09-25/jobsByPipeline/{PipelineId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListJobsByPipelineInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListJobsByPipelineInput(v *ListJobsByPipelineInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Ascending != nil {
		encoder.SetQuery("Ascending").String(*v.Ascending)
	}

	if v.PageToken != nil {
		encoder.SetQuery("PageToken").String(*v.PageToken)
	}

	if v.PipelineId == nil || len(*v.PipelineId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member PipelineId must not be empty")}
	}
	if v.PipelineId != nil {
		if err := encoder.SetURI("PipelineId").String(*v.PipelineId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListJobsByStatus struct {
}

func (*awsRestjson1_serializeOpListJobsByStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListJobsByStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListJobsByStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2012-09-25/jobsByStatus/{Status}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListJobsByStatusInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListJobsByStatusInput(v *ListJobsByStatusInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Ascending != nil {
		encoder.SetQuery("Ascending").String(*v.Ascending)
	}

	if v.PageToken != nil {
		encoder.SetQuery("PageToken").String(*v.PageToken)
	}

	if v.Status == nil || len(*v.Status) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Status must not be empty")}
	}
	if v.Status != nil {
		if err := encoder.SetURI("Status").String(*v.Status); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListPipelines struct {
}

func (*awsRestjson1_serializeOpListPipelines) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPipelines) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPipelinesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2012-09-25/pipelines")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPipelinesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPipelinesInput(v *ListPipelinesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Ascending != nil {
		encoder.SetQuery("Ascending").String(*v.Ascending)
	}

	if v.PageToken != nil {
		encoder.SetQuery("PageToken").String(*v.PageToken)
	}

	return nil
}

type awsRestjson1_serializeOpListPresets struct {
}

func (*awsRestjson1_serializeOpListPresets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPresets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPresetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2012-09-25/presets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPresetsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPresetsInput(v *ListPresetsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Ascending != nil {
		encoder.SetQuery("Ascending").String(*v.Ascending)
	}

	if v.PageToken != nil {
		encoder.SetQuery("PageToken").String(*v.PageToken)
	}

	return nil
}

type awsRestjson1_serializeOpReadJob struct {
}

func (*awsRestjson1_serializeOpReadJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpReadJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReadJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2012-09-25/jobs/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsReadJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsReadJobInput(v *ReadJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpReadPipeline struct {
}

func (*awsRestjson1_serializeOpReadPipeline) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpReadPipeline) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReadPipelineInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2012-09-25/pipelines/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsReadPipelineInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsReadPipelineInput(v *ReadPipelineInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpReadPreset struct {
}

func (*awsRestjson1_serializeOpReadPreset) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpReadPreset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReadPresetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2012-09-25/presets/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsReadPresetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsReadPresetInput(v *ReadPresetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTestRole struct {
}

func (*awsRestjson1_serializeOpTestRole) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTestRole) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TestRoleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2012-09-25/roleTests")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTestRoleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTestRoleInput(v *TestRoleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTestRoleInput(v *TestRoleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputBucket != nil {
		ok := object.Key("InputBucket")
		ok.String(*v.InputBucket)
	}

	if v.OutputBucket != nil {
		ok := object.Key("OutputBucket")
		ok.String(*v.OutputBucket)
	}

	if v.Role != nil {
		ok := object.Key("Role")
		ok.String(*v.Role)
	}

	if v.Topics != nil {
		ok := object.Key("Topics")
		if err := awsRestjson1_serializeDocumentSnsTopics(v.Topics, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdatePipeline struct {
}

func (*awsRestjson1_serializeOpUpdatePipeline) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdatePipeline) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdatePipelineInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2012-09-25/pipelines/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdatePipelineInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdatePipelineInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdatePipelineInput(v *UpdatePipelineInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdatePipelineInput(v *UpdatePipelineInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AwsKmsKeyArn != nil {
		ok := object.Key("AwsKmsKeyArn")
		ok.String(*v.AwsKmsKeyArn)
	}

	if v.ContentConfig != nil {
		ok := object.Key("ContentConfig")
		if err := awsRestjson1_serializeDocumentPipelineOutputConfig(v.ContentConfig, ok); err != nil {
			return err
		}
	}

	if v.InputBucket != nil {
		ok := object.Key("InputBucket")
		ok.String(*v.InputBucket)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Notifications != nil {
		ok := object.Key("Notifications")
		if err := awsRestjson1_serializeDocumentNotifications(v.Notifications, ok); err != nil {
			return err
		}
	}

	if v.Role != nil {
		ok := object.Key("Role")
		ok.String(*v.Role)
	}

	if v.ThumbnailConfig != nil {
		ok := object.Key("ThumbnailConfig")
		if err := awsRestjson1_serializeDocumentPipelineOutputConfig(v.ThumbnailConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdatePipelineNotifications struct {
}

func (*awsRestjson1_serializeOpUpdatePipelineNotifications) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdatePipelineNotifications) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdatePipelineNotificationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2012-09-25/pipelines/{Id}/notifications")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdatePipelineNotificationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdatePipelineNotificationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdatePipelineNotificationsInput(v *UpdatePipelineNotificationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdatePipelineNotificationsInput(v *UpdatePipelineNotificationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Notifications != nil {
		ok := object.Key("Notifications")
		if err := awsRestjson1_serializeDocumentNotifications(v.Notifications, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdatePipelineStatus struct {
}

func (*awsRestjson1_serializeOpUpdatePipelineStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdatePipelineStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdatePipelineStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2012-09-25/pipelines/{Id}/status")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdatePipelineStatusInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdatePipelineStatusInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdatePipelineStatusInput(v *UpdatePipelineStatusInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdatePipelineStatusInput(v *UpdatePipelineStatusInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	return nil
}

func awsRestjson1_serializeDocumentAccessControls(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentArtwork(v *types.Artwork, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AlbumArtFormat != nil {
		ok := object.Key("AlbumArtFormat")
		ok.String(*v.AlbumArtFormat)
	}

	if v.Encryption != nil {
		ok := object.Key("Encryption")
		if err := awsRestjson1_serializeDocumentEncryption(v.Encryption, ok); err != nil {
			return err
		}
	}

	if v.InputKey != nil {
		ok := object.Key("InputKey")
		ok.String(*v.InputKey)
	}

	if v.MaxHeight != nil {
		ok := object.Key("MaxHeight")
		ok.String(*v.MaxHeight)
	}

	if v.MaxWidth != nil {
		ok := object.Key("MaxWidth")
		ok.String(*v.MaxWidth)
	}

	if v.PaddingPolicy != nil {
		ok := object.Key("PaddingPolicy")
		ok.String(*v.PaddingPolicy)
	}

	if v.SizingPolicy != nil {
		ok := object.Key("SizingPolicy")
		ok.String(*v.SizingPolicy)
	}

	return nil
}

func awsRestjson1_serializeDocumentArtworks(v []types.Artwork, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentArtwork(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAudioCodecOptions(v *types.AudioCodecOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BitDepth != nil {
		ok := object.Key("BitDepth")
		ok.String(*v.BitDepth)
	}

	if v.BitOrder != nil {
		ok := object.Key("BitOrder")
		ok.String(*v.BitOrder)
	}

	if v.Profile != nil {
		ok := object.Key("Profile")
		ok.String(*v.Profile)
	}

	if v.Signed != nil {
		ok := object.Key("Signed")
		ok.String(*v.Signed)
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioParameters(v *types.AudioParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioPackingMode != nil {
		ok := object.Key("AudioPackingMode")
		ok.String(*v.AudioPackingMode)
	}

	if v.BitRate != nil {
		ok := object.Key("BitRate")
		ok.String(*v.BitRate)
	}

	if v.Channels != nil {
		ok := object.Key("Channels")
		ok.String(*v.Channels)
	}

	if v.Codec != nil {
		ok := object.Key("Codec")
		ok.String(*v.Codec)
	}

	if v.CodecOptions != nil {
		ok := object.Key("CodecOptions")
		if err := awsRestjson1_serializeDocumentAudioCodecOptions(v.CodecOptions, ok); err != nil {
			return err
		}
	}

	if v.SampleRate != nil {
		ok := object.Key("SampleRate")
		ok.String(*v.SampleRate)
	}

	return nil
}

func awsRestjson1_serializeDocumentCaptionFormat(v *types.CaptionFormat, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Encryption != nil {
		ok := object.Key("Encryption")
		if err := awsRestjson1_serializeDocumentEncryption(v.Encryption, ok); err != nil {
			return err
		}
	}

	if v.Format != nil {
		ok := object.Key("Format")
		ok.String(*v.Format)
	}

	if v.Pattern != nil {
		ok := object.Key("Pattern")
		ok.String(*v.Pattern)
	}

	return nil
}

func awsRestjson1_serializeDocumentCaptionFormats(v []types.CaptionFormat, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCaptionFormat(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCaptions(v *types.Captions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CaptionFormats != nil {
		ok := object.Key("CaptionFormats")
		if err := awsRestjson1_serializeDocumentCaptionFormats(v.CaptionFormats, ok); err != nil {
			return err
		}
	}

	if v.CaptionSources != nil {
		ok := object.Key("CaptionSources")
		if err := awsRestjson1_serializeDocumentCaptionSources(v.CaptionSources, ok); err != nil {
			return err
		}
	}

	if v.MergePolicy != nil {
		ok := object.Key("MergePolicy")
		ok.String(*v.MergePolicy)
	}

	return nil
}

func awsRestjson1_serializeDocumentCaptionSource(v *types.CaptionSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Encryption != nil {
		ok := object.Key("Encryption")
		if err := awsRestjson1_serializeDocumentEncryption(v.Encryption, ok); err != nil {
			return err
		}
	}

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Label != nil {
		ok := object.Key("Label")
		ok.String(*v.Label)
	}

	if v.Language != nil {
		ok := object.Key("Language")
		ok.String(*v.Language)
	}

	if v.TimeOffset != nil {
		ok := object.Key("TimeOffset")
		ok.String(*v.TimeOffset)
	}

	return nil
}

func awsRestjson1_serializeDocumentCaptionSources(v []types.CaptionSource, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCaptionSource(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentClip(v *types.Clip, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TimeSpan != nil {
		ok := object.Key("TimeSpan")
		if err := awsRestjson1_serializeDocumentTimeSpan(v.TimeSpan, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCodecOptions(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentComposition(v []types.Clip, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentClip(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCreateJobOutput(v *types.CreateJobOutput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AlbumArt != nil {
		ok := object.Key("AlbumArt")
		if err := awsRestjson1_serializeDocumentJobAlbumArt(v.AlbumArt, ok); err != nil {
			return err
		}
	}

	if v.Captions != nil {
		ok := object.Key("Captions")
		if err := awsRestjson1_serializeDocumentCaptions(v.Captions, ok); err != nil {
			return err
		}
	}

	if v.Composition != nil {
		ok := object.Key("Composition")
		if err := awsRestjson1_serializeDocumentComposition(v.Composition, ok); err != nil {
			return err
		}
	}

	if v.Encryption != nil {
		ok := object.Key("Encryption")
		if err := awsRestjson1_serializeDocumentEncryption(v.Encryption, ok); err != nil {
			return err
		}
	}

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.PresetId != nil {
		ok := object.Key("PresetId")
		ok.String(*v.PresetId)
	}

	if v.Rotate != nil {
		ok := object.Key("Rotate")
		ok.String(*v.Rotate)
	}

	if v.SegmentDuration != nil {
		ok := object.Key("SegmentDuration")
		ok.String(*v.SegmentDuration)
	}

	if v.ThumbnailEncryption != nil {
		ok := object.Key("ThumbnailEncryption")
		if err := awsRestjson1_serializeDocumentEncryption(v.ThumbnailEncryption, ok); err != nil {
			return err
		}
	}

	if v.ThumbnailPattern != nil {
		ok := object.Key("ThumbnailPattern")
		ok.String(*v.ThumbnailPattern)
	}

	if v.Watermarks != nil {
		ok := object.Key("Watermarks")
		if err := awsRestjson1_serializeDocumentJobWatermarks(v.Watermarks, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateJobOutputs(v []types.CreateJobOutput, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCreateJobOutput(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCreateJobPlaylist(v *types.CreateJobPlaylist, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Format != nil {
		ok := object.Key("Format")
		ok.String(*v.Format)
	}

	if v.HlsContentProtection != nil {
		ok := object.Key("HlsContentProtection")
		if err := awsRestjson1_serializeDocumentHlsContentProtection(v.HlsContentProtection, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OutputKeys != nil {
		ok := object.Key("OutputKeys")
		if err := awsRestjson1_serializeDocumentOutputKeys(v.OutputKeys, ok); err != nil {
			return err
		}
	}

	if v.PlayReadyDrm != nil {
		ok := object.Key("PlayReadyDrm")
		if err := awsRestjson1_serializeDocumentPlayReadyDrm(v.PlayReadyDrm, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateJobPlaylists(v []types.CreateJobPlaylist, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCreateJobPlaylist(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDetectedProperties(v *types.DetectedProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DurationMillis != nil {
		ok := object.Key("DurationMillis")
		ok.Long(*v.DurationMillis)
	}

	if v.FileSize != nil {
		ok := object.Key("FileSize")
		ok.Long(*v.FileSize)
	}

	if v.FrameRate != nil {
		ok := object.Key("FrameRate")
		ok.String(*v.FrameRate)
	}

	if v.Height != nil {
		ok := object.Key("Height")
		ok.Integer(*v.Height)
	}

	if v.Width != nil {
		ok := object.Key("Width")
		ok.Integer(*v.Width)
	}

	return nil
}

func awsRestjson1_serializeDocumentEncryption(v *types.Encryption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InitializationVector != nil {
		ok := object.Key("InitializationVector")
		ok.String(*v.InitializationVector)
	}

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.KeyMd5 != nil {
		ok := object.Key("KeyMd5")
		ok.String(*v.KeyMd5)
	}

	if v.Mode != nil {
		ok := object.Key("Mode")
		ok.String(*v.Mode)
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsContentProtection(v *types.HlsContentProtection, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InitializationVector != nil {
		ok := object.Key("InitializationVector")
		ok.String(*v.InitializationVector)
	}

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.KeyMd5 != nil {
		ok := object.Key("KeyMd5")
		ok.String(*v.KeyMd5)
	}

	if v.KeyStoragePolicy != nil {
		ok := object.Key("KeyStoragePolicy")
		ok.String(*v.KeyStoragePolicy)
	}

	if v.LicenseAcquisitionUrl != nil {
		ok := object.Key("LicenseAcquisitionUrl")
		ok.String(*v.LicenseAcquisitionUrl)
	}

	if v.Method != nil {
		ok := object.Key("Method")
		ok.String(*v.Method)
	}

	return nil
}

func awsRestjson1_serializeDocumentInputCaptions(v *types.InputCaptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CaptionSources != nil {
		ok := object.Key("CaptionSources")
		if err := awsRestjson1_serializeDocumentCaptionSources(v.CaptionSources, ok); err != nil {
			return err
		}
	}

	if v.MergePolicy != nil {
		ok := object.Key("MergePolicy")
		ok.String(*v.MergePolicy)
	}

	return nil
}

func awsRestjson1_serializeDocumentJobAlbumArt(v *types.JobAlbumArt, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Artwork != nil {
		ok := object.Key("Artwork")
		if err := awsRestjson1_serializeDocumentArtworks(v.Artwork, ok); err != nil {
			return err
		}
	}

	if v.MergePolicy != nil {
		ok := object.Key("MergePolicy")
		ok.String(*v.MergePolicy)
	}

	return nil
}

func awsRestjson1_serializeDocumentJobInput(v *types.JobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AspectRatio != nil {
		ok := object.Key("AspectRatio")
		ok.String(*v.AspectRatio)
	}

	if v.Container != nil {
		ok := object.Key("Container")
		ok.String(*v.Container)
	}

	if v.DetectedProperties != nil {
		ok := object.Key("DetectedProperties")
		if err := awsRestjson1_serializeDocumentDetectedProperties(v.DetectedProperties, ok); err != nil {
			return err
		}
	}

	if v.Encryption != nil {
		ok := object.Key("Encryption")
		if err := awsRestjson1_serializeDocumentEncryption(v.Encryption, ok); err != nil {
			return err
		}
	}

	if v.FrameRate != nil {
		ok := object.Key("FrameRate")
		ok.String(*v.FrameRate)
	}

	if v.InputCaptions != nil {
		ok := object.Key("InputCaptions")
		if err := awsRestjson1_serializeDocumentInputCaptions(v.InputCaptions, ok); err != nil {
			return err
		}
	}

	if v.Interlaced != nil {
		ok := object.Key("Interlaced")
		ok.String(*v.Interlaced)
	}

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Resolution != nil {
		ok := object.Key("Resolution")
		ok.String(*v.Resolution)
	}

	if v.TimeSpan != nil {
		ok := object.Key("TimeSpan")
		if err := awsRestjson1_serializeDocumentTimeSpan(v.TimeSpan, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentJobInputs(v []types.JobInput, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentJobInput(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentJobWatermark(v *types.JobWatermark, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Encryption != nil {
		ok := object.Key("Encryption")
		if err := awsRestjson1_serializeDocumentEncryption(v.Encryption, ok); err != nil {
			return err
		}
	}

	if v.InputKey != nil {
		ok := object.Key("InputKey")
		ok.String(*v.InputKey)
	}

	if v.PresetWatermarkId != nil {
		ok := object.Key("PresetWatermarkId")
		ok.String(*v.PresetWatermarkId)
	}

	return nil
}

func awsRestjson1_serializeDocumentJobWatermarks(v []types.JobWatermark, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentJobWatermark(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentNotifications(v *types.Notifications, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Completed != nil {
		ok := object.Key("Completed")
		ok.String(*v.Completed)
	}

	if v.Error != nil {
		ok := object.Key("Error")
		ok.String(*v.Error)
	}

	if v.Progressing != nil {
		ok := object.Key("Progressing")
		ok.String(*v.Progressing)
	}

	if v.Warning != nil {
		ok := object.Key("Warning")
		ok.String(*v.Warning)
	}

	return nil
}

func awsRestjson1_serializeDocumentOutputKeys(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentPermission(v *types.Permission, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Access != nil {
		ok := object.Key("Access")
		if err := awsRestjson1_serializeDocumentAccessControls(v.Access, ok); err != nil {
			return err
		}
	}

	if v.Grantee != nil {
		ok := object.Key("Grantee")
		ok.String(*v.Grantee)
	}

	if v.GranteeType != nil {
		ok := object.Key("GranteeType")
		ok.String(*v.GranteeType)
	}

	return nil
}

func awsRestjson1_serializeDocumentPermissions(v []types.Permission, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPermission(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPipelineOutputConfig(v *types.PipelineOutputConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("Bucket")
		ok.String(*v.Bucket)
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentPermissions(v.Permissions, ok); err != nil {
			return err
		}
	}

	if v.StorageClass != nil {
		ok := object.Key("StorageClass")
		ok.String(*v.StorageClass)
	}

	return nil
}

func awsRestjson1_serializeDocumentPlayReadyDrm(v *types.PlayReadyDrm, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Format != nil {
		ok := object.Key("Format")
		ok.String(*v.Format)
	}

	if v.InitializationVector != nil {
		ok := object.Key("InitializationVector")
		ok.String(*v.InitializationVector)
	}

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.KeyId != nil {
		ok := object.Key("KeyId")
		ok.String(*v.KeyId)
	}

	if v.KeyMd5 != nil {
		ok := object.Key("KeyMd5")
		ok.String(*v.KeyMd5)
	}

	if v.LicenseAcquisitionUrl != nil {
		ok := object.Key("LicenseAcquisitionUrl")
		ok.String(*v.LicenseAcquisitionUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentPresetWatermark(v *types.PresetWatermark, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HorizontalAlign != nil {
		ok := object.Key("HorizontalAlign")
		ok.String(*v.HorizontalAlign)
	}

	if v.HorizontalOffset != nil {
		ok := object.Key("HorizontalOffset")
		ok.String(*v.HorizontalOffset)
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.MaxHeight != nil {
		ok := object.Key("MaxHeight")
		ok.String(*v.MaxHeight)
	}

	if v.MaxWidth != nil {
		ok := object.Key("MaxWidth")
		ok.String(*v.MaxWidth)
	}

	if v.Opacity != nil {
		ok := object.Key("Opacity")
		ok.String(*v.Opacity)
	}

	if v.SizingPolicy != nil {
		ok := object.Key("SizingPolicy")
		ok.String(*v.SizingPolicy)
	}

	if v.Target != nil {
		ok := object.Key("Target")
		ok.String(*v.Target)
	}

	if v.VerticalAlign != nil {
		ok := object.Key("VerticalAlign")
		ok.String(*v.VerticalAlign)
	}

	if v.VerticalOffset != nil {
		ok := object.Key("VerticalOffset")
		ok.String(*v.VerticalOffset)
	}

	return nil
}

func awsRestjson1_serializeDocumentPresetWatermarks(v []types.PresetWatermark, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPresetWatermark(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSnsTopics(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentThumbnails(v *types.Thumbnails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AspectRatio != nil {
		ok := object.Key("AspectRatio")
		ok.String(*v.AspectRatio)
	}

	if v.Format != nil {
		ok := object.Key("Format")
		ok.String(*v.Format)
	}

	if v.Interval != nil {
		ok := object.Key("Interval")
		ok.String(*v.Interval)
	}

	if v.MaxHeight != nil {
		ok := object.Key("MaxHeight")
		ok.String(*v.MaxHeight)
	}

	if v.MaxWidth != nil {
		ok := object.Key("MaxWidth")
		ok.String(*v.MaxWidth)
	}

	if v.PaddingPolicy != nil {
		ok := object.Key("PaddingPolicy")
		ok.String(*v.PaddingPolicy)
	}

	if v.Resolution != nil {
		ok := object.Key("Resolution")
		ok.String(*v.Resolution)
	}

	if v.SizingPolicy != nil {
		ok := object.Key("SizingPolicy")
		ok.String(*v.SizingPolicy)
	}

	return nil
}

func awsRestjson1_serializeDocumentTimeSpan(v *types.TimeSpan, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Duration != nil {
		ok := object.Key("Duration")
		ok.String(*v.Duration)
	}

	if v.StartTime != nil {
		ok := object.Key("StartTime")
		ok.String(*v.StartTime)
	}

	return nil
}

func awsRestjson1_serializeDocumentUserMetadata(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentVideoParameters(v *types.VideoParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AspectRatio != nil {
		ok := object.Key("AspectRatio")
		ok.String(*v.AspectRatio)
	}

	if v.BitRate != nil {
		ok := object.Key("BitRate")
		ok.String(*v.BitRate)
	}

	if v.Codec != nil {
		ok := object.Key("Codec")
		ok.String(*v.Codec)
	}

	if v.CodecOptions != nil {
		ok := object.Key("CodecOptions")
		if err := awsRestjson1_serializeDocumentCodecOptions(v.CodecOptions, ok); err != nil {
			return err
		}
	}

	if v.DisplayAspectRatio != nil {
		ok := object.Key("DisplayAspectRatio")
		ok.String(*v.DisplayAspectRatio)
	}

	if v.FixedGOP != nil {
		ok := object.Key("FixedGOP")
		ok.String(*v.FixedGOP)
	}

	if v.FrameRate != nil {
		ok := object.Key("FrameRate")
		ok.String(*v.FrameRate)
	}

	if v.KeyframesMaxDist != nil {
		ok := object.Key("KeyframesMaxDist")
		ok.String(*v.KeyframesMaxDist)
	}

	if v.MaxFrameRate != nil {
		ok := object.Key("MaxFrameRate")
		ok.String(*v.MaxFrameRate)
	}

	if v.MaxHeight != nil {
		ok := object.Key("MaxHeight")
		ok.String(*v.MaxHeight)
	}

	if v.MaxWidth != nil {
		ok := object.Key("MaxWidth")
		ok.String(*v.MaxWidth)
	}

	if v.PaddingPolicy != nil {
		ok := object.Key("PaddingPolicy")
		ok.String(*v.PaddingPolicy)
	}

	if v.Resolution != nil {
		ok := object.Key("Resolution")
		ok.String(*v.Resolution)
	}

	if v.SizingPolicy != nil {
		ok := object.Key("SizingPolicy")
		ok.String(*v.SizingPolicy)
	}

	if v.Watermarks != nil {
		ok := object.Key("Watermarks")
		if err := awsRestjson1_serializeDocumentPresetWatermarks(v.Watermarks, ok); err != nil {
			return err
		}
	}

	return nil
}
