// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfront

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Associates an alias (also known as a CNAME or an alternate domain name) with a
// CloudFront distribution. With this operation you can move an alias that’s
// already in use on a CloudFront distribution to a different distribution in one
// step. This prevents the downtime that could occur if you first remove the alias
// from one distribution and then separately add the alias to another distribution.
// To use this operation to associate an alias with a distribution, you provide the
// alias and the ID of the target distribution for the alias. For more information,
// including how to set up the target distribution, prerequisites that you must
// complete, and other restrictions, see Moving an alternate domain name to a
// different distribution
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move)
// in the Amazon CloudFront Developer Guide.
func (c *Client) AssociateAlias(ctx context.Context, params *AssociateAliasInput, optFns ...func(*Options)) (*AssociateAliasOutput, error) {
	if params == nil {
		params = &AssociateAliasInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AssociateAlias", params, optFns, c.addOperationAssociateAliasMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AssociateAliasOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AssociateAliasInput struct {

	// The alias (also known as a CNAME) to add to the target distribution.
	//
	// This member is required.
	Alias *string

	// The ID of the distribution that you’re associating the alias with.
	//
	// This member is required.
	TargetDistributionId *string

	noSmithyDocumentSerde
}

type AssociateAliasOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAssociateAliasMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestxml_serializeOpAssociateAlias{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpAssociateAlias{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpAssociateAliasValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAssociateAlias(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opAssociateAlias(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "cloudfront",
		OperationName: "AssociateAlias",
	}
}
