// Code generated by smithy-go-codegen DO NOT EDIT.

package clouddirectory

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/clouddirectory/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpAddFacetToObject struct {
}

func (*awsRestjson1_serializeOpAddFacetToObject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAddFacetToObject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddFacetToObjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/object/facets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAddFacetToObjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAddFacetToObjectInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAddFacetToObjectInput(v *AddFacetToObjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAddFacetToObjectInput(v *AddFacetToObjectInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ObjectAttributeList != nil {
		ok := object.Key("ObjectAttributeList")
		if err := awsRestjson1_serializeDocumentAttributeKeyAndValueList(v.ObjectAttributeList, ok); err != nil {
			return err
		}
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	if v.SchemaFacet != nil {
		ok := object.Key("SchemaFacet")
		if err := awsRestjson1_serializeDocumentSchemaFacet(v.SchemaFacet, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpApplySchema struct {
}

func (*awsRestjson1_serializeOpApplySchema) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpApplySchema) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ApplySchemaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/schema/apply")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsApplySchemaInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentApplySchemaInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsApplySchemaInput(v *ApplySchemaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentApplySchemaInput(v *ApplySchemaInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PublishedSchemaArn != nil {
		ok := object.Key("PublishedSchemaArn")
		ok.String(*v.PublishedSchemaArn)
	}

	return nil
}

type awsRestjson1_serializeOpAttachObject struct {
}

func (*awsRestjson1_serializeOpAttachObject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAttachObject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AttachObjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/object/attach")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAttachObjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAttachObjectInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAttachObjectInput(v *AttachObjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAttachObjectInput(v *AttachObjectInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChildReference != nil {
		ok := object.Key("ChildReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ChildReference, ok); err != nil {
			return err
		}
	}

	if v.LinkName != nil {
		ok := object.Key("LinkName")
		ok.String(*v.LinkName)
	}

	if v.ParentReference != nil {
		ok := object.Key("ParentReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ParentReference, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAttachPolicy struct {
}

func (*awsRestjson1_serializeOpAttachPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAttachPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AttachPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/policy/attach")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAttachPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAttachPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAttachPolicyInput(v *AttachPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAttachPolicyInput(v *AttachPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	if v.PolicyReference != nil {
		ok := object.Key("PolicyReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.PolicyReference, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAttachToIndex struct {
}

func (*awsRestjson1_serializeOpAttachToIndex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAttachToIndex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AttachToIndexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/index/attach")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAttachToIndexInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAttachToIndexInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAttachToIndexInput(v *AttachToIndexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAttachToIndexInput(v *AttachToIndexInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IndexReference != nil {
		ok := object.Key("IndexReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.IndexReference, ok); err != nil {
			return err
		}
	}

	if v.TargetReference != nil {
		ok := object.Key("TargetReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.TargetReference, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAttachTypedLink struct {
}

func (*awsRestjson1_serializeOpAttachTypedLink) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAttachTypedLink) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AttachTypedLinkInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/typedlink/attach")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAttachTypedLinkInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAttachTypedLinkInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAttachTypedLinkInput(v *AttachTypedLinkInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAttachTypedLinkInput(v *AttachTypedLinkInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsRestjson1_serializeDocumentAttributeNameAndValueList(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.SourceObjectReference != nil {
		ok := object.Key("SourceObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.SourceObjectReference, ok); err != nil {
			return err
		}
	}

	if v.TargetObjectReference != nil {
		ok := object.Key("TargetObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.TargetObjectReference, ok); err != nil {
			return err
		}
	}

	if v.TypedLinkFacet != nil {
		ok := object.Key("TypedLinkFacet")
		if err := awsRestjson1_serializeDocumentTypedLinkSchemaAndFacetName(v.TypedLinkFacet, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchRead struct {
}

func (*awsRestjson1_serializeOpBatchRead) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchRead) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchReadInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/batchread")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchReadInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchReadInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchReadInput(v *BatchReadInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ConsistencyLevel) > 0 {
		locationName := "X-Amz-Consistency-Level"
		encoder.SetHeader(locationName).String(string(v.ConsistencyLevel))
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchReadInput(v *BatchReadInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Operations != nil {
		ok := object.Key("Operations")
		if err := awsRestjson1_serializeDocumentBatchReadOperationList(v.Operations, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchWrite struct {
}

func (*awsRestjson1_serializeOpBatchWrite) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchWrite) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchWriteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/batchwrite")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchWriteInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchWriteInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchWriteInput(v *BatchWriteInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchWriteInput(v *BatchWriteInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Operations != nil {
		ok := object.Key("Operations")
		if err := awsRestjson1_serializeDocumentBatchWriteOperationList(v.Operations, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateDirectory struct {
}

func (*awsRestjson1_serializeOpCreateDirectory) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDirectory) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDirectoryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/directory/create")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateDirectoryInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDirectoryInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDirectoryInput(v *CreateDirectoryInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SchemaArn != nil && len(*v.SchemaArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.SchemaArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDirectoryInput(v *CreateDirectoryInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpCreateFacet struct {
}

func (*awsRestjson1_serializeOpCreateFacet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateFacet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFacetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/facet/create")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateFacetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateFacetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateFacetInput(v *CreateFacetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SchemaArn != nil && len(*v.SchemaArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.SchemaArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateFacetInput(v *CreateFacetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsRestjson1_serializeDocumentFacetAttributeList(v.Attributes, ok); err != nil {
			return err
		}
	}

	if len(v.FacetStyle) > 0 {
		ok := object.Key("FacetStyle")
		ok.String(string(v.FacetStyle))
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.ObjectType) > 0 {
		ok := object.Key("ObjectType")
		ok.String(string(v.ObjectType))
	}

	return nil
}

type awsRestjson1_serializeOpCreateIndex struct {
}

func (*awsRestjson1_serializeOpCreateIndex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateIndex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateIndexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/index")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateIndexInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateIndexInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateIndexInput(v *CreateIndexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateIndexInput(v *CreateIndexInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("IsUnique")
		ok.Boolean(v.IsUnique)
	}

	if v.LinkName != nil {
		ok := object.Key("LinkName")
		ok.String(*v.LinkName)
	}

	if v.OrderedIndexedAttributeList != nil {
		ok := object.Key("OrderedIndexedAttributeList")
		if err := awsRestjson1_serializeDocumentAttributeKeyList(v.OrderedIndexedAttributeList, ok); err != nil {
			return err
		}
	}

	if v.ParentReference != nil {
		ok := object.Key("ParentReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ParentReference, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateObject struct {
}

func (*awsRestjson1_serializeOpCreateObject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateObject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateObjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/object")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateObjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateObjectInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateObjectInput(v *CreateObjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateObjectInput(v *CreateObjectInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LinkName != nil {
		ok := object.Key("LinkName")
		ok.String(*v.LinkName)
	}

	if v.ObjectAttributeList != nil {
		ok := object.Key("ObjectAttributeList")
		if err := awsRestjson1_serializeDocumentAttributeKeyAndValueList(v.ObjectAttributeList, ok); err != nil {
			return err
		}
	}

	if v.ParentReference != nil {
		ok := object.Key("ParentReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ParentReference, ok); err != nil {
			return err
		}
	}

	if v.SchemaFacets != nil {
		ok := object.Key("SchemaFacets")
		if err := awsRestjson1_serializeDocumentSchemaFacetList(v.SchemaFacets, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateSchema struct {
}

func (*awsRestjson1_serializeOpCreateSchema) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateSchema) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSchemaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/schema/create")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateSchemaInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateSchemaInput(v *CreateSchemaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateSchemaInput(v *CreateSchemaInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpCreateTypedLinkFacet struct {
}

func (*awsRestjson1_serializeOpCreateTypedLinkFacet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateTypedLinkFacet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTypedLinkFacetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/typedlink/facet/create")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateTypedLinkFacetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateTypedLinkFacetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateTypedLinkFacetInput(v *CreateTypedLinkFacetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SchemaArn != nil && len(*v.SchemaArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.SchemaArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateTypedLinkFacetInput(v *CreateTypedLinkFacetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Facet != nil {
		ok := object.Key("Facet")
		if err := awsRestjson1_serializeDocumentTypedLinkFacet(v.Facet, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDirectory struct {
}

func (*awsRestjson1_serializeOpDeleteDirectory) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDirectory) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDirectoryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/directory")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDirectoryInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDirectoryInput(v *DeleteDirectoryInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteFacet struct {
}

func (*awsRestjson1_serializeOpDeleteFacet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteFacet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFacetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/facet/delete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteFacetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteFacetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteFacetInput(v *DeleteFacetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SchemaArn != nil && len(*v.SchemaArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.SchemaArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteFacetInput(v *DeleteFacetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteObject struct {
}

func (*awsRestjson1_serializeOpDeleteObject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteObject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteObjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/object/delete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteObjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteObjectInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteObjectInput(v *DeleteObjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteObjectInput(v *DeleteObjectInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteSchema struct {
}

func (*awsRestjson1_serializeOpDeleteSchema) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteSchema) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSchemaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/schema")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteSchemaInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteSchemaInput(v *DeleteSchemaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SchemaArn != nil && len(*v.SchemaArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.SchemaArn)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteTypedLinkFacet struct {
}

func (*awsRestjson1_serializeOpDeleteTypedLinkFacet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteTypedLinkFacet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTypedLinkFacetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/typedlink/facet/delete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteTypedLinkFacetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteTypedLinkFacetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteTypedLinkFacetInput(v *DeleteTypedLinkFacetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SchemaArn != nil && len(*v.SchemaArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.SchemaArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteTypedLinkFacetInput(v *DeleteTypedLinkFacetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpDetachFromIndex struct {
}

func (*awsRestjson1_serializeOpDetachFromIndex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDetachFromIndex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachFromIndexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/index/detach")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDetachFromIndexInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDetachFromIndexInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDetachFromIndexInput(v *DetachFromIndexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDetachFromIndexInput(v *DetachFromIndexInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IndexReference != nil {
		ok := object.Key("IndexReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.IndexReference, ok); err != nil {
			return err
		}
	}

	if v.TargetReference != nil {
		ok := object.Key("TargetReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.TargetReference, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDetachObject struct {
}

func (*awsRestjson1_serializeOpDetachObject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDetachObject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachObjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/object/detach")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDetachObjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDetachObjectInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDetachObjectInput(v *DetachObjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDetachObjectInput(v *DetachObjectInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LinkName != nil {
		ok := object.Key("LinkName")
		ok.String(*v.LinkName)
	}

	if v.ParentReference != nil {
		ok := object.Key("ParentReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ParentReference, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDetachPolicy struct {
}

func (*awsRestjson1_serializeOpDetachPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDetachPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/policy/detach")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDetachPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDetachPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDetachPolicyInput(v *DetachPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDetachPolicyInput(v *DetachPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	if v.PolicyReference != nil {
		ok := object.Key("PolicyReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.PolicyReference, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDetachTypedLink struct {
}

func (*awsRestjson1_serializeOpDetachTypedLink) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDetachTypedLink) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachTypedLinkInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/typedlink/detach")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDetachTypedLinkInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDetachTypedLinkInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDetachTypedLinkInput(v *DetachTypedLinkInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDetachTypedLinkInput(v *DetachTypedLinkInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TypedLinkSpecifier != nil {
		ok := object.Key("TypedLinkSpecifier")
		if err := awsRestjson1_serializeDocumentTypedLinkSpecifier(v.TypedLinkSpecifier, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisableDirectory struct {
}

func (*awsRestjson1_serializeOpDisableDirectory) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisableDirectory) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisableDirectoryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/directory/disable")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisableDirectoryInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisableDirectoryInput(v *DisableDirectoryInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

type awsRestjson1_serializeOpEnableDirectory struct {
}

func (*awsRestjson1_serializeOpEnableDirectory) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpEnableDirectory) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableDirectoryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/directory/enable")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsEnableDirectoryInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsEnableDirectoryInput(v *EnableDirectoryInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

type awsRestjson1_serializeOpGetAppliedSchemaVersion struct {
}

func (*awsRestjson1_serializeOpGetAppliedSchemaVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetAppliedSchemaVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAppliedSchemaVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/schema/getappliedschema")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetAppliedSchemaVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetAppliedSchemaVersionInput(v *GetAppliedSchemaVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetAppliedSchemaVersionInput(v *GetAppliedSchemaVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SchemaArn != nil {
		ok := object.Key("SchemaArn")
		ok.String(*v.SchemaArn)
	}

	return nil
}

type awsRestjson1_serializeOpGetDirectory struct {
}

func (*awsRestjson1_serializeOpGetDirectory) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDirectory) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDirectoryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/directory/get")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDirectoryInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDirectoryInput(v *GetDirectoryInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

type awsRestjson1_serializeOpGetFacet struct {
}

func (*awsRestjson1_serializeOpGetFacet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetFacet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFacetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/facet")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetFacetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetFacetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetFacetInput(v *GetFacetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SchemaArn != nil && len(*v.SchemaArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.SchemaArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetFacetInput(v *GetFacetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpGetLinkAttributes struct {
}

func (*awsRestjson1_serializeOpGetLinkAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetLinkAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetLinkAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/typedlink/attributes/get")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetLinkAttributesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetLinkAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetLinkAttributesInput(v *GetLinkAttributesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetLinkAttributesInput(v *GetLinkAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeNames != nil {
		ok := object.Key("AttributeNames")
		if err := awsRestjson1_serializeDocumentAttributeNameList(v.AttributeNames, ok); err != nil {
			return err
		}
	}

	if len(v.ConsistencyLevel) > 0 {
		ok := object.Key("ConsistencyLevel")
		ok.String(string(v.ConsistencyLevel))
	}

	if v.TypedLinkSpecifier != nil {
		ok := object.Key("TypedLinkSpecifier")
		if err := awsRestjson1_serializeDocumentTypedLinkSpecifier(v.TypedLinkSpecifier, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetObjectAttributes struct {
}

func (*awsRestjson1_serializeOpGetObjectAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetObjectAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetObjectAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/object/attributes/get")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetObjectAttributesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetObjectAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetObjectAttributesInput(v *GetObjectAttributesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ConsistencyLevel) > 0 {
		locationName := "X-Amz-Consistency-Level"
		encoder.SetHeader(locationName).String(string(v.ConsistencyLevel))
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetObjectAttributesInput(v *GetObjectAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeNames != nil {
		ok := object.Key("AttributeNames")
		if err := awsRestjson1_serializeDocumentAttributeNameList(v.AttributeNames, ok); err != nil {
			return err
		}
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	if v.SchemaFacet != nil {
		ok := object.Key("SchemaFacet")
		if err := awsRestjson1_serializeDocumentSchemaFacet(v.SchemaFacet, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetObjectInformation struct {
}

func (*awsRestjson1_serializeOpGetObjectInformation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetObjectInformation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetObjectInformationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/object/information")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetObjectInformationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetObjectInformationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetObjectInformationInput(v *GetObjectInformationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ConsistencyLevel) > 0 {
		locationName := "X-Amz-Consistency-Level"
		encoder.SetHeader(locationName).String(string(v.ConsistencyLevel))
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetObjectInformationInput(v *GetObjectInformationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetSchemaAsJson struct {
}

func (*awsRestjson1_serializeOpGetSchemaAsJson) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSchemaAsJson) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSchemaAsJsonInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/schema/json")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetSchemaAsJsonInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSchemaAsJsonInput(v *GetSchemaAsJsonInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SchemaArn != nil && len(*v.SchemaArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.SchemaArn)
	}

	return nil
}

type awsRestjson1_serializeOpGetTypedLinkFacetInformation struct {
}

func (*awsRestjson1_serializeOpGetTypedLinkFacetInformation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetTypedLinkFacetInformation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTypedLinkFacetInformationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/typedlink/facet/get")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetTypedLinkFacetInformationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetTypedLinkFacetInformationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetTypedLinkFacetInformationInput(v *GetTypedLinkFacetInformationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SchemaArn != nil && len(*v.SchemaArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.SchemaArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetTypedLinkFacetInformationInput(v *GetTypedLinkFacetInformationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpListAppliedSchemaArns struct {
}

func (*awsRestjson1_serializeOpListAppliedSchemaArns) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAppliedSchemaArns) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAppliedSchemaArnsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/schema/applied")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListAppliedSchemaArnsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAppliedSchemaArnsInput(v *ListAppliedSchemaArnsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListAppliedSchemaArnsInput(v *ListAppliedSchemaArnsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DirectoryArn != nil {
		ok := object.Key("DirectoryArn")
		ok.String(*v.DirectoryArn)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.SchemaArn != nil {
		ok := object.Key("SchemaArn")
		ok.String(*v.SchemaArn)
	}

	return nil
}

type awsRestjson1_serializeOpListAttachedIndices struct {
}

func (*awsRestjson1_serializeOpListAttachedIndices) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAttachedIndices) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAttachedIndicesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/object/indices")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAttachedIndicesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListAttachedIndicesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAttachedIndicesInput(v *ListAttachedIndicesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ConsistencyLevel) > 0 {
		locationName := "X-Amz-Consistency-Level"
		encoder.SetHeader(locationName).String(string(v.ConsistencyLevel))
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListAttachedIndicesInput(v *ListAttachedIndicesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.TargetReference != nil {
		ok := object.Key("TargetReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.TargetReference, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListDevelopmentSchemaArns struct {
}

func (*awsRestjson1_serializeOpListDevelopmentSchemaArns) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDevelopmentSchemaArns) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDevelopmentSchemaArnsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/schema/development")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListDevelopmentSchemaArnsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDevelopmentSchemaArnsInput(v *ListDevelopmentSchemaArnsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListDevelopmentSchemaArnsInput(v *ListDevelopmentSchemaArnsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDirectories struct {
}

func (*awsRestjson1_serializeOpListDirectories) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDirectories) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDirectoriesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/directory/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListDirectoriesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDirectoriesInput(v *ListDirectoriesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListDirectoriesInput(v *ListDirectoriesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

type awsRestjson1_serializeOpListFacetAttributes struct {
}

func (*awsRestjson1_serializeOpListFacetAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFacetAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFacetAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/facet/attributes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListFacetAttributesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListFacetAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFacetAttributesInput(v *ListFacetAttributesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SchemaArn != nil && len(*v.SchemaArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.SchemaArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListFacetAttributesInput(v *ListFacetAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListFacetNames struct {
}

func (*awsRestjson1_serializeOpListFacetNames) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFacetNames) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFacetNamesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/facet/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListFacetNamesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListFacetNamesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFacetNamesInput(v *ListFacetNamesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SchemaArn != nil && len(*v.SchemaArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.SchemaArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListFacetNamesInput(v *ListFacetNamesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListIncomingTypedLinks struct {
}

func (*awsRestjson1_serializeOpListIncomingTypedLinks) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListIncomingTypedLinks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIncomingTypedLinksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/typedlink/incoming")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListIncomingTypedLinksInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListIncomingTypedLinksInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListIncomingTypedLinksInput(v *ListIncomingTypedLinksInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListIncomingTypedLinksInput(v *ListIncomingTypedLinksInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ConsistencyLevel) > 0 {
		ok := object.Key("ConsistencyLevel")
		ok.String(string(v.ConsistencyLevel))
	}

	if v.FilterAttributeRanges != nil {
		ok := object.Key("FilterAttributeRanges")
		if err := awsRestjson1_serializeDocumentTypedLinkAttributeRangeList(v.FilterAttributeRanges, ok); err != nil {
			return err
		}
	}

	if v.FilterTypedLink != nil {
		ok := object.Key("FilterTypedLink")
		if err := awsRestjson1_serializeDocumentTypedLinkSchemaAndFacetName(v.FilterTypedLink, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListIndex struct {
}

func (*awsRestjson1_serializeOpListIndex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListIndex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIndexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/index/targets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListIndexInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListIndexInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListIndexInput(v *ListIndexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ConsistencyLevel) > 0 {
		locationName := "X-Amz-Consistency-Level"
		encoder.SetHeader(locationName).String(string(v.ConsistencyLevel))
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListIndexInput(v *ListIndexInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IndexReference != nil {
		ok := object.Key("IndexReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.IndexReference, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.RangesOnIndexedValues != nil {
		ok := object.Key("RangesOnIndexedValues")
		if err := awsRestjson1_serializeDocumentObjectAttributeRangeList(v.RangesOnIndexedValues, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListManagedSchemaArns struct {
}

func (*awsRestjson1_serializeOpListManagedSchemaArns) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListManagedSchemaArns) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListManagedSchemaArnsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/schema/managed")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListManagedSchemaArnsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListManagedSchemaArnsInput(v *ListManagedSchemaArnsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListManagedSchemaArnsInput(v *ListManagedSchemaArnsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.SchemaArn != nil {
		ok := object.Key("SchemaArn")
		ok.String(*v.SchemaArn)
	}

	return nil
}

type awsRestjson1_serializeOpListObjectAttributes struct {
}

func (*awsRestjson1_serializeOpListObjectAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListObjectAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListObjectAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/object/attributes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListObjectAttributesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListObjectAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListObjectAttributesInput(v *ListObjectAttributesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ConsistencyLevel) > 0 {
		locationName := "X-Amz-Consistency-Level"
		encoder.SetHeader(locationName).String(string(v.ConsistencyLevel))
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListObjectAttributesInput(v *ListObjectAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FacetFilter != nil {
		ok := object.Key("FacetFilter")
		if err := awsRestjson1_serializeDocumentSchemaFacet(v.FacetFilter, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListObjectChildren struct {
}

func (*awsRestjson1_serializeOpListObjectChildren) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListObjectChildren) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListObjectChildrenInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/object/children")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListObjectChildrenInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListObjectChildrenInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListObjectChildrenInput(v *ListObjectChildrenInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ConsistencyLevel) > 0 {
		locationName := "X-Amz-Consistency-Level"
		encoder.SetHeader(locationName).String(string(v.ConsistencyLevel))
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListObjectChildrenInput(v *ListObjectChildrenInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListObjectParentPaths struct {
}

func (*awsRestjson1_serializeOpListObjectParentPaths) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListObjectParentPaths) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListObjectParentPathsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/object/parentpaths")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListObjectParentPathsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListObjectParentPathsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListObjectParentPathsInput(v *ListObjectParentPathsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListObjectParentPathsInput(v *ListObjectParentPathsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListObjectParents struct {
}

func (*awsRestjson1_serializeOpListObjectParents) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListObjectParents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListObjectParentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/object/parent")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListObjectParentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListObjectParentsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListObjectParentsInput(v *ListObjectParentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ConsistencyLevel) > 0 {
		locationName := "X-Amz-Consistency-Level"
		encoder.SetHeader(locationName).String(string(v.ConsistencyLevel))
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListObjectParentsInput(v *ListObjectParentsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IncludeAllLinksToEachParent {
		ok := object.Key("IncludeAllLinksToEachParent")
		ok.Boolean(v.IncludeAllLinksToEachParent)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListObjectPolicies struct {
}

func (*awsRestjson1_serializeOpListObjectPolicies) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListObjectPolicies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListObjectPoliciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/object/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListObjectPoliciesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListObjectPoliciesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListObjectPoliciesInput(v *ListObjectPoliciesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ConsistencyLevel) > 0 {
		locationName := "X-Amz-Consistency-Level"
		encoder.SetHeader(locationName).String(string(v.ConsistencyLevel))
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListObjectPoliciesInput(v *ListObjectPoliciesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListOutgoingTypedLinks struct {
}

func (*awsRestjson1_serializeOpListOutgoingTypedLinks) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListOutgoingTypedLinks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListOutgoingTypedLinksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/typedlink/outgoing")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListOutgoingTypedLinksInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListOutgoingTypedLinksInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListOutgoingTypedLinksInput(v *ListOutgoingTypedLinksInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListOutgoingTypedLinksInput(v *ListOutgoingTypedLinksInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ConsistencyLevel) > 0 {
		ok := object.Key("ConsistencyLevel")
		ok.String(string(v.ConsistencyLevel))
	}

	if v.FilterAttributeRanges != nil {
		ok := object.Key("FilterAttributeRanges")
		if err := awsRestjson1_serializeDocumentTypedLinkAttributeRangeList(v.FilterAttributeRanges, ok); err != nil {
			return err
		}
	}

	if v.FilterTypedLink != nil {
		ok := object.Key("FilterTypedLink")
		if err := awsRestjson1_serializeDocumentTypedLinkSchemaAndFacetName(v.FilterTypedLink, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListPolicyAttachments struct {
}

func (*awsRestjson1_serializeOpListPolicyAttachments) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPolicyAttachments) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPolicyAttachmentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/policy/attachment")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPolicyAttachmentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListPolicyAttachmentsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPolicyAttachmentsInput(v *ListPolicyAttachmentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ConsistencyLevel) > 0 {
		locationName := "X-Amz-Consistency-Level"
		encoder.SetHeader(locationName).String(string(v.ConsistencyLevel))
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListPolicyAttachmentsInput(v *ListPolicyAttachmentsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.PolicyReference != nil {
		ok := object.Key("PolicyReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.PolicyReference, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListPublishedSchemaArns struct {
}

func (*awsRestjson1_serializeOpListPublishedSchemaArns) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPublishedSchemaArns) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPublishedSchemaArnsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/schema/published")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListPublishedSchemaArnsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPublishedSchemaArnsInput(v *ListPublishedSchemaArnsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListPublishedSchemaArnsInput(v *ListPublishedSchemaArnsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.SchemaArn != nil {
		ok := object.Key("SchemaArn")
		ok.String(*v.SchemaArn)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

type awsRestjson1_serializeOpListTypedLinkFacetAttributes struct {
}

func (*awsRestjson1_serializeOpListTypedLinkFacetAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTypedLinkFacetAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTypedLinkFacetAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/typedlink/facet/attributes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTypedLinkFacetAttributesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListTypedLinkFacetAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTypedLinkFacetAttributesInput(v *ListTypedLinkFacetAttributesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SchemaArn != nil && len(*v.SchemaArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.SchemaArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListTypedLinkFacetAttributesInput(v *ListTypedLinkFacetAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTypedLinkFacetNames struct {
}

func (*awsRestjson1_serializeOpListTypedLinkFacetNames) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTypedLinkFacetNames) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTypedLinkFacetNamesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/typedlink/facet/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTypedLinkFacetNamesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListTypedLinkFacetNamesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTypedLinkFacetNamesInput(v *ListTypedLinkFacetNamesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SchemaArn != nil && len(*v.SchemaArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.SchemaArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListTypedLinkFacetNamesInput(v *ListTypedLinkFacetNamesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpLookupPolicy struct {
}

func (*awsRestjson1_serializeOpLookupPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpLookupPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*LookupPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/policy/lookup")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsLookupPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentLookupPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsLookupPolicyInput(v *LookupPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentLookupPolicyInput(v *LookupPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPublishSchema struct {
}

func (*awsRestjson1_serializeOpPublishSchema) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPublishSchema) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PublishSchemaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/schema/publish")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPublishSchemaInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPublishSchemaInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPublishSchemaInput(v *PublishSchemaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DevelopmentSchemaArn != nil && len(*v.DevelopmentSchemaArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DevelopmentSchemaArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPublishSchemaInput(v *PublishSchemaInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MinorVersion != nil {
		ok := object.Key("MinorVersion")
		ok.String(*v.MinorVersion)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Version != nil {
		ok := object.Key("Version")
		ok.String(*v.Version)
	}

	return nil
}

type awsRestjson1_serializeOpPutSchemaFromJson struct {
}

func (*awsRestjson1_serializeOpPutSchemaFromJson) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutSchemaFromJson) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutSchemaFromJsonInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/schema/json")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutSchemaFromJsonInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutSchemaFromJsonInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutSchemaFromJsonInput(v *PutSchemaFromJsonInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SchemaArn != nil && len(*v.SchemaArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.SchemaArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutSchemaFromJsonInput(v *PutSchemaFromJsonInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Document != nil {
		ok := object.Key("Document")
		ok.String(*v.Document)
	}

	return nil
}

type awsRestjson1_serializeOpRemoveFacetFromObject struct {
}

func (*awsRestjson1_serializeOpRemoveFacetFromObject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRemoveFacetFromObject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveFacetFromObjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/object/facets/delete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRemoveFacetFromObjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRemoveFacetFromObjectInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRemoveFacetFromObjectInput(v *RemoveFacetFromObjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRemoveFacetFromObjectInput(v *RemoveFacetFromObjectInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	if v.SchemaFacet != nil {
		ok := object.Key("SchemaFacet")
		if err := awsRestjson1_serializeDocumentSchemaFacet(v.SchemaFacet, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/tags/add")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/tags/remove")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.TagKeys != nil {
		ok := object.Key("TagKeys")
		if err := awsRestjson1_serializeDocumentTagKeyList(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFacet struct {
}

func (*awsRestjson1_serializeOpUpdateFacet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFacet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFacetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/facet")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFacetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFacetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFacetInput(v *UpdateFacetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SchemaArn != nil && len(*v.SchemaArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.SchemaArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFacetInput(v *UpdateFacetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeUpdates != nil {
		ok := object.Key("AttributeUpdates")
		if err := awsRestjson1_serializeDocumentFacetAttributeUpdateList(v.AttributeUpdates, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.ObjectType) > 0 {
		ok := object.Key("ObjectType")
		ok.String(string(v.ObjectType))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateLinkAttributes struct {
}

func (*awsRestjson1_serializeOpUpdateLinkAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateLinkAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateLinkAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/typedlink/attributes/update")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateLinkAttributesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateLinkAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateLinkAttributesInput(v *UpdateLinkAttributesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateLinkAttributesInput(v *UpdateLinkAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeUpdates != nil {
		ok := object.Key("AttributeUpdates")
		if err := awsRestjson1_serializeDocumentLinkAttributeUpdateList(v.AttributeUpdates, ok); err != nil {
			return err
		}
	}

	if v.TypedLinkSpecifier != nil {
		ok := object.Key("TypedLinkSpecifier")
		if err := awsRestjson1_serializeDocumentTypedLinkSpecifier(v.TypedLinkSpecifier, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateObjectAttributes struct {
}

func (*awsRestjson1_serializeOpUpdateObjectAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateObjectAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateObjectAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/object/update")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateObjectAttributesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateObjectAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateObjectAttributesInput(v *UpdateObjectAttributesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryArn != nil && len(*v.DirectoryArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.DirectoryArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateObjectAttributesInput(v *UpdateObjectAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeUpdates != nil {
		ok := object.Key("AttributeUpdates")
		if err := awsRestjson1_serializeDocumentObjectAttributeUpdateList(v.AttributeUpdates, ok); err != nil {
			return err
		}
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateSchema struct {
}

func (*awsRestjson1_serializeOpUpdateSchema) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateSchema) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSchemaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/schema/update")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateSchemaInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateSchemaInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateSchemaInput(v *UpdateSchemaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SchemaArn != nil && len(*v.SchemaArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.SchemaArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateSchemaInput(v *UpdateSchemaInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateTypedLinkFacet struct {
}

func (*awsRestjson1_serializeOpUpdateTypedLinkFacet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateTypedLinkFacet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTypedLinkFacetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/typedlink/facet")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateTypedLinkFacetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateTypedLinkFacetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateTypedLinkFacetInput(v *UpdateTypedLinkFacetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SchemaArn != nil && len(*v.SchemaArn) > 0 {
		locationName := "X-Amz-Data-Partition"
		encoder.SetHeader(locationName).String(*v.SchemaArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateTypedLinkFacetInput(v *UpdateTypedLinkFacetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeUpdates != nil {
		ok := object.Key("AttributeUpdates")
		if err := awsRestjson1_serializeDocumentTypedLinkFacetAttributeUpdateList(v.AttributeUpdates, ok); err != nil {
			return err
		}
	}

	if v.IdentityAttributeOrder != nil {
		ok := object.Key("IdentityAttributeOrder")
		if err := awsRestjson1_serializeDocumentAttributeNameList(v.IdentityAttributeOrder, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpUpgradeAppliedSchema struct {
}

func (*awsRestjson1_serializeOpUpgradeAppliedSchema) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpgradeAppliedSchema) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpgradeAppliedSchemaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/schema/upgradeapplied")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpgradeAppliedSchemaInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpgradeAppliedSchemaInput(v *UpgradeAppliedSchemaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpgradeAppliedSchemaInput(v *UpgradeAppliedSchemaInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DirectoryArn != nil {
		ok := object.Key("DirectoryArn")
		ok.String(*v.DirectoryArn)
	}

	if v.DryRun {
		ok := object.Key("DryRun")
		ok.Boolean(v.DryRun)
	}

	if v.PublishedSchemaArn != nil {
		ok := object.Key("PublishedSchemaArn")
		ok.String(*v.PublishedSchemaArn)
	}

	return nil
}

type awsRestjson1_serializeOpUpgradePublishedSchema struct {
}

func (*awsRestjson1_serializeOpUpgradePublishedSchema) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpgradePublishedSchema) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpgradePublishedSchemaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/amazonclouddirectory/2017-01-11/schema/upgradepublished")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpgradePublishedSchemaInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpgradePublishedSchemaInput(v *UpgradePublishedSchemaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpgradePublishedSchemaInput(v *UpgradePublishedSchemaInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DevelopmentSchemaArn != nil {
		ok := object.Key("DevelopmentSchemaArn")
		ok.String(*v.DevelopmentSchemaArn)
	}

	if v.DryRun {
		ok := object.Key("DryRun")
		ok.Boolean(v.DryRun)
	}

	if v.MinorVersion != nil {
		ok := object.Key("MinorVersion")
		ok.String(*v.MinorVersion)
	}

	if v.PublishedSchemaArn != nil {
		ok := object.Key("PublishedSchemaArn")
		ok.String(*v.PublishedSchemaArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentAttributeKey(v *types.AttributeKey, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FacetName != nil {
		ok := object.Key("FacetName")
		ok.String(*v.FacetName)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.SchemaArn != nil {
		ok := object.Key("SchemaArn")
		ok.String(*v.SchemaArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentAttributeKeyAndValue(v *types.AttributeKeyAndValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		if err := awsRestjson1_serializeDocumentAttributeKey(v.Key, ok); err != nil {
			return err
		}
	}

	if v.Value != nil {
		ok := object.Key("Value")
		if err := awsRestjson1_serializeDocumentTypedAttributeValue(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAttributeKeyAndValueList(v []types.AttributeKeyAndValue, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAttributeKeyAndValue(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAttributeKeyList(v []types.AttributeKey, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAttributeKey(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAttributeNameAndValue(v *types.AttributeNameAndValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeName != nil {
		ok := object.Key("AttributeName")
		ok.String(*v.AttributeName)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		if err := awsRestjson1_serializeDocumentTypedAttributeValue(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAttributeNameAndValueList(v []types.AttributeNameAndValue, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAttributeNameAndValue(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAttributeNameList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentBatchAddFacetToObject(v *types.BatchAddFacetToObject, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ObjectAttributeList != nil {
		ok := object.Key("ObjectAttributeList")
		if err := awsRestjson1_serializeDocumentAttributeKeyAndValueList(v.ObjectAttributeList, ok); err != nil {
			return err
		}
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	if v.SchemaFacet != nil {
		ok := object.Key("SchemaFacet")
		if err := awsRestjson1_serializeDocumentSchemaFacet(v.SchemaFacet, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchAttachObject(v *types.BatchAttachObject, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChildReference != nil {
		ok := object.Key("ChildReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ChildReference, ok); err != nil {
			return err
		}
	}

	if v.LinkName != nil {
		ok := object.Key("LinkName")
		ok.String(*v.LinkName)
	}

	if v.ParentReference != nil {
		ok := object.Key("ParentReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ParentReference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchAttachPolicy(v *types.BatchAttachPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	if v.PolicyReference != nil {
		ok := object.Key("PolicyReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.PolicyReference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchAttachToIndex(v *types.BatchAttachToIndex, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IndexReference != nil {
		ok := object.Key("IndexReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.IndexReference, ok); err != nil {
			return err
		}
	}

	if v.TargetReference != nil {
		ok := object.Key("TargetReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.TargetReference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchAttachTypedLink(v *types.BatchAttachTypedLink, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsRestjson1_serializeDocumentAttributeNameAndValueList(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.SourceObjectReference != nil {
		ok := object.Key("SourceObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.SourceObjectReference, ok); err != nil {
			return err
		}
	}

	if v.TargetObjectReference != nil {
		ok := object.Key("TargetObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.TargetObjectReference, ok); err != nil {
			return err
		}
	}

	if v.TypedLinkFacet != nil {
		ok := object.Key("TypedLinkFacet")
		if err := awsRestjson1_serializeDocumentTypedLinkSchemaAndFacetName(v.TypedLinkFacet, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchCreateIndex(v *types.BatchCreateIndex, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchReferenceName != nil {
		ok := object.Key("BatchReferenceName")
		ok.String(*v.BatchReferenceName)
	}

	{
		ok := object.Key("IsUnique")
		ok.Boolean(v.IsUnique)
	}

	if v.LinkName != nil {
		ok := object.Key("LinkName")
		ok.String(*v.LinkName)
	}

	if v.OrderedIndexedAttributeList != nil {
		ok := object.Key("OrderedIndexedAttributeList")
		if err := awsRestjson1_serializeDocumentAttributeKeyList(v.OrderedIndexedAttributeList, ok); err != nil {
			return err
		}
	}

	if v.ParentReference != nil {
		ok := object.Key("ParentReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ParentReference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchCreateObject(v *types.BatchCreateObject, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchReferenceName != nil {
		ok := object.Key("BatchReferenceName")
		ok.String(*v.BatchReferenceName)
	}

	if v.LinkName != nil {
		ok := object.Key("LinkName")
		ok.String(*v.LinkName)
	}

	if v.ObjectAttributeList != nil {
		ok := object.Key("ObjectAttributeList")
		if err := awsRestjson1_serializeDocumentAttributeKeyAndValueList(v.ObjectAttributeList, ok); err != nil {
			return err
		}
	}

	if v.ParentReference != nil {
		ok := object.Key("ParentReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ParentReference, ok); err != nil {
			return err
		}
	}

	if v.SchemaFacet != nil {
		ok := object.Key("SchemaFacet")
		if err := awsRestjson1_serializeDocumentSchemaFacetList(v.SchemaFacet, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchDeleteObject(v *types.BatchDeleteObject, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchDetachFromIndex(v *types.BatchDetachFromIndex, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IndexReference != nil {
		ok := object.Key("IndexReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.IndexReference, ok); err != nil {
			return err
		}
	}

	if v.TargetReference != nil {
		ok := object.Key("TargetReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.TargetReference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchDetachObject(v *types.BatchDetachObject, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchReferenceName != nil {
		ok := object.Key("BatchReferenceName")
		ok.String(*v.BatchReferenceName)
	}

	if v.LinkName != nil {
		ok := object.Key("LinkName")
		ok.String(*v.LinkName)
	}

	if v.ParentReference != nil {
		ok := object.Key("ParentReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ParentReference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchDetachPolicy(v *types.BatchDetachPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	if v.PolicyReference != nil {
		ok := object.Key("PolicyReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.PolicyReference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchDetachTypedLink(v *types.BatchDetachTypedLink, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TypedLinkSpecifier != nil {
		ok := object.Key("TypedLinkSpecifier")
		if err := awsRestjson1_serializeDocumentTypedLinkSpecifier(v.TypedLinkSpecifier, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchGetLinkAttributes(v *types.BatchGetLinkAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeNames != nil {
		ok := object.Key("AttributeNames")
		if err := awsRestjson1_serializeDocumentAttributeNameList(v.AttributeNames, ok); err != nil {
			return err
		}
	}

	if v.TypedLinkSpecifier != nil {
		ok := object.Key("TypedLinkSpecifier")
		if err := awsRestjson1_serializeDocumentTypedLinkSpecifier(v.TypedLinkSpecifier, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchGetObjectAttributes(v *types.BatchGetObjectAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeNames != nil {
		ok := object.Key("AttributeNames")
		if err := awsRestjson1_serializeDocumentAttributeNameList(v.AttributeNames, ok); err != nil {
			return err
		}
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	if v.SchemaFacet != nil {
		ok := object.Key("SchemaFacet")
		if err := awsRestjson1_serializeDocumentSchemaFacet(v.SchemaFacet, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchGetObjectInformation(v *types.BatchGetObjectInformation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchListAttachedIndices(v *types.BatchListAttachedIndices, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.TargetReference != nil {
		ok := object.Key("TargetReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.TargetReference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchListIncomingTypedLinks(v *types.BatchListIncomingTypedLinks, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilterAttributeRanges != nil {
		ok := object.Key("FilterAttributeRanges")
		if err := awsRestjson1_serializeDocumentTypedLinkAttributeRangeList(v.FilterAttributeRanges, ok); err != nil {
			return err
		}
	}

	if v.FilterTypedLink != nil {
		ok := object.Key("FilterTypedLink")
		if err := awsRestjson1_serializeDocumentTypedLinkSchemaAndFacetName(v.FilterTypedLink, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchListIndex(v *types.BatchListIndex, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IndexReference != nil {
		ok := object.Key("IndexReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.IndexReference, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.RangesOnIndexedValues != nil {
		ok := object.Key("RangesOnIndexedValues")
		if err := awsRestjson1_serializeDocumentObjectAttributeRangeList(v.RangesOnIndexedValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchListObjectAttributes(v *types.BatchListObjectAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FacetFilter != nil {
		ok := object.Key("FacetFilter")
		if err := awsRestjson1_serializeDocumentSchemaFacet(v.FacetFilter, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchListObjectChildren(v *types.BatchListObjectChildren, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchListObjectParentPaths(v *types.BatchListObjectParentPaths, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchListObjectParents(v *types.BatchListObjectParents, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchListObjectPolicies(v *types.BatchListObjectPolicies, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchListOutgoingTypedLinks(v *types.BatchListOutgoingTypedLinks, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilterAttributeRanges != nil {
		ok := object.Key("FilterAttributeRanges")
		if err := awsRestjson1_serializeDocumentTypedLinkAttributeRangeList(v.FilterAttributeRanges, ok); err != nil {
			return err
		}
	}

	if v.FilterTypedLink != nil {
		ok := object.Key("FilterTypedLink")
		if err := awsRestjson1_serializeDocumentTypedLinkSchemaAndFacetName(v.FilterTypedLink, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchListPolicyAttachments(v *types.BatchListPolicyAttachments, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.PolicyReference != nil {
		ok := object.Key("PolicyReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.PolicyReference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchLookupPolicy(v *types.BatchLookupPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchReadOperation(v *types.BatchReadOperation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GetLinkAttributes != nil {
		ok := object.Key("GetLinkAttributes")
		if err := awsRestjson1_serializeDocumentBatchGetLinkAttributes(v.GetLinkAttributes, ok); err != nil {
			return err
		}
	}

	if v.GetObjectAttributes != nil {
		ok := object.Key("GetObjectAttributes")
		if err := awsRestjson1_serializeDocumentBatchGetObjectAttributes(v.GetObjectAttributes, ok); err != nil {
			return err
		}
	}

	if v.GetObjectInformation != nil {
		ok := object.Key("GetObjectInformation")
		if err := awsRestjson1_serializeDocumentBatchGetObjectInformation(v.GetObjectInformation, ok); err != nil {
			return err
		}
	}

	if v.ListAttachedIndices != nil {
		ok := object.Key("ListAttachedIndices")
		if err := awsRestjson1_serializeDocumentBatchListAttachedIndices(v.ListAttachedIndices, ok); err != nil {
			return err
		}
	}

	if v.ListIncomingTypedLinks != nil {
		ok := object.Key("ListIncomingTypedLinks")
		if err := awsRestjson1_serializeDocumentBatchListIncomingTypedLinks(v.ListIncomingTypedLinks, ok); err != nil {
			return err
		}
	}

	if v.ListIndex != nil {
		ok := object.Key("ListIndex")
		if err := awsRestjson1_serializeDocumentBatchListIndex(v.ListIndex, ok); err != nil {
			return err
		}
	}

	if v.ListObjectAttributes != nil {
		ok := object.Key("ListObjectAttributes")
		if err := awsRestjson1_serializeDocumentBatchListObjectAttributes(v.ListObjectAttributes, ok); err != nil {
			return err
		}
	}

	if v.ListObjectChildren != nil {
		ok := object.Key("ListObjectChildren")
		if err := awsRestjson1_serializeDocumentBatchListObjectChildren(v.ListObjectChildren, ok); err != nil {
			return err
		}
	}

	if v.ListObjectParentPaths != nil {
		ok := object.Key("ListObjectParentPaths")
		if err := awsRestjson1_serializeDocumentBatchListObjectParentPaths(v.ListObjectParentPaths, ok); err != nil {
			return err
		}
	}

	if v.ListObjectParents != nil {
		ok := object.Key("ListObjectParents")
		if err := awsRestjson1_serializeDocumentBatchListObjectParents(v.ListObjectParents, ok); err != nil {
			return err
		}
	}

	if v.ListObjectPolicies != nil {
		ok := object.Key("ListObjectPolicies")
		if err := awsRestjson1_serializeDocumentBatchListObjectPolicies(v.ListObjectPolicies, ok); err != nil {
			return err
		}
	}

	if v.ListOutgoingTypedLinks != nil {
		ok := object.Key("ListOutgoingTypedLinks")
		if err := awsRestjson1_serializeDocumentBatchListOutgoingTypedLinks(v.ListOutgoingTypedLinks, ok); err != nil {
			return err
		}
	}

	if v.ListPolicyAttachments != nil {
		ok := object.Key("ListPolicyAttachments")
		if err := awsRestjson1_serializeDocumentBatchListPolicyAttachments(v.ListPolicyAttachments, ok); err != nil {
			return err
		}
	}

	if v.LookupPolicy != nil {
		ok := object.Key("LookupPolicy")
		if err := awsRestjson1_serializeDocumentBatchLookupPolicy(v.LookupPolicy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchReadOperationList(v []types.BatchReadOperation, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentBatchReadOperation(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentBatchRemoveFacetFromObject(v *types.BatchRemoveFacetFromObject, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	if v.SchemaFacet != nil {
		ok := object.Key("SchemaFacet")
		if err := awsRestjson1_serializeDocumentSchemaFacet(v.SchemaFacet, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchUpdateLinkAttributes(v *types.BatchUpdateLinkAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeUpdates != nil {
		ok := object.Key("AttributeUpdates")
		if err := awsRestjson1_serializeDocumentLinkAttributeUpdateList(v.AttributeUpdates, ok); err != nil {
			return err
		}
	}

	if v.TypedLinkSpecifier != nil {
		ok := object.Key("TypedLinkSpecifier")
		if err := awsRestjson1_serializeDocumentTypedLinkSpecifier(v.TypedLinkSpecifier, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchUpdateObjectAttributes(v *types.BatchUpdateObjectAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeUpdates != nil {
		ok := object.Key("AttributeUpdates")
		if err := awsRestjson1_serializeDocumentObjectAttributeUpdateList(v.AttributeUpdates, ok); err != nil {
			return err
		}
	}

	if v.ObjectReference != nil {
		ok := object.Key("ObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.ObjectReference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchWriteOperation(v *types.BatchWriteOperation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AddFacetToObject != nil {
		ok := object.Key("AddFacetToObject")
		if err := awsRestjson1_serializeDocumentBatchAddFacetToObject(v.AddFacetToObject, ok); err != nil {
			return err
		}
	}

	if v.AttachObject != nil {
		ok := object.Key("AttachObject")
		if err := awsRestjson1_serializeDocumentBatchAttachObject(v.AttachObject, ok); err != nil {
			return err
		}
	}

	if v.AttachPolicy != nil {
		ok := object.Key("AttachPolicy")
		if err := awsRestjson1_serializeDocumentBatchAttachPolicy(v.AttachPolicy, ok); err != nil {
			return err
		}
	}

	if v.AttachToIndex != nil {
		ok := object.Key("AttachToIndex")
		if err := awsRestjson1_serializeDocumentBatchAttachToIndex(v.AttachToIndex, ok); err != nil {
			return err
		}
	}

	if v.AttachTypedLink != nil {
		ok := object.Key("AttachTypedLink")
		if err := awsRestjson1_serializeDocumentBatchAttachTypedLink(v.AttachTypedLink, ok); err != nil {
			return err
		}
	}

	if v.CreateIndex != nil {
		ok := object.Key("CreateIndex")
		if err := awsRestjson1_serializeDocumentBatchCreateIndex(v.CreateIndex, ok); err != nil {
			return err
		}
	}

	if v.CreateObject != nil {
		ok := object.Key("CreateObject")
		if err := awsRestjson1_serializeDocumentBatchCreateObject(v.CreateObject, ok); err != nil {
			return err
		}
	}

	if v.DeleteObject != nil {
		ok := object.Key("DeleteObject")
		if err := awsRestjson1_serializeDocumentBatchDeleteObject(v.DeleteObject, ok); err != nil {
			return err
		}
	}

	if v.DetachFromIndex != nil {
		ok := object.Key("DetachFromIndex")
		if err := awsRestjson1_serializeDocumentBatchDetachFromIndex(v.DetachFromIndex, ok); err != nil {
			return err
		}
	}

	if v.DetachObject != nil {
		ok := object.Key("DetachObject")
		if err := awsRestjson1_serializeDocumentBatchDetachObject(v.DetachObject, ok); err != nil {
			return err
		}
	}

	if v.DetachPolicy != nil {
		ok := object.Key("DetachPolicy")
		if err := awsRestjson1_serializeDocumentBatchDetachPolicy(v.DetachPolicy, ok); err != nil {
			return err
		}
	}

	if v.DetachTypedLink != nil {
		ok := object.Key("DetachTypedLink")
		if err := awsRestjson1_serializeDocumentBatchDetachTypedLink(v.DetachTypedLink, ok); err != nil {
			return err
		}
	}

	if v.RemoveFacetFromObject != nil {
		ok := object.Key("RemoveFacetFromObject")
		if err := awsRestjson1_serializeDocumentBatchRemoveFacetFromObject(v.RemoveFacetFromObject, ok); err != nil {
			return err
		}
	}

	if v.UpdateLinkAttributes != nil {
		ok := object.Key("UpdateLinkAttributes")
		if err := awsRestjson1_serializeDocumentBatchUpdateLinkAttributes(v.UpdateLinkAttributes, ok); err != nil {
			return err
		}
	}

	if v.UpdateObjectAttributes != nil {
		ok := object.Key("UpdateObjectAttributes")
		if err := awsRestjson1_serializeDocumentBatchUpdateObjectAttributes(v.UpdateObjectAttributes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchWriteOperationList(v []types.BatchWriteOperation, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentBatchWriteOperation(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFacetAttribute(v *types.FacetAttribute, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeDefinition != nil {
		ok := object.Key("AttributeDefinition")
		if err := awsRestjson1_serializeDocumentFacetAttributeDefinition(v.AttributeDefinition, ok); err != nil {
			return err
		}
	}

	if v.AttributeReference != nil {
		ok := object.Key("AttributeReference")
		if err := awsRestjson1_serializeDocumentFacetAttributeReference(v.AttributeReference, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.RequiredBehavior) > 0 {
		ok := object.Key("RequiredBehavior")
		ok.String(string(v.RequiredBehavior))
	}

	return nil
}

func awsRestjson1_serializeDocumentFacetAttributeDefinition(v *types.FacetAttributeDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultValue != nil {
		ok := object.Key("DefaultValue")
		if err := awsRestjson1_serializeDocumentTypedAttributeValue(v.DefaultValue, ok); err != nil {
			return err
		}
	}

	if v.IsImmutable {
		ok := object.Key("IsImmutable")
		ok.Boolean(v.IsImmutable)
	}

	if v.Rules != nil {
		ok := object.Key("Rules")
		if err := awsRestjson1_serializeDocumentRuleMap(v.Rules, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentFacetAttributeList(v []types.FacetAttribute, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFacetAttribute(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFacetAttributeReference(v *types.FacetAttributeReference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TargetAttributeName != nil {
		ok := object.Key("TargetAttributeName")
		ok.String(*v.TargetAttributeName)
	}

	if v.TargetFacetName != nil {
		ok := object.Key("TargetFacetName")
		ok.String(*v.TargetFacetName)
	}

	return nil
}

func awsRestjson1_serializeDocumentFacetAttributeUpdate(v *types.FacetAttributeUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("Action")
		ok.String(string(v.Action))
	}

	if v.Attribute != nil {
		ok := object.Key("Attribute")
		if err := awsRestjson1_serializeDocumentFacetAttribute(v.Attribute, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFacetAttributeUpdateList(v []types.FacetAttributeUpdate, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFacetAttributeUpdate(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentLinkAttributeAction(v *types.LinkAttributeAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AttributeActionType) > 0 {
		ok := object.Key("AttributeActionType")
		ok.String(string(v.AttributeActionType))
	}

	if v.AttributeUpdateValue != nil {
		ok := object.Key("AttributeUpdateValue")
		if err := awsRestjson1_serializeDocumentTypedAttributeValue(v.AttributeUpdateValue, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentLinkAttributeUpdate(v *types.LinkAttributeUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeAction != nil {
		ok := object.Key("AttributeAction")
		if err := awsRestjson1_serializeDocumentLinkAttributeAction(v.AttributeAction, ok); err != nil {
			return err
		}
	}

	if v.AttributeKey != nil {
		ok := object.Key("AttributeKey")
		if err := awsRestjson1_serializeDocumentAttributeKey(v.AttributeKey, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentLinkAttributeUpdateList(v []types.LinkAttributeUpdate, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentLinkAttributeUpdate(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentObjectAttributeAction(v *types.ObjectAttributeAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ObjectAttributeActionType) > 0 {
		ok := object.Key("ObjectAttributeActionType")
		ok.String(string(v.ObjectAttributeActionType))
	}

	if v.ObjectAttributeUpdateValue != nil {
		ok := object.Key("ObjectAttributeUpdateValue")
		if err := awsRestjson1_serializeDocumentTypedAttributeValue(v.ObjectAttributeUpdateValue, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentObjectAttributeRange(v *types.ObjectAttributeRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeKey != nil {
		ok := object.Key("AttributeKey")
		if err := awsRestjson1_serializeDocumentAttributeKey(v.AttributeKey, ok); err != nil {
			return err
		}
	}

	if v.Range != nil {
		ok := object.Key("Range")
		if err := awsRestjson1_serializeDocumentTypedAttributeValueRange(v.Range, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentObjectAttributeRangeList(v []types.ObjectAttributeRange, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentObjectAttributeRange(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentObjectAttributeUpdate(v *types.ObjectAttributeUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ObjectAttributeAction != nil {
		ok := object.Key("ObjectAttributeAction")
		if err := awsRestjson1_serializeDocumentObjectAttributeAction(v.ObjectAttributeAction, ok); err != nil {
			return err
		}
	}

	if v.ObjectAttributeKey != nil {
		ok := object.Key("ObjectAttributeKey")
		if err := awsRestjson1_serializeDocumentAttributeKey(v.ObjectAttributeKey, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentObjectAttributeUpdateList(v []types.ObjectAttributeUpdate, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentObjectAttributeUpdate(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentObjectReference(v *types.ObjectReference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Selector != nil {
		ok := object.Key("Selector")
		ok.String(*v.Selector)
	}

	return nil
}

func awsRestjson1_serializeDocumentRule(v *types.Rule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsRestjson1_serializeDocumentRuleParameterMap(v.Parameters, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentRuleMap(v map[string]types.Rule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentRule(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRuleParameterMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentSchemaFacet(v *types.SchemaFacet, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FacetName != nil {
		ok := object.Key("FacetName")
		ok.String(*v.FacetName)
	}

	if v.SchemaArn != nil {
		ok := object.Key("SchemaArn")
		ok.String(*v.SchemaArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentSchemaFacetList(v []types.SchemaFacet, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSchemaFacet(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentTagKeyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTypedAttributeValue(v types.TypedAttributeValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.TypedAttributeValueMemberBinaryValue:
		av := object.Key("BinaryValue")
		av.Base64EncodeBytes(uv.Value)

	case *types.TypedAttributeValueMemberBooleanValue:
		av := object.Key("BooleanValue")
		av.Boolean(uv.Value)

	case *types.TypedAttributeValueMemberDatetimeValue:
		av := object.Key("DatetimeValue")
		av.Double(smithytime.FormatEpochSeconds(uv.Value))

	case *types.TypedAttributeValueMemberNumberValue:
		av := object.Key("NumberValue")
		av.String(uv.Value)

	case *types.TypedAttributeValueMemberStringValue:
		av := object.Key("StringValue")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentTypedAttributeValueRange(v *types.TypedAttributeValueRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.EndMode) > 0 {
		ok := object.Key("EndMode")
		ok.String(string(v.EndMode))
	}

	if v.EndValue != nil {
		ok := object.Key("EndValue")
		if err := awsRestjson1_serializeDocumentTypedAttributeValue(v.EndValue, ok); err != nil {
			return err
		}
	}

	if len(v.StartMode) > 0 {
		ok := object.Key("StartMode")
		ok.String(string(v.StartMode))
	}

	if v.StartValue != nil {
		ok := object.Key("StartValue")
		if err := awsRestjson1_serializeDocumentTypedAttributeValue(v.StartValue, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTypedLinkAttributeDefinition(v *types.TypedLinkAttributeDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultValue != nil {
		ok := object.Key("DefaultValue")
		if err := awsRestjson1_serializeDocumentTypedAttributeValue(v.DefaultValue, ok); err != nil {
			return err
		}
	}

	if v.IsImmutable {
		ok := object.Key("IsImmutable")
		ok.Boolean(v.IsImmutable)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.RequiredBehavior) > 0 {
		ok := object.Key("RequiredBehavior")
		ok.String(string(v.RequiredBehavior))
	}

	if v.Rules != nil {
		ok := object.Key("Rules")
		if err := awsRestjson1_serializeDocumentRuleMap(v.Rules, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentTypedLinkAttributeDefinitionList(v []types.TypedLinkAttributeDefinition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTypedLinkAttributeDefinition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTypedLinkAttributeRange(v *types.TypedLinkAttributeRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeName != nil {
		ok := object.Key("AttributeName")
		ok.String(*v.AttributeName)
	}

	if v.Range != nil {
		ok := object.Key("Range")
		if err := awsRestjson1_serializeDocumentTypedAttributeValueRange(v.Range, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTypedLinkAttributeRangeList(v []types.TypedLinkAttributeRange, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTypedLinkAttributeRange(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTypedLinkFacet(v *types.TypedLinkFacet, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsRestjson1_serializeDocumentTypedLinkAttributeDefinitionList(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.IdentityAttributeOrder != nil {
		ok := object.Key("IdentityAttributeOrder")
		if err := awsRestjson1_serializeDocumentAttributeNameList(v.IdentityAttributeOrder, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentTypedLinkFacetAttributeUpdate(v *types.TypedLinkFacetAttributeUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("Action")
		ok.String(string(v.Action))
	}

	if v.Attribute != nil {
		ok := object.Key("Attribute")
		if err := awsRestjson1_serializeDocumentTypedLinkAttributeDefinition(v.Attribute, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTypedLinkFacetAttributeUpdateList(v []types.TypedLinkFacetAttributeUpdate, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTypedLinkFacetAttributeUpdate(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTypedLinkSchemaAndFacetName(v *types.TypedLinkSchemaAndFacetName, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SchemaArn != nil {
		ok := object.Key("SchemaArn")
		ok.String(*v.SchemaArn)
	}

	if v.TypedLinkName != nil {
		ok := object.Key("TypedLinkName")
		ok.String(*v.TypedLinkName)
	}

	return nil
}

func awsRestjson1_serializeDocumentTypedLinkSpecifier(v *types.TypedLinkSpecifier, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdentityAttributeValues != nil {
		ok := object.Key("IdentityAttributeValues")
		if err := awsRestjson1_serializeDocumentAttributeNameAndValueList(v.IdentityAttributeValues, ok); err != nil {
			return err
		}
	}

	if v.SourceObjectReference != nil {
		ok := object.Key("SourceObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.SourceObjectReference, ok); err != nil {
			return err
		}
	}

	if v.TargetObjectReference != nil {
		ok := object.Key("TargetObjectReference")
		if err := awsRestjson1_serializeDocumentObjectReference(v.TargetObjectReference, ok); err != nil {
			return err
		}
	}

	if v.TypedLinkFacet != nil {
		ok := object.Key("TypedLinkFacet")
		if err := awsRestjson1_serializeDocumentTypedLinkSchemaAndFacetName(v.TypedLinkFacet, ok); err != nil {
			return err
		}
	}

	return nil
}
