/* MediaFactory.c generated by valac 0.34.4, the Vala compiler
 * generated from MediaFactory.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/rtsp-server/rtsp-server.h>
#include <gst/gst.h>
#include <gst/rtsp/rtsp.h>
#include <stdlib.h>
#include <string.h>


#define DVB_TYPE_MEDIA_FACTORY (dvb_media_factory_get_type ())
#define DVB_MEDIA_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MEDIA_FACTORY, DVBMediaFactory))
#define DVB_MEDIA_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MEDIA_FACTORY, DVBMediaFactoryClass))
#define DVB_IS_MEDIA_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MEDIA_FACTORY))
#define DVB_IS_MEDIA_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MEDIA_FACTORY))
#define DVB_MEDIA_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MEDIA_FACTORY, DVBMediaFactoryClass))

typedef struct _DVBMediaFactory DVBMediaFactory;
typedef struct _DVBMediaFactoryClass DVBMediaFactoryClass;
typedef struct _DVBMediaFactoryPrivate DVBMediaFactoryPrivate;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_PLAYER_THREAD (dvb_player_thread_get_type ())
#define DVB_PLAYER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_PLAYER_THREAD, DVBPlayerThread))
#define DVB_PLAYER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadClass))
#define DVB_IS_PLAYER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_PLAYER_THREAD))
#define DVB_IS_PLAYER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_PLAYER_THREAD))
#define DVB_PLAYER_THREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadClass))

typedef struct _DVBPlayerThread DVBPlayerThread;
typedef struct _DVBPlayerThreadClass DVBPlayerThreadClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_CHANNEL_FACTORY (dvb_channel_factory_get_type ())
#define DVB_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactory))
#define DVB_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))
#define DVB_IS_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_IS_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_CHANNEL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))

typedef struct _DVBChannelFactory DVBChannelFactory;
typedef struct _DVBChannelFactoryClass DVBChannelFactoryClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_MANAGER (dvb_manager_get_type ())
#define DVB_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MANAGER, DVBManager))
#define DVB_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MANAGER, DVBManagerClass))
#define DVB_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MANAGER))
#define DVB_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MANAGER))
#define DVB_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MANAGER, DVBManagerClass))

typedef struct _DVBManager DVBManager;
typedef struct _DVBManagerClass DVBManagerClass;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

struct _DVBMediaFactory {
	GstRTSPMediaFactory parent_instance;
	DVBMediaFactoryPrivate * priv;
};

struct _DVBMediaFactoryClass {
	GstRTSPMediaFactoryClass parent_class;
};

struct _DVBMediaFactoryPrivate {
	DVBDeviceGroup* group;
	DVBChannel* channel;
	GstElement* payloader;
	DVBPlayerThread* player;
};

typedef void (*DVBForcedStopNotify) (DVBChannel* channel, void* user_data);

static gpointer dvb_media_factory_parent_class = NULL;
static DVBLoggingLogger* dvb_media_factory_log;
static DVBLoggingLogger* dvb_media_factory_log = NULL;

GType dvb_media_factory_get_type (void) G_GNUC_CONST;
GType dvb_device_group_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_player_thread_get_type (void) G_GNUC_CONST;
#define DVB_MEDIA_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_MEDIA_FACTORY, DVBMediaFactoryPrivate))
enum  {
	DVB_MEDIA_FACTORY_DUMMY_PROPERTY
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
static void dvb_media_factory_on_media_unprepared (DVBMediaFactory* self);
GType dvb_channel_factory_get_type (void) G_GNUC_CONST;
DVBChannelFactory* dvb_device_group_get_channel_factory (DVBDeviceGroup* self);
gboolean dvb_channel_factory_stop_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink);
static GstElement* dvb_media_factory_real_create_element (GstRTSPMediaFactory* base, GstRTSPUrl* url);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
GType dvb_manager_get_type (void) G_GNUC_CONST;
DVBManager* dvb_manager_get_instance (void);
DVBDeviceGroup* dvb_manager_get_device_group_if_exists (DVBManager* self, guint group_id);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
DVBPlayerThread* dvb_channel_factory_watch_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink_element, gboolean force, DVBForcedStopNotify notify_func, void* notify_func_target);
void dvb_rtsp_server_stop_streaming (DVBChannel* channel);
static void _dvb_rtsp_server_stop_streaming_dvb_forced_stop_notify (DVBChannel* channel, gpointer self);
GstElement* dvb_player_thread_get_sink_bin (DVBPlayerThread* self, guint sid, GstElement* sink);
static GstPipeline* dvb_media_factory_real_create_pipeline (GstRTSPMediaFactory* base, GstRTSPMedia* media);
GstElement* dvb_player_thread_get_pipeline (DVBPlayerThread* self);
static void _dvb_media_factory_on_media_unprepared_gst_rtsp_media_unprepared (GstRTSPMedia* _sender, gpointer self);
DVBMediaFactory* dvb_media_factory_new (void);
DVBMediaFactory* dvb_media_factory_construct (GType object_type);
static GObject * dvb_media_factory_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_media_factory_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_media_factory_on_media_unprepared (DVBMediaFactory* self) {
	DVBChannelFactory* channels_factory = NULL;
	DVBDeviceGroup* _tmp0_ = NULL;
	DVBChannelFactory* _tmp1_ = NULL;
	DVBChannelFactory* _tmp2_ = NULL;
	DVBChannelFactory* _tmp3_ = NULL;
	DVBChannel* _tmp4_ = NULL;
	GstElement* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->group;
	_tmp1_ = dvb_device_group_get_channel_factory (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	channels_factory = _tmp3_;
	_tmp4_ = self->priv->channel;
	_tmp5_ = self->priv->payloader;
	dvb_channel_factory_stop_channel (channels_factory, _tmp4_, _tmp5_);
	_g_object_unref0 (self->priv->group);
	self->priv->group = NULL;
	_g_object_unref0 (self->priv->channel);
	self->priv->channel = NULL;
	_g_object_unref0 (self->priv->payloader);
	self->priv->payloader = NULL;
	_g_object_unref0 (self->priv->player);
	self->priv->player = NULL;
	_g_object_unref0 (channels_factory);
}


static void _dvb_rtsp_server_stop_streaming_dvb_forced_stop_notify (DVBChannel* channel, gpointer self) {
	dvb_rtsp_server_stop_streaming (channel);
}


static GstElement* dvb_media_factory_real_create_element (GstRTSPMediaFactory* base, GstRTSPUrl* url) {
	DVBMediaFactory * self;
	GstElement* result = NULL;
	guint sidnr = 0U;
	guint grpnr = 0U;
	DVBLoggingLogger* _tmp0_ = NULL;
	gchar** path_elements = NULL;
	GstRTSPUrl* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint path_elements_length1 = 0;
	gint _path_elements_size_ = 0;
	gint i = 0;
	gchar* elem = NULL;
	DVBManager* manager = NULL;
	DVBManager* _tmp17_ = NULL;
	DVBManager* _tmp18_ = NULL;
	DVBManager* _tmp19_ = NULL;
	guint _tmp20_ = 0U;
	DVBDeviceGroup* _tmp21_ = NULL;
	DVBDeviceGroup* _tmp22_ = NULL;
	GstElement* _tmp24_ = NULL;
	GstElement* _tmp25_ = NULL;
	GstElement* _tmp27_ = NULL;
	DVBDeviceGroup* _tmp28_ = NULL;
	DVBChannelList* _tmp29_ = NULL;
	DVBChannelList* _tmp30_ = NULL;
	guint _tmp31_ = 0U;
	DVBChannel* _tmp32_ = NULL;
	DVBChannel* _tmp33_ = NULL;
	DVBChannelFactory* channels_factory = NULL;
	DVBDeviceGroup* _tmp36_ = NULL;
	DVBChannelFactory* _tmp37_ = NULL;
	DVBChannelFactory* _tmp38_ = NULL;
	DVBChannelFactory* _tmp39_ = NULL;
	DVBChannelFactory* _tmp40_ = NULL;
	DVBChannel* _tmp41_ = NULL;
	GstElement* _tmp42_ = NULL;
	GstElement* _tmp43_ = NULL;
	DVBPlayerThread* _tmp44_ = NULL;
	DVBPlayerThread* _tmp45_ = NULL;
	DVBLoggingLogger* _tmp47_ = NULL;
	DVBPlayerThread* _tmp48_ = NULL;
	guint _tmp49_ = 0U;
	GstElement* _tmp50_ = NULL;
	GstElement* _tmp51_ = NULL;
	self = (DVBMediaFactory*) base;
	g_return_val_if_fail (url != NULL, NULL);
	sidnr = (guint) 0;
	grpnr = (guint) 0;
	_tmp0_ = dvb_media_factory_log;
	dvb_logging_logger_debug (_tmp0_, "MediaFactory.vala:49: create element");
	_tmp1_ = url;
	_tmp2_ = _tmp1_->abspath;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "/", 0);
	path_elements = _tmp4_;
	path_elements_length1 = _vala_array_length (_tmp3_);
	_path_elements_size_ = path_elements_length1;
	i = 0;
	while (TRUE) {
		gchar** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp6_ = 0;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp16_ = 0;
		_tmp5_ = path_elements;
		_tmp5__length1 = path_elements_length1;
		_tmp6_ = i;
		_tmp7_ = _tmp5_[_tmp6_];
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (elem);
		elem = _tmp8_;
		_tmp9_ = elem;
		if (!(_tmp9_ != NULL)) {
			break;
		}
		_tmp10_ = i;
		if (_tmp10_ == 1) {
			const gchar* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			_tmp11_ = elem;
			_tmp12_ = atoi (_tmp11_);
			grpnr = (guint) _tmp12_;
		} else {
			gint _tmp13_ = 0;
			_tmp13_ = i;
			if (_tmp13_ == 2) {
				const gchar* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				_tmp14_ = elem;
				_tmp15_ = atoi (_tmp14_);
				sidnr = (guint) _tmp15_;
			}
		}
		_tmp16_ = i;
		i = _tmp16_ + 1;
	}
	_tmp17_ = dvb_manager_get_instance ();
	_tmp18_ = _g_object_ref0 (_tmp17_);
	manager = _tmp18_;
	_tmp19_ = manager;
	_tmp20_ = grpnr;
	_tmp21_ = dvb_manager_get_device_group_if_exists (_tmp19_, _tmp20_);
	_g_object_unref0 (self->priv->group);
	self->priv->group = _tmp21_;
	_tmp22_ = self->priv->group;
	if (_tmp22_ == NULL) {
		guint _tmp23_ = 0U;
		_tmp23_ = grpnr;
		g_warning ("MediaFactory.vala:66: Unknown group %u", _tmp23_);
		result = NULL;
		_g_object_unref0 (manager);
		_g_free0 (elem);
		path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp24_ = gst_element_factory_make ("rtpmp2tpay", "pay0");
	if (_tmp24_ != NULL) {
		g_object_ref_sink (_tmp24_);
	}
	_g_object_unref0 (self->priv->payloader);
	self->priv->payloader = _tmp24_;
	_tmp25_ = self->priv->payloader;
	if (_tmp25_ == NULL) {
		DVBLoggingLogger* _tmp26_ = NULL;
		_tmp26_ = dvb_media_factory_log;
		dvb_logging_logger_error (_tmp26_, "MediaFactory.vala:72: Could not create rtpmp2tpay element");
		result = NULL;
		_g_object_unref0 (manager);
		_g_free0 (elem);
		path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp27_ = self->priv->payloader;
	g_object_set ((GObject*) _tmp27_, "pt", 96, NULL);
	_tmp28_ = self->priv->group;
	_tmp29_ = dvb_device_group_get_Channels (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = sidnr;
	_tmp32_ = dvb_channel_list_get_channel (_tmp30_, _tmp31_);
	_g_object_unref0 (self->priv->channel);
	self->priv->channel = _tmp32_;
	_tmp33_ = self->priv->channel;
	if (_tmp33_ == NULL) {
		DVBLoggingLogger* _tmp34_ = NULL;
		guint _tmp35_ = 0U;
		_tmp34_ = dvb_media_factory_log;
		_tmp35_ = sidnr;
		dvb_logging_logger_error (_tmp34_, "MediaFactory.vala:79: No channel with SID %u", _tmp35_);
		result = NULL;
		_g_object_unref0 (manager);
		_g_free0 (elem);
		path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp36_ = self->priv->group;
	_tmp37_ = dvb_device_group_get_channel_factory (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = _g_object_ref0 (_tmp38_);
	channels_factory = _tmp39_;
	_tmp40_ = channels_factory;
	_tmp41_ = self->priv->channel;
	_tmp42_ = self->priv->payloader;
	_tmp43_ = _g_object_ref0 (_tmp42_);
	_tmp44_ = dvb_channel_factory_watch_channel (_tmp40_, _tmp41_, _tmp43_, FALSE, _dvb_rtsp_server_stop_streaming_dvb_forced_stop_notify, NULL);
	_g_object_unref0 (self->priv->player);
	self->priv->player = _tmp44_;
	_tmp45_ = self->priv->player;
	if (_tmp45_ == NULL) {
		DVBLoggingLogger* _tmp46_ = NULL;
		_tmp46_ = dvb_media_factory_log;
		dvb_logging_logger_debug (_tmp46_, "MediaFactory.vala:87: Could not create player");
		result = NULL;
		_g_object_unref0 (channels_factory);
		_g_object_unref0 (manager);
		_g_free0 (elem);
		path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp47_ = dvb_media_factory_log;
	dvb_logging_logger_debug (_tmp47_, "MediaFactory.vala:90: Retrieving sink bin with payloader");
	_tmp48_ = self->priv->player;
	_tmp49_ = sidnr;
	_tmp50_ = self->priv->payloader;
	_tmp51_ = dvb_player_thread_get_sink_bin (_tmp48_, _tmp49_, _tmp50_);
	result = _tmp51_;
	_g_object_unref0 (channels_factory);
	_g_object_unref0 (manager);
	_g_free0 (elem);
	path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void _dvb_media_factory_on_media_unprepared_gst_rtsp_media_unprepared (GstRTSPMedia* _sender, gpointer self) {
	dvb_media_factory_on_media_unprepared ((DVBMediaFactory*) self);
}


static GstPipeline* dvb_media_factory_real_create_pipeline (GstRTSPMediaFactory* base, GstRTSPMedia* media) {
	DVBMediaFactory * self;
	GstPipeline* result = NULL;
	DVBLoggingLogger* _tmp0_ = NULL;
	GstPipeline* pipeline = NULL;
	DVBPlayerThread* _tmp1_ = NULL;
	GstElement* _tmp2_ = NULL;
	GstRTSPMedia* _tmp3_ = NULL;
	GstRTSPMedia* _tmp4_ = NULL;
	GstPipeline* _tmp5_ = NULL;
	self = (DVBMediaFactory*) base;
	g_return_val_if_fail (media != NULL, NULL);
	_tmp0_ = dvb_media_factory_log;
	dvb_logging_logger_debug (_tmp0_, "MediaFactory.vala:96: create pipeline");
	_tmp1_ = self->priv->player;
	_tmp2_ = dvb_player_thread_get_pipeline (_tmp1_);
	pipeline = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gst_pipeline_get_type (), GstPipeline);
	_tmp3_ = media;
	g_signal_connect_object (_tmp3_, "unprepared", (GCallback) _dvb_media_factory_on_media_unprepared_gst_rtsp_media_unprepared, self, 0);
	_tmp4_ = media;
	_tmp5_ = _g_object_ref0 (pipeline);
	gst_rtsp_media_take_pipeline (_tmp4_, _tmp5_);
	result = pipeline;
	return result;
}


DVBMediaFactory* dvb_media_factory_construct (GType object_type) {
	DVBMediaFactory * self = NULL;
	self = (DVBMediaFactory*) g_object_new (object_type, NULL);
	return self;
}


DVBMediaFactory* dvb_media_factory_new (void) {
	return dvb_media_factory_construct (DVB_TYPE_MEDIA_FACTORY);
}


static GObject * dvb_media_factory_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBMediaFactory * self;
	parent_class = G_OBJECT_CLASS (dvb_media_factory_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_MEDIA_FACTORY, DVBMediaFactory);
	gst_rtsp_media_factory_set_shared ((GstRTSPMediaFactory*) self, TRUE);
	return obj;
}


static void dvb_media_factory_class_init (DVBMediaFactoryClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_media_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBMediaFactoryPrivate));
	((GstRTSPMediaFactoryClass *) klass)->create_element = dvb_media_factory_real_create_element;
	((GstRTSPMediaFactoryClass *) klass)->create_pipeline = dvb_media_factory_real_create_pipeline;
	G_OBJECT_CLASS (klass)->constructor = dvb_media_factory_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_media_factory_finalize;
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_media_factory_log = _tmp1_;
}


static void dvb_media_factory_instance_init (DVBMediaFactory * self) {
	self->priv = DVB_MEDIA_FACTORY_GET_PRIVATE (self);
}


static void dvb_media_factory_finalize (GObject* obj) {
	DVBMediaFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_MEDIA_FACTORY, DVBMediaFactory);
	_g_object_unref0 (self->priv->group);
	_g_object_unref0 (self->priv->channel);
	_g_object_unref0 (self->priv->payloader);
	_g_object_unref0 (self->priv->player);
	G_OBJECT_CLASS (dvb_media_factory_parent_class)->finalize (obj);
}


GType dvb_media_factory_get_type (void) {
	static volatile gsize dvb_media_factory_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_media_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBMediaFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_media_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBMediaFactory), 0, (GInstanceInitFunc) dvb_media_factory_instance_init, NULL };
		GType dvb_media_factory_type_id;
		dvb_media_factory_type_id = g_type_register_static (gst_rtsp_media_factory_get_type (), "DVBMediaFactory", &g_define_type_info, 0);
		g_once_init_leave (&dvb_media_factory_type_id__volatile, dvb_media_factory_type_id);
	}
	return dvb_media_factory_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



