// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package visionai

import (
	"bytes"
	"context"
	"fmt"
	"io"
	"math"
	"net/http"
	"net/url"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	visionaipb "cloud.google.com/go/visionai/apiv1/visionaipb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/googleapi"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newAppPlatformClientHook clientHook

// AppPlatformCallOptions contains the retry settings for each method of AppPlatformClient.
type AppPlatformCallOptions struct {
	ListApplications             []gax.CallOption
	GetApplication               []gax.CallOption
	CreateApplication            []gax.CallOption
	UpdateApplication            []gax.CallOption
	DeleteApplication            []gax.CallOption
	DeployApplication            []gax.CallOption
	UndeployApplication          []gax.CallOption
	AddApplicationStreamInput    []gax.CallOption
	RemoveApplicationStreamInput []gax.CallOption
	UpdateApplicationStreamInput []gax.CallOption
	ListInstances                []gax.CallOption
	GetInstance                  []gax.CallOption
	CreateApplicationInstances   []gax.CallOption
	DeleteApplicationInstances   []gax.CallOption
	UpdateApplicationInstances   []gax.CallOption
	ListDrafts                   []gax.CallOption
	GetDraft                     []gax.CallOption
	CreateDraft                  []gax.CallOption
	UpdateDraft                  []gax.CallOption
	DeleteDraft                  []gax.CallOption
	ListProcessors               []gax.CallOption
	ListPrebuiltProcessors       []gax.CallOption
	GetProcessor                 []gax.CallOption
	CreateProcessor              []gax.CallOption
	UpdateProcessor              []gax.CallOption
	DeleteProcessor              []gax.CallOption
	CancelOperation              []gax.CallOption
	DeleteOperation              []gax.CallOption
	GetOperation                 []gax.CallOption
	ListOperations               []gax.CallOption
}

func defaultAppPlatformGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("visionai.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("visionai.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("visionai.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://visionai.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultAppPlatformCallOptions() *AppPlatformCallOptions {
	return &AppPlatformCallOptions{
		ListApplications:             []gax.CallOption{},
		GetApplication:               []gax.CallOption{},
		CreateApplication:            []gax.CallOption{},
		UpdateApplication:            []gax.CallOption{},
		DeleteApplication:            []gax.CallOption{},
		DeployApplication:            []gax.CallOption{},
		UndeployApplication:          []gax.CallOption{},
		AddApplicationStreamInput:    []gax.CallOption{},
		RemoveApplicationStreamInput: []gax.CallOption{},
		UpdateApplicationStreamInput: []gax.CallOption{},
		ListInstances:                []gax.CallOption{},
		GetInstance:                  []gax.CallOption{},
		CreateApplicationInstances:   []gax.CallOption{},
		DeleteApplicationInstances:   []gax.CallOption{},
		UpdateApplicationInstances:   []gax.CallOption{},
		ListDrafts:                   []gax.CallOption{},
		GetDraft:                     []gax.CallOption{},
		CreateDraft:                  []gax.CallOption{},
		UpdateDraft:                  []gax.CallOption{},
		DeleteDraft:                  []gax.CallOption{},
		ListProcessors:               []gax.CallOption{},
		ListPrebuiltProcessors:       []gax.CallOption{},
		GetProcessor:                 []gax.CallOption{},
		CreateProcessor:              []gax.CallOption{},
		UpdateProcessor:              []gax.CallOption{},
		DeleteProcessor:              []gax.CallOption{},
		CancelOperation:              []gax.CallOption{},
		DeleteOperation:              []gax.CallOption{},
		GetOperation:                 []gax.CallOption{},
		ListOperations:               []gax.CallOption{},
	}
}

func defaultAppPlatformRESTCallOptions() *AppPlatformCallOptions {
	return &AppPlatformCallOptions{
		ListApplications:             []gax.CallOption{},
		GetApplication:               []gax.CallOption{},
		CreateApplication:            []gax.CallOption{},
		UpdateApplication:            []gax.CallOption{},
		DeleteApplication:            []gax.CallOption{},
		DeployApplication:            []gax.CallOption{},
		UndeployApplication:          []gax.CallOption{},
		AddApplicationStreamInput:    []gax.CallOption{},
		RemoveApplicationStreamInput: []gax.CallOption{},
		UpdateApplicationStreamInput: []gax.CallOption{},
		ListInstances:                []gax.CallOption{},
		GetInstance:                  []gax.CallOption{},
		CreateApplicationInstances:   []gax.CallOption{},
		DeleteApplicationInstances:   []gax.CallOption{},
		UpdateApplicationInstances:   []gax.CallOption{},
		ListDrafts:                   []gax.CallOption{},
		GetDraft:                     []gax.CallOption{},
		CreateDraft:                  []gax.CallOption{},
		UpdateDraft:                  []gax.CallOption{},
		DeleteDraft:                  []gax.CallOption{},
		ListProcessors:               []gax.CallOption{},
		ListPrebuiltProcessors:       []gax.CallOption{},
		GetProcessor:                 []gax.CallOption{},
		CreateProcessor:              []gax.CallOption{},
		UpdateProcessor:              []gax.CallOption{},
		DeleteProcessor:              []gax.CallOption{},
		CancelOperation:              []gax.CallOption{},
		DeleteOperation:              []gax.CallOption{},
		GetOperation:                 []gax.CallOption{},
		ListOperations:               []gax.CallOption{},
	}
}

// internalAppPlatformClient is an interface that defines the methods available from Vision AI API.
type internalAppPlatformClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListApplications(context.Context, *visionaipb.ListApplicationsRequest, ...gax.CallOption) *ApplicationIterator
	GetApplication(context.Context, *visionaipb.GetApplicationRequest, ...gax.CallOption) (*visionaipb.Application, error)
	CreateApplication(context.Context, *visionaipb.CreateApplicationRequest, ...gax.CallOption) (*CreateApplicationOperation, error)
	CreateApplicationOperation(name string) *CreateApplicationOperation
	UpdateApplication(context.Context, *visionaipb.UpdateApplicationRequest, ...gax.CallOption) (*UpdateApplicationOperation, error)
	UpdateApplicationOperation(name string) *UpdateApplicationOperation
	DeleteApplication(context.Context, *visionaipb.DeleteApplicationRequest, ...gax.CallOption) (*DeleteApplicationOperation, error)
	DeleteApplicationOperation(name string) *DeleteApplicationOperation
	DeployApplication(context.Context, *visionaipb.DeployApplicationRequest, ...gax.CallOption) (*DeployApplicationOperation, error)
	DeployApplicationOperation(name string) *DeployApplicationOperation
	UndeployApplication(context.Context, *visionaipb.UndeployApplicationRequest, ...gax.CallOption) (*UndeployApplicationOperation, error)
	UndeployApplicationOperation(name string) *UndeployApplicationOperation
	AddApplicationStreamInput(context.Context, *visionaipb.AddApplicationStreamInputRequest, ...gax.CallOption) (*AddApplicationStreamInputOperation, error)
	AddApplicationStreamInputOperation(name string) *AddApplicationStreamInputOperation
	RemoveApplicationStreamInput(context.Context, *visionaipb.RemoveApplicationStreamInputRequest, ...gax.CallOption) (*RemoveApplicationStreamInputOperation, error)
	RemoveApplicationStreamInputOperation(name string) *RemoveApplicationStreamInputOperation
	UpdateApplicationStreamInput(context.Context, *visionaipb.UpdateApplicationStreamInputRequest, ...gax.CallOption) (*UpdateApplicationStreamInputOperation, error)
	UpdateApplicationStreamInputOperation(name string) *UpdateApplicationStreamInputOperation
	ListInstances(context.Context, *visionaipb.ListInstancesRequest, ...gax.CallOption) *InstanceIterator
	GetInstance(context.Context, *visionaipb.GetInstanceRequest, ...gax.CallOption) (*visionaipb.Instance, error)
	CreateApplicationInstances(context.Context, *visionaipb.CreateApplicationInstancesRequest, ...gax.CallOption) (*CreateApplicationInstancesOperation, error)
	CreateApplicationInstancesOperation(name string) *CreateApplicationInstancesOperation
	DeleteApplicationInstances(context.Context, *visionaipb.DeleteApplicationInstancesRequest, ...gax.CallOption) (*DeleteApplicationInstancesOperation, error)
	DeleteApplicationInstancesOperation(name string) *DeleteApplicationInstancesOperation
	UpdateApplicationInstances(context.Context, *visionaipb.UpdateApplicationInstancesRequest, ...gax.CallOption) (*UpdateApplicationInstancesOperation, error)
	UpdateApplicationInstancesOperation(name string) *UpdateApplicationInstancesOperation
	ListDrafts(context.Context, *visionaipb.ListDraftsRequest, ...gax.CallOption) *DraftIterator
	GetDraft(context.Context, *visionaipb.GetDraftRequest, ...gax.CallOption) (*visionaipb.Draft, error)
	CreateDraft(context.Context, *visionaipb.CreateDraftRequest, ...gax.CallOption) (*CreateDraftOperation, error)
	CreateDraftOperation(name string) *CreateDraftOperation
	UpdateDraft(context.Context, *visionaipb.UpdateDraftRequest, ...gax.CallOption) (*UpdateDraftOperation, error)
	UpdateDraftOperation(name string) *UpdateDraftOperation
	DeleteDraft(context.Context, *visionaipb.DeleteDraftRequest, ...gax.CallOption) (*DeleteDraftOperation, error)
	DeleteDraftOperation(name string) *DeleteDraftOperation
	ListProcessors(context.Context, *visionaipb.ListProcessorsRequest, ...gax.CallOption) *ProcessorIterator
	ListPrebuiltProcessors(context.Context, *visionaipb.ListPrebuiltProcessorsRequest, ...gax.CallOption) (*visionaipb.ListPrebuiltProcessorsResponse, error)
	GetProcessor(context.Context, *visionaipb.GetProcessorRequest, ...gax.CallOption) (*visionaipb.Processor, error)
	CreateProcessor(context.Context, *visionaipb.CreateProcessorRequest, ...gax.CallOption) (*CreateProcessorOperation, error)
	CreateProcessorOperation(name string) *CreateProcessorOperation
	UpdateProcessor(context.Context, *visionaipb.UpdateProcessorRequest, ...gax.CallOption) (*UpdateProcessorOperation, error)
	UpdateProcessorOperation(name string) *UpdateProcessorOperation
	DeleteProcessor(context.Context, *visionaipb.DeleteProcessorRequest, ...gax.CallOption) (*DeleteProcessorOperation, error)
	DeleteProcessorOperation(name string) *DeleteProcessorOperation
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// AppPlatformClient is a client for interacting with Vision AI API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Service describing handlers for resources
type AppPlatformClient struct {
	// The internal transport-dependent client.
	internalClient internalAppPlatformClient

	// The call options for this service.
	CallOptions *AppPlatformCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *AppPlatformClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *AppPlatformClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *AppPlatformClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListApplications lists Applications in a given project and location.
func (c *AppPlatformClient) ListApplications(ctx context.Context, req *visionaipb.ListApplicationsRequest, opts ...gax.CallOption) *ApplicationIterator {
	return c.internalClient.ListApplications(ctx, req, opts...)
}

// GetApplication gets details of a single Application.
func (c *AppPlatformClient) GetApplication(ctx context.Context, req *visionaipb.GetApplicationRequest, opts ...gax.CallOption) (*visionaipb.Application, error) {
	return c.internalClient.GetApplication(ctx, req, opts...)
}

// CreateApplication creates a new Application in a given project and location.
func (c *AppPlatformClient) CreateApplication(ctx context.Context, req *visionaipb.CreateApplicationRequest, opts ...gax.CallOption) (*CreateApplicationOperation, error) {
	return c.internalClient.CreateApplication(ctx, req, opts...)
}

// CreateApplicationOperation returns a new CreateApplicationOperation from a given name.
// The name must be that of a previously created CreateApplicationOperation, possibly from a different process.
func (c *AppPlatformClient) CreateApplicationOperation(name string) *CreateApplicationOperation {
	return c.internalClient.CreateApplicationOperation(name)
}

// UpdateApplication updates the parameters of a single Application.
func (c *AppPlatformClient) UpdateApplication(ctx context.Context, req *visionaipb.UpdateApplicationRequest, opts ...gax.CallOption) (*UpdateApplicationOperation, error) {
	return c.internalClient.UpdateApplication(ctx, req, opts...)
}

// UpdateApplicationOperation returns a new UpdateApplicationOperation from a given name.
// The name must be that of a previously created UpdateApplicationOperation, possibly from a different process.
func (c *AppPlatformClient) UpdateApplicationOperation(name string) *UpdateApplicationOperation {
	return c.internalClient.UpdateApplicationOperation(name)
}

// DeleteApplication deletes a single Application.
func (c *AppPlatformClient) DeleteApplication(ctx context.Context, req *visionaipb.DeleteApplicationRequest, opts ...gax.CallOption) (*DeleteApplicationOperation, error) {
	return c.internalClient.DeleteApplication(ctx, req, opts...)
}

// DeleteApplicationOperation returns a new DeleteApplicationOperation from a given name.
// The name must be that of a previously created DeleteApplicationOperation, possibly from a different process.
func (c *AppPlatformClient) DeleteApplicationOperation(name string) *DeleteApplicationOperation {
	return c.internalClient.DeleteApplicationOperation(name)
}

// DeployApplication deploys a single Application.
func (c *AppPlatformClient) DeployApplication(ctx context.Context, req *visionaipb.DeployApplicationRequest, opts ...gax.CallOption) (*DeployApplicationOperation, error) {
	return c.internalClient.DeployApplication(ctx, req, opts...)
}

// DeployApplicationOperation returns a new DeployApplicationOperation from a given name.
// The name must be that of a previously created DeployApplicationOperation, possibly from a different process.
func (c *AppPlatformClient) DeployApplicationOperation(name string) *DeployApplicationOperation {
	return c.internalClient.DeployApplicationOperation(name)
}

// UndeployApplication undeploys a single Application.
func (c *AppPlatformClient) UndeployApplication(ctx context.Context, req *visionaipb.UndeployApplicationRequest, opts ...gax.CallOption) (*UndeployApplicationOperation, error) {
	return c.internalClient.UndeployApplication(ctx, req, opts...)
}

// UndeployApplicationOperation returns a new UndeployApplicationOperation from a given name.
// The name must be that of a previously created UndeployApplicationOperation, possibly from a different process.
func (c *AppPlatformClient) UndeployApplicationOperation(name string) *UndeployApplicationOperation {
	return c.internalClient.UndeployApplicationOperation(name)
}

// AddApplicationStreamInput adds target stream input to the Application.
// If the Application is deployed, the corresponding new Application instance
// will be created. If the stream has already been in the Application, the RPC
// will fail.
func (c *AppPlatformClient) AddApplicationStreamInput(ctx context.Context, req *visionaipb.AddApplicationStreamInputRequest, opts ...gax.CallOption) (*AddApplicationStreamInputOperation, error) {
	return c.internalClient.AddApplicationStreamInput(ctx, req, opts...)
}

// AddApplicationStreamInputOperation returns a new AddApplicationStreamInputOperation from a given name.
// The name must be that of a previously created AddApplicationStreamInputOperation, possibly from a different process.
func (c *AppPlatformClient) AddApplicationStreamInputOperation(name string) *AddApplicationStreamInputOperation {
	return c.internalClient.AddApplicationStreamInputOperation(name)
}

// RemoveApplicationStreamInput remove target stream input to the Application, if the Application is
// deployed, the corresponding instance based will be deleted. If the stream
// is not in the Application, the RPC will fail.
func (c *AppPlatformClient) RemoveApplicationStreamInput(ctx context.Context, req *visionaipb.RemoveApplicationStreamInputRequest, opts ...gax.CallOption) (*RemoveApplicationStreamInputOperation, error) {
	return c.internalClient.RemoveApplicationStreamInput(ctx, req, opts...)
}

// RemoveApplicationStreamInputOperation returns a new RemoveApplicationStreamInputOperation from a given name.
// The name must be that of a previously created RemoveApplicationStreamInputOperation, possibly from a different process.
func (c *AppPlatformClient) RemoveApplicationStreamInputOperation(name string) *RemoveApplicationStreamInputOperation {
	return c.internalClient.RemoveApplicationStreamInputOperation(name)
}

// UpdateApplicationStreamInput update target stream input to the Application, if the Application is
// deployed, the corresponding instance based will be deployed. For
// CreateOrUpdate behavior, set allow_missing to true.
func (c *AppPlatformClient) UpdateApplicationStreamInput(ctx context.Context, req *visionaipb.UpdateApplicationStreamInputRequest, opts ...gax.CallOption) (*UpdateApplicationStreamInputOperation, error) {
	return c.internalClient.UpdateApplicationStreamInput(ctx, req, opts...)
}

// UpdateApplicationStreamInputOperation returns a new UpdateApplicationStreamInputOperation from a given name.
// The name must be that of a previously created UpdateApplicationStreamInputOperation, possibly from a different process.
func (c *AppPlatformClient) UpdateApplicationStreamInputOperation(name string) *UpdateApplicationStreamInputOperation {
	return c.internalClient.UpdateApplicationStreamInputOperation(name)
}

// ListInstances lists Instances in a given project and location.
func (c *AppPlatformClient) ListInstances(ctx context.Context, req *visionaipb.ListInstancesRequest, opts ...gax.CallOption) *InstanceIterator {
	return c.internalClient.ListInstances(ctx, req, opts...)
}

// GetInstance gets details of a single Instance.
func (c *AppPlatformClient) GetInstance(ctx context.Context, req *visionaipb.GetInstanceRequest, opts ...gax.CallOption) (*visionaipb.Instance, error) {
	return c.internalClient.GetInstance(ctx, req, opts...)
}

// CreateApplicationInstances adds target stream input to the Application.
// If the Application is deployed, the corresponding new Application instance
// will be created. If the stream has already been in the Application, the RPC
// will fail.
func (c *AppPlatformClient) CreateApplicationInstances(ctx context.Context, req *visionaipb.CreateApplicationInstancesRequest, opts ...gax.CallOption) (*CreateApplicationInstancesOperation, error) {
	return c.internalClient.CreateApplicationInstances(ctx, req, opts...)
}

// CreateApplicationInstancesOperation returns a new CreateApplicationInstancesOperation from a given name.
// The name must be that of a previously created CreateApplicationInstancesOperation, possibly from a different process.
func (c *AppPlatformClient) CreateApplicationInstancesOperation(name string) *CreateApplicationInstancesOperation {
	return c.internalClient.CreateApplicationInstancesOperation(name)
}

// DeleteApplicationInstances remove target stream input to the Application, if the Application is
// deployed, the corresponding instance based will be deleted. If the stream
// is not in the Application, the RPC will fail.
func (c *AppPlatformClient) DeleteApplicationInstances(ctx context.Context, req *visionaipb.DeleteApplicationInstancesRequest, opts ...gax.CallOption) (*DeleteApplicationInstancesOperation, error) {
	return c.internalClient.DeleteApplicationInstances(ctx, req, opts...)
}

// DeleteApplicationInstancesOperation returns a new DeleteApplicationInstancesOperation from a given name.
// The name must be that of a previously created DeleteApplicationInstancesOperation, possibly from a different process.
func (c *AppPlatformClient) DeleteApplicationInstancesOperation(name string) *DeleteApplicationInstancesOperation {
	return c.internalClient.DeleteApplicationInstancesOperation(name)
}

// UpdateApplicationInstances adds target stream input to the Application.
// If the Application is deployed, the corresponding new Application instance
// will be created. If the stream has already been in the Application, the RPC
// will fail.
func (c *AppPlatformClient) UpdateApplicationInstances(ctx context.Context, req *visionaipb.UpdateApplicationInstancesRequest, opts ...gax.CallOption) (*UpdateApplicationInstancesOperation, error) {
	return c.internalClient.UpdateApplicationInstances(ctx, req, opts...)
}

// UpdateApplicationInstancesOperation returns a new UpdateApplicationInstancesOperation from a given name.
// The name must be that of a previously created UpdateApplicationInstancesOperation, possibly from a different process.
func (c *AppPlatformClient) UpdateApplicationInstancesOperation(name string) *UpdateApplicationInstancesOperation {
	return c.internalClient.UpdateApplicationInstancesOperation(name)
}

// ListDrafts lists Drafts in a given project and location.
func (c *AppPlatformClient) ListDrafts(ctx context.Context, req *visionaipb.ListDraftsRequest, opts ...gax.CallOption) *DraftIterator {
	return c.internalClient.ListDrafts(ctx, req, opts...)
}

// GetDraft gets details of a single Draft.
func (c *AppPlatformClient) GetDraft(ctx context.Context, req *visionaipb.GetDraftRequest, opts ...gax.CallOption) (*visionaipb.Draft, error) {
	return c.internalClient.GetDraft(ctx, req, opts...)
}

// CreateDraft creates a new Draft in a given project and location.
func (c *AppPlatformClient) CreateDraft(ctx context.Context, req *visionaipb.CreateDraftRequest, opts ...gax.CallOption) (*CreateDraftOperation, error) {
	return c.internalClient.CreateDraft(ctx, req, opts...)
}

// CreateDraftOperation returns a new CreateDraftOperation from a given name.
// The name must be that of a previously created CreateDraftOperation, possibly from a different process.
func (c *AppPlatformClient) CreateDraftOperation(name string) *CreateDraftOperation {
	return c.internalClient.CreateDraftOperation(name)
}

// UpdateDraft updates the parameters of a single Draft.
func (c *AppPlatformClient) UpdateDraft(ctx context.Context, req *visionaipb.UpdateDraftRequest, opts ...gax.CallOption) (*UpdateDraftOperation, error) {
	return c.internalClient.UpdateDraft(ctx, req, opts...)
}

// UpdateDraftOperation returns a new UpdateDraftOperation from a given name.
// The name must be that of a previously created UpdateDraftOperation, possibly from a different process.
func (c *AppPlatformClient) UpdateDraftOperation(name string) *UpdateDraftOperation {
	return c.internalClient.UpdateDraftOperation(name)
}

// DeleteDraft deletes a single Draft.
func (c *AppPlatformClient) DeleteDraft(ctx context.Context, req *visionaipb.DeleteDraftRequest, opts ...gax.CallOption) (*DeleteDraftOperation, error) {
	return c.internalClient.DeleteDraft(ctx, req, opts...)
}

// DeleteDraftOperation returns a new DeleteDraftOperation from a given name.
// The name must be that of a previously created DeleteDraftOperation, possibly from a different process.
func (c *AppPlatformClient) DeleteDraftOperation(name string) *DeleteDraftOperation {
	return c.internalClient.DeleteDraftOperation(name)
}

// ListProcessors lists Processors in a given project and location.
func (c *AppPlatformClient) ListProcessors(ctx context.Context, req *visionaipb.ListProcessorsRequest, opts ...gax.CallOption) *ProcessorIterator {
	return c.internalClient.ListProcessors(ctx, req, opts...)
}

// ListPrebuiltProcessors listPrebuiltProcessors is a custom pass-through verb that Lists Prebuilt
// Processors.
func (c *AppPlatformClient) ListPrebuiltProcessors(ctx context.Context, req *visionaipb.ListPrebuiltProcessorsRequest, opts ...gax.CallOption) (*visionaipb.ListPrebuiltProcessorsResponse, error) {
	return c.internalClient.ListPrebuiltProcessors(ctx, req, opts...)
}

// GetProcessor gets details of a single Processor.
func (c *AppPlatformClient) GetProcessor(ctx context.Context, req *visionaipb.GetProcessorRequest, opts ...gax.CallOption) (*visionaipb.Processor, error) {
	return c.internalClient.GetProcessor(ctx, req, opts...)
}

// CreateProcessor creates a new Processor in a given project and location.
func (c *AppPlatformClient) CreateProcessor(ctx context.Context, req *visionaipb.CreateProcessorRequest, opts ...gax.CallOption) (*CreateProcessorOperation, error) {
	return c.internalClient.CreateProcessor(ctx, req, opts...)
}

// CreateProcessorOperation returns a new CreateProcessorOperation from a given name.
// The name must be that of a previously created CreateProcessorOperation, possibly from a different process.
func (c *AppPlatformClient) CreateProcessorOperation(name string) *CreateProcessorOperation {
	return c.internalClient.CreateProcessorOperation(name)
}

// UpdateProcessor updates the parameters of a single Processor.
func (c *AppPlatformClient) UpdateProcessor(ctx context.Context, req *visionaipb.UpdateProcessorRequest, opts ...gax.CallOption) (*UpdateProcessorOperation, error) {
	return c.internalClient.UpdateProcessor(ctx, req, opts...)
}

// UpdateProcessorOperation returns a new UpdateProcessorOperation from a given name.
// The name must be that of a previously created UpdateProcessorOperation, possibly from a different process.
func (c *AppPlatformClient) UpdateProcessorOperation(name string) *UpdateProcessorOperation {
	return c.internalClient.UpdateProcessorOperation(name)
}

// DeleteProcessor deletes a single Processor.
func (c *AppPlatformClient) DeleteProcessor(ctx context.Context, req *visionaipb.DeleteProcessorRequest, opts ...gax.CallOption) (*DeleteProcessorOperation, error) {
	return c.internalClient.DeleteProcessor(ctx, req, opts...)
}

// DeleteProcessorOperation returns a new DeleteProcessorOperation from a given name.
// The name must be that of a previously created DeleteProcessorOperation, possibly from a different process.
func (c *AppPlatformClient) DeleteProcessorOperation(name string) *DeleteProcessorOperation {
	return c.internalClient.DeleteProcessorOperation(name)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *AppPlatformClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *AppPlatformClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *AppPlatformClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *AppPlatformClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// appPlatformGRPCClient is a client for interacting with Vision AI API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type appPlatformGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing AppPlatformClient
	CallOptions **AppPlatformCallOptions

	// The gRPC API client.
	appPlatformClient visionaipb.AppPlatformClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string
}

// NewAppPlatformClient creates a new app platform client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Service describing handlers for resources
func NewAppPlatformClient(ctx context.Context, opts ...option.ClientOption) (*AppPlatformClient, error) {
	clientOpts := defaultAppPlatformGRPCClientOptions()
	if newAppPlatformClientHook != nil {
		hookOpts, err := newAppPlatformClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := AppPlatformClient{CallOptions: defaultAppPlatformCallOptions()}

	c := &appPlatformGRPCClient{
		connPool:          connPool,
		appPlatformClient: visionaipb.NewAppPlatformClient(connPool),
		CallOptions:       &client.CallOptions,
		operationsClient:  longrunningpb.NewOperationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *appPlatformGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *appPlatformGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{"x-goog-api-client", gax.XGoogHeader(kv...)}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *appPlatformGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type appPlatformRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing AppPlatformClient
	CallOptions **AppPlatformCallOptions
}

// NewAppPlatformRESTClient creates a new app platform rest client.
//
// Service describing handlers for resources
func NewAppPlatformRESTClient(ctx context.Context, opts ...option.ClientOption) (*AppPlatformClient, error) {
	clientOpts := append(defaultAppPlatformRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultAppPlatformRESTCallOptions()
	c := &appPlatformRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &AppPlatformClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultAppPlatformRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://visionai.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://visionai.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://visionai.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://visionai.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *appPlatformRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{"x-goog-api-client", gax.XGoogHeader(kv...)}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *appPlatformRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *appPlatformRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *appPlatformGRPCClient) ListApplications(ctx context.Context, req *visionaipb.ListApplicationsRequest, opts ...gax.CallOption) *ApplicationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListApplications[0:len((*c.CallOptions).ListApplications):len((*c.CallOptions).ListApplications)], opts...)
	it := &ApplicationIterator{}
	req = proto.Clone(req).(*visionaipb.ListApplicationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.Application, string, error) {
		resp := &visionaipb.ListApplicationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.appPlatformClient.ListApplications(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetApplications(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *appPlatformGRPCClient) GetApplication(ctx context.Context, req *visionaipb.GetApplicationRequest, opts ...gax.CallOption) (*visionaipb.Application, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetApplication[0:len((*c.CallOptions).GetApplication):len((*c.CallOptions).GetApplication)], opts...)
	var resp *visionaipb.Application
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.GetApplication(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *appPlatformGRPCClient) CreateApplication(ctx context.Context, req *visionaipb.CreateApplicationRequest, opts ...gax.CallOption) (*CreateApplicationOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateApplication[0:len((*c.CallOptions).CreateApplication):len((*c.CallOptions).CreateApplication)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.CreateApplication(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateApplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *appPlatformGRPCClient) UpdateApplication(ctx context.Context, req *visionaipb.UpdateApplicationRequest, opts ...gax.CallOption) (*UpdateApplicationOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "application.name", url.QueryEscape(req.GetApplication().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateApplication[0:len((*c.CallOptions).UpdateApplication):len((*c.CallOptions).UpdateApplication)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.UpdateApplication(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateApplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *appPlatformGRPCClient) DeleteApplication(ctx context.Context, req *visionaipb.DeleteApplicationRequest, opts ...gax.CallOption) (*DeleteApplicationOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteApplication[0:len((*c.CallOptions).DeleteApplication):len((*c.CallOptions).DeleteApplication)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.DeleteApplication(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteApplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *appPlatformGRPCClient) DeployApplication(ctx context.Context, req *visionaipb.DeployApplicationRequest, opts ...gax.CallOption) (*DeployApplicationOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeployApplication[0:len((*c.CallOptions).DeployApplication):len((*c.CallOptions).DeployApplication)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.DeployApplication(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeployApplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *appPlatformGRPCClient) UndeployApplication(ctx context.Context, req *visionaipb.UndeployApplicationRequest, opts ...gax.CallOption) (*UndeployApplicationOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UndeployApplication[0:len((*c.CallOptions).UndeployApplication):len((*c.CallOptions).UndeployApplication)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.UndeployApplication(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UndeployApplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *appPlatformGRPCClient) AddApplicationStreamInput(ctx context.Context, req *visionaipb.AddApplicationStreamInputRequest, opts ...gax.CallOption) (*AddApplicationStreamInputOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).AddApplicationStreamInput[0:len((*c.CallOptions).AddApplicationStreamInput):len((*c.CallOptions).AddApplicationStreamInput)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.AddApplicationStreamInput(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &AddApplicationStreamInputOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *appPlatformGRPCClient) RemoveApplicationStreamInput(ctx context.Context, req *visionaipb.RemoveApplicationStreamInputRequest, opts ...gax.CallOption) (*RemoveApplicationStreamInputOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RemoveApplicationStreamInput[0:len((*c.CallOptions).RemoveApplicationStreamInput):len((*c.CallOptions).RemoveApplicationStreamInput)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.RemoveApplicationStreamInput(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &RemoveApplicationStreamInputOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *appPlatformGRPCClient) UpdateApplicationStreamInput(ctx context.Context, req *visionaipb.UpdateApplicationStreamInputRequest, opts ...gax.CallOption) (*UpdateApplicationStreamInputOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateApplicationStreamInput[0:len((*c.CallOptions).UpdateApplicationStreamInput):len((*c.CallOptions).UpdateApplicationStreamInput)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.UpdateApplicationStreamInput(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateApplicationStreamInputOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *appPlatformGRPCClient) ListInstances(ctx context.Context, req *visionaipb.ListInstancesRequest, opts ...gax.CallOption) *InstanceIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListInstances[0:len((*c.CallOptions).ListInstances):len((*c.CallOptions).ListInstances)], opts...)
	it := &InstanceIterator{}
	req = proto.Clone(req).(*visionaipb.ListInstancesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.Instance, string, error) {
		resp := &visionaipb.ListInstancesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.appPlatformClient.ListInstances(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetInstances(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *appPlatformGRPCClient) GetInstance(ctx context.Context, req *visionaipb.GetInstanceRequest, opts ...gax.CallOption) (*visionaipb.Instance, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetInstance[0:len((*c.CallOptions).GetInstance):len((*c.CallOptions).GetInstance)], opts...)
	var resp *visionaipb.Instance
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.GetInstance(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *appPlatformGRPCClient) CreateApplicationInstances(ctx context.Context, req *visionaipb.CreateApplicationInstancesRequest, opts ...gax.CallOption) (*CreateApplicationInstancesOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateApplicationInstances[0:len((*c.CallOptions).CreateApplicationInstances):len((*c.CallOptions).CreateApplicationInstances)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.CreateApplicationInstances(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateApplicationInstancesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *appPlatformGRPCClient) DeleteApplicationInstances(ctx context.Context, req *visionaipb.DeleteApplicationInstancesRequest, opts ...gax.CallOption) (*DeleteApplicationInstancesOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteApplicationInstances[0:len((*c.CallOptions).DeleteApplicationInstances):len((*c.CallOptions).DeleteApplicationInstances)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.DeleteApplicationInstances(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteApplicationInstancesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *appPlatformGRPCClient) UpdateApplicationInstances(ctx context.Context, req *visionaipb.UpdateApplicationInstancesRequest, opts ...gax.CallOption) (*UpdateApplicationInstancesOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateApplicationInstances[0:len((*c.CallOptions).UpdateApplicationInstances):len((*c.CallOptions).UpdateApplicationInstances)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.UpdateApplicationInstances(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateApplicationInstancesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *appPlatformGRPCClient) ListDrafts(ctx context.Context, req *visionaipb.ListDraftsRequest, opts ...gax.CallOption) *DraftIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListDrafts[0:len((*c.CallOptions).ListDrafts):len((*c.CallOptions).ListDrafts)], opts...)
	it := &DraftIterator{}
	req = proto.Clone(req).(*visionaipb.ListDraftsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.Draft, string, error) {
		resp := &visionaipb.ListDraftsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.appPlatformClient.ListDrafts(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetDrafts(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *appPlatformGRPCClient) GetDraft(ctx context.Context, req *visionaipb.GetDraftRequest, opts ...gax.CallOption) (*visionaipb.Draft, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetDraft[0:len((*c.CallOptions).GetDraft):len((*c.CallOptions).GetDraft)], opts...)
	var resp *visionaipb.Draft
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.GetDraft(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *appPlatformGRPCClient) CreateDraft(ctx context.Context, req *visionaipb.CreateDraftRequest, opts ...gax.CallOption) (*CreateDraftOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateDraft[0:len((*c.CallOptions).CreateDraft):len((*c.CallOptions).CreateDraft)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.CreateDraft(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateDraftOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *appPlatformGRPCClient) UpdateDraft(ctx context.Context, req *visionaipb.UpdateDraftRequest, opts ...gax.CallOption) (*UpdateDraftOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "draft.name", url.QueryEscape(req.GetDraft().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateDraft[0:len((*c.CallOptions).UpdateDraft):len((*c.CallOptions).UpdateDraft)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.UpdateDraft(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateDraftOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *appPlatformGRPCClient) DeleteDraft(ctx context.Context, req *visionaipb.DeleteDraftRequest, opts ...gax.CallOption) (*DeleteDraftOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteDraft[0:len((*c.CallOptions).DeleteDraft):len((*c.CallOptions).DeleteDraft)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.DeleteDraft(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteDraftOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *appPlatformGRPCClient) ListProcessors(ctx context.Context, req *visionaipb.ListProcessorsRequest, opts ...gax.CallOption) *ProcessorIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListProcessors[0:len((*c.CallOptions).ListProcessors):len((*c.CallOptions).ListProcessors)], opts...)
	it := &ProcessorIterator{}
	req = proto.Clone(req).(*visionaipb.ListProcessorsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.Processor, string, error) {
		resp := &visionaipb.ListProcessorsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.appPlatformClient.ListProcessors(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetProcessors(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *appPlatformGRPCClient) ListPrebuiltProcessors(ctx context.Context, req *visionaipb.ListPrebuiltProcessorsRequest, opts ...gax.CallOption) (*visionaipb.ListPrebuiltProcessorsResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListPrebuiltProcessors[0:len((*c.CallOptions).ListPrebuiltProcessors):len((*c.CallOptions).ListPrebuiltProcessors)], opts...)
	var resp *visionaipb.ListPrebuiltProcessorsResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.ListPrebuiltProcessors(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *appPlatformGRPCClient) GetProcessor(ctx context.Context, req *visionaipb.GetProcessorRequest, opts ...gax.CallOption) (*visionaipb.Processor, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetProcessor[0:len((*c.CallOptions).GetProcessor):len((*c.CallOptions).GetProcessor)], opts...)
	var resp *visionaipb.Processor
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.GetProcessor(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *appPlatformGRPCClient) CreateProcessor(ctx context.Context, req *visionaipb.CreateProcessorRequest, opts ...gax.CallOption) (*CreateProcessorOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateProcessor[0:len((*c.CallOptions).CreateProcessor):len((*c.CallOptions).CreateProcessor)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.CreateProcessor(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateProcessorOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *appPlatformGRPCClient) UpdateProcessor(ctx context.Context, req *visionaipb.UpdateProcessorRequest, opts ...gax.CallOption) (*UpdateProcessorOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "processor.name", url.QueryEscape(req.GetProcessor().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateProcessor[0:len((*c.CallOptions).UpdateProcessor):len((*c.CallOptions).UpdateProcessor)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.UpdateProcessor(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateProcessorOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *appPlatformGRPCClient) DeleteProcessor(ctx context.Context, req *visionaipb.DeleteProcessorRequest, opts ...gax.CallOption) (*DeleteProcessorOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteProcessor[0:len((*c.CallOptions).DeleteProcessor):len((*c.CallOptions).DeleteProcessor)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.appPlatformClient.DeleteProcessor(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteProcessorOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *appPlatformGRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.operationsClient.CancelOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *appPlatformGRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.operationsClient.DeleteOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *appPlatformGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.operationsClient.GetOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *appPlatformGRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.operationsClient.ListOperations(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListApplications lists Applications in a given project and location.
func (c *appPlatformRESTClient) ListApplications(ctx context.Context, req *visionaipb.ListApplicationsRequest, opts ...gax.CallOption) *ApplicationIterator {
	it := &ApplicationIterator{}
	req = proto.Clone(req).(*visionaipb.ListApplicationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.Application, string, error) {
		resp := &visionaipb.ListApplicationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/applications", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetApplications(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetApplication gets details of a single Application.
func (c *appPlatformRESTClient) GetApplication(ctx context.Context, req *visionaipb.GetApplicationRequest, opts ...gax.CallOption) (*visionaipb.Application, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetApplication[0:len((*c.CallOptions).GetApplication):len((*c.CallOptions).GetApplication)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.Application{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateApplication creates a new Application in a given project and location.
func (c *appPlatformRESTClient) CreateApplication(ctx context.Context, req *visionaipb.CreateApplicationRequest, opts ...gax.CallOption) (*CreateApplicationOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetApplication()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/applications", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("applicationId", fmt.Sprintf("%v", req.GetApplicationId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateApplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateApplication updates the parameters of a single Application.
func (c *appPlatformRESTClient) UpdateApplication(ctx context.Context, req *visionaipb.UpdateApplicationRequest, opts ...gax.CallOption) (*UpdateApplicationOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetApplication()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetApplication().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "application.name", url.QueryEscape(req.GetApplication().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateApplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteApplication deletes a single Application.
func (c *appPlatformRESTClient) DeleteApplication(ctx context.Context, req *visionaipb.DeleteApplicationRequest, opts ...gax.CallOption) (*DeleteApplicationOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetForce() {
		params.Add("force", fmt.Sprintf("%v", req.GetForce()))
	}
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteApplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeployApplication deploys a single Application.
func (c *appPlatformRESTClient) DeployApplication(ctx context.Context, req *visionaipb.DeployApplicationRequest, opts ...gax.CallOption) (*DeployApplicationOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:deploy", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeployApplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UndeployApplication undeploys a single Application.
func (c *appPlatformRESTClient) UndeployApplication(ctx context.Context, req *visionaipb.UndeployApplicationRequest, opts ...gax.CallOption) (*UndeployApplicationOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:undeploy", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UndeployApplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// AddApplicationStreamInput adds target stream input to the Application.
// If the Application is deployed, the corresponding new Application instance
// will be created. If the stream has already been in the Application, the RPC
// will fail.
func (c *appPlatformRESTClient) AddApplicationStreamInput(ctx context.Context, req *visionaipb.AddApplicationStreamInputRequest, opts ...gax.CallOption) (*AddApplicationStreamInputOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:addStreamInput", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &AddApplicationStreamInputOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// RemoveApplicationStreamInput remove target stream input to the Application, if the Application is
// deployed, the corresponding instance based will be deleted. If the stream
// is not in the Application, the RPC will fail.
func (c *appPlatformRESTClient) RemoveApplicationStreamInput(ctx context.Context, req *visionaipb.RemoveApplicationStreamInputRequest, opts ...gax.CallOption) (*RemoveApplicationStreamInputOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:removeStreamInput", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &RemoveApplicationStreamInputOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateApplicationStreamInput update target stream input to the Application, if the Application is
// deployed, the corresponding instance based will be deployed. For
// CreateOrUpdate behavior, set allow_missing to true.
func (c *appPlatformRESTClient) UpdateApplicationStreamInput(ctx context.Context, req *visionaipb.UpdateApplicationStreamInputRequest, opts ...gax.CallOption) (*UpdateApplicationStreamInputOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:updateStreamInput", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateApplicationStreamInputOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListInstances lists Instances in a given project and location.
func (c *appPlatformRESTClient) ListInstances(ctx context.Context, req *visionaipb.ListInstancesRequest, opts ...gax.CallOption) *InstanceIterator {
	it := &InstanceIterator{}
	req = proto.Clone(req).(*visionaipb.ListInstancesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.Instance, string, error) {
		resp := &visionaipb.ListInstancesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/instances", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetInstances(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetInstance gets details of a single Instance.
func (c *appPlatformRESTClient) GetInstance(ctx context.Context, req *visionaipb.GetInstanceRequest, opts ...gax.CallOption) (*visionaipb.Instance, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetInstance[0:len((*c.CallOptions).GetInstance):len((*c.CallOptions).GetInstance)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.Instance{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateApplicationInstances adds target stream input to the Application.
// If the Application is deployed, the corresponding new Application instance
// will be created. If the stream has already been in the Application, the RPC
// will fail.
func (c *appPlatformRESTClient) CreateApplicationInstances(ctx context.Context, req *visionaipb.CreateApplicationInstancesRequest, opts ...gax.CallOption) (*CreateApplicationInstancesOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:createApplicationInstances", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateApplicationInstancesOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteApplicationInstances remove target stream input to the Application, if the Application is
// deployed, the corresponding instance based will be deleted. If the stream
// is not in the Application, the RPC will fail.
func (c *appPlatformRESTClient) DeleteApplicationInstances(ctx context.Context, req *visionaipb.DeleteApplicationInstancesRequest, opts ...gax.CallOption) (*DeleteApplicationInstancesOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:deleteApplicationInstances", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteApplicationInstancesOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateApplicationInstances adds target stream input to the Application.
// If the Application is deployed, the corresponding new Application instance
// will be created. If the stream has already been in the Application, the RPC
// will fail.
func (c *appPlatformRESTClient) UpdateApplicationInstances(ctx context.Context, req *visionaipb.UpdateApplicationInstancesRequest, opts ...gax.CallOption) (*UpdateApplicationInstancesOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:updateApplicationInstances", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateApplicationInstancesOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListDrafts lists Drafts in a given project and location.
func (c *appPlatformRESTClient) ListDrafts(ctx context.Context, req *visionaipb.ListDraftsRequest, opts ...gax.CallOption) *DraftIterator {
	it := &DraftIterator{}
	req = proto.Clone(req).(*visionaipb.ListDraftsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.Draft, string, error) {
		resp := &visionaipb.ListDraftsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/drafts", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetDrafts(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetDraft gets details of a single Draft.
func (c *appPlatformRESTClient) GetDraft(ctx context.Context, req *visionaipb.GetDraftRequest, opts ...gax.CallOption) (*visionaipb.Draft, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetDraft[0:len((*c.CallOptions).GetDraft):len((*c.CallOptions).GetDraft)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.Draft{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateDraft creates a new Draft in a given project and location.
func (c *appPlatformRESTClient) CreateDraft(ctx context.Context, req *visionaipb.CreateDraftRequest, opts ...gax.CallOption) (*CreateDraftOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetDraft()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/drafts", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("draftId", fmt.Sprintf("%v", req.GetDraftId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateDraftOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateDraft updates the parameters of a single Draft.
func (c *appPlatformRESTClient) UpdateDraft(ctx context.Context, req *visionaipb.UpdateDraftRequest, opts ...gax.CallOption) (*UpdateDraftOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetDraft()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetDraft().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetAllowMissing() {
		params.Add("allowMissing", fmt.Sprintf("%v", req.GetAllowMissing()))
	}
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "draft.name", url.QueryEscape(req.GetDraft().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateDraftOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteDraft deletes a single Draft.
func (c *appPlatformRESTClient) DeleteDraft(ctx context.Context, req *visionaipb.DeleteDraftRequest, opts ...gax.CallOption) (*DeleteDraftOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteDraftOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListProcessors lists Processors in a given project and location.
func (c *appPlatformRESTClient) ListProcessors(ctx context.Context, req *visionaipb.ListProcessorsRequest, opts ...gax.CallOption) *ProcessorIterator {
	it := &ProcessorIterator{}
	req = proto.Clone(req).(*visionaipb.ListProcessorsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.Processor, string, error) {
		resp := &visionaipb.ListProcessorsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/processors", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetProcessors(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListPrebuiltProcessors listPrebuiltProcessors is a custom pass-through verb that Lists Prebuilt
// Processors.
func (c *appPlatformRESTClient) ListPrebuiltProcessors(ctx context.Context, req *visionaipb.ListPrebuiltProcessorsRequest, opts ...gax.CallOption) (*visionaipb.ListPrebuiltProcessorsResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/processors:prebuilt", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).ListPrebuiltProcessors[0:len((*c.CallOptions).ListPrebuiltProcessors):len((*c.CallOptions).ListPrebuiltProcessors)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.ListPrebuiltProcessorsResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetProcessor gets details of a single Processor.
func (c *appPlatformRESTClient) GetProcessor(ctx context.Context, req *visionaipb.GetProcessorRequest, opts ...gax.CallOption) (*visionaipb.Processor, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetProcessor[0:len((*c.CallOptions).GetProcessor):len((*c.CallOptions).GetProcessor)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.Processor{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateProcessor creates a new Processor in a given project and location.
func (c *appPlatformRESTClient) CreateProcessor(ctx context.Context, req *visionaipb.CreateProcessorRequest, opts ...gax.CallOption) (*CreateProcessorOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetProcessor()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/processors", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("processorId", fmt.Sprintf("%v", req.GetProcessorId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateProcessorOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateProcessor updates the parameters of a single Processor.
func (c *appPlatformRESTClient) UpdateProcessor(ctx context.Context, req *visionaipb.UpdateProcessorRequest, opts ...gax.CallOption) (*UpdateProcessorOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetProcessor()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetProcessor().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "processor.name", url.QueryEscape(req.GetProcessor().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateProcessorOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteProcessor deletes a single Processor.
func (c *appPlatformRESTClient) DeleteProcessor(ctx context.Context, req *visionaipb.DeleteProcessorRequest, opts ...gax.CallOption) (*DeleteProcessorOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteProcessorOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *appPlatformRESTClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:cancel", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		// Returns nil if there is no error, otherwise wraps
		// the response code and body into a non-nil error
		return googleapi.CheckResponse(httpRsp)
	}, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *appPlatformRESTClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		// Returns nil if there is no error, otherwise wraps
		// the response code and body into a non-nil error
		return googleapi.CheckResponse(httpRsp)
	}, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *appPlatformRESTClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *appPlatformRESTClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/operations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// AddApplicationStreamInputOperation returns a new AddApplicationStreamInputOperation from a given name.
// The name must be that of a previously created AddApplicationStreamInputOperation, possibly from a different process.
func (c *appPlatformGRPCClient) AddApplicationStreamInputOperation(name string) *AddApplicationStreamInputOperation {
	return &AddApplicationStreamInputOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// AddApplicationStreamInputOperation returns a new AddApplicationStreamInputOperation from a given name.
// The name must be that of a previously created AddApplicationStreamInputOperation, possibly from a different process.
func (c *appPlatformRESTClient) AddApplicationStreamInputOperation(name string) *AddApplicationStreamInputOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &AddApplicationStreamInputOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateApplicationOperation returns a new CreateApplicationOperation from a given name.
// The name must be that of a previously created CreateApplicationOperation, possibly from a different process.
func (c *appPlatformGRPCClient) CreateApplicationOperation(name string) *CreateApplicationOperation {
	return &CreateApplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateApplicationOperation returns a new CreateApplicationOperation from a given name.
// The name must be that of a previously created CreateApplicationOperation, possibly from a different process.
func (c *appPlatformRESTClient) CreateApplicationOperation(name string) *CreateApplicationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateApplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateApplicationInstancesOperation returns a new CreateApplicationInstancesOperation from a given name.
// The name must be that of a previously created CreateApplicationInstancesOperation, possibly from a different process.
func (c *appPlatformGRPCClient) CreateApplicationInstancesOperation(name string) *CreateApplicationInstancesOperation {
	return &CreateApplicationInstancesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateApplicationInstancesOperation returns a new CreateApplicationInstancesOperation from a given name.
// The name must be that of a previously created CreateApplicationInstancesOperation, possibly from a different process.
func (c *appPlatformRESTClient) CreateApplicationInstancesOperation(name string) *CreateApplicationInstancesOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateApplicationInstancesOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateDraftOperation returns a new CreateDraftOperation from a given name.
// The name must be that of a previously created CreateDraftOperation, possibly from a different process.
func (c *appPlatformGRPCClient) CreateDraftOperation(name string) *CreateDraftOperation {
	return &CreateDraftOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateDraftOperation returns a new CreateDraftOperation from a given name.
// The name must be that of a previously created CreateDraftOperation, possibly from a different process.
func (c *appPlatformRESTClient) CreateDraftOperation(name string) *CreateDraftOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateDraftOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateProcessorOperation returns a new CreateProcessorOperation from a given name.
// The name must be that of a previously created CreateProcessorOperation, possibly from a different process.
func (c *appPlatformGRPCClient) CreateProcessorOperation(name string) *CreateProcessorOperation {
	return &CreateProcessorOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateProcessorOperation returns a new CreateProcessorOperation from a given name.
// The name must be that of a previously created CreateProcessorOperation, possibly from a different process.
func (c *appPlatformRESTClient) CreateProcessorOperation(name string) *CreateProcessorOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateProcessorOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteApplicationOperation returns a new DeleteApplicationOperation from a given name.
// The name must be that of a previously created DeleteApplicationOperation, possibly from a different process.
func (c *appPlatformGRPCClient) DeleteApplicationOperation(name string) *DeleteApplicationOperation {
	return &DeleteApplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteApplicationOperation returns a new DeleteApplicationOperation from a given name.
// The name must be that of a previously created DeleteApplicationOperation, possibly from a different process.
func (c *appPlatformRESTClient) DeleteApplicationOperation(name string) *DeleteApplicationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteApplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteApplicationInstancesOperation returns a new DeleteApplicationInstancesOperation from a given name.
// The name must be that of a previously created DeleteApplicationInstancesOperation, possibly from a different process.
func (c *appPlatformGRPCClient) DeleteApplicationInstancesOperation(name string) *DeleteApplicationInstancesOperation {
	return &DeleteApplicationInstancesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteApplicationInstancesOperation returns a new DeleteApplicationInstancesOperation from a given name.
// The name must be that of a previously created DeleteApplicationInstancesOperation, possibly from a different process.
func (c *appPlatformRESTClient) DeleteApplicationInstancesOperation(name string) *DeleteApplicationInstancesOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteApplicationInstancesOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteDraftOperation returns a new DeleteDraftOperation from a given name.
// The name must be that of a previously created DeleteDraftOperation, possibly from a different process.
func (c *appPlatformGRPCClient) DeleteDraftOperation(name string) *DeleteDraftOperation {
	return &DeleteDraftOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteDraftOperation returns a new DeleteDraftOperation from a given name.
// The name must be that of a previously created DeleteDraftOperation, possibly from a different process.
func (c *appPlatformRESTClient) DeleteDraftOperation(name string) *DeleteDraftOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteDraftOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteProcessorOperation returns a new DeleteProcessorOperation from a given name.
// The name must be that of a previously created DeleteProcessorOperation, possibly from a different process.
func (c *appPlatformGRPCClient) DeleteProcessorOperation(name string) *DeleteProcessorOperation {
	return &DeleteProcessorOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteProcessorOperation returns a new DeleteProcessorOperation from a given name.
// The name must be that of a previously created DeleteProcessorOperation, possibly from a different process.
func (c *appPlatformRESTClient) DeleteProcessorOperation(name string) *DeleteProcessorOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteProcessorOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeployApplicationOperation returns a new DeployApplicationOperation from a given name.
// The name must be that of a previously created DeployApplicationOperation, possibly from a different process.
func (c *appPlatformGRPCClient) DeployApplicationOperation(name string) *DeployApplicationOperation {
	return &DeployApplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeployApplicationOperation returns a new DeployApplicationOperation from a given name.
// The name must be that of a previously created DeployApplicationOperation, possibly from a different process.
func (c *appPlatformRESTClient) DeployApplicationOperation(name string) *DeployApplicationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeployApplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// RemoveApplicationStreamInputOperation returns a new RemoveApplicationStreamInputOperation from a given name.
// The name must be that of a previously created RemoveApplicationStreamInputOperation, possibly from a different process.
func (c *appPlatformGRPCClient) RemoveApplicationStreamInputOperation(name string) *RemoveApplicationStreamInputOperation {
	return &RemoveApplicationStreamInputOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// RemoveApplicationStreamInputOperation returns a new RemoveApplicationStreamInputOperation from a given name.
// The name must be that of a previously created RemoveApplicationStreamInputOperation, possibly from a different process.
func (c *appPlatformRESTClient) RemoveApplicationStreamInputOperation(name string) *RemoveApplicationStreamInputOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &RemoveApplicationStreamInputOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UndeployApplicationOperation returns a new UndeployApplicationOperation from a given name.
// The name must be that of a previously created UndeployApplicationOperation, possibly from a different process.
func (c *appPlatformGRPCClient) UndeployApplicationOperation(name string) *UndeployApplicationOperation {
	return &UndeployApplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UndeployApplicationOperation returns a new UndeployApplicationOperation from a given name.
// The name must be that of a previously created UndeployApplicationOperation, possibly from a different process.
func (c *appPlatformRESTClient) UndeployApplicationOperation(name string) *UndeployApplicationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UndeployApplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateApplicationOperation returns a new UpdateApplicationOperation from a given name.
// The name must be that of a previously created UpdateApplicationOperation, possibly from a different process.
func (c *appPlatformGRPCClient) UpdateApplicationOperation(name string) *UpdateApplicationOperation {
	return &UpdateApplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateApplicationOperation returns a new UpdateApplicationOperation from a given name.
// The name must be that of a previously created UpdateApplicationOperation, possibly from a different process.
func (c *appPlatformRESTClient) UpdateApplicationOperation(name string) *UpdateApplicationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateApplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateApplicationInstancesOperation returns a new UpdateApplicationInstancesOperation from a given name.
// The name must be that of a previously created UpdateApplicationInstancesOperation, possibly from a different process.
func (c *appPlatformGRPCClient) UpdateApplicationInstancesOperation(name string) *UpdateApplicationInstancesOperation {
	return &UpdateApplicationInstancesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateApplicationInstancesOperation returns a new UpdateApplicationInstancesOperation from a given name.
// The name must be that of a previously created UpdateApplicationInstancesOperation, possibly from a different process.
func (c *appPlatformRESTClient) UpdateApplicationInstancesOperation(name string) *UpdateApplicationInstancesOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateApplicationInstancesOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateApplicationStreamInputOperation returns a new UpdateApplicationStreamInputOperation from a given name.
// The name must be that of a previously created UpdateApplicationStreamInputOperation, possibly from a different process.
func (c *appPlatformGRPCClient) UpdateApplicationStreamInputOperation(name string) *UpdateApplicationStreamInputOperation {
	return &UpdateApplicationStreamInputOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateApplicationStreamInputOperation returns a new UpdateApplicationStreamInputOperation from a given name.
// The name must be that of a previously created UpdateApplicationStreamInputOperation, possibly from a different process.
func (c *appPlatformRESTClient) UpdateApplicationStreamInputOperation(name string) *UpdateApplicationStreamInputOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateApplicationStreamInputOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateDraftOperation returns a new UpdateDraftOperation from a given name.
// The name must be that of a previously created UpdateDraftOperation, possibly from a different process.
func (c *appPlatformGRPCClient) UpdateDraftOperation(name string) *UpdateDraftOperation {
	return &UpdateDraftOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateDraftOperation returns a new UpdateDraftOperation from a given name.
// The name must be that of a previously created UpdateDraftOperation, possibly from a different process.
func (c *appPlatformRESTClient) UpdateDraftOperation(name string) *UpdateDraftOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateDraftOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateProcessorOperation returns a new UpdateProcessorOperation from a given name.
// The name must be that of a previously created UpdateProcessorOperation, possibly from a different process.
func (c *appPlatformGRPCClient) UpdateProcessorOperation(name string) *UpdateProcessorOperation {
	return &UpdateProcessorOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateProcessorOperation returns a new UpdateProcessorOperation from a given name.
// The name must be that of a previously created UpdateProcessorOperation, possibly from a different process.
func (c *appPlatformRESTClient) UpdateProcessorOperation(name string) *UpdateProcessorOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateProcessorOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}
