//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armtestbase

import "time"

// AccountListResult - A list of Test Base Accounts.
type AccountListResult struct {
	// The list of Test Base Accounts.
	Value []*AccountResource `json:"value,omitempty"`

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// AccountResource - The Test Base Account resource.
type AccountResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Properties of a Test Base Account.
	Properties *AccountResourceProperties `json:"properties,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AccountResourceProperties - The properties of a Test Base Account resource.
type AccountResourceProperties struct {
	// REQUIRED; The SKU of the Test Base Account.
	SKU *AccountSKU `json:"sku,omitempty"`

	// READ-ONLY; The access level of the Test Base Account.
	AccessLevel *string `json:"accessLevel,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// AccountSKU - Describes a Test Base Account SKU.
type AccountSKU struct {
	// REQUIRED; The name of the SKU. This is typically a letter + number code, such as B0 or S0.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The tier of this particular SKU.
	Tier *Tier `json:"tier,omitempty"`

	// The locations that the SKU is available.
	Locations []*string `json:"locations,omitempty"`

	// The type of resource the SKU applies to.
	ResourceType *string `json:"resourceType,omitempty"`

	// READ-ONLY; The capabilities of a SKU.
	Capabilities []*AccountSKUCapability `json:"capabilities,omitempty" azure:"ro"`
}

// AccountSKUCapability - Properties of the Test Base Account SKU Capability.
type AccountSKUCapability struct {
	// REQUIRED; An invariant to describe the feature, such as 'SLA'.
	Name *string `json:"name,omitempty"`

	// REQUIRED; An invariant if the feature is measured by quantity, such as 99.9%.
	Value *string `json:"value,omitempty"`
}

// AccountSKUListResult - A list of Test Base Account SKUs.
type AccountSKUListResult struct {
	// The list of Test Base Account SKUs.
	Value []*AccountSKU `json:"value,omitempty"`

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// AccountUpdateParameterProperties - Parameters supplied to update a Test Base Account.
type AccountUpdateParameterProperties struct {
	// The SKU of the Test Base Account.
	SKU *AccountSKU `json:"sku,omitempty"`
}

// AccountUpdateParameters - Parameters supplied to update a Test Base Account.
type AccountUpdateParameters struct {
	// Test Base Account update parameters.
	Properties *AccountUpdateParameterProperties `json:"properties,omitempty"`

	// The tags of the Test Base Account.
	Tags map[string]*string `json:"tags,omitempty"`
}

// AccountUsageData - The usage data of a Test Base Account.
type AccountUsageData struct {
	// Current value for the usage quota.
	CurrentValue *int64 `json:"currentValue,omitempty"`

	// Fully qualified ARM resource id
	ID *string `json:"id,omitempty"`

	// The maximum permitted value for the usage quota. If there is no limit, this value will be -1.
	Limit *int64 `json:"limit,omitempty"`

	// Localizable String object containing the name and a localized value.
	Name *AccountUsageName `json:"name,omitempty"`

	// Representing the units of the usage quota. Possible values are: Count, Bytes, Seconds, Percent, CountPerSecond, BytesPerSecond.
	Unit *string `json:"unit,omitempty"`
}

// AccountUsageDataList - A list of Test Base Account usage data.
type AccountUsageDataList struct {
	// The list of Test Base Account usage data.
	Value []*AccountUsageData `json:"value,omitempty"`

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// AccountUsageName - Localizable String object containing the name and a localized value.
type AccountUsageName struct {
	// Localized name of the usage.
	LocalizedValue *string `json:"localizedValue,omitempty"`

	// The identifier of the usage.
	Value *string `json:"value,omitempty"`
}

// AccountsClientBeginCreateOptions contains the optional parameters for the AccountsClient.BeginCreate method.
type AccountsClientBeginCreateOptions struct {
	// The flag indicating if we would like to restore the Test Base Accounts which were soft deleted before.
	Restore *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientBeginDeleteOptions contains the optional parameters for the AccountsClient.BeginDelete method.
type AccountsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientBeginOffboardOptions contains the optional parameters for the AccountsClient.BeginOffboard method.
type AccountsClientBeginOffboardOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientBeginUpdateOptions contains the optional parameters for the AccountsClient.BeginUpdate method.
type AccountsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientCheckPackageNameAvailabilityOptions contains the optional parameters for the AccountsClient.CheckPackageNameAvailability
// method.
type AccountsClientCheckPackageNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientGetFileUploadURLOptions contains the optional parameters for the AccountsClient.GetFileUploadURL method.
type AccountsClientGetFileUploadURLOptions struct {
	// Parameters supplied to the Test Base Account GetFileUploadURL operation.
	Parameters *GetFileUploadURLParameters
}

// AccountsClientGetOptions contains the optional parameters for the AccountsClient.Get method.
type AccountsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListByResourceGroupOptions contains the optional parameters for the AccountsClient.ListByResourceGroup method.
type AccountsClientListByResourceGroupOptions struct {
	// The flag indicating if we need to include the Test Base Accounts which were soft deleted before.
	GetDeleted *bool
}

// AccountsClientListBySubscriptionOptions contains the optional parameters for the AccountsClient.ListBySubscription method.
type AccountsClientListBySubscriptionOptions struct {
	// The flag indicating if we need to include the Test Base Accounts which were soft deleted before.
	GetDeleted *bool
}

// AnalysisResultListResult - A list of Analysis Results. It will only contain one element as all the data will be nested
// in a singleton object.
type AnalysisResultListResult struct {
	// The list of Analysis Results.
	Value []*AnalysisResultSingletonResource `json:"value,omitempty"`

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// AnalysisResultSingletonResource - The Analysis Result Singleton Resource.
type AnalysisResultSingletonResource struct {
	// Properties of an Analysis Result.
	Properties AnalysisResultSingletonResourcePropertiesClassification `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AnalysisResultSingletonResourcePropertiesClassification provides polymorphic access to related types.
// Call the interface's GetAnalysisResultSingletonResourceProperties() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AnalysisResultSingletonResourceProperties, *CPURegressionResultSingletonResourceProperties, *CPUUtilizationResultSingletonResourceProperties,
// - *MemoryRegressionResultSingletonResourceProperties, *MemoryUtilizationResultSingletonResourceProperties, *ReliabilityResultSingletonResourceProperties,
// - *ScriptExecutionResultSingletonResourceProperties, *TestAnalysisResultSingletonResourceProperties
type AnalysisResultSingletonResourcePropertiesClassification interface {
	// GetAnalysisResultSingletonResourceProperties returns the AnalysisResultSingletonResourceProperties content of the underlying type.
	GetAnalysisResultSingletonResourceProperties() *AnalysisResultSingletonResourceProperties
}

// AnalysisResultSingletonResourceProperties - The properties of Analysis Result resource.
type AnalysisResultSingletonResourceProperties struct {
	// REQUIRED; Type of the Analysis Result.
	AnalysisResultType *AnalysisResultType `json:"analysisResultType,omitempty"`

	// The grade of the test.
	Grade *Grade `json:"grade,omitempty"`
}

// GetAnalysisResultSingletonResourceProperties implements the AnalysisResultSingletonResourcePropertiesClassification interface
// for type AnalysisResultSingletonResourceProperties.
func (a *AnalysisResultSingletonResourceProperties) GetAnalysisResultSingletonResourceProperties() *AnalysisResultSingletonResourceProperties {
	return a
}

// AnalysisResultsClientGetOptions contains the optional parameters for the AnalysisResultsClient.Get method.
type AnalysisResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AnalysisResultsClientListOptions contains the optional parameters for the AnalysisResultsClient.List method.
type AnalysisResultsClientListOptions struct {
	// placeholder for future optional parameters
}

// AvailableOSClientGetOptions contains the optional parameters for the AvailableOSClient.Get method.
type AvailableOSClientGetOptions struct {
	// placeholder for future optional parameters
}

// AvailableOSClientListOptions contains the optional parameters for the AvailableOSClient.List method.
type AvailableOSClientListOptions struct {
	// placeholder for future optional parameters
}

// AvailableOSListResult - A list of available OSs.
type AvailableOSListResult struct {
	// The list of available OSs.
	Value []*AvailableOSResource `json:"value,omitempty"`

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// AvailableOSProperties - The Available OS properties.
type AvailableOSProperties struct {
	// The insider channel of an Available OS of a Test Base Account.
	InsiderChannel *string `json:"insiderChannel,omitempty"`

	// The Id of an Available OS of a Test Base Account.
	OSID *string `json:"osId,omitempty"`

	// The name of an Available OS of a Test Base Account.
	OSName *string `json:"osName,omitempty"`

	// The Platform of an Available OS of a Test Base Account.
	OSPlatform *string `json:"osPlatform,omitempty"`

	// The OS update type of an Available OS of a Test Base Account.
	OSUpdateType *string `json:"osUpdateType,omitempty"`

	// The version of an Available OS of a Test Base Account.
	OSVersion *string `json:"osVersion,omitempty"`
}

// AvailableOSResource - The Available OS resource.
type AvailableOSResource struct {
	// Available OS properties.
	Properties *AvailableOSProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CPURegressionResultSingletonResourceProperties - The properties of CPU Regression Result.
type CPURegressionResultSingletonResourceProperties struct {
	// REQUIRED; Type of the Analysis Result.
	AnalysisResultType *AnalysisResultType `json:"analysisResultType,omitempty"`

	// The result array data.
	CPURegressionResults []*RegressionResult `json:"cpuRegressionResults,omitempty"`

	// The grade of the test.
	Grade *Grade `json:"grade,omitempty"`
}

// GetAnalysisResultSingletonResourceProperties implements the AnalysisResultSingletonResourcePropertiesClassification interface
// for type CPURegressionResultSingletonResourceProperties.
func (c *CPURegressionResultSingletonResourceProperties) GetAnalysisResultSingletonResourceProperties() *AnalysisResultSingletonResourceProperties {
	return &AnalysisResultSingletonResourceProperties{
		Grade:              c.Grade,
		AnalysisResultType: c.AnalysisResultType,
	}
}

// CPUUtilizationResultSingletonResourceProperties - The properties of CPU Utilization Result.
type CPUUtilizationResultSingletonResourceProperties struct {
	// REQUIRED; Type of the Analysis Result.
	AnalysisResultType *AnalysisResultType `json:"analysisResultType,omitempty"`

	// The result array data.
	CPUUtilizationResults []*UtilizationResult `json:"cpuUtilizationResults,omitempty"`

	// The grade of the test.
	Grade *Grade `json:"grade,omitempty"`
}

// GetAnalysisResultSingletonResourceProperties implements the AnalysisResultSingletonResourcePropertiesClassification interface
// for type CPUUtilizationResultSingletonResourceProperties.
func (c *CPUUtilizationResultSingletonResourceProperties) GetAnalysisResultSingletonResourceProperties() *AnalysisResultSingletonResourceProperties {
	return &AnalysisResultSingletonResourceProperties{
		Grade:              c.Grade,
		AnalysisResultType: c.AnalysisResultType,
	}
}

// CheckNameAvailabilityResult - Description of a Check Name availability response properties.
type CheckNameAvailabilityResult struct {
	// Value indicating the availability of the name: true if the name is available; otherwise, false.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// The reason for unavailability of a name. Required if nameAvailable == false.
	Reason *Reason `json:"reason,omitempty"`

	// READ-ONLY; The detailed info regarding the reason associated with the name. Required if nameAvailable == false.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// Command - The command used in the test
type Command struct {
	// REQUIRED; The action of the command.
	Action *Action `json:"action,omitempty"`

	// REQUIRED; The content of the command. The content depends on source type.
	Content *string `json:"content,omitempty"`

	// REQUIRED; The type of command content.
	ContentType *ContentType `json:"contentType,omitempty"`

	// REQUIRED; The name of the command.
	Name *string `json:"name,omitempty"`

	// Specifies whether to run the command even if a previous command is failed.
	AlwaysRun *bool `json:"alwaysRun,omitempty"`

	// Specifies whether to apply update before the command.
	ApplyUpdateBefore *bool `json:"applyUpdateBefore,omitempty"`

	// Specifies the max run time of the command.
	MaxRunTime *int32 `json:"maxRunTime,omitempty"`

	// Specifies whether to restart the VM after the command executed.
	RestartAfter *bool `json:"restartAfter,omitempty"`

	// Specifies whether to run the command in interactive mode.
	RunAsInteractive *bool `json:"runAsInteractive,omitempty"`

	// Specifies whether to run the command as administrator.
	RunElevated *bool `json:"runElevated,omitempty"`
}

// CustomerEventListResult - A list of Test Base Customer Events.
type CustomerEventListResult struct {
	// The list of Test Base Customer Events.
	Value []*CustomerEventResource `json:"value,omitempty"`

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// CustomerEventProperties - A notification events subscribed to be received by customer.
type CustomerEventProperties struct {
	// REQUIRED; The name of the event subscribed to.
	EventName *string `json:"eventName,omitempty"`

	// REQUIRED; The notification event receivers.
	Receivers []*NotificationEventReceiver `json:"receivers,omitempty"`
}

// CustomerEventResource - The Customer Notification Event resource.
type CustomerEventResource struct {
	// Customer Notification Event properties.
	Properties *CustomerEventProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CustomerEventsClientBeginCreateOptions contains the optional parameters for the CustomerEventsClient.BeginCreate method.
type CustomerEventsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CustomerEventsClientBeginDeleteOptions contains the optional parameters for the CustomerEventsClient.BeginDelete method.
type CustomerEventsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CustomerEventsClientGetOptions contains the optional parameters for the CustomerEventsClient.Get method.
type CustomerEventsClientGetOptions struct {
	// placeholder for future optional parameters
}

// CustomerEventsClientListByTestBaseAccountOptions contains the optional parameters for the CustomerEventsClient.ListByTestBaseAccount
// method.
type CustomerEventsClientListByTestBaseAccountOptions struct {
	// placeholder for future optional parameters
}

// DistributionGroupListReceiverValue - The user object receiver value.
type DistributionGroupListReceiverValue struct {
	// The list of distribution groups.
	DistributionGroups []*string `json:"distributionGroups,omitempty"`
}

// DownloadURLResponse - The response of getting a download URL.
type DownloadURLResponse struct {
	// READ-ONLY; The download URL.
	DownloadURL *string `json:"downloadUrl,omitempty" azure:"ro"`

	// READ-ONLY; Expiry date of the download URL.
	ExpirationTime *time.Time `json:"expirationTime,omitempty" azure:"ro"`
}

// EmailEventListResult - A list of email events.
type EmailEventListResult struct {
	// The list of email events.
	Value []*EmailEventResource `json:"value,omitempty"`

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// EmailEventProperties - The Email Event properties.
type EmailEventProperties struct {
	// The display name of the email event.
	DisplayName *string `json:"displayName,omitempty"`

	// The identifier of the email event.
	EventID *string `json:"eventId,omitempty"`

	// The name of the email event.
	EventName *string `json:"eventName,omitempty"`
}

// EmailEventResource - The email event resource.
type EmailEventResource struct {
	// Email Event properties.
	Properties *EmailEventProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EmailEventsClientGetOptions contains the optional parameters for the EmailEventsClient.Get method.
type EmailEventsClientGetOptions struct {
	// placeholder for future optional parameters
}

// EmailEventsClientListOptions contains the optional parameters for the EmailEventsClient.List method.
type EmailEventsClientListOptions struct {
	// placeholder for future optional parameters
}

// ErrorDefinition - Error definition.
type ErrorDefinition struct {
	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDefinition `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The target of the particular error.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - The error response send when an operation fails.
type ErrorResponse struct {
	// The error details.
	Error *ErrorDefinition `json:"error,omitempty"`
}

// FavoriteProcessListResult - A list of favorite processes for a package.
type FavoriteProcessListResult struct {
	// The list of favorite processes for a package.
	Value []*FavoriteProcessResource `json:"value,omitempty"`

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// FavoriteProcessProperties - Properties of a favorite process identifier.
type FavoriteProcessProperties struct {
	// REQUIRED; The actual name of the favorite process. It will be equal to resource name except for the scenario that the process
	// name contains characters that are not allowed in the resource name.
	ActualProcessName *string `json:"actualProcessName,omitempty"`
}

// FavoriteProcessResource - A favorite process identifier.
type FavoriteProcessResource struct {
	// Properties of a favorite process identifier.
	Properties *FavoriteProcessProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FavoriteProcessesClientCreateOptions contains the optional parameters for the FavoriteProcessesClient.Create method.
type FavoriteProcessesClientCreateOptions struct {
	// placeholder for future optional parameters
}

// FavoriteProcessesClientDeleteOptions contains the optional parameters for the FavoriteProcessesClient.Delete method.
type FavoriteProcessesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// FavoriteProcessesClientGetOptions contains the optional parameters for the FavoriteProcessesClient.Get method.
type FavoriteProcessesClientGetOptions struct {
	// placeholder for future optional parameters
}

// FavoriteProcessesClientListOptions contains the optional parameters for the FavoriteProcessesClient.List method.
type FavoriteProcessesClientListOptions struct {
	// placeholder for future optional parameters
}

// FileUploadURLResponse - The URL response
type FileUploadURLResponse struct {
	// READ-ONLY; The blob path of the uploaded package. It will be used as the 'blobPath' property of PackageResource.
	BlobPath *string `json:"blobPath,omitempty" azure:"ro"`

	// READ-ONLY; The URL used for uploading the package.
	UploadURL *string `json:"uploadUrl,omitempty" azure:"ro"`
}

// FlightingRingListResult - A list of flighting rings.
type FlightingRingListResult struct {
	// The list of flighting rings.
	Value []*FlightingRingResource `json:"value,omitempty"`

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// FlightingRingProperties - The Flighting Ring properties.
type FlightingRingProperties struct {
	// The actual name of a flighting ring of a Test Base Account.
	ActualFlightingRingName *string `json:"actualFlightingRingName,omitempty"`
}

// FlightingRingResource - The flighting ring resource.
type FlightingRingResource struct {
	// Flighting Ring properties.
	Properties *FlightingRingProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FlightingRingsClientGetOptions contains the optional parameters for the FlightingRingsClient.Get method.
type FlightingRingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// FlightingRingsClientListOptions contains the optional parameters for the FlightingRingsClient.List method.
type FlightingRingsClientListOptions struct {
	// placeholder for future optional parameters
}

// GetFileUploadURLParameters - The parameters supplied to the Test Base Account GetFileUploadURL action.
type GetFileUploadURLParameters struct {
	// The custom file name of the uploaded blob.
	BlobName *string `json:"blobName,omitempty"`
}

// IdentifiedFailure - The failure identified.
type IdentifiedFailure struct {
	// The category of the failure.
	Category *Category `json:"category,omitempty"`

	// Message that shows information about the failure.
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// The Failure Id.
	FailureID *string `json:"failureId,omitempty"`

	// Guidance that shows what the customer needs to do for this failure.
	Guidance *string `json:"guidance,omitempty"`
}

// MemoryRegressionResultSingletonResourceProperties - The properties of Memory Regression Result.
type MemoryRegressionResultSingletonResourceProperties struct {
	// REQUIRED; Type of the Analysis Result.
	AnalysisResultType *AnalysisResultType `json:"analysisResultType,omitempty"`

	// The grade of the test.
	Grade *Grade `json:"grade,omitempty"`

	// The result array data.
	MemoryRegressionResults []*RegressionResult `json:"memoryRegressionResults,omitempty"`
}

// GetAnalysisResultSingletonResourceProperties implements the AnalysisResultSingletonResourcePropertiesClassification interface
// for type MemoryRegressionResultSingletonResourceProperties.
func (m *MemoryRegressionResultSingletonResourceProperties) GetAnalysisResultSingletonResourceProperties() *AnalysisResultSingletonResourceProperties {
	return &AnalysisResultSingletonResourceProperties{
		Grade:              m.Grade,
		AnalysisResultType: m.AnalysisResultType,
	}
}

// MemoryUtilizationResultSingletonResourceProperties - The properties of Memory Utilization Result.
type MemoryUtilizationResultSingletonResourceProperties struct {
	// REQUIRED; Type of the Analysis Result.
	AnalysisResultType *AnalysisResultType `json:"analysisResultType,omitempty"`

	// The grade of the test.
	Grade *Grade `json:"grade,omitempty"`

	// The result array data.
	MemoryUtilizationResults []*UtilizationResult `json:"memoryUtilizationResults,omitempty"`
}

// GetAnalysisResultSingletonResourceProperties implements the AnalysisResultSingletonResourcePropertiesClassification interface
// for type MemoryUtilizationResultSingletonResourceProperties.
func (m *MemoryUtilizationResultSingletonResourceProperties) GetAnalysisResultSingletonResourceProperties() *AnalysisResultSingletonResourceProperties {
	return &AnalysisResultSingletonResourceProperties{
		Grade:              m.Grade,
		AnalysisResultType: m.AnalysisResultType,
	}
}

// NotificationEventReceiver - A notification event receivers.
type NotificationEventReceiver struct {
	// The type of the notification event receiver.
	ReceiverType *string `json:"receiverType,omitempty"`

	// The notification event receiver value.
	ReceiverValue *NotificationReceiverValue `json:"receiverValue,omitempty"`
}

// NotificationReceiverValue - A notification event receiver value.
type NotificationReceiverValue struct {
	// The user object receiver value.
	DistributionGroupListReceiverValue *DistributionGroupListReceiverValue `json:"distributionGroupListReceiverValue,omitempty"`

	// The user object receiver value.
	SubscriptionReceiverValue *SubscriptionReceiverValue `json:"subscriptionReceiverValue,omitempty"`

	// The user object receiver value.
	UserObjectReceiverValue *UserObjectReceiverValue `json:"userObjectReceiverValue,omitempty"`
}

// OSUpdateListResult - A list of OS Updates.
type OSUpdateListResult struct {
	// The list of OS Updates.
	Value []*OSUpdateResource `json:"value,omitempty"`

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// OSUpdateProperties - Properties of an OS Update.
type OSUpdateProperties struct {
	// The build revision of the tested release (OS update)
	BuildRevision *string `json:"buildRevision,omitempty"`

	// The build version of the tested release (OS update).
	BuildVersion *string `json:"buildVersion,omitempty"`

	// The flighting ring, only for release of feature updates.
	FlightingRing *string `json:"flightingRing,omitempty"`

	// The name of the OS.
	OSName *string `json:"osName,omitempty"`

	// The name of tested release.
	Release *string `json:"release,omitempty"`

	// The release version date the tested release (OS update)
	ReleaseVersionDate *time.Time `json:"releaseVersionDate,omitempty"`

	// The type of this release (OS update).
	Type *Type `json:"type,omitempty"`
}

// OSUpdateResource - An OS Update.
type OSUpdateResource struct {
	// Properties of an OS Update.
	Properties *OSUpdateProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OSUpdateTestSummary - The summary of a test.
type OSUpdateTestSummary struct {
	// The build revision of the tested release (OS update)
	BuildRevision *string `json:"buildRevision,omitempty"`

	// The build version of the tested release (OS update)
	BuildVersion *string `json:"buildVersion,omitempty"`

	// The execution status of the test.
	ExecutionStatus *ExecutionStatus `json:"executionStatus,omitempty"`

	// The flighting ring, only for release of feature updates.
	FlightingRing *string `json:"flightingRing,omitempty"`

	// The grade of the test.
	Grade *Grade `json:"grade,omitempty"`

	// The operating system name. e.g. Windows 10 1809.
	OSName *string `json:"osName,omitempty"`

	// The name of the tested release (OS update).
	ReleaseName *string `json:"releaseName,omitempty"`

	// The release version date.
	ReleaseVersionDate *time.Time `json:"releaseVersionDate,omitempty"`

	// The run time of the test.
	TestRunTime *string `json:"testRunTime,omitempty"`

	// The status of the test.
	TestStatus *TestStatus `json:"testStatus,omitempty"`

	// The test type of the package
	TestType *string `json:"testType,omitempty"`
}

// OSUpdatesClientGetOptions contains the optional parameters for the OSUpdatesClient.Get method.
type OSUpdatesClientGetOptions struct {
	// placeholder for future optional parameters
}

// OSUpdatesClientListOptions contains the optional parameters for the OSUpdatesClient.List method.
type OSUpdatesClientListOptions struct {
	// placeholder for future optional parameters
}

// OSUpdatesTestSummary - The summary of some tests.
type OSUpdatesTestSummary struct {
	// The status of the last test.
	ExecutionStatus *ExecutionStatus `json:"executionStatus,omitempty"`

	// The grade of last test.
	Grade *Grade `json:"grade,omitempty"`

	// Detailed summary for each OS update
	OSUpdateTestSummaries []*OSUpdateTestSummary `json:"osUpdateTestSummaries,omitempty"`

	// The run time of the last test.
	TestRunTime *string `json:"testRunTime,omitempty"`

	// The status of last test.
	TestStatus *TestStatus `json:"testStatus,omitempty"`
}

// Operation - REST API operation
type Operation struct {
	// The object that describes the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Extra properties of the operation.
	Properties interface{} `json:"properties,omitempty"`

	// READ-ONLY; Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty" azure:"ro"`

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Origin of the operation
	Origin *string `json:"origin,omitempty" azure:"ro"`
}

// OperationDisplay - The object that describes the operation.
type OperationDisplay struct {
	// READ-ONLY; Friendly name of the operation.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Operation type: read, write, delete, listPackages, etc.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The resource provider name: Microsoft.TestBase.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Resource type on which the operation is performed.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - A list of operations supported by the resource provider.
type OperationListResult struct {
	// List of operations supported by the Test Base resource provider.
	Value []*Operation `json:"value,omitempty"`

	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PackageCheckNameAvailabilityParameters - Parameters body to pass for Test Base Package name availability check.
type PackageCheckNameAvailabilityParameters struct {
	// REQUIRED; Application name to verify.
	ApplicationName *string `json:"applicationName,omitempty"`

	// REQUIRED; Resource name to verify.
	Name *string `json:"name,omitempty"`

	// REQUIRED; fully qualified resource type which includes provider namespace.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Version name to verify.
	Version *string `json:"version,omitempty"`
}

// PackageListResult - A list of Test Base Packages.
type PackageListResult struct {
	// The list of Test Base Packages.
	Value []*PackageResource `json:"value,omitempty"`

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PackageProperties - The properties of the Test Base Package.
type PackageProperties struct {
	// REQUIRED; Application name
	ApplicationName *string `json:"applicationName,omitempty"`

	// REQUIRED; The file path of the package.
	BlobPath *string `json:"blobPath,omitempty"`

	// REQUIRED; The flighting ring for feature update.
	FlightingRing *string `json:"flightingRing,omitempty"`

	// REQUIRED; Specifies the target OSs of specific OS Update types.
	TargetOSList []*TargetOSInfo `json:"targetOSList,omitempty"`

	// REQUIRED; The detailed test information.
	Tests []*Test `json:"tests,omitempty"`

	// REQUIRED; Application version
	Version *string `json:"version,omitempty"`

	// READ-ONLY; Flag showing that whether the package is enabled. It doesn't schedule test for package which is not enabled.
	IsEnabled *bool `json:"isEnabled,omitempty" azure:"ro"`

	// READ-ONLY; The UTC timestamp when the package was last modified.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; The status of the package.
	PackageStatus *PackageStatus `json:"packageStatus,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; OOB, functional or both. Mapped to the data in 'tests' property.
	TestTypes []*TestType `json:"testTypes,omitempty" azure:"ro"`

	// READ-ONLY; The validation results. There's validation on package when it's created or updated.
	ValidationResults []*PackageValidationResult `json:"validationResults,omitempty" azure:"ro"`
}

// PackageResource - The Test Base Package resource.
type PackageResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Test Base Package properties.
	Properties *PackageProperties `json:"properties,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PackageUpdateParameterProperties - Parameters supplied to update a Test Base Package.
type PackageUpdateParameterProperties struct {
	// The file name of the package.
	BlobPath *string `json:"blobPath,omitempty"`

	// The flighting ring for feature update.
	FlightingRing *string `json:"flightingRing,omitempty"`

	// Specifies whether the package is enabled. It doesn't schedule test for package which is not enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// Specifies the target OSs of specific OS Update types.
	TargetOSList []*TargetOSInfo `json:"targetOSList,omitempty"`

	// The detailed test information.
	Tests []*Test `json:"tests,omitempty"`
}

// PackageUpdateParameters - Parameters supplied to update a Test Base Package.
type PackageUpdateParameters struct {
	// Test Base Package update parameters.
	Properties *PackageUpdateParameterProperties `json:"properties,omitempty"`

	// The tags of the Package.
	Tags map[string]*string `json:"tags,omitempty"`
}

// PackageValidationResult - The validation results. There's validation on package when it's created or updated.
type PackageValidationResult struct {
	// READ-ONLY; Error information.
	Errors []*string `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether the package passed the validation.
	IsValid *bool `json:"isValid,omitempty" azure:"ro"`

	// READ-ONLY; Validation name.
	ValidationName *string `json:"validationName,omitempty" azure:"ro"`
}

// PackagesClientBeginCreateOptions contains the optional parameters for the PackagesClient.BeginCreate method.
type PackagesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PackagesClientBeginDeleteOptions contains the optional parameters for the PackagesClient.BeginDelete method.
type PackagesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PackagesClientBeginHardDeleteOptions contains the optional parameters for the PackagesClient.BeginHardDelete method.
type PackagesClientBeginHardDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PackagesClientBeginUpdateOptions contains the optional parameters for the PackagesClient.BeginUpdate method.
type PackagesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PackagesClientGetDownloadURLOptions contains the optional parameters for the PackagesClient.GetDownloadURL method.
type PackagesClientGetDownloadURLOptions struct {
	// placeholder for future optional parameters
}

// PackagesClientGetOptions contains the optional parameters for the PackagesClient.Get method.
type PackagesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PackagesClientListByTestBaseAccountOptions contains the optional parameters for the PackagesClient.ListByTestBaseAccount
// method.
type PackagesClientListByTestBaseAccountOptions struct {
	// placeholder for future optional parameters
}

// ProxyResource - The resource model definition for an ARM proxy resource. It will have everything other than required location
// and tags
type ProxyResource struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RegressionResult - The regression result.
type RegressionResult struct {
	// Message that facilitates debugging a particular regression, if any was inferred.
	Details *string `json:"details,omitempty"`

	// Difference between the two datasets being analyzed.
	Diff *float64 `json:"diff,omitempty"`

	// FileName of the binary being analyzed.
	FileName *string `json:"fileName,omitempty"`

	// The grade of the test.
	Grade *Grade `json:"grade,omitempty"`

	// Indicates if a regression was inferred.
	IsRegressed *bool `json:"isRegressed,omitempty"`
}

// RegressionTestDetails - The details of a regression test.
type RegressionTestDetails struct {
	// Difference between the two datasets being analyzed.
	Diff *float64 `json:"diff,omitempty"`

	// Indicates if a regression was inferred.
	IsRegressed *bool `json:"isRegressed,omitempty"`
}

// ReliabilityResult - The Reliability Result.
type ReliabilityResult struct {
	// Count of number of crashes.
	CrashCount *int32 `json:"crashCount,omitempty"`

	// The statistic regression grade for crash signal.
	CrashRegressionGrade *Grade `json:"crashRegressionGrade,omitempty"`

	// Details related to the crash regression analysis.
	CrashRegressionTestDetails *RegressionTestDetails `json:"crashRegressionTestDetails,omitempty"`

	// File name.
	FileName *string `json:"fileName,omitempty"`

	// Count of number of hangs.
	HangCount *int32 `json:"hangCount,omitempty"`

	// The statistic regression grade for hang signal.
	HangRegressionGrade *Grade `json:"hangRegressionGrade,omitempty"`

	// Details related to the hang regression analysis.
	HangRegressionTestDetails *RegressionTestDetails `json:"hangRegressionTestDetails,omitempty"`

	// Count of number of launches.
	LaunchCount *int32 `json:"launchCount,omitempty"`

	// The regression grade.
	RegressionGrade *Grade `json:"regressionGrade,omitempty"`
}

// ReliabilityResultSingletonResourceProperties - The properties of Reliability Result.
type ReliabilityResultSingletonResourceProperties struct {
	// REQUIRED; Type of the Analysis Result.
	AnalysisResultType *AnalysisResultType `json:"analysisResultType,omitempty"`

	// The grade of the test.
	Grade *Grade `json:"grade,omitempty"`

	// The result array data.
	ReliabilityResults []*ReliabilityResult `json:"reliabilityResults,omitempty"`
}

// GetAnalysisResultSingletonResourceProperties implements the AnalysisResultSingletonResourcePropertiesClassification interface
// for type ReliabilityResultSingletonResourceProperties.
func (r *ReliabilityResultSingletonResourceProperties) GetAnalysisResultSingletonResourceProperties() *AnalysisResultSingletonResourceProperties {
	return &AnalysisResultSingletonResourceProperties{
		Grade:              r.Grade,
		AnalysisResultType: r.AnalysisResultType,
	}
}

// Resource - The Resource definition.
type Resource struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SKUsClientListOptions contains the optional parameters for the SKUsClient.List method.
type SKUsClientListOptions struct {
	// placeholder for future optional parameters
}

// ScriptExecutionResult - The Script Execution Result.
type ScriptExecutionResult struct {
	// End time of script execution.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Exit code.
	ExitCode *int32 `json:"exitCode,omitempty"`

	// Name of script.
	ScriptName *string `json:"scriptName,omitempty"`

	// Start time of script execution.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Whether the script execution is timed out.
	TimedOut *bool `json:"timedOut,omitempty"`
}

// ScriptExecutionResultSingletonResourceProperties - The properties of Script Execution Result.
type ScriptExecutionResultSingletonResourceProperties struct {
	// REQUIRED; Type of the Analysis Result.
	AnalysisResultType *AnalysisResultType `json:"analysisResultType,omitempty"`

	// The grade of the test.
	Grade *Grade `json:"grade,omitempty"`

	// The result array data.
	ScriptExecutionResults []*ScriptExecutionResult `json:"scriptExecutionResults,omitempty"`
}

// GetAnalysisResultSingletonResourceProperties implements the AnalysisResultSingletonResourcePropertiesClassification interface
// for type ScriptExecutionResultSingletonResourceProperties.
func (s *ScriptExecutionResultSingletonResourceProperties) GetAnalysisResultSingletonResourceProperties() *AnalysisResultSingletonResourceProperties {
	return &AnalysisResultSingletonResourceProperties{
		Grade:              s.Grade,
		AnalysisResultType: s.AnalysisResultType,
	}
}

// SubscriptionReceiverValue - The subscription role receiver value.
type SubscriptionReceiverValue struct {
	// The role of the notification receiver.
	Role *string `json:"role,omitempty"`

	// The subscription id of the notification receiver.
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// The subscription name of the notification receiver.
	SubscriptionName *string `json:"subscriptionName,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TargetOSInfo - The information of the target OS to be tested.
type TargetOSInfo struct {
	// REQUIRED; Specifies the OS update type to test against, e.g., 'Security updates' or 'Feature updates'.
	OSUpdateType *string `json:"osUpdateType,omitempty"`

	// REQUIRED; Specifies the target OSs to be tested.
	TargetOSs []*string `json:"targetOSs,omitempty"`
}

// Test - The definition of a Test.
type Test struct {
	// REQUIRED; The commands used in the test.
	Commands []*Command `json:"commands,omitempty"`

	// REQUIRED; The type of the test.
	TestType *TestType `json:"testType,omitempty"`

	// Indicates if this test is active.It doesn't schedule test for not active Test.
	IsActive *bool `json:"isActive,omitempty"`

	// READ-ONLY; The status of the validation run of the package.
	ValidationRunStatus *ValidationRunStatus `json:"validationRunStatus,omitempty" azure:"ro"`
}

// TestAnalysisResult - The test analysis result.
type TestAnalysisResult struct {
	// The data to provide more failure analysis information.
	BlobData *string `json:"blobData,omitempty"`

	// The array of identified failures.
	IdentifiedFailures []*IdentifiedFailure `json:"identifiedFailures,omitempty"`

	// The status of the analysis.
	TestAnalysisStatus *TestAnalysisStatus `json:"testAnalysisStatus,omitempty"`
}

// TestAnalysisResultSingletonResourceProperties - The properties of Test Analysis Result.
type TestAnalysisResultSingletonResourceProperties struct {
	// REQUIRED; Type of the Analysis Result.
	AnalysisResultType *AnalysisResultType `json:"analysisResultType,omitempty"`

	// The grade of the test.
	Grade *Grade `json:"grade,omitempty"`

	// The result of test analysis.
	TestAnalysisResult *TestAnalysisResult `json:"testAnalysisResult,omitempty"`
}

// GetAnalysisResultSingletonResourceProperties implements the AnalysisResultSingletonResourcePropertiesClassification interface
// for type TestAnalysisResultSingletonResourceProperties.
func (t *TestAnalysisResultSingletonResourceProperties) GetAnalysisResultSingletonResourceProperties() *AnalysisResultSingletonResourceProperties {
	return &AnalysisResultSingletonResourceProperties{
		Grade:              t.Grade,
		AnalysisResultType: t.AnalysisResultType,
	}
}

// TestResultAnalysisSummary - The summary of a Test Analysis Result.
type TestResultAnalysisSummary struct {
	// The analysis status.
	AnalysisStatus *AnalysisStatus `json:"analysisStatus,omitempty"`

	// The grade of the test result.
	Grade *Grade `json:"grade,omitempty"`

	// Metric name
	Name *string `json:"name,omitempty"`
}

// TestResultListResult - A list of Test Results.
type TestResultListResult struct {
	// The list of Test Results.
	Value []*TestResultResource `json:"value,omitempty"`

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// TestResultProperties - The properties of a Test Result.
type TestResultProperties struct {
	// List of analysis summaries.
	AnalysisSummaries []*TestResultAnalysisSummary `json:"analysisSummaries,omitempty"`

	// Application name.
	ApplicationName *string `json:"applicationName,omitempty"`

	// Application version.
	ApplicationVersion *string `json:"applicationVersion,omitempty"`

	// Azure Id of the baseline test result.
	BaselineTestResultID *string `json:"baselineTestResultId,omitempty"`

	// The build revision of the tested release (OS update).
	BuildRevision *string `json:"buildRevision,omitempty"`

	// The build version of the tested release (OS update).
	BuildVersion *string `json:"buildVersion,omitempty"`

	// The execution status of the test.
	ExecutionStatus *ExecutionStatus `json:"executionStatus,omitempty"`

	// The flighting ring, only for release of feature updates.
	FlightingRing *string `json:"flightingRing,omitempty"`

	// The grade of the test.
	Grade *Grade `json:"grade,omitempty"`

	// Whether download data is available.
	IsDownloadDataAvailable *bool `json:"isDownloadDataAvailable,omitempty"`

	// Whether video data is available.
	IsVideoAvailable *bool `json:"isVideoAvailable,omitempty"`

	// KB number.
	KbNumber *string `json:"kbNumber,omitempty"`

	// The operating system name, e.g. Windows 10 1809.
	OSName *string `json:"osName,omitempty"`

	// Resource Id of the package.
	PackageID *string `json:"packageId,omitempty"`

	// The version of the Windows update package.
	PackageVersion *string `json:"packageVersion,omitempty"`

	// The name of the tested release (OS update).
	ReleaseName *string `json:"releaseName,omitempty"`

	// The release version date of the tested release.
	ReleaseVersionDate *time.Time `json:"releaseVersionDate,omitempty"`

	// The run time of the test.
	TestRunTime *string `json:"testRunTime,omitempty"`

	// The status of the test.
	TestStatus *TestStatus `json:"testStatus,omitempty"`

	// Test type. E.g. 'Out of box test' or 'Functional test'.
	TestType *string `json:"testType,omitempty"`
}

// TestResultResource - The Test Result Resource.
type TestResultResource struct {
	// The properties of a Test Result.
	Properties *TestResultProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TestResultsClientGetDownloadURLOptions contains the optional parameters for the TestResultsClient.GetDownloadURL method.
type TestResultsClientGetDownloadURLOptions struct {
	// placeholder for future optional parameters
}

// TestResultsClientGetOptions contains the optional parameters for the TestResultsClient.Get method.
type TestResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// TestResultsClientGetVideoDownloadURLOptions contains the optional parameters for the TestResultsClient.GetVideoDownloadURL
// method.
type TestResultsClientGetVideoDownloadURLOptions struct {
	// placeholder for future optional parameters
}

// TestResultsClientListOptions contains the optional parameters for the TestResultsClient.List method.
type TestResultsClientListOptions struct {
	// Odata filter
	Filter *string
}

// TestSummariesClientGetOptions contains the optional parameters for the TestSummariesClient.Get method.
type TestSummariesClientGetOptions struct {
	// placeholder for future optional parameters
}

// TestSummariesClientListOptions contains the optional parameters for the TestSummariesClient.List method.
type TestSummariesClientListOptions struct {
	// placeholder for future optional parameters
}

// TestSummaryListResult - A list of Test Summaries.
type TestSummaryListResult struct {
	// The list of Test Summaries.
	Value []*TestSummaryResource `json:"value,omitempty"`

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// TestSummaryProperties - Properties of a Test Summary.
type TestSummaryProperties struct {
	// Application name.
	ApplicationName *string `json:"applicationName,omitempty"`

	// Application version.
	ApplicationVersion *string `json:"applicationVersion,omitempty"`

	// The execution status of last test.
	ExecutionStatus *ExecutionStatus `json:"executionStatus,omitempty"`

	// The result summary of tests triggered by feature updates
	FeatureUpdatesTestSummary *OSUpdatesTestSummary `json:"featureUpdatesTestSummary,omitempty"`

	// The grade of the test.
	Grade *Grade `json:"grade,omitempty"`

	// The Azure resource Id of package.
	PackageID *string `json:"packageId,omitempty"`

	// The result summary of tests triggered by security updates
	SecurityUpdatesTestSummary *OSUpdatesTestSummary `json:"securityUpdatesTestSummary,omitempty"`

	// The run time of the last test.
	TestRunTime *string `json:"testRunTime,omitempty"`

	// The status of last test.
	TestStatus *TestStatus `json:"testStatus,omitempty"`

	// The Id of the current Test Summary.
	TestSummaryID *string `json:"testSummaryId,omitempty"`
}

// TestSummaryResource - Summary of a Test.
type TestSummaryResource struct {
	// Properties of a Test Summary.
	Properties *TestSummaryProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TestTypeListResult - A list of test types.
type TestTypeListResult struct {
	// The list of test types.
	Value []*TestTypeResource `json:"value,omitempty"`

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// TestTypeProperties - The Test Type properties.
type TestTypeProperties struct {
	// The actual name of a test type of a Test Base Account.
	ActualTestTypeName *string `json:"actualTestTypeName,omitempty"`
}

// TestTypeResource - The test type resource.
type TestTypeResource struct {
	// Test Type properties.
	Properties *TestTypeProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TestTypesClientGetOptions contains the optional parameters for the TestTypesClient.Get method.
type TestTypesClientGetOptions struct {
	// placeholder for future optional parameters
}

// TestTypesClientListOptions contains the optional parameters for the TestTypesClient.List method.
type TestTypesClientListOptions struct {
	// placeholder for future optional parameters
}

// TrackedResource - The resource model definition for an ARM tracked top level resource
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UsageClientListOptions contains the optional parameters for the UsageClient.List method.
type UsageClientListOptions struct {
	// Odata filter
	Filter *string
}

// UserObjectReceiverValue - The user object receiver value.
type UserObjectReceiverValue struct {
	// user object ids.
	UserObjectIDs []*string `json:"userObjectIds,omitempty"`
}

// UtilizationBound - The bound of a utilization result.
type UtilizationBound struct {
	// The percentile of the bound.
	Percentile *float64 `json:"percentile,omitempty"`

	// The value of the bound.
	Value *float64 `json:"value,omitempty"`
}

// UtilizationEntry - The utilization entry.
type UtilizationEntry struct {
	// The timestamp.
	Timestamp *time.Time `json:"timestamp,omitempty"`

	// The value.
	Value *float64 `json:"value,omitempty"`
}

// UtilizationResult - The Utilization Result.
type UtilizationResult struct {
	// Lower bound
	LowerBound *UtilizationBound `json:"lowerBound,omitempty"`

	// Process name, or '_total' for all processes
	Process *string `json:"process,omitempty"`

	// Upper bound
	UpperBound *UtilizationBound `json:"upperBound,omitempty"`

	// Utilization data
	Utilization []*UtilizationEntry `json:"utilization,omitempty"`
}
