//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armguestconfiguration

import "time"

// Assignment - Guest configuration assignment is an association between a machine and guest configuration.
type Assignment struct {
	// Region where the VM is located.
	Location *string `json:"location,omitempty"`

	// Name of the guest configuration assignment.
	Name *string `json:"name,omitempty"`

	// Properties of the Guest configuration assignment.
	Properties *AssignmentProperties `json:"properties,omitempty"`

	// READ-ONLY; ARM resource id of the guest configuration assignment.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AssignmentInfo - Information about the guest configuration assignment.
type AssignmentInfo struct {
	// Information about the configuration.
	Configuration *ConfigurationInfo `json:"configuration,omitempty"`

	// READ-ONLY; Name of the guest configuration assignment.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// AssignmentList - The response of the list guest configuration assignment operation.
type AssignmentList struct {
	// Result of the list guest configuration assignment operation.
	Value []*Assignment `json:"value,omitempty"`
}

// AssignmentProperties - Guest configuration assignment properties.
type AssignmentProperties struct {
	// The source which initiated the guest configuration assignment. Ex: Azure Policy
	Context *string `json:"context,omitempty"`

	// The guest configuration to assign.
	GuestConfiguration *Navigation `json:"guestConfiguration,omitempty"`

	// Last reported guest configuration assignment report.
	LatestAssignmentReport *CommonAssignmentReport `json:"latestAssignmentReport,omitempty"`

	// The list of VM Compliance data for VMSS
	VmssVMList []*VMSSVMInfo `json:"vmssVMList,omitempty"`

	// READ-ONLY; Combined hash of the configuration package and parameters.
	AssignmentHash *string `json:"assignmentHash,omitempty" azure:"ro"`

	// READ-ONLY; A value indicating compliance status of the machine for the assigned guest configuration.
	ComplianceStatus *ComplianceStatus `json:"complianceStatus,omitempty" azure:"ro"`

	// READ-ONLY; Date and time when last compliance status was checked.
	LastComplianceStatusChecked *time.Time `json:"lastComplianceStatusChecked,omitempty" azure:"ro"`

	// READ-ONLY; Id of the latest report for the guest configuration assignment.
	LatestReportID *string `json:"latestReportId,omitempty" azure:"ro"`

	// READ-ONLY; parameter hash for the guest configuration assignment.
	ParameterHash *string `json:"parameterHash,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource - VMSS / VM
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; VM resource Id.
	TargetResourceID *string `json:"targetResourceId,omitempty" azure:"ro"`
}

// AssignmentReport - Report for the guest configuration assignment. Report contains information such as compliance status,
// reason, and more.
type AssignmentReport struct {
	// Properties of the guest configuration report.
	Properties *AssignmentReportProperties `json:"properties,omitempty"`

	// READ-ONLY; ARM resource id of the report for the guest configuration assignment.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; GUID that identifies the guest configuration assignment report under a subscription, resource group.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// AssignmentReportDetails - Details of the guest configuration assignment report.
type AssignmentReportDetails struct {
	// The list of resources for which guest configuration assignment compliance is checked.
	Resources []*AssignmentReportResource `json:"resources,omitempty"`

	// READ-ONLY; A value indicating compliance status of the machine for the assigned guest configuration.
	ComplianceStatus *ComplianceStatus `json:"complianceStatus,omitempty" azure:"ro"`

	// READ-ONLY; End date and time of the guest configuration assignment compliance status check.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; GUID of the report.
	JobID *string `json:"jobId,omitempty" azure:"ro"`

	// READ-ONLY; Type of report, Consistency or Initial
	OperationType *Type `json:"operationType,omitempty" azure:"ro"`

	// READ-ONLY; Start date and time of the guest configuration assignment compliance status check.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`
}

// AssignmentReportList - List of guest configuration assignment reports.
type AssignmentReportList struct {
	// List of reports for the guest configuration. Report contains information such as compliance status, reason and more.
	Value []*AssignmentReport `json:"value,omitempty"`
}

// AssignmentReportProperties - Report for the guest configuration assignment. Report contains information such as compliance
// status, reason, and more.
type AssignmentReportProperties struct {
	// Configuration details of the guest configuration assignment.
	Assignment *AssignmentInfo `json:"assignment,omitempty"`

	// Details of the assignment report.
	Details *AssignmentReportDetails `json:"details,omitempty"`

	// Information about the VM.
	VM *VMInfo `json:"vm,omitempty"`

	// READ-ONLY; A value indicating compliance status of the machine for the assigned guest configuration.
	ComplianceStatus *ComplianceStatus `json:"complianceStatus,omitempty" azure:"ro"`

	// READ-ONLY; End date and time of the guest configuration assignment compliance status check.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; GUID that identifies the guest configuration assignment report under a subscription, resource group.
	ReportID *string `json:"reportId,omitempty" azure:"ro"`

	// READ-ONLY; Start date and time of the guest configuration assignment compliance status check.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource Id of the VMSS.
	VmssResourceID *string `json:"vmssResourceId,omitempty" azure:"ro"`
}

// AssignmentReportResource - The guest configuration assignment resource.
type AssignmentReportResource struct {
	// Compliance reason and reason code for a resource.
	Reasons []*AssignmentReportResourceComplianceReason `json:"reasons,omitempty"`

	// READ-ONLY; A value indicating compliance status of the machine for the assigned guest configuration.
	ComplianceStatus *ComplianceStatus `json:"complianceStatus,omitempty" azure:"ro"`

	// READ-ONLY; Properties of a guest configuration assignment resource.
	Properties interface{} `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Name of the guest configuration assignment resource setting.
	ResourceID *string `json:"resourceId,omitempty" azure:"ro"`
}

// AssignmentReportResourceComplianceReason - Reason and code for the compliance of the guest configuration assignment resource.
type AssignmentReportResourceComplianceReason struct {
	// READ-ONLY; Code for the compliance of the guest configuration assignment resource.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Reason for the compliance of the guest configuration assignment resource.
	Phrase *string `json:"phrase,omitempty" azure:"ro"`
}

// AssignmentReportsClientGetOptions contains the optional parameters for the AssignmentReportsClient.Get method.
type AssignmentReportsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AssignmentReportsClientListOptions contains the optional parameters for the AssignmentReportsClient.List method.
type AssignmentReportsClientListOptions struct {
	// placeholder for future optional parameters
}

// AssignmentReportsVMSSClientGetOptions contains the optional parameters for the AssignmentReportsVMSSClient.Get method.
type AssignmentReportsVMSSClientGetOptions struct {
	// placeholder for future optional parameters
}

// AssignmentReportsVMSSClientListOptions contains the optional parameters for the AssignmentReportsVMSSClient.List method.
type AssignmentReportsVMSSClientListOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsClientCreateOrUpdateOptions contains the optional parameters for the AssignmentsClient.CreateOrUpdate method.
type AssignmentsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsClientDeleteOptions contains the optional parameters for the AssignmentsClient.Delete method.
type AssignmentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsClientGetOptions contains the optional parameters for the AssignmentsClient.Get method.
type AssignmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsClientListOptions contains the optional parameters for the AssignmentsClient.List method.
type AssignmentsClientListOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsClientRGListOptions contains the optional parameters for the AssignmentsClient.RGList method.
type AssignmentsClientRGListOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsClientSubscriptionListOptions contains the optional parameters for the AssignmentsClient.SubscriptionList method.
type AssignmentsClientSubscriptionListOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsVMSSClientDeleteOptions contains the optional parameters for the AssignmentsVMSSClient.Delete method.
type AssignmentsVMSSClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsVMSSClientGetOptions contains the optional parameters for the AssignmentsVMSSClient.Get method.
type AssignmentsVMSSClientGetOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsVMSSClientListOptions contains the optional parameters for the AssignmentsVMSSClient.List method.
type AssignmentsVMSSClientListOptions struct {
	// placeholder for future optional parameters
}

type CommonAssignmentReport struct {
	// Configuration details of the guest configuration assignment.
	Assignment *AssignmentInfo `json:"assignment,omitempty"`

	// The list of resources for which guest configuration assignment compliance is checked.
	Resources []*AssignmentReportResource `json:"resources,omitempty"`

	// Information about the VM.
	VM *VMInfo `json:"vm,omitempty"`

	// READ-ONLY; A value indicating compliance status of the machine for the assigned guest configuration.
	ComplianceStatus *ComplianceStatus `json:"complianceStatus,omitempty" azure:"ro"`

	// READ-ONLY; End date and time of the guest configuration assignment compliance status check.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; ARM resource id of the report for the guest configuration assignment.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Type of report, Consistency or Initial
	OperationType *Type `json:"operationType,omitempty" azure:"ro"`

	// READ-ONLY; GUID that identifies the guest configuration assignment report under a subscription, resource group.
	ReportID *string `json:"reportId,omitempty" azure:"ro"`

	// READ-ONLY; Start date and time of the guest configuration assignment compliance status check.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`
}

// ConfigurationInfo - Information about the configuration.
type ConfigurationInfo struct {
	// READ-ONLY; Name of the configuration.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Version of the configuration.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// ConfigurationParameter - Represents a configuration parameter.
type ConfigurationParameter struct {
	// Name of the configuration parameter.
	Name *string `json:"name,omitempty"`

	// Value of the configuration parameter.
	Value *string `json:"value,omitempty"`
}

// ConfigurationSetting - Configuration setting of LCM (Local Configuration Manager).
type ConfigurationSetting struct {
	// READ-ONLY; Specifies what happens after a reboot during the application of a configuration. The possible values are ContinueConfiguration
	// and StopConfiguration
	ActionAfterReboot *ActionAfterReboot `json:"actionAfterReboot,omitempty" azure:"ro"`

	// READ-ONLY; If true - new configurations downloaded from the pull service are allowed to overwrite the old ones on the target
	// node. Otherwise, false
	AllowModuleOverwrite *bool `json:"allowModuleOverwrite,omitempty" azure:"ro"`

	// READ-ONLY; Specifies how the LCM(Local Configuration Manager) actually applies the configuration to the target nodes. Possible
	// values are ApplyOnly, ApplyAndMonitor, and ApplyAndAutoCorrect.
	ConfigurationMode *ConfigurationMode `json:"configurationMode,omitempty" azure:"ro"`

	// READ-ONLY; How often, in minutes, the current configuration is checked and applied. This property is ignored if the ConfigurationMode
	// property is set to ApplyOnly. The default value is 15.
	ConfigurationModeFrequencyMins *float32 `json:"configurationModeFrequencyMins,omitempty" azure:"ro"`

	// READ-ONLY; Set this to true to automatically reboot the node after a configuration that requires reboot is applied. Otherwise,
	// you will have to manually reboot the node for any configuration that requires it.
	// The default value is false. To use this setting when a reboot condition is enacted by something other than DSC (such as
	// Windows Installer), combine this setting with the xPendingReboot module.
	RebootIfNeeded *bool `json:"rebootIfNeeded,omitempty" azure:"ro"`

	// READ-ONLY; The time interval, in minutes, at which the LCM checks a pull service to get updated configurations. This value
	// is ignored if the LCM is not configured in pull mode. The default value is 30.
	RefreshFrequencyMins *float32 `json:"refreshFrequencyMins,omitempty" azure:"ro"`
}

// ErrorResponse - Error response of an operation failure
type ErrorResponse struct {
	Error *ErrorResponseError `json:"error,omitempty"`
}

type ErrorResponseError struct {
	// Error code.
	Code *string `json:"code,omitempty"`

	// Detail error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// HCRPAssignmentReportsClientGetOptions contains the optional parameters for the HCRPAssignmentReportsClient.Get method.
type HCRPAssignmentReportsClientGetOptions struct {
	// placeholder for future optional parameters
}

// HCRPAssignmentReportsClientListOptions contains the optional parameters for the HCRPAssignmentReportsClient.List method.
type HCRPAssignmentReportsClientListOptions struct {
	// placeholder for future optional parameters
}

// HCRPAssignmentsClientCreateOrUpdateOptions contains the optional parameters for the HCRPAssignmentsClient.CreateOrUpdate
// method.
type HCRPAssignmentsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// HCRPAssignmentsClientDeleteOptions contains the optional parameters for the HCRPAssignmentsClient.Delete method.
type HCRPAssignmentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// HCRPAssignmentsClientGetOptions contains the optional parameters for the HCRPAssignmentsClient.Get method.
type HCRPAssignmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// HCRPAssignmentsClientListOptions contains the optional parameters for the HCRPAssignmentsClient.List method.
type HCRPAssignmentsClientListOptions struct {
	// placeholder for future optional parameters
}

// Navigation - Guest configuration is an artifact that encapsulates DSC configuration and its dependencies. The artifact
// is a zip file containing DSC configuration (as MOF) and dependent resources and other
// dependencies like modules.
type Navigation struct {
	// Specifies the assignment type and execution of the configuration. Possible values are Audit, DeployAndAutoCorrect, ApplyAndAutoCorrect
	// and ApplyAndMonitor.
	AssignmentType *AssignmentType `json:"assignmentType,omitempty"`

	// The configuration parameters for the guest configuration.
	ConfigurationParameter []*ConfigurationParameter `json:"configurationParameter,omitempty"`

	// The protected configuration parameters for the guest configuration.
	ConfigurationProtectedParameter []*ConfigurationParameter `json:"configurationProtectedParameter,omitempty"`

	// Combined hash of the guest configuration package and configuration parameters.
	ContentHash *string `json:"contentHash,omitempty"`

	// Uri of the storage where guest configuration package is uploaded.
	ContentURI *string `json:"contentUri,omitempty"`

	// Kind of the guest configuration. For example:DSC
	Kind *Kind `json:"kind,omitempty"`

	// Name of the guest configuration.
	Name *string `json:"name,omitempty"`

	// Version of the guest configuration.
	Version *string `json:"version,omitempty"`

	// READ-ONLY; Specifies the origin of the configuration.
	AssignmentSource *string `json:"assignmentSource,omitempty" azure:"ro"`

	// READ-ONLY; The configuration setting for the guest configuration.
	ConfigurationSetting *ConfigurationSetting `json:"configurationSetting,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the content type of the configuration. Possible values could be Builtin or Custom.
	ContentType *string `json:"contentType,omitempty" azure:"ro"`
}

// Operation - GuestConfiguration REST API operation
type Operation struct {
	// Provider, Resource, Operation and description values.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: For ex. providers/Microsoft.GuestConfiguration/guestConfigurationAssignments/write or read
	Name *string `json:"name,omitempty"`

	// Provider, Resource, Operation and description values.
	Properties *OperationProperties `json:"properties,omitempty"`
}

// OperationDisplay - Provider, Resource, Operation and description values.
type OperationDisplay struct {
	// Description about operation.
	Description *string `json:"description,omitempty"`

	// Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft.GuestConfiguration
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed: For ex.
	Resource *string `json:"resource,omitempty"`
}

// OperationList - The response model for the list of Automation operations
type OperationList struct {
	// List of Automation operations supported by the Automation resource provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationProperties - Provider, Resource, Operation and description values.
type OperationProperties struct {
	// Service provider: Microsoft.GuestConfiguration
	StatusCode *string `json:"statusCode,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ProxyResource - ARM proxy resource.
type ProxyResource struct {
	// Region where the VM is located.
	Location *string `json:"location,omitempty"`

	// Name of the guest configuration assignment.
	Name *string `json:"name,omitempty"`

	// READ-ONLY; ARM resource id of the guest configuration assignment.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Resource - The core properties of ARM resources
type Resource struct {
	// Region where the VM is located.
	Location *string `json:"location,omitempty"`

	// Name of the guest configuration assignment.
	Name *string `json:"name,omitempty"`

	// READ-ONLY; ARM resource id of the guest configuration assignment.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// VMInfo - Information about the VM.
type VMInfo struct {
	// READ-ONLY; Azure resource Id of the VM.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; UUID(Universally Unique Identifier) of the VM.
	UUID *string `json:"uuid,omitempty" azure:"ro"`
}

// VMSSVMInfo - Information about VMSS VM
type VMSSVMInfo struct {
	// READ-ONLY; A value indicating compliance status of the machine for the assigned guest configuration.
	ComplianceStatus *ComplianceStatus `json:"complianceStatus,omitempty" azure:"ro"`

	// READ-ONLY; Date and time when last compliance status was checked.
	LastComplianceChecked *time.Time `json:"lastComplianceChecked,omitempty" azure:"ro"`

	// READ-ONLY; Id of the latest report for the guest configuration assignment.
	LatestReportID *string `json:"latestReportId,omitempty" azure:"ro"`

	// READ-ONLY; UUID of the VM.
	VMID *string `json:"vmId,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource Id of the VM.
	VMResourceID *string `json:"vmResourceId,omitempty" azure:"ro"`
}
