//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armbotservice

import "time"

// AlexaChannel - Alexa channel definition
type AlexaChannel struct {
	// REQUIRED; The channel name
	ChannelName *string `json:"channelName,omitempty"`

	// Entity Tag of the resource
	Etag *string `json:"etag,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// The set of properties specific to Alexa channel resource
	Properties *AlexaChannelProperties `json:"properties,omitempty"`

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GetChannel implements the ChannelClassification interface for type AlexaChannel.
func (a *AlexaChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       a.ChannelName,
		Etag:              a.Etag,
		ProvisioningState: a.ProvisioningState,
		Location:          a.Location,
	}
}

// AlexaChannelProperties - The parameters to provide for the Alexa channel.
type AlexaChannelProperties struct {
	// REQUIRED; The Alexa skill Id
	AlexaSkillID *string `json:"alexaSkillId,omitempty"`

	// REQUIRED; Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// READ-ONLY; Full Uri used to configured the skill in Alexa
	ServiceEndpointURI *string `json:"serviceEndpointUri,omitempty" azure:"ro"`

	// READ-ONLY; Url fragment used in part of the Uri configured in Alexa
	URLFragment *string `json:"urlFragment,omitempty" azure:"ro"`
}

// Bot resource definition
type Bot struct {
	// Entity Tag
	Etag *string `json:"etag,omitempty"`

	// Required. Gets or sets the Kind of the resource.
	Kind *Kind `json:"kind,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// The set of properties specific to bot resource
	Properties *BotProperties `json:"properties,omitempty"`

	// Gets or sets the SKU of the resource.
	SKU *SKU `json:"sku,omitempty"`

	// Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; Entity zones
	Zones []*string `json:"zones,omitempty" azure:"ro"`
}

// BotChannel - Bot channel resource definition
type BotChannel struct {
	// Entity Tag
	Etag *string `json:"etag,omitempty"`

	// Required. Gets or sets the Kind of the resource.
	Kind *Kind `json:"kind,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// The set of properties specific to bot channel resource
	Properties ChannelClassification `json:"properties,omitempty"`

	// Gets or sets the SKU of the resource.
	SKU *SKU `json:"sku,omitempty"`

	// Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; Entity zones
	Zones []*string `json:"zones,omitempty" azure:"ro"`
}

// BotConnectionClientCreateOptions contains the optional parameters for the BotConnectionClient.Create method.
type BotConnectionClientCreateOptions struct {
	// placeholder for future optional parameters
}

// BotConnectionClientDeleteOptions contains the optional parameters for the BotConnectionClient.Delete method.
type BotConnectionClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// BotConnectionClientGetOptions contains the optional parameters for the BotConnectionClient.Get method.
type BotConnectionClientGetOptions struct {
	// placeholder for future optional parameters
}

// BotConnectionClientListByBotServiceOptions contains the optional parameters for the BotConnectionClient.ListByBotService
// method.
type BotConnectionClientListByBotServiceOptions struct {
	// placeholder for future optional parameters
}

// BotConnectionClientListServiceProvidersOptions contains the optional parameters for the BotConnectionClient.ListServiceProviders
// method.
type BotConnectionClientListServiceProvidersOptions struct {
	// placeholder for future optional parameters
}

// BotConnectionClientListWithSecretsOptions contains the optional parameters for the BotConnectionClient.ListWithSecrets
// method.
type BotConnectionClientListWithSecretsOptions struct {
	// placeholder for future optional parameters
}

// BotConnectionClientUpdateOptions contains the optional parameters for the BotConnectionClient.Update method.
type BotConnectionClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// BotProperties - The parameters to provide for the Bot.
type BotProperties struct {
	// REQUIRED; The Name of the bot
	DisplayName *string `json:"displayName,omitempty"`

	// REQUIRED; The bot's endpoint
	Endpoint *string `json:"endpoint,omitempty"`

	// REQUIRED; Microsoft App Id for the bot
	MsaAppID *string `json:"msaAppId,omitempty"`

	// Contains resource all settings defined as key/value pairs.
	AllSettings map[string]*string `json:"allSettings,omitempty"`

	// The hint (e.g. keyVault secret resourceId) on how to fetch the app secret
	AppPasswordHint *string `json:"appPasswordHint,omitempty"`

	// The CMK Url
	CmekKeyVaultURL *string `json:"cmekKeyVaultUrl,omitempty"`

	// The description of the bot
	Description *string `json:"description,omitempty"`

	// The Application Insights key
	DeveloperAppInsightKey *string `json:"developerAppInsightKey,omitempty"`

	// The Application Insights Api Key
	DeveloperAppInsightsAPIKey *string `json:"developerAppInsightsApiKey,omitempty"`

	// The Application Insights App Id
	DeveloperAppInsightsApplicationID *string `json:"developerAppInsightsApplicationId,omitempty"`

	// Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// The Icon Url of the bot
	IconURL *string `json:"iconUrl,omitempty"`

	// Whether Cmek is enabled
	IsCmekEnabled *bool `json:"isCmekEnabled,omitempty"`

	// Whether the bot is streaming supported
	IsStreamingSupported *bool `json:"isStreamingSupported,omitempty"`

	// Collection of LUIS App Ids
	LuisAppIDs []*string `json:"luisAppIds,omitempty"`

	// The LUIS Key
	LuisKey *string `json:"luisKey,omitempty"`

	// The bot's manifest url
	ManifestURL *string `json:"manifestUrl,omitempty"`

	// Microsoft App Managed Identity Resource Id for the bot
	MsaAppMSIResourceID *string `json:"msaAppMSIResourceId,omitempty"`

	// Microsoft App Tenant Id for the bot
	MsaAppTenantID *string `json:"msaAppTenantId,omitempty"`

	// Microsoft App Type for the bot
	MsaAppType *MsaAppType `json:"msaAppType,omitempty"`

	// The hint to browser (e.g. protocol handler) on how to open the bot for authoring
	OpenWithHint *string `json:"openWithHint,omitempty"`

	// Contains resource parameters defined as key/value pairs.
	Parameters map[string]*string `json:"parameters,omitempty"`

	// Whether the bot is in an isolated network
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Publishing credentials of the resource
	PublishingCredentials *string `json:"publishingCredentials,omitempty"`

	// The channel schema transformation version for the bot
	SchemaTransformationVersion *string `json:"schemaTransformationVersion,omitempty"`

	// The storage resourceId for the bot
	StorageResourceID *string `json:"storageResourceId,omitempty"`

	// READ-ONLY; The CMK encryption status
	CmekEncryptionStatus *string `json:"cmekEncryptionStatus,omitempty" azure:"ro"`

	// READ-ONLY; Collection of channels for which the bot is configured
	ConfiguredChannels []*string `json:"configuredChannels,omitempty" azure:"ro"`

	// READ-ONLY; Collection of channels for which the bot is enabled
	EnabledChannels []*string `json:"enabledChannels,omitempty" azure:"ro"`

	// READ-ONLY; The bot's endpoint version
	EndpointVersion *string `json:"endpointVersion,omitempty" azure:"ro"`

	// READ-ONLY; Whether the bot is developerAppInsightsApiKey set
	IsDeveloperAppInsightsAPIKeySet *bool `json:"isDeveloperAppInsightsApiKeySet,omitempty" azure:"ro"`

	// READ-ONLY; Token used to migrate non Azure bot to azure subscription
	MigrationToken *string `json:"migrationToken,omitempty" azure:"ro"`

	// READ-ONLY; List of Private Endpoint Connections configured for the bot
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// BotResponseList - The list of bot service operation response.
type BotResponseList struct {
	// The link used to get the next page of bot service resources.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; Gets the list of bot service results and their properties.
	Value []*Bot `json:"value,omitempty" azure:"ro"`
}

// BotsClientCreateOptions contains the optional parameters for the BotsClient.Create method.
type BotsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// BotsClientDeleteOptions contains the optional parameters for the BotsClient.Delete method.
type BotsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// BotsClientGetCheckNameAvailabilityOptions contains the optional parameters for the BotsClient.GetCheckNameAvailability
// method.
type BotsClientGetCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// BotsClientGetOptions contains the optional parameters for the BotsClient.Get method.
type BotsClientGetOptions struct {
	// placeholder for future optional parameters
}

// BotsClientListByResourceGroupOptions contains the optional parameters for the BotsClient.ListByResourceGroup method.
type BotsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// BotsClientListOptions contains the optional parameters for the BotsClient.List method.
type BotsClientListOptions struct {
	// placeholder for future optional parameters
}

// BotsClientUpdateOptions contains the optional parameters for the BotsClient.Update method.
type BotsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ChannelClassification provides polymorphic access to related types.
// Call the interface's GetChannel() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AlexaChannel, *Channel, *DirectLineChannel, *DirectLineSpeechChannel, *EmailChannel, *FacebookChannel, *KikChannel,
// - *LineChannel, *MsTeamsChannel, *SkypeChannel, *SlackChannel, *SmsChannel, *TelegramChannel, *WebChatChannel
type ChannelClassification interface {
	// GetChannel returns the Channel content of the underlying type.
	GetChannel() *Channel
}

// Channel definition
type Channel struct {
	// REQUIRED; The channel name
	ChannelName *string `json:"channelName,omitempty"`

	// Entity Tag of the resource
	Etag *string `json:"etag,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GetChannel implements the ChannelClassification interface for type Channel.
func (c *Channel) GetChannel() *Channel { return c }

// ChannelResponseList - The list of bot service channel operation response.
type ChannelResponseList struct {
	// The link used to get the next page of bot service channel resources.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; Gets the list of bot service channel results and their properties.
	Value []*BotChannel `json:"value,omitempty" azure:"ro"`
}

// ChannelSettings - Channel settings definition
type ChannelSettings struct {
	// The bot id
	BotID *string `json:"botId,omitempty"`

	// The bot icon url
	BotIconURL *string `json:"botIconUrl,omitempty"`

	// The channel display name
	ChannelDisplayName *string `json:"channelDisplayName,omitempty"`

	// The channel id
	ChannelID *string `json:"channelId,omitempty"`

	// Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// The extensionKey1
	ExtensionKey1 *string `json:"extensionKey1,omitempty"`

	// The extensionKey2
	ExtensionKey2 *string `json:"extensionKey2,omitempty"`

	// Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// The list of sites
	Sites []*Site `json:"sites,omitempty"`
}

// ChannelsClientCreateOptions contains the optional parameters for the ChannelsClient.Create method.
type ChannelsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// ChannelsClientDeleteOptions contains the optional parameters for the ChannelsClient.Delete method.
type ChannelsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ChannelsClientGetOptions contains the optional parameters for the ChannelsClient.Get method.
type ChannelsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ChannelsClientListByResourceGroupOptions contains the optional parameters for the ChannelsClient.ListByResourceGroup method.
type ChannelsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ChannelsClientListWithKeysOptions contains the optional parameters for the ChannelsClient.ListWithKeys method.
type ChannelsClientListWithKeysOptions struct {
	// placeholder for future optional parameters
}

// ChannelsClientUpdateOptions contains the optional parameters for the ChannelsClient.Update method.
type ChannelsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// CheckNameAvailabilityRequestBody - The request body for a request to Bot Service Management to check availability of a
// bot name.
type CheckNameAvailabilityRequestBody struct {
	// the name of the bot for which availability needs to be checked.
	Name *string `json:"name,omitempty"`

	// the type of the bot for which availability needs to be checked
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResponseBody - The response body returned for a request to Bot Service Management to check availability
// of a bot name.
type CheckNameAvailabilityResponseBody struct {
	// additional message from the bot management api showing why a bot name is not available
	Message *string `json:"message,omitempty"`

	// indicates if the bot name is valid.
	Valid *bool `json:"valid,omitempty"`
}

// ConnectionItemName - The display name of a connection Item Setting registered with the Bot
type ConnectionItemName struct {
	// READ-ONLY; Connection Item name that has been added in the API
	Name *string `json:"name,omitempty" azure:"ro"`
}

// ConnectionSetting - Bot channel resource definition
type ConnectionSetting struct {
	// Entity Tag
	Etag *string `json:"etag,omitempty"`

	// Required. Gets or sets the Kind of the resource.
	Kind *Kind `json:"kind,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// The set of properties specific to bot channel resource
	Properties *ConnectionSettingProperties `json:"properties,omitempty"`

	// Gets or sets the SKU of the resource.
	SKU *SKU `json:"sku,omitempty"`

	// Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; Entity zones
	Zones []*string `json:"zones,omitempty" azure:"ro"`
}

// ConnectionSettingParameter - Extra Parameter in a Connection Setting Properties to indicate service provider specific properties
type ConnectionSettingParameter struct {
	// Key for the Connection Setting Parameter.
	Key *string `json:"key,omitempty"`

	// Value associated with the Connection Setting Parameter.
	Value *string `json:"value,omitempty"`
}

// ConnectionSettingProperties - Properties for a Connection Setting Item
type ConnectionSettingProperties struct {
	// Client Id associated with the Connection Setting.
	ClientID *string `json:"clientId,omitempty"`

	// Client Secret associated with the Connection Setting
	ClientSecret *string `json:"clientSecret,omitempty"`

	// Id associated with the Connection Setting.
	ID *string `json:"id,omitempty"`

	// Name associated with the Connection Setting.
	Name *string `json:"name,omitempty"`

	// Service Provider Parameters associated with the Connection Setting
	Parameters []*ConnectionSettingParameter `json:"parameters,omitempty"`

	// Provisioning state of the resource
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// Scopes associated with the Connection Setting
	Scopes *string `json:"scopes,omitempty"`

	// Service Provider Display Name associated with the Connection Setting
	ServiceProviderDisplayName *string `json:"serviceProviderDisplayName,omitempty"`

	// Service Provider Id associated with the Connection Setting
	ServiceProviderID *string `json:"serviceProviderId,omitempty"`

	// READ-ONLY; Setting Id set by the service for the Connection Setting.
	SettingID *string `json:"settingId,omitempty" azure:"ro"`
}

// ConnectionSettingResponseList - The list of bot service connection settings response.
type ConnectionSettingResponseList struct {
	// The link used to get the next page of bot service connection setting resources.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; Gets the list of bot service connection settings and their properties.
	Value []*ConnectionSetting `json:"value,omitempty" azure:"ro"`
}

// DirectLineChannel - Direct Line channel definition
type DirectLineChannel struct {
	// REQUIRED; The channel name
	ChannelName *string `json:"channelName,omitempty"`

	// Entity Tag of the resource
	Etag *string `json:"etag,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// The set of properties specific to Direct Line channel resource
	Properties *DirectLineChannelProperties `json:"properties,omitempty"`

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GetChannel implements the ChannelClassification interface for type DirectLineChannel.
func (d *DirectLineChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       d.ChannelName,
		Etag:              d.Etag,
		ProvisioningState: d.ProvisioningState,
		Location:          d.Location,
	}
}

// DirectLineChannelProperties - The parameters to provide for the Direct Line channel.
type DirectLineChannelProperties struct {
	// Direct Line embed code of the resource
	DirectLineEmbedCode *string `json:"DirectLineEmbedCode,omitempty"`

	// The list of Direct Line sites
	Sites []*DirectLineSite `json:"sites,omitempty"`
}

// DirectLineClientRegenerateKeysOptions contains the optional parameters for the DirectLineClient.RegenerateKeys method.
type DirectLineClientRegenerateKeysOptions struct {
	// placeholder for future optional parameters
}

// DirectLineSite - A site for the Direct Line channel
type DirectLineSite struct {
	// REQUIRED; Whether this site is enabled for DirectLine channel.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; Whether this site is enabled for Bot Framework V1 protocol.
	IsV1Enabled *bool `json:"isV1Enabled,omitempty"`

	// REQUIRED; Whether this site is enabled for Bot Framework V1 protocol.
	IsV3Enabled *bool `json:"isV3Enabled,omitempty"`

	// REQUIRED; Site name
	SiteName *string `json:"siteName,omitempty"`

	// Whether this site is enabled for block user upload.
	IsBlockUserUploadEnabled *bool `json:"isBlockUserUploadEnabled,omitempty"`

	// Whether this site is enabled for authentication with Bot Framework.
	IsSecureSiteEnabled *bool `json:"isSecureSiteEnabled,omitempty"`

	// List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
	TrustedOrigins []*string `json:"trustedOrigins,omitempty"`

	// READ-ONLY; Primary key. Value only returned through POST to the action Channel List API, otherwise empty.
	Key *string `json:"key,omitempty" azure:"ro"`

	// READ-ONLY; Secondary key. Value only returned through POST to the action Channel List API, otherwise empty.
	Key2 *string `json:"key2,omitempty" azure:"ro"`

	// READ-ONLY; Site Id
	SiteID *string `json:"siteId,omitempty" azure:"ro"`
}

// DirectLineSpeechChannel - DirectLine Speech channel definition
type DirectLineSpeechChannel struct {
	// REQUIRED; The channel name
	ChannelName *string `json:"channelName,omitempty"`

	// Entity Tag of the resource
	Etag *string `json:"etag,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// The set of properties specific to DirectLine Speech channel resource
	Properties *DirectLineSpeechChannelProperties `json:"properties,omitempty"`

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GetChannel implements the ChannelClassification interface for type DirectLineSpeechChannel.
func (d *DirectLineSpeechChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       d.ChannelName,
		Etag:              d.Etag,
		ProvisioningState: d.ProvisioningState,
		Location:          d.Location,
	}
}

// DirectLineSpeechChannelProperties - The parameters to provide for the DirectLine Speech channel.
type DirectLineSpeechChannelProperties struct {
	// REQUIRED; The cognitive service region with this channel registration.
	CognitiveServiceRegion *string `json:"cognitiveServiceRegion,omitempty"`

	// REQUIRED; The cognitive service subscription key to use with this channel registration.
	CognitiveServiceSubscriptionKey *string `json:"cognitiveServiceSubscriptionKey,omitempty"`

	// Custom voice deployment id (optional).
	CustomSpeechModelID *string `json:"customSpeechModelId,omitempty"`

	// Custom speech model id (optional).
	CustomVoiceDeploymentID *string `json:"customVoiceDeploymentId,omitempty"`

	// Make this a default bot for chosen cognitive service account.
	IsDefaultBotForCogSvcAccount *bool `json:"isDefaultBotForCogSvcAccount,omitempty"`

	// Whether this channel is enabled or not.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// EmailChannel - Email channel definition
type EmailChannel struct {
	// REQUIRED; The channel name
	ChannelName *string `json:"channelName,omitempty"`

	// Entity Tag of the resource
	Etag *string `json:"etag,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// The set of properties specific to email channel resource
	Properties *EmailChannelProperties `json:"properties,omitempty"`

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GetChannel implements the ChannelClassification interface for type EmailChannel.
func (e *EmailChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       e.ChannelName,
		Etag:              e.Etag,
		ProvisioningState: e.ProvisioningState,
		Location:          e.Location,
	}
}

// EmailChannelProperties - The parameters to provide for the Email channel.
type EmailChannelProperties struct {
	// REQUIRED; The email address
	EmailAddress *string `json:"emailAddress,omitempty"`

	// REQUIRED; Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// The password for the email address. Value only returned through POST to the action Channel List API, otherwise empty.
	Password *string `json:"password,omitempty"`
}

// Error - Bot Service error object.
type Error struct {
	// The error body.
	Error *ErrorBody `json:"error,omitempty"`
}

// ErrorBody - Bot Service error body.
type ErrorBody struct {
	// REQUIRED; error code
	Code *string `json:"code,omitempty"`

	// REQUIRED; error message
	Message *string `json:"message,omitempty"`
}

// FacebookChannel - Facebook channel definition
type FacebookChannel struct {
	// REQUIRED; The channel name
	ChannelName *string `json:"channelName,omitempty"`

	// Entity Tag of the resource
	Etag *string `json:"etag,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// The set of properties specific to bot facebook channel
	Properties *FacebookChannelProperties `json:"properties,omitempty"`

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GetChannel implements the ChannelClassification interface for type FacebookChannel.
func (f *FacebookChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       f.ChannelName,
		Etag:              f.Etag,
		ProvisioningState: f.ProvisioningState,
		Location:          f.Location,
	}
}

// FacebookChannelProperties - The parameters to provide for the Facebook channel.
type FacebookChannelProperties struct {
	// REQUIRED; Facebook application id
	AppID *string `json:"appId,omitempty"`

	// REQUIRED; Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// Facebook application secret. Value only returned through POST to the action Channel List API, otherwise empty.
	AppSecret *string `json:"appSecret,omitempty"`

	// The list of Facebook pages
	Pages []*FacebookPage `json:"pages,omitempty"`

	// READ-ONLY; Callback Url
	CallbackURL *string `json:"callbackUrl,omitempty" azure:"ro"`

	// READ-ONLY; Verify token. Value only returned through POST to the action Channel List API, otherwise empty.
	VerifyToken *string `json:"verifyToken,omitempty" azure:"ro"`
}

// FacebookPage - A Facebook page for Facebook channel registration
type FacebookPage struct {
	// REQUIRED; Page id
	ID *string `json:"id,omitempty"`

	// Facebook application access token. Value only returned through POST to the action Channel List API, otherwise empty.
	AccessToken *string `json:"accessToken,omitempty"`
}

// HostSettingsClientGetOptions contains the optional parameters for the HostSettingsClient.Get method.
type HostSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// HostSettingsResponse - The response body returned for a request to Bot Service Management to check per subscription hostSettings
type HostSettingsResponse struct {
	// Same as toBotFromChannelOpenIdMetadataUrl, used by SDK < v4.12
	BotOpenIDMetadata *string `json:"BotOpenIdMetadata,omitempty"`

	// For in-conversation bot user authentication
	OAuthURL *string `json:"OAuthUrl,omitempty"`

	// For verifying incoming tokens from the channels
	ToBotFromChannelOpenIDMetadataURL *string `json:"ToBotFromChannelOpenIdMetadataUrl,omitempty"`

	// For verifying incoming tokens from the channels
	ToBotFromChannelTokenIssuer *string `json:"ToBotFromChannelTokenIssuer,omitempty"`

	// For verifying incoming tokens from bot emulator
	ToBotFromEmulatorOpenIDMetadataURL *string `json:"ToBotFromEmulatorOpenIdMetadataUrl,omitempty"`

	// For getting access token to channels from bot host
	ToChannelFromBotLoginURL *string `json:"ToChannelFromBotLoginUrl,omitempty"`

	// For getting access token to channels from bot host
	ToChannelFromBotOAuthScope *string `json:"ToChannelFromBotOAuthScope,omitempty"`

	// Per cloud OAuth setting on whether authority is validated
	ValidateAuthority *bool `json:"ValidateAuthority,omitempty"`
}

// KikChannel - Kik channel definition
type KikChannel struct {
	// REQUIRED; The channel name
	ChannelName *string `json:"channelName,omitempty"`

	// Entity Tag of the resource
	Etag *string `json:"etag,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// The set of properties specific to Kik channel resource
	Properties *KikChannelProperties `json:"properties,omitempty"`

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GetChannel implements the ChannelClassification interface for type KikChannel.
func (k *KikChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       k.ChannelName,
		Etag:              k.Etag,
		ProvisioningState: k.ProvisioningState,
		Location:          k.Location,
	}
}

// KikChannelProperties - The parameters to provide for the Kik channel.
type KikChannelProperties struct {
	// REQUIRED; Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The Kik user name
	UserName *string `json:"userName,omitempty"`

	// Kik API key. Value only returned through POST to the action Channel List API, otherwise empty.
	APIKey *string `json:"apiKey,omitempty"`

	// Whether this channel is validated for the bot
	IsValidated *bool `json:"isValidated,omitempty"`
}

// LineChannel - Line channel definition
type LineChannel struct {
	// REQUIRED; The channel name
	ChannelName *string `json:"channelName,omitempty"`

	// Entity Tag of the resource
	Etag *string `json:"etag,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// The set of properties specific to line channel resource
	Properties *LineChannelProperties `json:"properties,omitempty"`

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GetChannel implements the ChannelClassification interface for type LineChannel.
func (l *LineChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       l.ChannelName,
		Etag:              l.Etag,
		ProvisioningState: l.ProvisioningState,
		Location:          l.Location,
	}
}

// LineChannelProperties - The parameters to provide for the Line channel.
type LineChannelProperties struct {
	// REQUIRED; The list of line channel registrations
	LineRegistrations []*LineRegistration `json:"lineRegistrations,omitempty"`

	// READ-ONLY; Callback Url to enter in line registration.
	CallbackURL *string `json:"callbackUrl,omitempty" azure:"ro"`

	// READ-ONLY; Whether this channel is validated for the bot
	IsValidated *bool `json:"isValidated,omitempty" azure:"ro"`
}

// LineRegistration - The properties corresponding to a line channel registration
type LineRegistration struct {
	// Access token for the line channel registration
	ChannelAccessToken *string `json:"channelAccessToken,omitempty"`

	// Secret for the line channel registration
	ChannelSecret *string `json:"channelSecret,omitempty"`

	// READ-ONLY; Id generated for the line channel registration
	GeneratedID *string `json:"generatedId,omitempty" azure:"ro"`
}

// ListChannelWithKeysResponse - The ARM channel of list channel with keys operation response.
type ListChannelWithKeysResponse struct {
	// Changed time of the resource
	ChangedTime *string `json:"changedTime,omitempty"`

	// Entity tag of the resource
	EntityTag *string `json:"entityTag,omitempty"`

	// Entity Tag
	Etag *string `json:"etag,omitempty"`

	// Required. Gets or sets the Kind of the resource.
	Kind *Kind `json:"kind,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// The set of properties specific to bot channel resource
	Properties ChannelClassification `json:"properties,omitempty"`

	// Provisioning state of the resource
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// The set of properties specific to bot channel resource
	Resource ChannelClassification `json:"resource,omitempty"`

	// Gets or sets the SKU of the resource.
	SKU *SKU `json:"sku,omitempty"`

	// Channel settings
	Setting *ChannelSettings `json:"setting,omitempty"`

	// Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; Entity zones
	Zones []*string `json:"zones,omitempty" azure:"ro"`
}

// MsTeamsChannel - Microsoft Teams channel definition
type MsTeamsChannel struct {
	// REQUIRED; The channel name
	ChannelName *string `json:"channelName,omitempty"`

	// Entity Tag of the resource
	Etag *string `json:"etag,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// The set of properties specific to Microsoft Teams channel resource
	Properties *MsTeamsChannelProperties `json:"properties,omitempty"`

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GetChannel implements the ChannelClassification interface for type MsTeamsChannel.
func (m *MsTeamsChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       m.ChannelName,
		Etag:              m.Etag,
		ProvisioningState: m.ProvisioningState,
		Location:          m.Location,
	}
}

// MsTeamsChannelProperties - The parameters to provide for the Microsoft Teams channel.
type MsTeamsChannelProperties struct {
	// REQUIRED; Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// Whether this channel accepted terms
	AcceptedTerms *bool `json:"acceptedTerms,omitempty"`

	// Webhook for Microsoft Teams channel calls
	CallingWebHook *string `json:"callingWebHook,omitempty"`

	// Deployment environment for Microsoft Teams channel calls
	DeploymentEnvironment *string `json:"deploymentEnvironment,omitempty"`

	// Enable calling for Microsoft Teams channel
	EnableCalling *bool `json:"enableCalling,omitempty"`

	// Webhook for Microsoft Teams channel calls
	IncomingCallRoute *string `json:"incomingCallRoute,omitempty"`
}

// OperationDisplayInfo - The operation supported by Bot Service Management.
type OperationDisplayInfo struct {
	// The description of the operation.
	Description *string `json:"description,omitempty"`

	// The action that users can perform, based on their permission level.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft Bot Service.
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationEntity - The operations supported by Bot Service Management.
type OperationEntity struct {
	// The operation supported by Bot Service Management.
	Display *OperationDisplayInfo `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`

	// The origin of the operation.
	Origin *string `json:"origin,omitempty"`

	// Additional properties.
	Properties interface{} `json:"properties,omitempty"`
}

// OperationEntityListResult - The list of bot service operation response.
type OperationEntityListResult struct {
	// The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of operations.
	Value []*OperationEntity `json:"value,omitempty"`
}

// OperationResultsClientBeginGetOptions contains the optional parameters for the OperationResultsClient.BeginGet method.
type OperationResultsClientBeginGetOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OperationResultsDescription - The properties indicating the operation result of an operation on a service.
type OperationResultsDescription struct {
	// READ-ONLY; The ID of the operation returned.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation result.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The time that the operation was started.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The status of the operation being performed.
	Status *OperationResultStatus `json:"status,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty" azure:"ro"`
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - List of private endpoint connection associated with the specified storage account
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientCreateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Create
// method.
type PrivateEndpointConnectionsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Delete
// method.
type PrivateEndpointConnectionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListOptions contains the optional parameters for the PrivateEndpointConnectionsClient.List
// method.
type PrivateEndpointConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceBase - Common fields that are returned in the response for all BotService Private Link Resources
type PrivateLinkResourceBase struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientListByBotResourceOptions contains the optional parameters for the PrivateLinkResourcesClient.ListByBotResource
// method.
type PrivateLinkResourcesClientListByBotResourceOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`

	// The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
}

// Resource - Azure resource
type Resource struct {
	// Entity Tag
	Etag *string `json:"etag,omitempty"`

	// Required. Gets or sets the Kind of the resource.
	Kind *Kind `json:"kind,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// Gets or sets the SKU of the resource.
	SKU *SKU `json:"sku,omitempty"`

	// Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; Entity zones
	Zones []*string `json:"zones,omitempty" azure:"ro"`
}

// SKU - The SKU of the cognitive services account.
type SKU struct {
	// REQUIRED; The sku name
	Name *SKUName `json:"name,omitempty"`

	// READ-ONLY; Gets the sku tier. This is based on the SKU name.
	Tier *SKUTier `json:"tier,omitempty" azure:"ro"`
}

// ServiceProvider - Service Provider Definition
type ServiceProvider struct {
	// The Properties of a Service Provider Object
	Properties *ServiceProviderProperties `json:"properties,omitempty"`
}

// ServiceProviderParameter - Extra Parameters specific to each Service Provider
type ServiceProviderParameter struct {
	// READ-ONLY; Default Name for the Service Provider
	Default *string `json:"default,omitempty" azure:"ro"`

	// READ-ONLY; Description of the Service Provider
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Display Name of the Service Provider
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Help Url for the Service Provider
	HelpURL *string `json:"helpUrl,omitempty" azure:"ro"`

	// READ-ONLY; Meta data for the Service Provider
	Metadata *ServiceProviderParameterMetadata `json:"metadata,omitempty" azure:"ro"`

	// READ-ONLY; Name of the Service Provider
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of the Service Provider
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceProviderParameterMetadata - Meta data for the Service Provider
type ServiceProviderParameterMetadata struct {
	// the constraints of the bot meta data.
	Constraints *ServiceProviderParameterMetadataConstraints `json:"constraints,omitempty"`
}

// ServiceProviderParameterMetadataConstraints - the constraints of the bot meta data.
type ServiceProviderParameterMetadataConstraints struct {
	// Whether required the constraints of the bot meta data.
	Required *bool `json:"required,omitempty"`
}

// ServiceProviderProperties - The Object used to describe a Service Provider supported by Bot Service
type ServiceProviderProperties struct {
	// The list of parameters for the Service Provider
	Parameters []*ServiceProviderParameter `json:"parameters,omitempty"`

	// READ-ONLY; Display Name of the Service Provider
	DevPortalURL *string `json:"devPortalUrl,omitempty" azure:"ro"`

	// READ-ONLY; Display Name of the Service Provider
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Id for Service Provider
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Display Name of the Service Provider
	IconURL *string `json:"iconUrl,omitempty" azure:"ro"`

	// READ-ONLY; Display Name of the Service Provider
	ServiceProviderName *string `json:"serviceProviderName,omitempty" azure:"ro"`
}

// ServiceProviderResponseList - The list of bot service providers response.
type ServiceProviderResponseList struct {
	// The link used to get the next page of bot service providers.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; Gets the list of bot service providers and their properties.
	Value []*ServiceProvider `json:"value,omitempty" azure:"ro"`
}

// Site - A site for the channel
type Site struct {
	// REQUIRED; Whether this site is enabled for DirectLine channel
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; Whether this site is enabled for Bot Framework V1 protocol.
	IsV1Enabled *bool `json:"isV1Enabled,omitempty"`

	// REQUIRED; Whether this site is enabled for Bot Framework V1 protocol.
	IsV3Enabled *bool `json:"isV3Enabled,omitempty"`

	// REQUIRED; Whether this site is enabled for preview versions of Webchat
	IsWebchatPreviewEnabled *bool `json:"isWebchatPreviewEnabled,omitempty"`

	// REQUIRED; Site name
	SiteName *string `json:"siteName,omitempty"`

	// Entity Tag
	ETag *string `json:"eTag,omitempty"`

	// Whether this site is enabled for block user upload.
	IsBlockUserUploadEnabled *bool `json:"isBlockUserUploadEnabled,omitempty"`

	// Whether this site is enabled for authentication with Bot Framework.
	IsSecureSiteEnabled *bool `json:"isSecureSiteEnabled,omitempty"`

	// Whether this site is token enabled for channel
	IsTokenEnabled *bool `json:"isTokenEnabled,omitempty"`

	// List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
	TrustedOrigins []*string `json:"trustedOrigins,omitempty"`

	// READ-ONLY; Primary key. Value only returned through POST to the action Channel List API, otherwise empty.
	Key *string `json:"key,omitempty" azure:"ro"`

	// READ-ONLY; Secondary key. Value only returned through POST to the action Channel List API, otherwise empty.
	Key2 *string `json:"key2,omitempty" azure:"ro"`

	// READ-ONLY; Site Id
	SiteID *string `json:"siteId,omitempty" azure:"ro"`
}

// SiteInfo - Site information for WebChat or DirectLine Channels to identify which site to regenerate keys for.
type SiteInfo struct {
	// REQUIRED; Determines which key is to be regenerated
	Key *Key `json:"key,omitempty"`

	// REQUIRED; The site name
	SiteName *string `json:"siteName,omitempty"`
}

// SkypeChannel - Skype channel definition
type SkypeChannel struct {
	// REQUIRED; The channel name
	ChannelName *string `json:"channelName,omitempty"`

	// Entity Tag of the resource
	Etag *string `json:"etag,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// The set of properties specific to Skype channel resource
	Properties *SkypeChannelProperties `json:"properties,omitempty"`

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GetChannel implements the ChannelClassification interface for type SkypeChannel.
func (s *SkypeChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       s.ChannelName,
		Etag:              s.Etag,
		ProvisioningState: s.ProvisioningState,
		Location:          s.Location,
	}
}

// SkypeChannelProperties - The parameters to provide for the Microsoft Teams channel.
type SkypeChannelProperties struct {
	// REQUIRED; Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// Calling web hook for Skype channel
	CallingWebHook *string `json:"callingWebHook,omitempty"`

	// Enable calling for Skype channel
	EnableCalling *bool `json:"enableCalling,omitempty"`

	// Enable groups for Skype channel
	EnableGroups *bool `json:"enableGroups,omitempty"`

	// Enable media cards for Skype channel
	EnableMediaCards *bool `json:"enableMediaCards,omitempty"`

	// Enable messaging for Skype channel
	EnableMessaging *bool `json:"enableMessaging,omitempty"`

	// Enable screen sharing for Skype channel
	EnableScreenSharing *bool `json:"enableScreenSharing,omitempty"`

	// Enable video for Skype channel
	EnableVideo *bool `json:"enableVideo,omitempty"`

	// Group mode for Skype channel
	GroupsMode *string `json:"groupsMode,omitempty"`

	// Incoming call route for Skype channel
	IncomingCallRoute *string `json:"incomingCallRoute,omitempty"`
}

// SlackChannel - Slack channel definition
type SlackChannel struct {
	// REQUIRED; The channel name
	ChannelName *string `json:"channelName,omitempty"`

	// Entity Tag of the resource
	Etag *string `json:"etag,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// The set of properties specific to Slack channel resource
	Properties *SlackChannelProperties `json:"properties,omitempty"`

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GetChannel implements the ChannelClassification interface for type SlackChannel.
func (s *SlackChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       s.ChannelName,
		Etag:              s.Etag,
		ProvisioningState: s.ProvisioningState,
		Location:          s.Location,
	}
}

// SlackChannelProperties - The parameters to provide for the Slack channel.
type SlackChannelProperties struct {
	// REQUIRED; Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// The Slack client id
	ClientID *string `json:"clientId,omitempty"`

	// The Slack client secret. Value only returned through POST to the action Channel List API, otherwise empty.
	ClientSecret *string `json:"clientSecret,omitempty"`

	// The Slack landing page Url
	LandingPageURL *string `json:"landingPageUrl,omitempty"`

	// The Slack permission scopes.
	Scopes *string `json:"scopes,omitempty"`

	// The Slack signing secret.
	SigningSecret *string `json:"signingSecret,omitempty"`

	// The Slack verification token. Value only returned through POST to the action Channel List API, otherwise empty.
	VerificationToken *string `json:"verificationToken,omitempty"`

	// READ-ONLY; Whether this channel is validated for the bot
	IsValidated *bool `json:"IsValidated,omitempty" azure:"ro"`

	// READ-ONLY; The Sms auth token
	LastSubmissionID *string `json:"lastSubmissionId,omitempty" azure:"ro"`

	// READ-ONLY; The Slack redirect action
	RedirectAction *string `json:"redirectAction,omitempty" azure:"ro"`

	// READ-ONLY; Whether to register the settings before OAuth validation is performed. Recommended to True.
	RegisterBeforeOAuthFlow *bool `json:"registerBeforeOAuthFlow,omitempty" azure:"ro"`
}

// SmsChannel - Sms channel definition
type SmsChannel struct {
	// REQUIRED; The channel name
	ChannelName *string `json:"channelName,omitempty"`

	// Entity Tag of the resource
	Etag *string `json:"etag,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// The set of properties specific to Sms channel resource
	Properties *SmsChannelProperties `json:"properties,omitempty"`

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GetChannel implements the ChannelClassification interface for type SmsChannel.
func (s *SmsChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       s.ChannelName,
		Etag:              s.Etag,
		ProvisioningState: s.ProvisioningState,
		Location:          s.Location,
	}
}

// SmsChannelProperties - The parameters to provide for the Sms channel.
type SmsChannelProperties struct {
	// REQUIRED; The Sms account SID. Value only returned through POST to the action Channel List API, otherwise empty.
	AccountSID *string `json:"accountSID,omitempty"`

	// REQUIRED; Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The Sms phone
	Phone *string `json:"phone,omitempty"`

	// The Sms auth token. Value only returned through POST to the action Channel List API, otherwise empty.
	AuthToken *string `json:"authToken,omitempty"`

	// Whether this channel is validated for the bot
	IsValidated *bool `json:"isValidated,omitempty"`
}

// TelegramChannel - Telegram channel definition
type TelegramChannel struct {
	// REQUIRED; The channel name
	ChannelName *string `json:"channelName,omitempty"`

	// Entity Tag of the resource
	Etag *string `json:"etag,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// The set of properties specific to Telegram channel resource
	Properties *TelegramChannelProperties `json:"properties,omitempty"`

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GetChannel implements the ChannelClassification interface for type TelegramChannel.
func (t *TelegramChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       t.ChannelName,
		Etag:              t.Etag,
		ProvisioningState: t.ProvisioningState,
		Location:          t.Location,
	}
}

// TelegramChannelProperties - The parameters to provide for the Telegram channel.
type TelegramChannelProperties struct {
	// REQUIRED; Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// The Telegram access token. Value only returned through POST to the action Channel List API, otherwise empty.
	AccessToken *string `json:"accessToken,omitempty"`

	// Whether this channel is validated for the bot
	IsValidated *bool `json:"isValidated,omitempty"`
}

// WebChatChannel - Web Chat channel definition
type WebChatChannel struct {
	// REQUIRED; The channel name
	ChannelName *string `json:"channelName,omitempty"`

	// Entity Tag of the resource
	Etag *string `json:"etag,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// The set of properties specific to Web Chat channel resource
	Properties *WebChatChannelProperties `json:"properties,omitempty"`

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GetChannel implements the ChannelClassification interface for type WebChatChannel.
func (w *WebChatChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       w.ChannelName,
		Etag:              w.Etag,
		ProvisioningState: w.ProvisioningState,
		Location:          w.Location,
	}
}

// WebChatChannelProperties - The parameters to provide for the Web Chat channel.
type WebChatChannelProperties struct {
	// The list of Web Chat sites
	Sites []*WebChatSite `json:"sites,omitempty"`

	// READ-ONLY; Web chat control embed code
	WebChatEmbedCode *string `json:"webChatEmbedCode,omitempty" azure:"ro"`
}

// WebChatSite - A site for the Webchat channel
type WebChatSite struct {
	// REQUIRED; Whether this site is enabled for DirectLine channel
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; Whether this site is enabled for preview versions of Webchat
	IsWebchatPreviewEnabled *bool `json:"isWebchatPreviewEnabled,omitempty"`

	// REQUIRED; Site name
	SiteName *string `json:"siteName,omitempty"`

	// READ-ONLY; Primary key. Value only returned through POST to the action Channel List API, otherwise empty.
	Key *string `json:"key,omitempty" azure:"ro"`

	// READ-ONLY; Secondary key. Value only returned through POST to the action Channel List API, otherwise empty.
	Key2 *string `json:"key2,omitempty" azure:"ro"`

	// READ-ONLY; Site Id
	SiteID *string `json:"siteId,omitempty" azure:"ro"`
}
