//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armappplatform_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appplatform/armappplatform"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2022-11-01-preview/examples/Apps_Get.json
func ExampleAppsClient_Get_appsGet() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappplatform.NewAppsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.Get(ctx, "myResourceGroup", "myservice", "myapp", &armappplatform.AppsClientGetOptions{SyncStatus: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2022-11-01-preview/examples/Apps_Get_VNetInjection.json
func ExampleAppsClient_Get_appsGetVNetInjection() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappplatform.NewAppsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.Get(ctx, "myResourceGroup", "myservice", "myapp", &armappplatform.AppsClientGetOptions{SyncStatus: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2022-11-01-preview/examples/Apps_CreateOrUpdate.json
func ExampleAppsClient_BeginCreateOrUpdate_appsCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappplatform.NewAppsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := client.BeginCreateOrUpdate(ctx, "myResourceGroup", "myservice", "myapp", armappplatform.AppResource{
		Identity: &armappplatform.ManagedIdentityProperties{
			Type: to.Ptr(armappplatform.ManagedIdentityTypeSystemAssignedUserAssigned),
			UserAssignedIdentities: map[string]*armappplatform.UserAssignedManagedIdentity{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": {},
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id2": {},
			},
		},
		Location: to.Ptr("eastus"),
		Properties: &armappplatform.AppResourceProperties{
			AddonConfigs: map[string]map[string]interface{}{
				"ApplicationConfigurationService": {
					"resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/configurationServices/myacs",
				},
				"ServiceRegistry": {
					"resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/serviceRegistries/myServiceRegistry",
				},
			},
			CustomPersistentDisks: []*armappplatform.CustomPersistentDiskResource{
				{
					CustomPersistentDiskProperties: &armappplatform.AzureFileVolume{
						Type: to.Ptr(armappplatform.TypeAzureFileVolume),
						MountOptions: []*string{
							to.Ptr("uid=0"),
							to.Ptr("gid=0"),
							to.Ptr("dir_mode=0777"),
							to.Ptr("file_mode=0777")},
						MountPath: to.Ptr("/mypath1/mypath2"),
						ShareName: to.Ptr("myFileShare"),
					},
					StorageID: to.Ptr("myASCStorageID"),
				}},
			EnableEndToEndTLS: to.Ptr(false),
			HTTPSOnly:         to.Ptr(false),
			LoadedCertificates: []*armappplatform.LoadedCertificate{
				{
					LoadTrustStore: to.Ptr(false),
					ResourceID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert1"),
				},
				{
					LoadTrustStore: to.Ptr(true),
					ResourceID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert2"),
				}},
			PersistentDisk: &armappplatform.PersistentDisk{
				MountPath: to.Ptr("/mypersistentdisk"),
				SizeInGB:  to.Ptr[int32](2),
			},
			Public: to.Ptr(true),
			TemporaryDisk: &armappplatform.TemporaryDisk{
				MountPath: to.Ptr("/mytemporarydisk"),
				SizeInGB:  to.Ptr[int32](2),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2022-11-01-preview/examples/Apps_CreateOrUpdate_VNetInjection.json
func ExampleAppsClient_BeginCreateOrUpdate_appsCreateOrUpdateVNetInjection() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappplatform.NewAppsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := client.BeginCreateOrUpdate(ctx, "myResourceGroup", "myservice", "myapp", armappplatform.AppResource{
		Identity: &armappplatform.ManagedIdentityProperties{
			Type: to.Ptr(armappplatform.ManagedIdentityTypeSystemAssignedUserAssigned),
			UserAssignedIdentities: map[string]*armappplatform.UserAssignedManagedIdentity{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": {},
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id2": {},
			},
		},
		Location: to.Ptr("eastus"),
		Properties: &armappplatform.AppResourceProperties{
			AddonConfigs: map[string]map[string]interface{}{
				"ApplicationConfigurationService": {
					"resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/configurationServices/myacs",
				},
				"ServiceRegistry": {
					"resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/serviceRegistries/myServiceRegistry",
				},
			},
			CustomPersistentDisks: []*armappplatform.CustomPersistentDiskResource{
				{
					CustomPersistentDiskProperties: &armappplatform.AzureFileVolume{
						Type: to.Ptr(armappplatform.TypeAzureFileVolume),
						MountOptions: []*string{
							to.Ptr("uid=0"),
							to.Ptr("gid=0"),
							to.Ptr("dir_mode=0777"),
							to.Ptr("file_mode=0777")},
						MountPath: to.Ptr("/mypath1/mypath2"),
						ShareName: to.Ptr("myFileShare"),
					},
					StorageID: to.Ptr("myASCStorageID"),
				}},
			EnableEndToEndTLS: to.Ptr(false),
			HTTPSOnly:         to.Ptr(false),
			LoadedCertificates: []*armappplatform.LoadedCertificate{
				{
					LoadTrustStore: to.Ptr(false),
					ResourceID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert1"),
				},
				{
					LoadTrustStore: to.Ptr(true),
					ResourceID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert2"),
				}},
			PersistentDisk: &armappplatform.PersistentDisk{
				MountPath: to.Ptr("/mypersistentdisk"),
				SizeInGB:  to.Ptr[int32](2),
			},
			Public: to.Ptr(true),
			TemporaryDisk: &armappplatform.TemporaryDisk{
				MountPath: to.Ptr("/mytemporarydisk"),
				SizeInGB:  to.Ptr[int32](2),
			},
			VnetAddons: &armappplatform.AppVNetAddons{
				PublicEndpoint: to.Ptr(true),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2022-11-01-preview/examples/Apps_Delete.json
func ExampleAppsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappplatform.NewAppsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := client.BeginDelete(ctx, "myResourceGroup", "myservice", "myapp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2022-11-01-preview/examples/Apps_Update.json
func ExampleAppsClient_BeginUpdate_appsUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappplatform.NewAppsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := client.BeginUpdate(ctx, "myResourceGroup", "myservice", "myapp", armappplatform.AppResource{
		Identity: &armappplatform.ManagedIdentityProperties{
			Type: to.Ptr(armappplatform.ManagedIdentityTypeSystemAssignedUserAssigned),
			UserAssignedIdentities: map[string]*armappplatform.UserAssignedManagedIdentity{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": {},
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id2": {},
			},
		},
		Location: to.Ptr("eastus"),
		Properties: &armappplatform.AppResourceProperties{
			CustomPersistentDisks: []*armappplatform.CustomPersistentDiskResource{
				{
					CustomPersistentDiskProperties: &armappplatform.AzureFileVolume{
						Type:         to.Ptr(armappplatform.TypeAzureFileVolume),
						MountOptions: []*string{},
						MountPath:    to.Ptr("/mypath1/mypath2"),
						ShareName:    to.Ptr("myFileShare"),
					},
					StorageID: to.Ptr("myASCStorageID"),
				}},
			EnableEndToEndTLS: to.Ptr(false),
			HTTPSOnly:         to.Ptr(false),
			PersistentDisk: &armappplatform.PersistentDisk{
				MountPath: to.Ptr("/mypersistentdisk"),
				SizeInGB:  to.Ptr[int32](2),
			},
			Public: to.Ptr(true),
			TemporaryDisk: &armappplatform.TemporaryDisk{
				MountPath: to.Ptr("/mytemporarydisk"),
				SizeInGB:  to.Ptr[int32](2),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2022-11-01-preview/examples/Apps_Update_VNetInjection.json
func ExampleAppsClient_BeginUpdate_appsUpdateVNetInjection() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappplatform.NewAppsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := client.BeginUpdate(ctx, "myResourceGroup", "myservice", "myapp", armappplatform.AppResource{
		Identity: &armappplatform.ManagedIdentityProperties{
			Type: to.Ptr(armappplatform.ManagedIdentityTypeSystemAssignedUserAssigned),
			UserAssignedIdentities: map[string]*armappplatform.UserAssignedManagedIdentity{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": {},
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id2": {},
			},
		},
		Location: to.Ptr("eastus"),
		Properties: &armappplatform.AppResourceProperties{
			CustomPersistentDisks: []*armappplatform.CustomPersistentDiskResource{
				{
					CustomPersistentDiskProperties: &armappplatform.AzureFileVolume{
						Type:         to.Ptr(armappplatform.TypeAzureFileVolume),
						MountOptions: []*string{},
						MountPath:    to.Ptr("/mypath1/mypath2"),
						ShareName:    to.Ptr("myFileShare"),
					},
					StorageID: to.Ptr("myASCStorageID"),
				}},
			EnableEndToEndTLS: to.Ptr(false),
			HTTPSOnly:         to.Ptr(false),
			PersistentDisk: &armappplatform.PersistentDisk{
				MountPath: to.Ptr("/mypersistentdisk"),
				SizeInGB:  to.Ptr[int32](2),
			},
			Public: to.Ptr(true),
			TemporaryDisk: &armappplatform.TemporaryDisk{
				MountPath: to.Ptr("/mytemporarydisk"),
				SizeInGB:  to.Ptr[int32](2),
			},
			VnetAddons: &armappplatform.AppVNetAddons{
				PublicEndpoint: to.Ptr(true),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2022-11-01-preview/examples/Apps_List.json
func ExampleAppsClient_NewListPager_appsList() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappplatform.NewAppsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := client.NewListPager("myResourceGroup", "myservice", nil)
	for pager.More() {
		nextResult, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range nextResult.Value {
			// TODO: use page item
			_ = v
		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2022-11-01-preview/examples/Apps_List_VNetInjection.json
func ExampleAppsClient_NewListPager_appsListVNetInjection() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappplatform.NewAppsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := client.NewListPager("myResourceGroup", "myservice", nil)
	for pager.More() {
		nextResult, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range nextResult.Value {
			// TODO: use page item
			_ = v
		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2022-11-01-preview/examples/Apps_GetResourceUploadUrl.json
func ExampleAppsClient_GetResourceUploadURL() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappplatform.NewAppsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.GetResourceUploadURL(ctx, "myResourceGroup", "myservice", "myapp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2022-11-01-preview/examples/Apps_SetActiveDeployments.json
func ExampleAppsClient_BeginSetActiveDeployments() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappplatform.NewAppsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := client.BeginSetActiveDeployments(ctx, "myResourceGroup", "myservice", "myapp", armappplatform.ActiveDeploymentCollection{
		ActiveDeploymentNames: []*string{
			to.Ptr("default")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2022-11-01-preview/examples/Apps_ValidateDomain.json
func ExampleAppsClient_ValidateDomain() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappplatform.NewAppsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.ValidateDomain(ctx, "myResourceGroup", "myservice", "myapp", armappplatform.CustomDomainValidatePayload{
		Name: to.Ptr("mydomain.io"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}
